/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.ValidationListener;
import com.microsoft.alm.plugin.idea.tfvc.ui.workspace.WorkspaceMappingsTableEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WorkspaceForm {
    private JTextField name;
    private JLabel server;
    private JLabel owner;
    private JLabel computer;
    private JTextArea comment;
    private JPanel contentPane;
    private JPanel workingFolderPanel;
    private WorkspaceMappingsTableEditor tableEditor;
    private JLabel workingFoldersLabel;
    private ComboBox location;
    private final Project project;
    private final ServerContext serverContext;
    private final ValidationListener validationListener;

    private void createUIComponents() {
        String defaultPath = this.project != null ? this.project.getBasePath() : "";
        this.tableEditor = new WorkspaceMappingsTableEditor(this.project, this.serverContext, defaultPath, new WorkspaceMappingsTableEditor.ValidationDispatcher(){

            @Override
            public void showValidationError(String errorMessage) {
                if (WorkspaceForm.this.validationListener != null) {
                    WorkspaceForm.this.validationListener.doValidate();
                }
            }
        });
        this.tableEditor.hideMessageLabel();
        this.tableEditor.setColumnReorderingAllowed(false);
        this.workingFolderPanel = new JPanel(new BorderLayout());
        this.workingFolderPanel.add(this.tableEditor.getContentPane());
    }

    public WorkspaceForm(Project project, ServerContext serverContext, ValidationListener validationListener) {
        this.project = project;
        this.serverContext = serverContext;
        this.validationListener = validationListener;
        this.$$$setupUI$$$();
        this.workingFoldersLabel.setLabelFor(this.tableEditor.getPreferredFocusedComponent());
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public void setComputer(String computer) {
        this.computer.setText(computer);
    }

    public void setOwner(String owner) {
        this.owner.setText(owner);
    }

    public void setServer(String server) {
        this.server.setText(server);
    }

    public void setWorkspaceName(String name) {
        this.name.setText(name);
    }

    public String getWorkspaceName() {
        return this.name.getText();
    }

    public void setComment(String comment) {
        this.comment.setText(comment);
    }

    public String getComment() {
        return this.comment.getText();
    }

    public void setMappings(List<Workspace.Mapping> mappings) {
        this.tableEditor.setMappings(mappings);
    }

    public List<Workspace.Mapping> getMappings() {
        return this.tableEditor.getMappings();
    }

    public String getFirstMappingValidationError() {
        return this.tableEditor.getFirstValidationError();
    }

    public void setLocation(Workspace.Location locationOption) {
        this.location.removeAllItems();
        this.location.addItem((Object)locationOption);
    }

    public void setLoading(boolean loading) {
        if (loading) {
            String loadingMessage = TfPluginBundle.message("WorkspaceDialog.Loading", new Object[0]);
            this.name.setEnabled(false);
            this.name.setText(loadingMessage);
            this.comment.setEnabled(false);
            this.comment.setText(loadingMessage);
            this.owner.setEnabled(false);
            this.owner.setText(loadingMessage);
            this.server.setEnabled(false);
            this.server.setText(loadingMessage);
            this.computer.setEnabled(false);
            this.computer.setText(loadingMessage);
            this.location.setEnabled(false);
            this.location.addItem((Object)loadingMessage);
        } else {
            this.name.setEnabled(true);
            this.comment.setEnabled(true);
            this.owner.setEnabled(true);
            this.server.setEnabled(true);
            this.computer.setEnabled(true);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.name;
    }

    public JComponent getComponent(String name) {
        if ("name".equals(name)) {
            return this.name;
        }
        if ("comment".equals(name)) {
            return this.comment;
        }
        if ("computer".equals(name)) {
            return this.computer;
        }
        if ("mappings".equals(name)) {
            return this.workingFolderPanel;
        }
        if ("owner".equals(name)) {
            return this.comment;
        }
        if ("server".equals(name)) {
            return this.server;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JLabel jLabel;
        JTextArea jTextArea;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.Name"));
        jPanel.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.name = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.Server"));
        jPanel.add((Component)jLabel6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.server = jLabel4 = new JLabel();
        jLabel4.setText("https://");
        jPanel.add((Component)jLabel4, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.Owner"));
        jPanel.add((Component)jLabel7, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.owner = jLabel3 = new JLabel();
        jLabel3.setText("domain\\user");
        jPanel.add((Component)jLabel3, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.Computer"));
        jPanel.add((Component)jLabel8, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.computer = jLabel2 = new JLabel();
        jLabel2.setText("localhost");
        jPanel.add((Component)jLabel2, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.Comment"));
        jPanel.add((Component)jLabel9, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        this.comment = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setRows(3);
        jTextArea.setText("");
        jBScrollPane.setViewportView(jTextArea);
        this.workingFoldersLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.WorkingFolders"));
        jPanel.add((Component)jLabel, new GridConstraints(7, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.Location"));
        jPanel.add((Component)jLabel10, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.location = comboBox = new ComboBox();
        comboBox.setEditable(false);
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JPanel jPanel2 = this.workingFolderPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jLabel5.setLabelFor(jTextField);
        jLabel9.setLabelFor(jTextArea);
        jLabel10.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static enum Location {
        LOCAL,
        SERVER;

    }
}

