/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.ValidatingTableEditor;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.ui.ServerPathCellEditor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceMappingsTableEditor
extends ValidatingTableEditor<Row> {
    public static Logger logger = LoggerFactory.getLogger(WorkspaceMappingsTableEditor.class);
    private final Project project;
    private final ServerContext serverContext;
    private final String defaultLocalPath;
    private final ValidationDispatcher validationDispatcher;

    public WorkspaceMappingsTableEditor(Project project, ServerContext serverContext, String defaultLocalPath, ValidationDispatcher validationDispatcher) {
        this.defaultLocalPath = defaultLocalPath;
        this.project = project;
        this.serverContext = serverContext;
        this.validationDispatcher = validationDispatcher;
    }

    public void setMappings(List<Workspace.Mapping> mappings) {
        if (mappings != null) {
            ArrayList<Row> rows = new ArrayList<Row>(mappings.size());
            for (Workspace.Mapping mapping : mappings) {
                rows.add(new Row(mapping.getServerPath(), mapping.getLocalPath(), mapping.isCloaked() ? MappingType.CLOAKED : MappingType.MAPPED));
            }
            this.setModel(new ColumnInfo[]{new MappingTypeColumn(), new ServerPathColumn(this.project, this.serverContext), new LocalPathColumn(this.project)}, rows);
        }
    }

    public List<Workspace.Mapping> getMappings() {
        ArrayList<Workspace.Mapping> result = new ArrayList<Workspace.Mapping>(this.getItems().size());
        for (Row r : this.getItems()) {
            Workspace.Mapping mapping = new Workspace.Mapping(r.serverPath, r.localPath, r.mappingType == MappingType.CLOAKED);
            result.add(mapping);
        }
        return result;
    }

    protected Row cloneOf(Row item) {
        return new Row(item);
    }

    protected Row createItem() {
        List items = this.getItems();
        if (items != null && items.size() > 0) {
            return new Row((Row)items.get(items.size() - 1));
        }
        ServerContext serverContext = TFSVcs.getInstance(this.project).getServerContext(false);
        if (serverContext != null && serverContext.getTeamProjectReference() != null && StringUtils.isNotEmpty((String)serverContext.getTeamProjectReference().getName())) {
            return new Row("$/".concat(serverContext.getTeamProjectReference().getName()), this.defaultLocalPath, MappingType.MAPPED);
        }
        logger.info("No rows or team project could be found so passing in empty root to new row");
        return new Row("", this.defaultLocalPath, MappingType.MAPPED);
    }

    public String getFirstValidationError() {
        for (Row r : this.getItems()) {
            String error = this.validate(r);
            if (!StringUtils.isNotEmpty((String)error)) continue;
            return error;
        }
        return null;
    }

    @Nullable
    protected String validate(Row item) {
        if (StringUtils.isEmpty((String)item.serverPath)) {
            return TfPluginBundle.message("WorkspaceDialog.Errors.ServerPathEmpty", new Object[0]);
        }
        if (!item.serverPath.startsWith("$/")) {
            return TfPluginBundle.message("WorkspaceDialog.Errors.ServerPathInvalid", new Object[0]);
        }
        if (StringUtils.isEmpty((String)item.localPath) && item.mappingType == MappingType.MAPPED) {
            return TfPluginBundle.message("WorkspaceDialog.Errors.LocalPathEmpty", new Object[0]);
        }
        return null;
    }

    protected void displayMessageAndFix(@Nullable Pair<String, ValidatingTableEditor.Fix> messageAndFix) {
        if (this.validationDispatcher != null) {
            String validationMessage;
            String string = validationMessage = messageAndFix != null ? (String)messageAndFix.first : null;
            if (StringUtils.isNotEmpty((String)validationMessage)) {
                this.validationDispatcher.showValidationError(validationMessage);
            }
        }
    }

    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = new StatusText(){

            protected boolean isStatusVisible() {
                return true;
            }
        };
        if (statusText == null) {
            WorkspaceMappingsTableEditor.$$$reportNull$$$0(0);
        }
        return statusText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/microsoft/alm/plugin/idea/tfvc/ui/workspace/WorkspaceMappingsTableEditor", "getEmptyText"));
    }

    private static class ServerPathColumn
    extends ColumnInfo<Row, String> {
        private final Project project;
        private final ServerContext serverContext;

        public ServerPathColumn(Project project, ServerContext serverContext) {
            super(TfPluginBundle.message("WorkspaceDialog.ColumnHeaders.ServerPath", new Object[0]));
            this.project = project;
            this.serverContext = serverContext;
        }

        public String valueOf(Row item) {
            return item.serverPath;
        }

        public void setValue(Row item, String value) {
            item.serverPath = value;
        }

        public boolean isCellEditable(Row item) {
            return true;
        }

        public TableCellEditor getEditor(Row item) {
            return new ServerPathCellEditor(this.getName(), this.project, this.serverContext);
        }
    }

    private class LocalPathColumn
    extends ColumnInfo<Row, String>
    implements ValidatingTableEditor.RowHeightProvider {
        private final Project project;

        public LocalPathColumn(Project project) {
            super(TfPluginBundle.message("WorkspaceDialog.ColumnHeaders.LocalPath", new Object[0]));
            this.project = project;
        }

        public String valueOf(Row item) {
            return item.localPath;
        }

        public boolean isCellEditable(Row Row2) {
            return true;
        }

        public void setValue(Row item, String value) {
            item.localPath = value;
        }

        public TableCellEditor getEditor(Row item) {
            return new LocalPathCellEditor(this.getName(), this.project);
        }

        public int getRowHeight() {
            return new JTextField().getPreferredSize().height + 1;
        }
    }

    private static class MappingTypeColumn
    extends ColumnInfo<Row, MappingType> {
        public MappingTypeColumn() {
            super(TfPluginBundle.message("WorkspaceDialog.ColumnHeaders.Status", new Object[0]));
        }

        public MappingType valueOf(Row item) {
            return item.mappingType;
        }

        public void setValue(Row item, MappingType value) {
            item.mappingType = value;
        }

        public boolean isCellEditable(Row item) {
            return true;
        }

        public int getWidth(JTable table) {
            return JBUI.scale((int)80);
        }

        public TableCellEditor getEditor(Row item) {
            return new AbstractTableCellEditor(){
                private ComboBox myCombo;

                public Object getCellEditorValue() {
                    return this.myCombo.getSelectedItem();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    EnumComboBoxModel model = new EnumComboBoxModel(MappingType.class);
                    model.setSelectedItem(value);
                    this.myCombo = new ComboBox((ComboBoxModel)model, MappingTypeColumn.this.getWidth(table));
                    return this.myCombo;
                }
            };
        }
    }

    public class Row {
        public MappingType mappingType;
        public String serverPath;
        public String localPath;

        public Row(Row otherRow) {
            this.serverPath = otherRow.serverPath;
            this.localPath = otherRow.localPath;
            this.mappingType = otherRow.mappingType;
        }

        public Row(String serverPath, String localPath, MappingType mappingType) {
            this.serverPath = serverPath;
            this.localPath = localPath;
            this.mappingType = mappingType;
        }
    }

    public static enum MappingType {
        MAPPED,
        CLOAKED;

    }

    public static interface ValidationDispatcher {
        public void showValidationError(String var1);
    }
}

