/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.framework;

import com.jetbrains.rider.framework.AbstractBuffer;
import com.jetbrains.rider.framework.RdId;
import com.jetbrains.rider.framework.SocketWire;
import com.jetbrains.rider.framework.SocketWireKt;
import com.jetbrains.rider.framework.UnsafeBuffer;
import com.jetbrains.rider.framework.base.WireBase;
import com.jetbrains.rider.util.LogLevel;
import com.jetbrains.rider.util.Logger;
import com.jetbrains.rider.util.LoggerKt;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import com.jetbrains.rider.util.reactive.IScheduler;
import com.jetbrains.rider.util.reactive.OptProperty;
import com.jetbrains.rider.util.threading.ByteArraySlice;
import com.jetbrains.rider.util.threading.ByteBufferAsyncProcessor;
import com.jetbrains.rider.util.threading.ByteBufferAsyncProcessorKt;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 \u00052\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/framework/SocketWire;", "", "()V", "Base", "Client", "Companion", "Server", "rd-framework-jvm"})
public final class SocketWire {
    @NotNull
    private static final Duration timeout;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        Duration duration = Duration.ofMillis(500L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMillis(500)");
        timeout = duration;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001dH\u0002J$\u0010'\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020%0*H\u0016J\u0010\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR2\u0010 \u001a&\u0012\f\u0012\n #*\u0004\u0018\u00010\"0\" #*\u0012\u0012\f\u0012\n #*\u0004\u0018\u00010\"0\"\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/framework/SocketWire$Base;", "Lcom/jetbrains/rider/framework/base/WireBase;", "id", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "scheduler", "Lcom/jetbrains/rider/util/reactive/IScheduler;", "(Ljava/lang/String;Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/jetbrains/rider/util/reactive/IScheduler;)V", "getId", "()Ljava/lang/String;", "input", "Ljava/io/InputStream;", "lock", "Ljava/lang/Object;", "getLock", "()Ljava/lang/Object;", "logger", "Lcom/jetbrains/rider/util/Logger;", "getLogger", "()Lcom/jetbrains/rider/util/Logger;", "output", "Ljava/io/OutputStream;", "sendBuffer", "Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor;", "getSendBuffer", "()Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor;", "socketProvider", "Lcom/jetbrains/rider/util/reactive/OptProperty;", "Ljava/net/Socket;", "getSocketProvider", "()Lcom/jetbrains/rider/util/reactive/OptProperty;", "threadLocalSendByteArray", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "receiverProc", "", "socket", "send", "Lcom/jetbrains/rider/framework/RdId;", "writer", "Lkotlin/Function1;", "Lcom/jetbrains/rider/framework/AbstractBuffer;", "send0", "msg", "Lcom/jetbrains/rider/util/threading/ByteArraySlice;", "rd-framework-jvm"})
    public static abstract class Base
    extends WireBase {
        @NotNull
        private final Logger logger;
        @NotNull
        private final OptProperty<Socket> socketProvider;
        private OutputStream output;
        private InputStream input;
        @NotNull
        private final ByteBufferAsyncProcessor sendBuffer;
        private final ThreadLocal<byte[]> threadLocalSendByteArray;
        @NotNull
        private final Object lock;
        @NotNull
        private final String id;
        private final Lifetime lifetime;

        @NotNull
        protected final Logger getLogger() {
            return this.logger;
        }

        @NotNull
        protected final OptProperty<Socket> getSocketProvider() {
            return this.socketProvider;
        }

        @NotNull
        protected final ByteBufferAsyncProcessor getSendBuffer() {
            return this.sendBuffer;
        }

        @NotNull
        protected final Object getLock() {
            return this.lock;
        }

        /*
         * WARNING - void declaration
         */
        private final void receiverProc(Socket socket) {
            while (!this.lifetime.isTerminated()) {
                Throwable throwable;
                try {
                    byte[] bytes;
                    boolean $receiver$iv$iv2;
                    Object level$iv$iv;
                    if (!socket.isConnected()) {
                        void $receiver$iv$iv2;
                        Logger $receiver$iv = this.logger;
                        throwable = $receiver$iv;
                        level$iv$iv = LogLevel.Debug;
                        if ($receiver$iv$iv2.isEnabled(level$iv$iv)) {
                            LogLevel logLevel = level$iv$iv;
                            void var10_9 = $receiver$iv$iv2;
                            String string = "Stop receive messages because socket disconnected";
                            var10_9.log(logLevel, (Object)string, null);
                        }
                        ByteBufferAsyncProcessor.terminate$default((ByteBufferAsyncProcessor)this.sendBuffer, null, (int)1, null);
                        break;
                    }
                    InputStream inputStream = this.input;
                    if (inputStream == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"input");
                    }
                    boolean bl = $receiver$iv$iv2 = (bytes = SocketWireKt.access$readByteArray(inputStream)).length >= 4;
                    if (_Assertions.ENABLED && !$receiver$iv$iv2) {
                        level$iv$iv = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError(level$iv$iv));
                    }
                    UnsafeBuffer unsafeBuffer = new UnsafeBuffer(bytes);
                    RdId id = RdId.Companion.read(unsafeBuffer);
                    this.getMessageBroker().dispatch(id, unsafeBuffer);
                }
                catch (Throwable ex) {
                    throwable = ex;
                    if (throwable instanceof SocketException || throwable instanceof EOFException) {
                        void $receiver$iv$iv;
                        Logger $receiver$iv;
                        Logger $i$a$1$debug = $receiver$iv = this.logger;
                        LogLevel level$iv$iv = LogLevel.Debug;
                        if ($receiver$iv$iv.isEnabled(level$iv$iv)) {
                            LogLevel logLevel = level$iv$iv;
                            void var10_10 = $receiver$iv$iv;
                            String string = "Exception in SocketWire.Receive:  " + this.id + ": " + ex;
                            var10_10.log(logLevel, (Object)string, null);
                        }
                    } else {
                        LoggerKt.error((Logger)this.logger, (String)(this.id + " caught processing"), (Throwable)ex);
                    }
                    ByteBufferAsyncProcessor.terminate$default((ByteBufferAsyncProcessor)this.sendBuffer, null, (int)1, null);
                    break;
                }
            }
        }

        private final void send0(ByteArraySlice msg) {
            try {
                OutputStream outputStream = this.output;
                if (outputStream == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                }
                ByteBufferAsyncProcessorKt.write((OutputStream)outputStream, (ByteArraySlice)msg);
            }
            catch (SocketException ex) {
                ByteBufferAsyncProcessor.terminate$default((ByteBufferAsyncProcessor)this.sendBuffer, null, (int)1, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(@NotNull RdId id, @NotNull Function1<? super AbstractBuffer, Unit> writer) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull(writer, (String)"writer");
            boolean bl2 = bl = !id.isNull();
            if (!bl) {
                String string = "id mustn't be null";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            byte[] byArray = this.threadLocalSendByteArray.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"threadLocalSendByteArray.get()");
            try (UnsafeBuffer unsafeBuffer = new UnsafeBuffer(byArray);){
                unsafeBuffer.writeInt(0);
                id.write(unsafeBuffer);
                writer.invoke((Object)unsafeBuffer);
                int len = unsafeBuffer.getPosition();
                unsafeBuffer.rewind();
                unsafeBuffer.writeInt(len - 4);
                byte[] byArray2 = unsafeBuffer.getArray();
                if (byArray2 == null) {
                    Intrinsics.throwNpe();
                }
                byte[] bytes = byArray2;
                this.threadLocalSendByteArray.set(bytes);
                this.sendBuffer.put(bytes, 0, len);
            }
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        protected Base(@NotNull String id, @NotNull Lifetime lifetime, @NotNull IScheduler scheduler) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
            Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
            super(scheduler);
            this.id = id;
            this.lifetime = lifetime;
            this.logger = LoggerKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
            this.socketProvider = new OptProperty();
            this.sendBuffer = new ByteBufferAsyncProcessor(this.id + "-AsyncSendProcessor", 0, (Function1)new Function1<ByteArraySlice, Unit>(this){
                final /* synthetic */ Base this$0;

                public final void invoke(@NotNull ByteArraySlice it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Base.access$send0(this.this$0, it);
                }
                {
                    this.this$0 = base;
                    super(1);
                }
            }, 2, null);
            this.threadLocalSendByteArray = ThreadLocal.withInitial(threadLocalSendByteArray.1.INSTANCE);
            this.lock = new Object();
            this.socketProvider.advise(this.lifetime, (Function1)new Function1<Socket, Unit>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull Socket socket) {
                    Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
                    Object object = this.getLock();
                    synchronized (object) {
                        if (lifetime.isTerminated()) {
                            return;
                        }
                        OutputStream outputStream = socket.getOutputStream();
                        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"socket.outputStream");
                        output = outputStream;
                        InputStream inputStream = socket.getInputStream();
                        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"socket.inputStream");
                        InputStream inputStream2 = inputStream;
                        Base base = this;
                        int n = 8192;
                        BufferedInputStream bufferedInputStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
                        base.input = bufferedInputStream;
                        this.getSendBuffer().start();
                        base = Unit.INSTANCE;
                    }
                    this.receiverProc(socket);
                }
            });
        }

        public static final /* synthetic */ void access$send0(Base $this, @NotNull ByteArraySlice msg) {
            $this.send0(msg);
        }

        @NotNull
        public static final /* synthetic */ OutputStream access$getOutput$p(Base $this) {
            OutputStream outputStream = $this.output;
            if (outputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"output");
            }
            return outputStream;
        }

        @NotNull
        public static final /* synthetic */ InputStream access$getInput$p(Base $this) {
            InputStream inputStream = $this.input;
            if (inputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"input");
            }
            return inputStream;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/framework/SocketWire$Client;", "Lcom/jetbrains/rider/framework/SocketWire$Base;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "scheduler", "Lcom/jetbrains/rider/util/reactive/IScheduler;", "port", "", "optId", "", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/jetbrains/rider/util/reactive/IScheduler;ILjava/lang/String;)V", "rd-framework-jvm"})
    public static final class Client
    extends Base {
        /*
         * WARNING - void declaration
         */
        public Client(@NotNull Lifetime lifetime, @NotNull IScheduler scheduler, int port, @Nullable String optId) {
            void socket;
            Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
            Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
            String string = optId;
            if (string == null) {
                string = "ClientSocket";
            }
            super(string, lifetime, scheduler);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Function0 function0 = (Function0)new Function0<Unit>(this, lifetime, port, (Ref.ObjectRef)socket){
                final /* synthetic */ Client this$0;
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ int $port;
                final /* synthetic */ Ref.ObjectRef $socket;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    block18: {
                        try {
                            while (!this.$lifetime.isTerminated()) {
                                Object comment$iv$iv;
                                try {
                                    Socket s = new Socket();
                                    s.setTcpNoDelay(true);
                                    s.connect(new InetSocketAddress(InetAddress.getLoopbackAddress(), this.$port));
                                    Object object = this.this$0.getLock();
                                    synchronized (object) {
                                        if (this.$lifetime.isTerminated()) {
                                            comment$iv$iv = null;
                                            try {
                                                s.close();
                                            }
                                            catch (Throwable e$iv$iv) {
                                                CharSequence charSequence = (CharSequence)comment$iv$iv;
                                                String sfx$iv$iv = "";
                                                LoggerKt.getLogger((String)"Default-Error-Logger").log(LogLevel.Error, (Object)("Catch" + sfx$iv$iv), e$iv$iv);
                                            }
                                        } else {
                                            this.$socket.element = s;
                                        }
                                        Unit e$iv$iv = Unit.INSTANCE;
                                    }
                                    this.this$0.getSocketProvider().set((Object)s);
                                    break;
                                }
                                catch (ConnectException e) {
                                    boolean bl;
                                    comment$iv$iv = this.this$0.getLock();
                                    synchronized (comment$iv$iv) {
                                        boolean bl2;
                                        if (!this.$lifetime.isTerminated()) {
                                            this.this$0.getLock().wait(SocketWire.Companion.getTimeout().toMillis());
                                            bl2 = !this.$lifetime.isTerminated();
                                        } else {
                                            bl2 = false;
                                        }
                                        bl = bl2;
                                    }
                                    boolean shouldReconnect = bl;
                                    if (shouldReconnect) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                        }
                        catch (SocketException ex) {
                            void $receiver$iv$iv;
                            Logger $receiver$iv;
                            Logger comment$iv$iv = $receiver$iv = this.this$0.getLogger();
                            LogLevel level$iv$iv = LogLevel.Info;
                            if (!$receiver$iv$iv.isEnabled(level$iv$iv)) break block18;
                            LogLevel logLevel = level$iv$iv;
                            void var11_18 = $receiver$iv$iv;
                            String string = this.this$0.getId() + ": closed with exception: " + ex;
                            var11_18.log(logLevel, (Object)string, null);
                        }
                    }
                }
                {
                    this.this$0 = client;
                    this.$lifetime = lifetime;
                    this.$port = n;
                    this.$socket = objectRef;
                    super(0);
                }
            };
            int n = 0;
            boolean bl = true;
            ClassLoader classLoader = null;
            String string2 = this.getId();
            Thread thread2 = ThreadsKt.thread$default((boolean)false, (boolean)bl, classLoader, (String)string2, (int)n, (Function0)function0, (int)21, null);
            LifetimeExKt.plusAssign((Lifetime)lifetime, (Function0)((Function0)new Function0<Unit>((Ref.ObjectRef)socket, thread2){
                final /* synthetic */ Ref.ObjectRef $socket;
                final /* synthetic */ Thread $thread;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    Object comment$iv$iv;
                    Object $receiver$iv$iv;
                    String string;
                    Object object;
                    LogLevel logLevel;
                    void $receiver$iv$iv2;
                    Logger $receiver$iv;
                    Logger logger = $receiver$iv = this.getLogger();
                    LogLevel level$iv$iv = LogLevel.Info;
                    if ($receiver$iv$iv2.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        object = $receiver$iv$iv2;
                        string = this.getId() + ": start terminating lifetime";
                        object.log(logLevel, (Object)string, null);
                    }
                    boolean sendBufferStopped = this.getSendBuffer().stop(Companion.getTimeout());
                    Object $receiver$iv2 = this.getLogger();
                    level$iv$iv = $receiver$iv2;
                    LogLevel level$iv$iv2 = LogLevel.Debug;
                    if ($receiver$iv$iv.isEnabled(level$iv$iv2)) {
                        logLevel = level$iv$iv2;
                        object = $receiver$iv$iv;
                        string = this.getId() + ": send buffer stopped, success: " + sendBufferStopped;
                        object.log(logLevel, (Object)string, null);
                    }
                    $receiver$iv2 = this.getLock();
                    synchronized ($receiver$iv2) {
                        void $receiver$iv$iv3;
                        Logger $receiver$iv3 = this.getLogger();
                        level$iv$iv2 = $receiver$iv3;
                        LogLevel level$iv$iv3 = LogLevel.Debug;
                        if ($receiver$iv$iv3.isEnabled(level$iv$iv3)) {
                            LogLevel $i$f$log = level$iv$iv3;
                            void $i$f$debug = $receiver$iv$iv3;
                            String string2 = this.getId() + ": closing socket";
                            $i$f$debug.log($i$f$log, (Object)string2, null);
                        }
                        comment$iv$iv = null;
                        try {
                            Socket socket = (Socket)this.$socket.element;
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (Throwable e$iv$iv) {
                            CharSequence charSequence = (CharSequence)comment$iv$iv;
                            String sfx$iv$iv = "";
                            LoggerKt.getLogger((String)"Default-Error-Logger").log(LogLevel.Error, (Object)("Catch" + sfx$iv$iv), e$iv$iv);
                        }
                        this.getLock().notifyAll();
                        Unit $i$a$2$catch = Unit.INSTANCE;
                    }
                    comment$iv$iv = $receiver$iv2 = this.getLogger();
                    level$iv$iv2 = LogLevel.Debug;
                    if ($receiver$iv$iv.isEnabled(level$iv$iv2)) {
                        logLevel = level$iv$iv2;
                        object = $receiver$iv$iv;
                        string = this.getId() + ": waiting for receiver thread";
                        object.log(logLevel, (Object)string, null);
                    }
                    this.$thread.join();
                    $receiver$iv$iv = $receiver$iv2 = this.getLogger();
                    level$iv$iv2 = LogLevel.Info;
                    if ($receiver$iv$iv.isEnabled(level$iv$iv2)) {
                        logLevel = level$iv$iv2;
                        object = $receiver$iv$iv;
                        string = this.getId() + ": termination finished";
                        object.log(logLevel, (Object)string, null);
                    }
                }
                {
                    this.$socket = objectRef;
                    this.$thread = thread2;
                    super(0);
                }
            }));
        }

        public /* synthetic */ Client(Lifetime lifetime, IScheduler iScheduler, int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string = null;
            }
            this(lifetime, iScheduler, n, string);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/framework/SocketWire$Server;", "Lcom/jetbrains/rider/framework/SocketWire$Base;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "scheduler", "Lcom/jetbrains/rider/util/reactive/IScheduler;", "port", "", "optId", "", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/jetbrains/rider/util/reactive/IScheduler;Ljava/lang/Integer;Ljava/lang/String;)V", "getPort", "()I", "rd-framework-jvm"})
    public static final class Server
    extends Base {
        private final int port;

        public final int getPort() {
            return this.port;
        }

        /*
         * WARNING - void declaration
         */
        public Server(@NotNull Lifetime lifetime, @NotNull IScheduler scheduler, @Nullable Integer port, @Nullable String optId) {
            void socket;
            Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
            Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
            String string = optId;
            if (string == null) {
                string = "ServerSocket";
            }
            super(string, lifetime, scheduler);
            Integer n = port;
            final ServerSocket ss = new ServerSocket(n != null ? n : 0, 0, InetAddress.getByName("127.0.0.1"));
            this.port = ss.getLocalPort();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Function0 function0 = (Function0)new Function0<Unit>(this, ss, lifetime, (Ref.ObjectRef)socket){
                final /* synthetic */ Server this$0;
                final /* synthetic */ ServerSocket $ss;
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ Ref.ObjectRef $socket;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    block9: {
                        try {
                            Socket s;
                            Socket socket = s = this.$ss.accept();
                            Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"s");
                            socket.setTcpNoDelay(true);
                            Object object = this.this$0.getLock();
                            synchronized (object) {
                                if (this.$lifetime.isTerminated()) {
                                    Object comment$iv$iv = null;
                                    try {
                                        s.close();
                                    }
                                    catch (Throwable e$iv$iv) {
                                        CharSequence charSequence = comment$iv$iv;
                                        String sfx$iv$iv = "";
                                        LoggerKt.getLogger((String)"Default-Error-Logger").log(LogLevel.Error, (Object)("Catch" + sfx$iv$iv), e$iv$iv);
                                    }
                                } else {
                                    this.$socket.element = s;
                                }
                                Unit e$iv$iv = Unit.INSTANCE;
                            }
                            this.this$0.getSocketProvider().set((Object)s);
                        }
                        catch (SocketException ex) {
                            void $receiver$iv$iv;
                            Logger $receiver$iv;
                            Logger comment$iv$iv = $receiver$iv = this.this$0.getLogger();
                            LogLevel level$iv$iv = LogLevel.Info;
                            if (!$receiver$iv$iv.isEnabled(level$iv$iv)) break block9;
                            LogLevel logLevel = level$iv$iv;
                            void var11_14 = $receiver$iv$iv;
                            String string = this.this$0.getId() + " closed with exception: " + ex;
                            var11_14.log(logLevel, (Object)string, null);
                        }
                    }
                }
                {
                    this.this$0 = server;
                    this.$ss = serverSocket;
                    this.$lifetime = lifetime;
                    this.$socket = objectRef;
                    super(0);
                }
            };
            int n2 = 0;
            boolean bl = true;
            ClassLoader classLoader = null;
            String string2 = this.getId();
            Thread thread2 = ThreadsKt.thread$default((boolean)false, (boolean)bl, classLoader, (String)string2, (int)n2, (Function0)function0, (int)21, null);
            LifetimeExKt.plusAssign((Lifetime)lifetime, (Function0)((Function0)new Function0<Unit>((Ref.ObjectRef)socket, thread2){
                final /* synthetic */ Ref.ObjectRef $socket;
                final /* synthetic */ Thread $thread;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    String string;
                    LogLevel $i$f$debug;
                    LogLevel level$iv$iv;
                    Object $receiver$iv;
                    Logger $receiver$iv$iv;
                    String string2;
                    Logger logger;
                    LogLevel logLevel;
                    void $receiver$iv$iv2;
                    Logger $receiver$iv2;
                    Logger logger2 = $receiver$iv2 = this.getLogger();
                    LogLevel level$iv$iv2 = LogLevel.Info;
                    if ($receiver$iv$iv2.isEnabled(level$iv$iv2)) {
                        logLevel = level$iv$iv2;
                        logger = $receiver$iv$iv2;
                        string2 = this.getId() + ": start terminating lifetime";
                        logger.log(logLevel, (Object)string2, null);
                    }
                    boolean sendBufferStopped = this.getSendBuffer().stop(Companion.getTimeout());
                    Logger $receiver$iv3 = this.getLogger();
                    level$iv$iv2 = $receiver$iv3;
                    LogLevel level$iv$iv3 = LogLevel.Debug;
                    if ($receiver$iv$iv.isEnabled(level$iv$iv3)) {
                        logLevel = level$iv$iv3;
                        logger = $receiver$iv$iv;
                        string2 = this.getId() + ": send buffer stopped, success: " + sendBufferStopped;
                        logger.log(logLevel, (Object)string2, null);
                    }
                    Object comment$iv$iv = null;
                    try {
                        void $receiver$iv$iv3;
                        $receiver$iv = this.getLogger();
                        level$iv$iv3 = $receiver$iv;
                        level$iv$iv = LogLevel.Debug;
                        if ($receiver$iv$iv3.isEnabled(level$iv$iv)) {
                            LogLevel $i$f$log = level$iv$iv;
                            $i$f$debug = $receiver$iv$iv3;
                            string = this.getId() + ": closing server socket";
                            $i$f$debug.log($i$f$log, (Object)string, null);
                        }
                        ss.close();
                    }
                    catch (Throwable e$iv$iv) {
                        CharSequence charSequence = comment$iv$iv;
                        String sfx$iv$iv = "";
                        LoggerKt.getLogger((String)"Default-Error-Logger").log(LogLevel.Error, (Object)("Catch" + sfx$iv$iv), e$iv$iv);
                    }
                    comment$iv$iv = null;
                    try {
                        $receiver$iv = this.getLock();
                        synchronized ($receiver$iv) {
                            Unit unit;
                            Unit $receiver$iv$iv4;
                            Logger $receiver$iv4 = this.getLogger();
                            level$iv$iv = $receiver$iv4;
                            LogLevel level$iv$iv4 = LogLevel.Debug;
                            if ($receiver$iv$iv4.isEnabled(level$iv$iv4)) {
                                $i$f$debug = level$iv$iv4;
                                string = $receiver$iv$iv4;
                                String string3 = this.getId() + ": closing socket";
                                string.log($i$f$debug, (Object)string3, null);
                            }
                            Socket socket = (Socket)this.$socket.element;
                            if (socket != null) {
                                socket.close();
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            $receiver$iv$iv4 = unit;
                        }
                    }
                    catch (Throwable e$iv$iv) {
                        CharSequence charSequence = comment$iv$iv;
                        String sfx$iv$iv = "";
                        LoggerKt.getLogger((String)"Default-Error-Logger").log(LogLevel.Error, (Object)("Catch" + sfx$iv$iv), e$iv$iv);
                    }
                    $receiver$iv = $receiver$iv3 = this.getLogger();
                    level$iv$iv3 = LogLevel.Debug;
                    if ($receiver$iv$iv.isEnabled(level$iv$iv3)) {
                        logLevel = level$iv$iv3;
                        logger = $receiver$iv$iv;
                        string2 = this.getId() + ": waiting for receiver thread";
                        logger.log(logLevel, (Object)string2, null);
                    }
                    this.$thread.join();
                    $receiver$iv$iv = $receiver$iv3 = this.getLogger();
                    level$iv$iv3 = LogLevel.Info;
                    if ($receiver$iv$iv.isEnabled(level$iv$iv3)) {
                        logLevel = level$iv$iv3;
                        logger = $receiver$iv$iv;
                        string2 = this.getId() + ": termination finished";
                        logger.log(logLevel, (Object)string2, null);
                    }
                }
                {
                    this.$socket = objectRef;
                    this.$thread = thread2;
                    super(0);
                }
            }));
        }

        public /* synthetic */ Server(Lifetime lifetime, IScheduler iScheduler, Integer n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string = null;
            }
            this(lifetime, iScheduler, n, string);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/framework/SocketWire$Companion;", "", "()V", "timeout", "Ljava/time/Duration;", "getTimeout", "()Ljava/time/Duration;", "rd-framework-jvm"})
    public static final class Companion {
        @NotNull
        public final Duration getTimeout() {
            return timeout;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

