/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.framework.impl;

import com.jetbrains.rider.framework.AbstractBuffer;
import com.jetbrains.rider.framework.IRdCall;
import com.jetbrains.rider.framework.IRdTask;
import com.jetbrains.rider.framework.ISerializer;
import com.jetbrains.rider.framework.Polymorphic;
import com.jetbrains.rider.framework.RdId;
import com.jetbrains.rider.framework.RdTaskResult;
import com.jetbrains.rider.framework.SerializationCtx;
import com.jetbrains.rider.framework.SerializersKt;
import com.jetbrains.rider.framework.base.RdBindableBase;
import com.jetbrains.rider.framework.base.RdBindableBaseKt;
import com.jetbrains.rider.framework.base.RdExtBase;
import com.jetbrains.rider.framework.base.RdReactiveBase;
import com.jetbrains.rider.framework.impl.RdTask;
import com.jetbrains.rider.framework.impl.RpcTimeouts;
import com.jetbrains.rider.util.CollectionExKt;
import com.jetbrains.rider.util.LogLevel;
import com.jetbrains.rider.util.Logger;
import com.jetbrains.rider.util.PlatformDependentKt;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import com.jetbrains.rider.util.reactive.IOptPropertyView;
import com.jetbrains.rider.util.reactive.IScheduler;
import com.jetbrains.rider.util.reactive.InterfacesKt;
import com.jetbrains.rider.util.string.IPrintableKt;
import com.jetbrains.rider.util.threading.SpinWait;
import com.jetbrains.rider.util.threading.SynchronousScheduler;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004:\u0001.B%\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0019\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u0010#J%\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\"\u001a\u00028\u00002\b\u0010$\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010%J)\u0010&\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\"\u001a\u00028\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010*J\u001f\u0010'\u001a\u00028\u00012\u0006\u0010\"\u001a\u00028\u00002\b\u0010+\u001a\u0004\u0018\u00010,H\u0016\u00a2\u0006\u0002\u0010-R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000e0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/framework/impl/RdCall;", "TReq", "TRes", "Lcom/jetbrains/rider/framework/base/RdReactiveBase;", "Lcom/jetbrains/rider/framework/IRdCall;", "requestSzr", "Lcom/jetbrains/rider/framework/ISerializer;", "responseSzr", "(Lcom/jetbrains/rider/framework/ISerializer;Lcom/jetbrains/rider/framework/ISerializer;)V", "requests", "", "Lcom/jetbrains/rider/framework/RdId;", "Lkotlin/Pair;", "Lcom/jetbrains/rider/util/reactive/IScheduler;", "Lcom/jetbrains/rider/framework/impl/RdTask;", "serializationContext", "Lcom/jetbrains/rider/framework/SerializationCtx;", "getSerializationContext", "()Lcom/jetbrains/rider/framework/SerializationCtx;", "setSerializationContext", "(Lcom/jetbrains/rider/framework/SerializationCtx;)V", "syncTaskId", "wireScheduler", "getWireScheduler", "()Lcom/jetbrains/rider/util/reactive/IScheduler;", "init", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "onWireReceived", "buffer", "Lcom/jetbrains/rider/framework/AbstractBuffer;", "start", "Lcom/jetbrains/rider/framework/IRdTask;", "request", "(Ljava/lang/Object;)Lcom/jetbrains/rider/framework/IRdTask;", "responseScheduler", "(Ljava/lang/Object;Lcom/jetbrains/rider/util/reactive/IScheduler;)Lcom/jetbrains/rider/framework/IRdTask;", "startInternal", "sync", "", "scheduler", "(Ljava/lang/Object;ZLcom/jetbrains/rider/util/reactive/IScheduler;)Lcom/jetbrains/rider/framework/IRdTask;", "timeouts", "Lcom/jetbrains/rider/framework/impl/RpcTimeouts;", "(Ljava/lang/Object;Lcom/jetbrains/rider/framework/impl/RpcTimeouts;)Ljava/lang/Object;", "Companion", "rd-framework-jvm"})
public final class RdCall<TReq, TRes>
extends RdReactiveBase
implements IRdCall<TReq, TRes> {
    private final Map<RdId, Pair<IScheduler, RdTask<TRes>>> requests;
    private volatile RdId syncTaskId;
    @NotNull
    public SerializationCtx serializationContext;
    private final ISerializer<TReq> requestSzr;
    private final ISerializer<TRes> responseSzr;
    private static boolean respectSyncCallTimeouts;
    public static final Companion Companion;

    @Override
    @NotNull
    public SerializationCtx getSerializationContext() {
        SerializationCtx serializationCtx = this.serializationContext;
        if (serializationCtx == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serializationContext");
        }
        return serializationCtx;
    }

    public void setSerializationContext(@NotNull SerializationCtx serializationCtx) {
        Intrinsics.checkParameterIsNotNull((Object)serializationCtx, (String)"<set-?>");
        this.serializationContext = serializationCtx;
    }

    @Override
    @NotNull
    public IScheduler getWireScheduler() {
        return (IScheduler)SynchronousScheduler.INSTANCE;
    }

    @Override
    protected void init(@NotNull Lifetime lifetime) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        super.init(lifetime);
        this.setSerializationContext(super.getSerializationContext());
        this.getWire().advise(lifetime, this);
        LifetimeExKt.plusAssign((Lifetime)lifetime, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RdCall this$0;

            public final void invoke() {
                Map map = RdCall.access$getRequests$p(this.this$0);
                for (Map.Entry<K, V> req : map.entrySet()) {
                    RdTask task = (RdTask)((Pair)req.getValue()).getSecond();
                    if (InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)task.getResult()))) continue;
                    task.getResult().set(new RdTaskResult.Cancelled<T>());
                }
                RdCall.access$getRequests$p(this.this$0).clear();
            }
            {
                this.this$0 = rdCall;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onWireReceived(@NotNull AbstractBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        RdId taskId = SerializersKt.readRdId(buffer);
        Pair<IScheduler, RdTask<TRes>> request = this.requests.get(taskId);
        if (request == null) {
            void $receiver$iv$iv;
            Logger $receiver$iv;
            Logger logger = $receiver$iv = (Logger)RdReactiveBase.Companion.getLogReceived();
            LogLevel level$iv$iv = LogLevel.Trace;
            if ($receiver$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var11_12 = $receiver$iv$iv;
                String string = "call `" + this.getLocation() + "` (" + this.getRdid() + ") received response '" + taskId + "' but it was dropped";
                var11_12.log(logLevel, (Object)string, null);
            }
        } else {
            void scheduler;
            void $receiver$iv$iv;
            Logger $receiver$iv;
            RdTaskResult<TRes> result = RdTaskResult.Companion.read(this.getSerializationContext(), buffer, this.responseSzr);
            Logger level$iv$iv = $receiver$iv = (Logger)RdReactiveBase.Companion.getLogReceived();
            LogLevel level$iv$iv2 = LogLevel.Trace;
            if ($receiver$iv$iv.isEnabled(level$iv$iv2)) {
                LogLevel logLevel = level$iv$iv2;
                void var11_13 = $receiver$iv$iv;
                String string = "call `" + this.getLocation() + "` (" + this.getRdid() + ") received response '" + taskId + "' : " + IPrintableKt.printToString(result) + ' ';
                var11_13.log(logLevel, (Object)string, null);
            }
            Pair<IScheduler, RdTask<TRes>> pair = request;
            $receiver$iv = (IScheduler)pair.component1();
            RdTask task = (RdTask)pair.component2();
            scheduler.queue((Function0)new Function0<Unit>(this, task, taskId, result){
                final /* synthetic */ RdCall this$0;
                final /* synthetic */ RdTask $task;
                final /* synthetic */ RdId $taskId;
                final /* synthetic */ RdTaskResult $result;

                public final void invoke() {
                    if (InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)this.$task.getResult()))) {
                        String string;
                        Logger logger;
                        LogLevel logLevel;
                        Logger $receiver$iv$iv;
                        Logger $receiver$iv;
                        Logger logger2 = $receiver$iv = (Logger)RdReactiveBase.Companion.getLogReceived();
                        LogLevel level$iv$iv = LogLevel.Trace;
                        if ($receiver$iv$iv.isEnabled(level$iv$iv)) {
                            logLevel = level$iv$iv;
                            logger = $receiver$iv$iv;
                            string = "call `" + this.this$0.getLocation() + "` (" + this.this$0.getRdid() + ") response was dropped, task result is: " + (RdTaskResult)this.$task.getResult().getValueOrNull();
                            logger.log(logLevel, (Object)string, null);
                        }
                        if (this.this$0.isBound() && RdCall.access$getDefaultScheduler$p(this.this$0).isActive() && RdCall.access$getRequests$p(this.this$0).containsKey(this.$taskId) && ($receiver$iv$iv = ($receiver$iv = RdReactiveBase.Companion.getLogAssert())).isEnabled(level$iv$iv = LogLevel.Error)) {
                            logLevel = level$iv$iv;
                            logger = $receiver$iv$iv;
                            string = "MainThread: " + RdCall.access$getDefaultScheduler$p(this.this$0).isActive() + ", taskId=" + this.$taskId + ' ';
                            logger.log(logLevel, (Object)string, null);
                        }
                    } else {
                        this.$task.getResult().set((Object)this.$result);
                        RdCall.access$getRequests$p(this.this$0).remove(this.$taskId);
                    }
                }
                {
                    this.this$0 = rdCall;
                    this.$task = rdTask;
                    this.$taskId = rdId;
                    this.$result = rdTaskResult;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public TRes sync(TReq request, @Nullable RpcTimeouts timeouts) {
        try {
            RpcTimeouts rpcTimeouts;
            IRdTask<?> task = this.startInternal(request, true, (IScheduler)SynchronousScheduler.INSTANCE);
            if (respectSyncCallTimeouts) {
                rpcTimeouts = timeouts;
                if (rpcTimeouts == null) {
                    rpcTimeouts = RpcTimeouts.Companion.getDefault();
                }
            } else {
                rpcTimeouts = RpcTimeouts.Companion.getMaximal();
            }
            RpcTimeouts effectiveTimeouts = rpcTimeouts;
            long freezeTime2 = PlatformDependentKt.measureTimeMillis((Function0)((Function0)new Function0<Unit>(this, task, effectiveTimeouts){
                final /* synthetic */ RdCall this$0;
                final /* synthetic */ IRdTask $task;
                final /* synthetic */ RpcTimeouts $effectiveTimeouts;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    boolean bl;
                    block5: {
                        void this_$iv$iv$iv;
                        void this_$iv$iv;
                        IRdTask iRdTask = this.$task;
                        long timeoutMs$iv = this.$effectiveTimeouts.getErrorAwaitTime();
                        SpinWait.Companion companion = SpinWait.Companion;
                        Lifetime lifetime$iv$iv = Lifetime.Companion.getEternal();
                        void var6_5 = this_$iv$iv;
                        Duration duration = Duration.ofMillis(timeoutMs$iv);
                        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMillis(timeoutMs)");
                        Duration duration$iv$iv$iv = duration;
                        SpinWait s$iv$iv$iv = this_$iv$iv$iv.getSpin();
                        long start$iv$iv$iv = System.nanoTime();
                        while (true) {
                            void $receiver$iv;
                            boolean bl2;
                            boolean $receiver$iv2;
                            if (!($receiver$iv2 = (bl2 = InterfacesKt.getHasValue($receiver$iv.getResult()))) && this.this$0.getProtocol().getScheduler().isActive()) {
                                RdExtBase rdExtBase = this.this$0.getContainingExt();
                                if (rdExtBase != null) {
                                    rdExtBase.pumpScheduler();
                                }
                            }
                            if (bl2) break;
                            if (lifetime$iv$iv.isTerminated() || System.nanoTime() - start$iv$iv$iv > duration$iv$iv$iv.toNanos()) {
                                bl = false;
                                break block5;
                            }
                            s$iv$iv$iv.spinOnce();
                        }
                        bl = true;
                    }
                    if (!bl) {
                        throw (Throwable)new TimeoutException("Sync execution of rpc `" + this.this$0.getLocation() + "` is timed out in " + this.$effectiveTimeouts.getErrorAwaitTime() + " ms");
                    }
                }
                {
                    this.this$0 = rdCall;
                    this.$task = iRdTask;
                    this.$effectiveTimeouts = rpcTimeouts;
                    super(0);
                }
            }));
            if (freezeTime2 > effectiveTimeouts.getWarnAwaitTime()) {
                void $receiver$iv$iv;
                Logger $receiver$iv;
                Logger logger = $receiver$iv = RdReactiveBase.Companion.getLogAssert();
                LogLevel level$iv$iv = LogLevel.Error;
                if ($receiver$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    void var13_11 = $receiver$iv$iv;
                    String string = "Sync execution of rpc `" + this.getLocation() + "` executed too long: " + freezeTime2 + " ms ";
                    var13_11.log(logLevel, (Object)string, null);
                }
            }
            Object object = InterfacesKt.getValueOrThrow(task.getResult());
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.framework.RdTaskResult<TRes>");
            }
            Object t = ((RdTaskResult)object).unwrap();
            return (TRes)t;
        }
        finally {
            this.syncTaskId = null;
        }
    }

    @Override
    @NotNull
    public IRdTask<TRes> start(TReq request, @Nullable IScheduler responseScheduler) {
        IScheduler iScheduler = responseScheduler;
        if (iScheduler == null) {
            iScheduler = this.getProtocol().getScheduler();
        }
        IRdTask<?> iRdTask = this.startInternal(request, false, iScheduler);
        if (iRdTask == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.framework.impl.RdTask<TRes>");
        }
        return (RdTask)iRdTask;
    }

    @NotNull
    public final IRdTask<TRes> start(TReq request) {
        return this.start(request, null);
    }

    private final IRdTask<?> startInternal(TReq request, boolean sync2, IScheduler scheduler) {
        this.assertBound();
        if (!this.getAsync()) {
            this.assertThreading();
        }
        RdId taskId = this.getProtocol().getIdentity().next(this.getRdid());
        RdTask task = new RdTask();
        CollectionExKt.putUnique(this.requests, (Object)taskId, (Object)TuplesKt.to((Object)scheduler, task));
        if (sync2) {
            if (this.syncTaskId != null) {
                throw (Throwable)new IllegalStateException("Already exists sync task for call `" + this.getLocation() + "`, taskId = " + this.syncTaskId);
            }
            this.syncTaskId = taskId;
        }
        this.getWire().send(this.getRdid(), (Function1<? super AbstractBuffer, Unit>)((Function1)new Function1<AbstractBuffer, Unit>(this, sync2, taskId, request){
            final /* synthetic */ RdCall this$0;
            final /* synthetic */ boolean $sync;
            final /* synthetic */ RdId $taskId;
            final /* synthetic */ Object $request;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull AbstractBuffer buffer) {
                void $receiver$iv$iv;
                Logger $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
                Logger logger = $receiver$iv = (Logger)RdReactiveBase.Companion.getLogSend();
                LogLevel level$iv$iv = LogLevel.Trace;
                if ($receiver$iv$iv.isEnabled(level$iv$iv)) {
                    void $receiver$iv2;
                    LogLevel logLevel = level$iv$iv;
                    void var13_6 = $receiver$iv$iv;
                    boolean bl = this.$sync;
                    StringBuilder stringBuilder = new StringBuilder().append("call `").append(this.this$0.getLocation()).append("`::(").append(this.this$0.getRdid()).append(") send");
                    String string = $receiver$iv2 != false ? " SYNC" : "";
                    String string2 = stringBuilder.append(string).append(" request '").append(this.$taskId).append("' : ").append(IPrintableKt.printToString((Object)this.$request)).append(' ').toString();
                    var13_6.log(logLevel, (Object)string2, null);
                }
                this.$taskId.write(buffer);
                RdCall.access$getRequestSzr$p(this.this$0).write(this.this$0.getSerializationContext(), buffer, this.$request);
            }
            {
                this.this$0 = rdCall;
                this.$sync = bl;
                this.$taskId = rdId;
                this.$request = object;
                super(1);
            }
        }));
        return task;
    }

    public RdCall(@NotNull ISerializer<TReq> requestSzr, @NotNull ISerializer<TRes> responseSzr) {
        Intrinsics.checkParameterIsNotNull(requestSzr, (String)"requestSzr");
        Intrinsics.checkParameterIsNotNull(responseSzr, (String)"responseSzr");
        this.requestSzr = requestSzr;
        this.responseSzr = responseSzr;
        this.requests = PlatformDependentKt.concurrentMapOf();
    }

    public /* synthetic */ RdCall(ISerializer iSerializer, ISerializer iSerializer2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iSerializer = Polymorphic.INSTANCE.invoke();
        }
        if ((n & 2) != 0) {
            iSerializer2 = Polymorphic.INSTANCE.invoke();
        }
        this(iSerializer, iSerializer2);
    }

    public RdCall() {
        this(null, null, 3, null);
    }

    static {
        Companion = new Companion(null);
        respectSyncCallTimeouts = true;
    }

    @NotNull
    public static final /* synthetic */ Map access$getRequests$p(RdCall $this) {
        return $this.requests;
    }

    @NotNull
    public static final /* synthetic */ IScheduler access$getDefaultScheduler$p(RdCall $this) {
        return $this.getDefaultScheduler();
    }

    @NotNull
    public static final /* synthetic */ ISerializer access$getRequestSzr$p(RdCall $this) {
        return $this.requestSzr;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016JJ\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u0002\"\u0004\b\u0002\u0010\u000f\"\u0004\b\u0003\u0010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0001J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u0015\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0002H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/framework/impl/RdCall$Companion;", "Lcom/jetbrains/rider/framework/ISerializer;", "Lcom/jetbrains/rider/framework/impl/RdCall;", "()V", "respectSyncCallTimeouts", "", "getRespectSyncCallTimeouts", "()Z", "setRespectSyncCallTimeouts", "(Z)V", "read", "ctx", "Lcom/jetbrains/rider/framework/SerializationCtx;", "buffer", "Lcom/jetbrains/rider/framework/AbstractBuffer;", "TReq", "TRes", "requestSzr", "responseSzr", "write", "", "value", "rd-framework-jvm"})
    public static final class Companion
    implements ISerializer<RdCall<?, ?>> {
        @Override
        @NotNull
        public RdCall<?, ?> read(@NotNull SerializationCtx ctx, @NotNull AbstractBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            return this.read(ctx, buffer, Polymorphic.INSTANCE.invoke(), Polymorphic.INSTANCE.invoke());
        }

        @NotNull
        public final <TReq, TRes> RdCall<TReq, TRes> read(@NotNull SerializationCtx ctx, @NotNull AbstractBuffer buffer, @NotNull ISerializer<TReq> requestSzr, @NotNull ISerializer<TRes> responseSzr) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull(requestSzr, (String)"requestSzr");
            Intrinsics.checkParameterIsNotNull(responseSzr, (String)"responseSzr");
            return (RdCall)RdBindableBaseKt.withId((RdBindableBase)new RdCall<TReq, TRes>(requestSzr, responseSzr), SerializersKt.readRdId(buffer));
        }

        @Override
        public void write(@NotNull SerializationCtx ctx, @NotNull AbstractBuffer buffer, @NotNull RdCall<?, ?> value2) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull(value2, (String)"value");
            SerializersKt.writeRdId(buffer, value2.getRdid());
        }

        public final boolean getRespectSyncCallTimeouts() {
            return respectSyncCallTimeouts;
        }

        public final void setRespectSyncCallTimeouts(boolean bl) {
            respectSyncCallTimeouts = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

