/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsProjectLog;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.config.GitSharedSettings;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"findProtectedRemoteBranch", "", "repository", "Lgit4idea/repo/GitRepository;", "branches", "", "findProtectedRemoteBranchContainingCommit", "hash", "Lcom/intellij/vcs/log/Hash;", "isCommitPublished", "", "intellij.vcs.git"})
public final class GitProtectedBranchesKt {
    @Nullable
    public static final String findProtectedRemoteBranch(@NotNull GitRepository repository, @NotNull Collection<String> branches2) {
        Object v4;
        block3: {
            GitRemoteBranch it;
            Iterable $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            Intrinsics.checkParameterIsNotNull(branches2, (String)"branches");
            GitSharedSettings settings = GitSharedSettings.getInstance(repository.getProject());
            GitBranchesCollection gitBranchesCollection = repository.getBranches();
            Intrinsics.checkExpressionValueIsNotNull((Object)gitBranchesCollection, (String)"repository.branches");
            Collection<GitRemoteBranch> collection = gitBranchesCollection.getRemoteBranches();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"repository.branches.remoteBranches");
            Iterable $receiver$iv = collection;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                GitRemoteBranch gitRemoteBranch = it = (GitRemoteBranch)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitRemoteBranch, (String)"it");
                if (!settings.isBranchProtected(gitRemoteBranch.getNameForRemoteOperations())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (GitRemoteBranch)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                GitRemoteBranch gitRemoteBranch = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitRemoteBranch, (String)"it");
                String string = gitRemoteBranch.getNameForLocalOperations();
                collection2.add(string);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                String it2 = (String)element$iv;
                if (!branches2.contains(it2)) continue;
                v4 = element$iv;
                break block3;
            }
            v4 = null;
        }
        return v4;
    }

    @Nullable
    public static final String findProtectedRemoteBranchContainingCommit(@NotNull GitRepository repository, @NotNull Hash hash) {
        Collection collection;
        ContainingBranchesGetter branchesGetter;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        VirtualFile root = repository.getRoot();
        VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance((Project)repository.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsProjectLog, (String)"VcsProjectLog.getInstance(repository.project)");
        VcsLogData vcsLogData = vcsProjectLog.getDataManager();
        Object object = branchesGetter = vcsLogData != null ? vcsLogData.getContainingBranchesGetter() : null;
        if (branchesGetter != null) {
            List list = (List)ActionsKt.invokeAndWaitIfNeed$default(null, (Function0)((Function0)new Function0<List<String>>(branchesGetter, root, hash){
                final /* synthetic */ ContainingBranchesGetter $branchesGetter;
                final /* synthetic */ VirtualFile $root;
                final /* synthetic */ Hash $hash;

                @Nullable
                public final List<String> invoke() {
                    return this.$branchesGetter.getContainingBranchesQuickly(this.$root, this.$hash);
                }
                {
                    this.$branchesGetter = containingBranchesGetter;
                    this.$root = virtualFile;
                    this.$hash = hash;
                    super(0);
                }
            }), (int)1, null);
            if (list != null) {
                collection = list;
            } else {
                List list2 = branchesGetter.getContainingBranchesSynchronously(root, hash);
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"branchesGetter.getContai\u2026Synchronously(root, hash)");
                collection = list2;
            }
        } else {
            Collection collection2 = GitBranchUtil.getBranches(repository.getProject(), root, false, true, hash.asString());
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"GitBranchUtil.getBranche\u2026e, true, hash.asString())");
        }
        Collection branches2 = collection;
        return GitProtectedBranchesKt.findProtectedRemoteBranch(repository, branches2);
    }

    public static final boolean isCommitPublished(@NotNull GitRepository repository, @NotNull Hash hash) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        return GitProtectedBranchesKt.findProtectedRemoteBranchContainingCommit(repository, hash) != null;
    }
}

