/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth;

import com.microsoft.alm.auth.Authenticator;
import com.microsoft.alm.auth.PromptBehavior;
import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.secret.Credential;
import com.microsoft.alm.secret.Secret;
import com.microsoft.alm.secret.Token;
import com.microsoft.alm.secret.TokenPair;
import com.microsoft.alm.secret.VsoTokenScope;
import com.microsoft.alm.storage.SecretStore;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(BaseAuthenticator.class);
    protected Secret.IUriNameConversion uriToKeyConversion = Secret.DefaultUriNameConversion;

    @Override
    public Secret.IUriNameConversion getUriToKeyConversion() {
        return this.uriToKeyConversion;
    }

    @Override
    public void setUriToKeyConversion(Secret.IUriNameConversion conversion) {
        this.uriToKeyConversion = conversion;
    }

    @Override
    public boolean isCredentialSupported() {
        return false;
    }

    @Override
    public Credential getCredential(URI key) {
        return null;
    }

    @Override
    public Credential getCredential(URI key, PromptBehavior promptBehavior) {
        return null;
    }

    @Override
    public boolean isOAuth2TokenSupported() {
        return false;
    }

    @Override
    public TokenPair getOAuth2TokenPair() {
        return null;
    }

    @Override
    public TokenPair getOAuth2TokenPair(PromptBehavior promptBehavior) {
        return null;
    }

    @Override
    public TokenPair getOAuth2TokenPair(URI key, PromptBehavior promptBehavior) {
        return null;
    }

    @Override
    public boolean isPersonalAccessTokenSupported() {
        return false;
    }

    @Override
    public Token getPersonalAccessToken(VsoTokenScope tokenScope, String patDisplayName, PromptBehavior promptBehavior) {
        return null;
    }

    @Override
    public Token getPersonalAccessToken(URI key, VsoTokenScope tokenScope, String patDisplayName, PromptBehavior promptBehavior) {
        return null;
    }

    @Override
    public Token getPersonalAccessToken(URI key, VsoTokenScope tokenScope, String patDisplayName, PromptBehavior promptBehavior, TokenPair oauth2Token) {
        return null;
    }

    @Override
    public boolean signOut() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean signOut(URI uri) {
        Debug.Assert((uri != null ? 1 : 0) != 0, (String)"uri cannot be null");
        logger.debug("Signing out from uri: {}", (Object)uri);
        String key = this.getKey(uri);
        Debug.Assert((key != null ? 1 : 0) != 0, (String)"key conversion failed");
        SecretStore secretStore = this.getStore();
        synchronized (secretStore) {
            logger.debug("Deleting secret for {}", (Object)key);
            return this.getStore().delete(key);
        }
    }

    public String getKey(URI targetUri) {
        logger.debug("Getting secret for uri: {}", (Object)targetUri);
        return this.uriToKeyConversion.convert(targetUri, this.getAuthType());
    }

    protected abstract SecretStore getStore();

    public static abstract class SecretRetriever<E extends Secret> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected E readFromStore(String key, SecretStore<E> store) {
            SecretStore<E> secretStore = store;
            synchronized (secretStore) {
                return (E)store.get(key);
            }
        }

        protected boolean tryGetValidated(E secret, AtomicReference<E> secretHolder) {
            return true;
        }

        protected abstract E doRetrieve();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void store(String key, SecretStore<E> store, E secret) {
            if (secret != null) {
                logger.debug("Storing secret for key: {}.", (Object)key);
                SecretStore<E> secretStore = store;
                synchronized (secretStore) {
                    store.delete(key);
                    store.add(key, secret);
                }
            }
        }

        public E retrieve(String key, SecretStore<E> store, PromptBehavior promptBehavior) {
            logger.debug("Retrieving secret with key: {}, and prompt behavior: {}.", (Object)key, (Object)promptBehavior.name());
            Secret secret = null;
            if (promptBehavior != PromptBehavior.ALWAYS) {
                logger.debug("Reading secret from store for key: {}", (Object)key);
                secret = (Secret)this.readFromStore(key, store);
                if (secret != null) {
                    AtomicReference<Secret> secretHolder = new AtomicReference<Secret>();
                    secretHolder.set(secret);
                    if (this.tryGetValidated(secret, secretHolder)) {
                        Secret validatedSecret = (Secret)secretHolder.get();
                        if (!validatedSecret.equals(secret)) {
                            store.delete(key);
                            store.add(key, validatedSecret);
                            secret = validatedSecret;
                        }
                    } else {
                        secret = null;
                        store.delete(key);
                    }
                }
            }
            if (promptBehavior == PromptBehavior.NEVER) {
                logger.debug("Returning whatever we retrieved from the store, do not prompt.");
                return (E)secret;
            }
            if (promptBehavior == PromptBehavior.ALWAYS || secret == null && promptBehavior == PromptBehavior.AUTO) {
                logger.debug("Retrieving secret.");
                secret = (Secret)this.doRetrieve();
                this.store(key, store, secret);
            }
            return (E)secret;
        }
    }
}

