/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.oauth;

import com.microsoft.alm.helpers.PropertyBag;
import java.net.URI;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicReference;

public class DeviceFlowResponse {
    private final AtomicReference<RESPONSE_STATE> state = new AtomicReference();
    private final String deviceCode;
    private final String userCode;
    private final URI verificationUri;
    private final int expiresIn;
    private final Calendar expiresAt;
    private final int interval;

    public DeviceFlowResponse(String deviceCode, String userCode, URI verificationUri, int expiresIn, int interval) {
        this.deviceCode = deviceCode;
        this.userCode = userCode;
        this.verificationUri = verificationUri;
        this.expiresIn = expiresIn;
        this.expiresAt = Calendar.getInstance();
        this.expiresAt.add(13, expiresIn);
        this.interval = interval;
        this.state.set(RESPONSE_STATE.WAITING_FOR_USER);
    }

    public static DeviceFlowResponse fromJson(String jsonText) {
        PropertyBag bag = PropertyBag.fromJson((String)jsonText);
        String deviceCode = (String)bag.get((Object)"device_code");
        String userCode = (String)bag.get((Object)"user_code");
        String verificationUriString = (String)bag.get((Object)"verification_uri");
        URI verificationUri = URI.create(verificationUriString);
        int expiresInSeconds = bag.readOptionalInteger("expires_in", 600);
        int intervalInSeconds = bag.readOptionalInteger("interval", 5);
        DeviceFlowResponse result = new DeviceFlowResponse(deviceCode, userCode, verificationUri, expiresInSeconds, intervalInSeconds);
        return result;
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public URI getVerificationUri() {
        return this.verificationUri;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public Calendar getExpiresAt() {
        return this.expiresAt;
    }

    public int getInterval() {
        return this.interval;
    }

    boolean cancelRequestedByUser() {
        return this.state.get() == RESPONSE_STATE.CANCEL_REQUESTED;
    }

    void setTokenAcquired() {
        this.state.set(RESPONSE_STATE.TOKEN_ACQUIRED);
    }

    public boolean isTokenAcquired() {
        return this.state.get() == RESPONSE_STATE.TOKEN_ACQUIRED;
    }

    public void requestCancel() {
        this.state.set(RESPONSE_STATE.CANCEL_REQUESTED);
    }

    static enum RESPONSE_STATE {
        WAITING_FOR_USER,
        CANCEL_REQUESTED,
        TOKEN_ACQUIRED;

    }
}

