/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.pat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.alm.auth.BaseAuthenticator;
import com.microsoft.alm.auth.PromptBehavior;
import com.microsoft.alm.auth.oauth.Global;
import com.microsoft.alm.auth.oauth.OAuth2Authenticator;
import com.microsoft.alm.auth.pat.VsoAzureAuthority;
import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.helpers.HttpClient;
import com.microsoft.alm.secret.Secret;
import com.microsoft.alm.secret.Token;
import com.microsoft.alm.secret.TokenPair;
import com.microsoft.alm.secret.VsoTokenScope;
import com.microsoft.alm.storage.SecretStore;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VstsPatAuthenticator
extends BaseAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(VstsPatAuthenticator.class);
    private static final String TYPE = "PersonalAccessToken";
    private final VsoAzureAuthority vsoAzureAuthority;
    private final OAuth2Authenticator vstsOauthAuthenticator;
    private final SecretStore<Token> store;
    private final ObjectMapper objectMapper;
    private static final Pattern ID_PATTERN = Pattern.compile("\"id\"\\s*:\\s*\"([^\"]+)\"", 2);

    public VstsPatAuthenticator(String oauthClientId, String oauthClientRedirectUrl, SecretStore<TokenPair> oauthTokenStore, SecretStore<Token> store) {
        Debug.Assert((oauthClientId != null ? 1 : 0) != 0, (String)"oauthClientId cannot be null");
        Debug.Assert((oauthClientRedirectUrl != null ? 1 : 0) != 0, (String)"oauthClientRedirectUrl cannot be null");
        Debug.Assert((store != null ? 1 : 0) != 0, (String)"store cannot be null");
        this.vstsOauthAuthenticator = OAuth2Authenticator.getAuthenticator(oauthClientId, oauthClientRedirectUrl, oauthTokenStore);
        this.vsoAzureAuthority = new VsoAzureAuthority();
        this.store = store;
        this.objectMapper = new ObjectMapper();
    }

    public VstsPatAuthenticator(OAuth2Authenticator oauth2Authenticator, SecretStore<Token> store) {
        this(new VsoAzureAuthority(), oauth2Authenticator, store);
    }

    VstsPatAuthenticator(VsoAzureAuthority vsoAzureAuthority, OAuth2Authenticator oauth2Authenticator, SecretStore<Token> store) {
        Debug.Assert((oauth2Authenticator != null ? 1 : 0) != 0, (String)"oauth2Authenticatorcannot be null");
        Debug.Assert((store != null ? 1 : 0) != 0, (String)"store cannot be null");
        this.vsoAzureAuthority = vsoAzureAuthority;
        this.vstsOauthAuthenticator = oauth2Authenticator;
        this.store = store;
        this.objectMapper = new ObjectMapper();
    }

    protected SecretStore<Token> getStore() {
        return this.store;
    }

    @Override
    public String getAuthType() {
        return TYPE;
    }

    @Override
    public boolean isPersonalAccessTokenSupported() {
        return true;
    }

    @Override
    public Token getPersonalAccessToken(VsoTokenScope tokenScope, String patDisplayName, PromptBehavior promptBehavior) {
        logger.debug("Retrieving global Personal Access Token.");
        return this.getToken(OAuth2Authenticator.APP_VSSPS_VISUALSTUDIO, true, tokenScope, patDisplayName, promptBehavior, null);
    }

    @Override
    public Token getPersonalAccessToken(URI uri, VsoTokenScope tokenScope, String patDisplayName, PromptBehavior promptBehavior) {
        logger.debug("Retrieving Personal Access Token for uri: {}", (Object)uri);
        return this.getToken(uri, false, tokenScope, patDisplayName, promptBehavior, null);
    }

    @Override
    public Token getPersonalAccessToken(URI uri, VsoTokenScope tokenScope, String patDisplayName, PromptBehavior promptBehavior, TokenPair oauth2Token) {
        logger.debug("Retrieving Personal Access Token for uri: {}", (Object)uri);
        return this.getToken(uri, false, tokenScope, patDisplayName, promptBehavior, oauth2Token);
    }

    private Token getToken(final URI uri, final boolean isCreatingGlobalPat, final VsoTokenScope tokenScope, final String patDisplayName, final PromptBehavior promptBehavior, final TokenPair oauth2Token) {
        Debug.Assert((uri != null ? 1 : 0) != 0, (String)"uri cannot be null");
        Debug.Assert((promptBehavior != null ? 1 : 0) != 0, (String)"promptBehavior cannot be null");
        logger.info("Retrieving PersonalAccessToken for uri:{} with name:{}, and with scope:{}, prompt behavior: {}", new Object[]{uri, patDisplayName, tokenScope, promptBehavior.name()});
        String key = this.getKey(uri);
        Debug.Assert((key != null ? 1 : 0) != 0, (String)"Failed to convert uri to key");
        BaseAuthenticator.SecretRetriever<Token> secretRetriever = new BaseAuthenticator.SecretRetriever<Token>(){

            @Override
            protected boolean tryGetValidated(Token token, AtomicReference<Token> holder) {
                Debug.Assert((token != null ? 1 : 0) != 0, (String)"Token is null");
                Debug.Assert((holder != null ? 1 : 0) != 0, (String)"Holder is null");
                URI validationEndpoint = URI.create(uri + "/_apis/connectionData");
                boolean valid = false;
                if (token.Value != null) {
                    HttpClient client = Global.getHttpClientFactory().createHttpClient();
                    token.contributeHeader(client.getHeaders());
                    try {
                        client.getGetResponseText(validationEndpoint);
                        valid = true;
                    }
                    catch (IOException e) {
                        logger.debug("Validation failed with IOException.", (Throwable)e);
                    }
                }
                logger.debug("Personal Access Token is {}.", (Object)(valid ? "valid" : "invalid."));
                return valid;
            }

            @Override
            protected Token doRetrieve() {
                TokenPair tokenPair;
                TokenPair tokenPair2 = oauth2Token == null ? VstsPatAuthenticator.this.vstsOauthAuthenticator.getOAuth2TokenPair(uri, PromptBehavior.AUTO) : (tokenPair = oauth2Token);
                if (tokenPair == null) {
                    logger.debug("Failed to get an OAuth2 token, cannot generate PersonalAccessToken.");
                    return null;
                }
                logger.debug("Got OAuth2 token, retrieving Personal Access Token with it.");
                URI accountSpecificUri = VstsPatAuthenticator.this.createAccountSpecificUri(uri, tokenPair);
                Token pat = VstsPatAuthenticator.this.vsoAzureAuthority.generatePersonalAccessToken(accountSpecificUri, tokenPair.AccessToken, tokenScope, true, isCreatingGlobalPat, patDisplayName);
                return pat;
            }
        };
        return secretRetriever.retrieve(key, this.getStore(), promptBehavior);
    }

    private URI createAccountSpecificUri(URI uri, TokenPair tokenPair) {
        if (OAuth2Authenticator.APP_VSSPS_VISUALSTUDIO.equals(uri)) {
            logger.debug("Find an account level target url to generate Personal Access Token.");
            HttpClient client = Global.getHttpClientFactory().createHttpClient();
            tokenPair.AccessToken.contributeHeader(client.getHeaders());
            try {
                String profileId = this.getProfileId(client);
                String accountUri = this.getAccountUri(client, profileId);
                logger.debug("Found account: {}", (Object)accountUri);
                return URI.create(accountUri);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return uri;
    }

    private String getProfileId(HttpClient authenticatedClient) throws IOException {
        Debug.Assert((authenticatedClient != null ? 1 : 0) != 0, (String)"authenticatedClient is null");
        URI profileUri = URI.create("https://app.vssps.visualstudio.com/_apis/profile/profiles/me?api-version=1.0");
        logger.debug("Getting user profile...");
        String responseText = authenticatedClient.getGetResponseText(profileUri);
        String id = VstsPatAuthenticator.parseIdFromJson(responseText);
        if (id != null) {
            logger.debug("Profile id: {}", (Object)id);
            return id;
        }
        throw new RuntimeException("Failed to get profile id.");
    }

    static String parseIdFromJson(String json) {
        String result = null;
        Matcher matcher = ID_PATTERN.matcher(json);
        if (matcher.find()) {
            result = matcher.group(1);
        }
        return result;
    }

    private String getAccountUri(HttpClient authenticatedClient, String profileId) throws IOException {
        AccountList accountList;
        Debug.Assert((authenticatedClient != null ? 1 : 0) != 0, (String)"authenticatedClient is null");
        Debug.Assert((profileId != null ? 1 : 0) != 0, (String)"profileId is null");
        String accountApiUrlFormat = "https://app.vssps.visualstudio.com/_apis/Accounts?memberid=%s&api-version=1.0";
        URI accountApiUrl = URI.create(String.format("https://app.vssps.visualstudio.com/_apis/Accounts?memberid=%s&api-version=1.0", profileId));
        String vstsAccountUrlFormat = "https://%s.visualstudio.com/";
        logger.debug("Account API URL: {}", (Object)accountApiUrl);
        String content = authenticatedClient.getGetResponseText(accountApiUrl);
        if (content != null && (accountList = (AccountList)this.objectMapper.readValue(content, AccountList.class)) != null && accountList.value != null) {
            for (Account account : accountList.value) {
                if (account.accountStatus == null || account.accountUri == null) continue;
                return String.format("https://%s.visualstudio.com/", account.accountName);
            }
        }
        throw new RuntimeException("Could not find any accounts.");
    }

    @Override
    public boolean signOut() {
        return this.signOut(OAuth2Authenticator.APP_VSSPS_VISUALSTUDIO);
    }

    @Override
    public boolean signOut(URI uri) {
        logger.info("Signing out from uri: {}", (Object)uri);
        Debug.Assert((uri != null ? 1 : 0) != 0, (String)"uri cannot be null");
        return super.signOut(uri) && this.vstsOauthAuthenticator.signOut();
    }

    public boolean assignGlobalPatTo(URI uri) {
        Debug.Assert((uri != null ? 1 : 0) != 0, (String)"uri cannot be null");
        logger.debug("Assigning the global PAT to uri: {}", (Object)uri);
        String globalKey = this.getKey(OAuth2Authenticator.APP_VSSPS_VISUALSTUDIO);
        Token token = (Token)this.getStore().get(globalKey);
        if (token != null) {
            this.assign(uri, token);
            logger.debug("Global PAT transferred to uri: {}", (Object)uri);
            return true;
        }
        logger.debug("Could not find global PAT.");
        return false;
    }

    private void assign(URI uri, Token token) {
        String key = this.getKey(uri);
        this.getStore().add(key, (Secret)token);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Account {
        public UUID accountId;
        public URI accountUri;
        public String accountName;
        public String organizationName;
        public String accountType;
        public UUID accountOwner;
        public String accountStatus;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AccountList {
        public int count;
        public List<Account> value;
    }
}

