/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.ConsoleMessage;
import com.intellij.javascript.debugger.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.ConsolePrinter;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.debugger.wip.WipConsoleMessageTask$WhenMappings;
import com.jetbrains.debugger.wip.WipConsoleMessageTaskKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateContextBase;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.wip.RequestInfo;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.protocol.console.ConsoleMessageValue;
import org.jetbrains.wip.protocol.network.InitiatorValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/debugger/wip/WipConsoleMessageTask;", "Lcom/intellij/javascript/debugger/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/console/ConsoleMessageValue;", "request", "Lorg/jetbrains/wip/RequestInfo;", "(Lorg/jetbrains/wip/protocol/console/ConsoleMessageValue;Lorg/jetbrains/wip/RequestInfo;)V", "print", "", "printer", "Lcom/intellij/javascript/debugger/ConsoleMessageBuilder;", "printFailedNetworkRequestMessage", "printParameters", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "isNotFirst", "", "intellij.javascript.chrome.connector"})
public final class WipConsoleMessageTask
implements ConsoleMessage {
    private final ConsoleMessageValue message;
    private final RequestInfo request;

    public void print(@NotNull ConsoleMessageBuilder printer) {
        boolean isFromNetwork;
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        String url = this.message.getUrl();
        int line = this.message.getLine();
        int column = this.message.getColumn();
        StackTraceValue stackTraceValue = this.message.getStack();
        List<CallFrameValue> stackTrace = stackTraceValue != null ? stackTraceValue.callFrames() : null;
        ConsoleViewContentType contentType = this.message.level() == ConsoleMessageValue.Level.ERROR ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT;
        block0 : switch (WipConsoleMessageTask$WhenMappings.$EnumSwitchMapping$1[this.message.source().ordinal()]) {
            case 1: {
                if (this.request == null) {
                    ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)this.message.text(), null, (int)2, null);
                    String string = this.message.getUrl();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    ConsoleMessageBuilder.addFileLink$default((ConsoleMessageBuilder)printer, (String)string, (int)-1, (int)-1, null, (boolean)false, null, (int)32, null);
                    break;
                }
                if (this.request.getInitiator() != null) {
                    InitiatorValue initiatorValue = this.request.getInitiator();
                    if (initiatorValue == null) {
                        Intrinsics.throwNpe();
                    }
                    StackTraceValue stackTraceValue2 = initiatorValue.getStack();
                    stackTrace = stackTraceValue2 != null ? stackTraceValue2.callFrames() : null;
                    InitiatorValue initiatorValue2 = this.request.getInitiator();
                    if (initiatorValue2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!StringUtil.isEmpty((String)initiatorValue2.getUrl())) {
                        InitiatorValue initiatorValue3 = this.request.getInitiator();
                        if (initiatorValue3 == null) {
                            Intrinsics.throwNpe();
                        }
                        url = initiatorValue3.getUrl();
                        InitiatorValue initiatorValue4 = this.request.getInitiator();
                        if (initiatorValue4 == null) {
                            Intrinsics.throwNpe();
                        }
                        line = (int)initiatorValue4.getLineNumber();
                        column = -1;
                    }
                }
                if (this.message.level() == ConsoleMessageValue.Level.ERROR) {
                    this.printFailedNetworkRequestMessage(printer);
                    break;
                }
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)this.message.text(), null, (int)2, null);
                break;
            }
            default: {
                ConsoleMessageValue.Type type = this.message.getType();
                if (type != null) {
                    switch (WipConsoleMessageTask$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            if (this.message.getType() == ConsoleMessageValue.Type.END_GROUP) {
                                printer.groupEnd();
                            } else {
                                printer.groupStart();
                            }
                            ConsoleViewContentType consoleViewContentType = contentType;
                            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
                            this.printParameters(printer, consoleViewContentType, false);
                            break block0;
                        }
                        case 4: 
                        case 5: {
                            return;
                        }
                        case 6: {
                            printer.clear();
                            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)ConsolePrinter.Companion.getCONSOLE_INFO_KEY());
                            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.g\u2026Printer.CONSOLE_INFO_KEY)");
                            printer.append("Console was cleared", consoleViewContentType);
                            break block0;
                        }
                    }
                }
                if (this.message.getType() == ConsoleMessageValue.Type.ASSERT) {
                    ConsoleViewContentType consoleViewContentType = contentType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
                    printer.append("Assertion failed:", consoleViewContentType);
                    this.printParameters(printer, contentType, true);
                    break;
                }
                if (!UtilKt.isNullOrEmpty((Collection)this.message.getParameters())) {
                    ConsoleViewContentType consoleViewContentType = contentType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
                    this.printParameters(printer, consoleViewContentType, false);
                    break;
                }
                String string = this.message.text();
                ConsoleViewContentType consoleViewContentType = contentType;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
                printer.append(string, consoleViewContentType);
            }
        }
        boolean bl = isFromNetwork = this.message.source() == ConsoleMessageValue.Source.NETWORK;
        if (!isFromNetwork || this.request != null) {
            CharSequence charSequence;
            CallFrameValue callFrame;
            List<CallFrameValue> list = stackTrace;
            CallFrameValue callFrameValue = callFrame = list != null ? (CallFrameValue)CollectionsKt.firstOrNull(list) : null;
            if (callFrame != null && !((charSequence = (CharSequence)callFrame.url()) == null || charSequence.length() == 0) && Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined") ^ true) {
                ConsoleMessageBuilder.addFileLink$default((ConsoleMessageBuilder)printer, (String)callFrame.url(), (int)(callFrame.getLineNumber() - 1), (int)callFrame.getColumnNumber(), (String)callFrame.functionName(), (!isFromNetwork ? 1 : 0) != 0, null, (int)32, null);
            } else {
                charSequence = url;
                if (!(charSequence == null || charSequence.length() == 0) && Intrinsics.areEqual((Object)url, (Object)"undefined") ^ true) {
                    String string = url;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    ConsoleMessageBuilder.addFileLink$default((ConsoleMessageBuilder)printer, (String)string, (int)(line - 1), (int)column, null, (!isFromNetwork ? 1 : 0) != 0, null, (int)32, null);
                }
            }
        }
        printer.newLine();
        if (!(ContainerUtil.isEmpty((Collection)stackTrace) || this.message.source() != ConsoleMessageValue.Source.NETWORK && this.message.level() != ConsoleMessageValue.Level.ERROR && this.message.getType() != ConsoleMessageValue.Type.TRACE)) {
            ConsoleViewContentType consoleViewContentType = contentType;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
            List<CallFrameValue> list = stackTrace;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            WipConsoleMessageTaskKt.access$printStackTrace(printer, consoleViewContentType, list);
        }
    }

    private final void printFailedNetworkRequestMessage(ConsoleMessageBuilder printer) {
        RequestInfo requestInfo = this.request;
        if (requestInfo == null) {
            Intrinsics.throwNpe();
        }
        printer.appendError(requestInfo.getValue().method());
        printer.appendError(" ");
        printer.printBrowserLink(this.request.getValue().url());
        printer.appendError(" ");
        if (this.request.isFailed()) {
            String string = this.request.getFailDescription();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            printer.appendError(string);
        } else {
            printer.appendError(String.valueOf(this.request.getStatusCode()));
            if (!StringUtil.isEmpty((String)this.request.getStatusText())) {
                printer.appendError(" (");
                String string = this.request.getStatusText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                printer.appendError(string);
                printer.appendError(")");
            }
        }
    }

    private final void printParameters(ConsoleMessageBuilder printer, ConsoleViewContentType contentType, boolean isNotFirst) {
        boolean isNotFirst2 = isNotFirst;
        if (UtilKt.isNullOrEmpty((Collection)this.message.getParameters())) {
            return;
        }
        JavaScriptDebugProcess debugProcess = printer.getDebugProcess();
        Vm vm = debugProcess.getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        EvaluateContext evaluateContext2 = vm.getEvaluateContext();
        if (evaluateContext2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.EvaluateContextBase<*>");
        }
        ValueManager valueManager = ((EvaluateContextBase)evaluateContext2).getValueManager();
        if (valueManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipValueManager");
        }
        WipValueManager valueManager2 = (WipValueManager)valueManager;
        List<RemoteObjectValue> list = this.message.getParameters();
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (RemoteObjectValue objectValue : list) {
            if (isNotFirst2) {
                printer.append(" ", contentType);
            } else {
                isNotFirst2 = true;
            }
            CharSequence charSequence = objectValue.getObjectId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                Value value = valueManager2.createValue(objectValue);
                if (value == null) {
                    Intrinsics.throwNpe();
                }
                printer.printAndStoreValueToInspect(value, null, contentType);
                continue;
            }
            if (objectValue.value() != null) {
                printer.append(String.valueOf(objectValue.value()), contentType);
                continue;
            }
            if (StringUtil.isEmpty((String)objectValue.getDescription())) continue;
            String string = objectValue.getDescription();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            printer.append(string, contentType);
        }
    }

    public WipConsoleMessageTask(@NotNull ConsoleMessageValue message, @Nullable RequestInfo request) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.message = message;
        this.request = request;
    }
}

