/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodeJs;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.nodeJs.NodeJSFileFinderKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/nodeJs/NodeJSFileFinder;", "Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "coreLibraryManager", "Lcom/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager;", "httpFinder", "Lcom/intellij/javascript/debugger/RemoteDebuggingFileFinder;", "doFindFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "findByName", "", "sourceContent", "", "script", "Lorg/jetbrains/debugger/Script;", "getRemoteUrls", "", "file", "intellij.javascript.chrome.connector"})
public final class NodeJSFileFinder
extends LocalFileSystemFileFinder {
    private final NodeJsCoreLibraryManager coreLibraryManager;
    private final RemoteDebuggingFileFinder httpFinder;

    @Nullable
    protected VirtualFile doFindFile(@NotNull Url url, @NotNull Project project, boolean findByName, @Nullable String sourceContent, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (NodeJSFileFinderKt.isModuleName(url)) {
            VirtualFile virtualFile = this.coreLibraryManager.findCoreModuleFileByName(StringUtil.trimEnd((String)url.getPath(), (String)".js"));
            if (virtualFile != null) {
                VirtualFile virtualFile2;
                VirtualFile it = virtualFile2 = virtualFile;
                return it;
            }
        }
        if (!url.isInLocalFileSystem()) {
            VirtualFile virtualFile = this.httpFinder.findFile(url, project, findByName, sourceContent, script);
            if (virtualFile != null) {
                VirtualFile virtualFile3;
                VirtualFile it = virtualFile3 = virtualFile;
                return it;
            }
        }
        return super.doFindFile(url, project, findByName, sourceContent, script);
    }

    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        List list2 = this.getCachedRemoteUrls(file);
        if (list2 != null) {
            List list3;
            List it = list3 = list2;
            return it;
        }
        if (this.coreLibraryManager.isCoreModuleLibraryFile(file)) {
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            list = CollectionsKt.listOf((Object)Urls.newLocalFileUrl((String)string));
        } else {
            list = super.getRemoteUrls(file);
        }
        return list;
    }

    public NodeJSFileFinder(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(false, 1, null);
        this.coreLibraryManager = NodeJsCoreLibraryManager.getInstance((Project)project);
        this.httpFinder = new RemoteDebuggingFileFinder(null, (DebuggableFileFinder)new DebuggableFileFinderImpl(project, null), 1, null);
    }
}

