/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.boilerplate.NpxPackageDescriptor;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.PathUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfigurationType;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReactNativeProjectGenerator
extends NpmPackageProjectGenerator {
    public static final String REACT_NATIVE_CLI = "react-native-cli";
    private static final Logger LOG = Logger.getInstance(ReactNativeProjectGenerator.class);

    @Nls
    @NotNull
    public String getName() {
        if ("React Native" == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(0);
        }
        return "React Native";
    }

    public String getDescription() {
        return "<a href='https://facebook.github.io/react-native/'>React Native</a> lets you build mobile apps using only JavaScript. It uses the same design as React, letting you compose a rich mobile UI from declarative components.";
    }

    @NotNull
    protected Filter[] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(2);
        }
        if (Filter.EMPTY_ARRAY == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(3);
        }
        return Filter.EMPTY_ARRAY;
    }

    @NotNull
    protected String executable(@NotNull NodePackage pkg) {
        if (pkg == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(4);
        }
        String string = pkg.getSystemDependentPath() + File.separator + "index.js";
        if (string == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected String[] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(6);
        }
        if (baseDir == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(7);
        }
        String[] stringArray = new String[]{"init", baseDir.getName()};
        if (stringArray == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    protected void customizeModule(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(9);
        }
        if (entry != null) {
            entry.addExcludeFolder(baseDir.getUrl() + "/android");
            entry.addExcludeFolder(baseDir.getUrl() + "/ios");
            Project project = ((ContentEntryImpl)entry).getRootModel().getProject();
            ReactNativeProjectGenerator.setLanguageLevel(project);
        }
    }

    private static void createRunConfigurations(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(10);
        }
        if (baseDir == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(11);
        }
        ReactNativeRunConfigurationType configurationType = ReactNativeRunConfigurationType.getInstance();
        if (!project.isDisposed()) {
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings rc = ReactNativeProjectGenerator.createRunConfiguration(project, runManager, (ConfigurationType)configurationType, ReactNativePlatform.ANDROID, baseDir);
            if (SystemInfo.isMac) {
                rc = ReactNativeProjectGenerator.createRunConfiguration(project, runManager, (ConfigurationType)configurationType, ReactNativePlatform.IOS, baseDir);
            }
            RunManager.getInstance((Project)project).setSelectedConfiguration(rc);
        }
    }

    @NotNull
    private static RunnerAndConfigurationSettings createRunConfiguration(Project project, RunManager runManager, ConfigurationType configurationType, ReactNativePlatform platform, VirtualFile baseDir) {
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(platform.getReadableName(), configurationType.getConfigurationFactories()[0]);
        ReactNativeRunConfiguration rc = (ReactNativeRunConfiguration)settings.getConfiguration();
        rc.setPlatform(platform);
        NodePackage pack = (NodePackage)ReadAction.compute(() -> NodePackage.findDefaultPackage((Project)project, (String)REACT_NATIVE_CLI, (NodeJsInterpreter)NodeJsInterpreterRef.createProjectRef().resolve(project)));
        if (pack != null) {
            rc.setReactNativePackage(pack);
        }
        rc.setWorkingDirectory(baseDir.getPath());
        runManager.addConfiguration(settings);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
        if (runnerAndConfigurationSettings == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(12);
        }
        return runnerAndConfigurationSettings;
    }

    private static void setLanguageLevel(Project project) {
        JSRootConfiguration.getInstance((Project)project).storeLanguageLevelAndUpdateCaches(JSLanguageLevel.FLOW);
    }

    @NotNull
    protected String packageName() {
        if (REACT_NATIVE_CLI == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(13);
        }
        return REACT_NATIVE_CLI;
    }

    @NotNull
    protected String presentablePackageName() {
        if ("React Native:" == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(14);
        }
        return "React Native:";
    }

    @NotNull
    protected List<NpxPackageDescriptor.NpxCommand> getNpxCommands() {
        List<NpxPackageDescriptor.NpxCommand> list = Collections.singletonList(new NpxPackageDescriptor.NpxCommand(REACT_NATIVE_CLI, "react-native"));
        if (list == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(15);
        }
        return list;
    }

    public Icon getIcon() {
        return JavaScriptLanguageIcons.Logos.Jsx_16;
    }

    @NotNull
    protected Runnable postInstall(@NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (project == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(16);
        }
        if (baseDir == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(17);
        }
        Runnable runnable = () -> {
            if (project == null) {
                ReactNativeProjectGenerator.$$$reportNull$$$0(23);
            }
            if (baseDir == null) {
                ReactNativeProjectGenerator.$$$reportNull$$$0(24);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (project == null) {
                    ReactNativeProjectGenerator.$$$reportNull$$$0(25);
                }
                if (baseDir == null) {
                    ReactNativeProjectGenerator.$$$reportNull$$$0(26);
                }
                super.postInstall(project, baseDir, workingDir).run();
                ReactNativeProjectGenerator.createRunConfigurations(project, baseDir);
            });
        };
        if (runnable == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(18);
        }
        return runnable;
    }

    protected boolean generateInTemp() {
        return false;
    }

    @NotNull
    protected File workingDir(NpmPackageProjectGenerator.Settings settings, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(19);
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir.getParent());
        if (file == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(20);
        }
        return file;
    }

    protected void onProcessHandlerCreated(@NotNull ProcessHandler processHandler) {
        OutputStream processInput;
        if (processHandler == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(21);
        }
        if ((processInput = processHandler.getProcessInput()) != null) {
            try {
                processInput.write("yes\n".getBytes(CharsetToolkit.UTF8_CHARSET));
                processInput.flush();
                if (!TerminalExecutionConsole.isAcceptable((ProcessHandler)processHandler)) {
                    processInput.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Cannot write input to " + processHandler.getClass(), (Throwable)e);
            }
        } else {
            LOG.warn("Null process input");
        }
        LOG.info("Answered 'yes' to prompt");
    }

    protected String validateProjectPath(@NotNull String path) {
        String fileName;
        if (path == null) {
            ReactNativeProjectGenerator.$$$reportNull$$$0(22);
        }
        if (!(fileName = PathUtil.getFileName((String)path)).matches("[$a-zA-Z_][0-9a-zA-Z_$]*")) {
            return XmlStringUtil.wrapInHtml((CharSequence)(fileName + " is not a valid name for a project. Please use an alphanumeric project name"));
        }
        return super.validateProjectPath(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 16: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 19: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/reactnative/ReactNativeProjectGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "executable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generatorArgs";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunConfiguration";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "packageName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "presentablePackageName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpxCommands";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "postInstall";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "workingDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filters";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatorArgs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "customizeModule";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfigurations";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "postInstall";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "workingDir";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onProcessHandlerCreated";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectPath";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postInstall$2";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

