/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditor;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfigurationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010>\u001a\u00020?H\u0016J\u0006\u0010@\u001a\u00020\rJ\b\u0010A\u001a\u00020BH\u0016J\u0018\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020?2\u0006\u0010J\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020?2\u0006\u0010J\u001a\u00020KH\u0016R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001c\u00102\u001a\u0004\u0018\u000103X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u000f\"\u0004\b:\u0010\u0011R\u001a\u0010;\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u000f\"\u0004\b=\u0010\u0011\u00a8\u0006M"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/javascript/JSRunProfileWithCompileBeforeLaunchOption;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "browserId", "", "getBrowserId", "()Ljava/lang/String;", "setBrowserId", "(Ljava/lang/String;)V", "buildAndLaunch", "", "getBuildAndLaunch", "()Z", "setBuildAndLaunch", "(Z)V", "effectiveWorkingDirectory", "getEffectiveWorkingDirectory", "envData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvData", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "setEnvData", "(Lcom/intellij/execution/configuration/EnvironmentVariablesData;)V", "nodePath", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;", "getNodePath", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;", "setNodePath", "(Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;)V", "packagerPort", "", "getPackagerPort", "()I", "setPackagerPort", "(I)V", "platform", "Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "getPlatform", "()Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "setPlatform", "(Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;)V", "reactNativePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "getReactNativePackage", "()Lcom/intellij/javascript/nodejs/util/NodePackage;", "setReactNativePackage", "(Lcom/intellij/javascript/nodejs/util/NodePackage;)V", "runArguments", "getRunArguments", "setRunArguments", "workingDirectory", "getWorkingDirectory", "setWorkingDirectory", "checkConfiguration", "", "findWorkingDirectory", "getConfigurationEditor", "Lcom/jetbrains/plugins/reactnative/ReactNativeConfigurationEditor;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "intellij.javascript.reactNativeDebugger"})
public final class ReactNativeRunConfiguration
extends LocatableConfigurationBase
implements JSRunProfileWithCompileBeforeLaunchOption {
    @Nullable
    private String browserId;
    private int packagerPort;
    @Nullable
    private NodePackage reactNativePackage;
    @NotNull
    private NodeJsInterpreterRef nodePath;
    @NotNull
    private String workingDirectory;
    private boolean buildAndLaunch;
    @NotNull
    private ReactNativePlatform platform;
    @NotNull
    private String runArguments;
    @NotNull
    private EnvironmentVariablesData envData;

    @Nullable
    public final String getBrowserId() {
        return this.browserId;
    }

    public final void setBrowserId(@Nullable String string) {
        this.browserId = string;
    }

    public final int getPackagerPort() {
        return this.packagerPort;
    }

    public final void setPackagerPort(int n) {
        this.packagerPort = n;
    }

    @Nullable
    public final NodePackage getReactNativePackage() {
        return this.reactNativePackage;
    }

    public final void setReactNativePackage(@Nullable NodePackage nodePackage) {
        this.reactNativePackage = nodePackage;
    }

    @NotNull
    public final NodeJsInterpreterRef getNodePath() {
        return this.nodePath;
    }

    public final void setNodePath(@NotNull NodeJsInterpreterRef nodeJsInterpreterRef) {
        Intrinsics.checkParameterIsNotNull((Object)nodeJsInterpreterRef, (String)"<set-?>");
        this.nodePath = nodeJsInterpreterRef;
    }

    @NotNull
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.workingDirectory = string;
    }

    public final boolean getBuildAndLaunch() {
        return this.buildAndLaunch;
    }

    public final void setBuildAndLaunch(boolean bl) {
        this.buildAndLaunch = bl;
    }

    @NotNull
    public final ReactNativePlatform getPlatform() {
        return this.platform;
    }

    public final void setPlatform(@NotNull ReactNativePlatform reactNativePlatform) {
        Intrinsics.checkParameterIsNotNull((Object)reactNativePlatform, (String)"<set-?>");
        this.platform = reactNativePlatform;
    }

    @NotNull
    public final String getRunArguments() {
        return this.runArguments;
    }

    public final void setRunArguments(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.runArguments = string;
    }

    @NotNull
    public final EnvironmentVariablesData getEnvData() {
        return this.envData;
    }

    public final void setEnvData(@NotNull EnvironmentVariablesData environmentVariablesData) {
        Intrinsics.checkParameterIsNotNull((Object)environmentVariablesData, (String)"<set-?>");
        this.envData = environmentVariablesData;
    }

    @NotNull
    public final String getEffectiveWorkingDirectory() {
        CharSequence charSequence = this.workingDirectory;
        return charSequence.length() == 0 ? this.findWorkingDirectory() : this.workingDirectory;
    }

    @NotNull
    public final String findWorkingDirectory() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return ReactNativeRunConfigurationKt.findEffectiveWorkingDirectory(null, project);
    }

    @NotNull
    public ReactNativeConfigurationEditor getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return new ReactNativeConfigurationEditor(project);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        RunProfileState runProfileState = EmptyRunProfileState.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)runProfileState, (String)"EmptyRunProfileState.INSTANCE");
        return runProfileState;
    }

    public void checkConfiguration() {
        block5: {
            NodePackage reactNative;
            block7: {
                block6: {
                    super.checkConfiguration();
                    WebBrowser webBrowser = this.getBrowser();
                    if (webBrowser.getPath() == null) {
                        throw (Throwable)new RuntimeConfigurationException("browser path is empty");
                    }
                    if (!this.buildAndLaunch) break block5;
                    NodeInterpreterUtil.checkForRunConfiguration((NodeJsInterpreter)this.nodePath.resolve(this.getProject()));
                    reactNative = this.reactNativePackage;
                    if (reactNative == null) break block6;
                    String string = reactNative.getSystemDependentPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reactNative.systemDependentPath");
                    CharSequence charSequence = string;
                    if (!(charSequence.length() == 0)) break block7;
                }
                throw (Throwable)new RuntimeConfigurationException("react-native is not specified");
            }
            if (!reactNative.isValid()) {
                throw (Throwable)new RuntimeConfigurationException("invalid react-native");
            }
        }
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.writeExternal(element);
        CharSequence charSequence = this.workingDirectory;
        if (!(charSequence.length() == 0)) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)"working-dir", (String)this.workingDirectory);
        }
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)"node-interpreter", (String)this.nodePath.getReferenceName());
        if (this.reactNativePackage != null) {
            NodePackage nodePackage = this.reactNativePackage;
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)"react-native", (String)(nodePackage != null ? nodePackage.getSystemIndependentPath() : null));
        }
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)"platform", (String)this.platform.name());
        charSequence = this.runArguments;
        if (!(charSequence.length() == 0)) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)"run-arguments", (String)this.runArguments);
        }
        this.envData.writeExternal(element);
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)"only-packager", null);
        if (!this.buildAndLaunch) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)"build-and-launch", (String)String.valueOf(Boolean.FALSE));
        }
        if (this.browserId != null) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)"browser", (String)this.browserId);
        }
        if (this.packagerPort != 8081) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)"debug-port", (String)String.valueOf(this.packagerPort));
        }
    }

    public void readExternal(@NotNull Element element) {
        int n;
        String runArguments;
        String platformTag;
        String reactNativeTag;
        String interpreterRefName;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.readExternal(element);
        String workingDir = JDOMExternalizerUtil.readCustomField((Element)element, (String)"working-dir");
        if (workingDir != null) {
            this.workingDirectory = workingDir;
        }
        if ((interpreterRefName = JDOMExternalizerUtil.readCustomField((Element)element, (String)"node-interpreter")) != null) {
            NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create((String)interpreterRefName);
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"NodeJsInterpreterRef.create(interpreterRefName)");
            this.nodePath = nodeJsInterpreterRef;
        }
        if ((reactNativeTag = JDOMExternalizerUtil.readCustomField((Element)element, (String)"react-native")) != null) {
            this.reactNativePackage = new NodePackage(reactNativeTag);
        }
        if ((platformTag = JDOMExternalizerUtil.readCustomField((Element)element, (String)"platform")) != null) {
            this.platform = ReactNativePlatform.valueOf(platformTag);
        }
        if ((runArguments = JDOMExternalizerUtil.readCustomField((Element)element, (String)"run-arguments")) != null) {
            this.runArguments = runArguments;
        }
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.readExternal((Element)element);
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentVariablesData, (String)"EnvironmentVariablesData.readExternal(element)");
        this.envData = environmentVariablesData;
        String buildAndLaunch = JDOMExternalizerUtil.readCustomField((Element)element, (String)"build-and-launch");
        String onlyStartPackager = JDOMExternalizerUtil.readCustomField((Element)element, (String)"only-packager");
        if (buildAndLaunch != null) {
            Boolean bl = Boolean.valueOf(buildAndLaunch);
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"valueOf(buildAndLaunch)");
            this.buildAndLaunch = bl;
        } else if (onlyStartPackager != null) {
            this.buildAndLaunch = Boolean.valueOf(onlyStartPackager) == false;
        }
        this.browserId = JDOMExternalizerUtil.readCustomField((Element)element, (String)"browser");
        ReactNativeRunConfiguration reactNativeRunConfiguration = this;
        String string = JDOMExternalizerUtil.readCustomField((Element)element, (String)"debug-port");
        if (string != null) {
            String string2 = string;
            ReactNativeRunConfiguration reactNativeRunConfiguration2 = reactNativeRunConfiguration;
            int n2 = Integer.parseInt(string2);
            reactNativeRunConfiguration = reactNativeRunConfiguration2;
            n = n2;
        } else {
            n = 8081;
        }
        reactNativeRunConfiguration.packagerPort = n;
    }

    @NotNull
    public final WebBrowser getBrowser() {
        WebBrowser webBrowser = WebBrowserManager.getInstance().findBrowserById(this.browserId);
        if (webBrowser == null) {
            WebBrowser webBrowser2 = WebBrowserManager.getInstance().getFirstBrowser(BrowserFamily.CHROME);
            webBrowser = webBrowser2;
            Intrinsics.checkExpressionValueIsNotNull((Object)webBrowser2, (String)"WebBrowserManager.getIns\u2026ser(BrowserFamily.CHROME)");
        }
        return webBrowser;
    }

    public ReactNativeRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(project, factory, "");
        this.packagerPort = 8081;
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.createProjectRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"NodeJsInterpreterRef.createProjectRef()");
        this.nodePath = nodeJsInterpreterRef;
        this.workingDirectory = "";
        this.buildAndLaunch = true;
        this.platform = ReactNativePlatform.ANDROID;
        this.runArguments = "";
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentVariablesData, (String)"EnvironmentVariablesData.DEFAULT");
        this.envData = environmentVariablesData;
    }
}

