/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.codeInsight;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.util.PathUtil;
import com.intellij.ws.http.request.actions.HttpRequestBaseAction;
import com.intellij.ws.http.request.psi.HttpFilePath;
import com.intellij.ws.rest.client.RestClientBundle;
import org.jetbrains.annotations.NotNull;

public class HttpRequestDiffAction
extends HttpRequestBaseAction {
    private final HttpFilePath myFirstFilePath;
    private final HttpFilePath mySecondFilePath;

    public HttpRequestDiffAction(@NotNull HttpFilePath first, @NotNull HttpFilePath second) {
        if (first == null) {
            HttpRequestDiffAction.$$$reportNull$$$0(0);
        }
        if (second == null) {
            HttpRequestDiffAction.$$$reportNull$$$0(1);
        }
        this.myFirstFilePath = first;
        this.mySecondFilePath = second;
        this.getTemplatePresentation().setIcon(AllIcons.Actions.DiffWithCurrent);
        this.getTemplatePresentation().setText(RestClientBundle.message("http.request.diff.compare.with.file", this.mySecondFilePath.getPresentablePath()));
        this.getTemplatePresentation().setDescription(RestClientBundle.message("http.request.diff.compare.with.description", new Object[0]));
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        ApplicationManager.getApplication().saveAll();
        PsiFile firstFile = FileReferenceUtil.findFile((PsiElement)this.myFirstFilePath);
        if (firstFile == null) {
            this.showErrorBalloon(RestClientBundle.message("http.request.diff.compare.with.can.not.resolve", this.myFirstFilePath.getPresentablePath()), e);
            return;
        }
        PsiFile secondFile = FileReferenceUtil.findFile((PsiElement)this.mySecondFilePath);
        if (secondFile == null) {
            this.showErrorBalloon(RestClientBundle.message("http.request.diff.compare.with.can.not.resolve", this.mySecondFilePath.getPresentablePath()), e);
            return;
        }
        DiffContent first = DiffContentFactory.getInstance().create(project, firstFile.getVirtualFile());
        DiffContent second = DiffContentFactory.getInstance().create(project, secondFile.getVirtualFile());
        String firstName = firstFile.getName();
        String secondName = secondFile.getName();
        String directories = HttpRequestDiffAction.getPresentableDirectories(firstFile.getVirtualFile().getPath(), secondFile.getVirtualFile().getPath());
        String title = RestClientBundle.message("http.request.diff.compare.with.dialog.title", firstName, secondName, directories);
        SimpleDiffRequest diffData = new SimpleDiffRequest(title, first, second, firstName, secondName);
        DiffManager.getInstance().showDiff(project, (DiffRequest)diffData);
    }

    @NotNull
    private static String getPresentableDirectories(@NotNull String firstPath, @NotNull String secondPath) {
        String secondDirectory;
        String firstDirectory;
        if (firstPath == null) {
            HttpRequestDiffAction.$$$reportNull$$$0(2);
        }
        if (secondPath == null) {
            HttpRequestDiffAction.$$$reportNull$$$0(3);
        }
        if (FileUtil.pathsEqual((String)(firstDirectory = PathUtil.getParentPath((String)firstPath)), (String)(secondDirectory = PathUtil.getParentPath((String)secondPath)))) {
            String string = PathUtil.toSystemDependentName((String)firstDirectory);
            if (string == null) {
                HttpRequestDiffAction.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = RestClientBundle.message("http.request.diff.compare.with.dialog.title.directories", PathUtil.toSystemDependentName((String)firstDirectory), PathUtil.toSystemDependentName((String)secondDirectory));
        if (string == null) {
            HttpRequestDiffAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/codeInsight/HttpRequestDiffAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/codeInsight/HttpRequestDiffAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableDirectories";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

