/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ws.http.request.run.HttpClientExternal;
import com.intellij.ws.rest.client.RestClientResponse;
import java.nio.charset.Charset;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientSession {
    public HttpClientExternal client;
    public HttpResponseHeaders headers;
    public HttpResponseContentType contentType;
    public String content;
    public int statusCode;

    public HttpClientSession(@NotNull HttpClientExternal client, @NotNull HttpResponseHeaders headers, @NotNull HttpResponseContentType contentType, @NotNull String content, int statusCode) {
        if (client == null) {
            HttpClientSession.$$$reportNull$$$0(0);
        }
        if (headers == null) {
            HttpClientSession.$$$reportNull$$$0(1);
        }
        if (contentType == null) {
            HttpClientSession.$$$reportNull$$$0(2);
        }
        if (content == null) {
            HttpClientSession.$$$reportNull$$$0(3);
        }
        this.client = client;
        this.headers = headers;
        this.contentType = contentType;
        this.content = content;
        this.statusCode = statusCode;
    }

    @NotNull
    public static HttpClientSession create(@NotNull Project project, @NotNull RestClientResponse response) {
        if (project == null) {
            HttpClientSession.$$$reportNull$$$0(4);
        }
        if (response == null) {
            HttpClientSession.$$$reportNull$$$0(5);
        }
        HttpClientExternal client = new HttpClientExternal(project);
        HttpResponseHeaders headers = new HttpResponseHeaders(response.getAllHeaders());
        ContentType type = response.getContentType();
        Charset charset = type.getCharset();
        HttpResponseContentType contentType = new HttpResponseContentType(type.getMimeType(), charset != null ? charset.name() : "");
        HttpClientSession httpClientSession = new HttpClientSession(client, headers, contentType, response.getContent(), response.getStatusLine().getStatusCode());
        if (httpClientSession == null) {
            HttpClientSession.$$$reportNull$$$0(6);
        }
        return httpClientSession;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/HttpClientSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/HttpClientSession";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HttpResponseHeaders {
        private static final String EMPTY_HEADERS = "Empty";
        public Header[] headers;

        public HttpResponseHeaders(Header[] headers) {
            this.headers = headers;
        }

        @Nullable
        public String valueOf(@NotNull String name) {
            if (name == null) {
                HttpResponseHeaders.$$$reportNull$$$0(0);
            }
            for (Header header : this.headers) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)header.getName(), (CharSequence)name)) continue;
                return header.getValue();
            }
            return null;
        }

        public String toString() {
            if (this.headers.length == 0) {
                return EMPTY_HEADERS;
            }
            return Stream.of(this.headers).map(header -> header.getName() + ": " + header.getValue()).collect(Collectors.joining("\n"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ws/http/request/run/HttpClientSession$HttpResponseHeaders", "valueOf"));
        }
    }

    public static class HttpResponseContentType {
        public String mimeType;
        public String charset;

        public HttpResponseContentType(String mimeType, String charset) {
            this.mimeType = mimeType;
            this.charset = charset;
        }

        public String toString() {
            return this.mimeType + "; charset=" + this.charset;
        }
    }
}

