/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.HttpRequestFileType;
import com.intellij.ws.http.request.HttpRequestPsiConverter;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.psi.HttpDifferenceFile;
import com.intellij.ws.http.request.psi.HttpFilePath;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.run.HttpRequestInvalidLogFileException;
import com.intellij.ws.http.request.run.HttpResponseProcessor;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientFileUtil;
import com.intellij.ws.rest.client.RestClientRequest;
import com.intellij.ws.rest.client.RestClientResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestHistoryManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.HttpRequestHistoryManager");
    private static final String DEFAULT_HTTP_REQUESTS_ROOT = "/httpRequests";
    private static final String DEFAULT_LOG_FILE_NAME = PathUtil.makeFileName((String)"http-requests-log", (String)HttpRequestFileType.INSTANCE.getDefaultExtension());
    private static final String ACTION_TITLE = RestClientBundle.message("http.request.save.log.file.action.title", new Object[0]);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("hhmmss");
    private static final int CAPACITY = 50;
    @NotNull
    private final Project myProject;
    @Nullable
    private SmartPsiElementPointer<HttpRequestPsiFile> myLogFilePointer;

    public HttpRequestHistoryManager(@NotNull Project project) {
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public static HttpRequestHistoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(1);
        }
        return (HttpRequestHistoryManager)ServiceManager.getService((Project)project, HttpRequestHistoryManager.class);
    }

    @NotNull
    public synchronized String getLogDirectoryPath() {
        if (this.myLogFilePointer != null) {
            PsiDirectory directory;
            HttpRequestPsiFile file = (HttpRequestPsiFile)this.myLogFilePointer.getElement();
            PsiDirectory psiDirectory = directory = file != null ? file.getParent() : null;
            if (directory != null) {
                String string = directory.getVirtualFile().getPath();
                if (string == null) {
                    HttpRequestHistoryManager.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        String string = HttpRequestHistoryManager.getDefaultDirectoryPath(this.myProject);
        if (string == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getDefaultDirectoryPath(@NotNull Project project) {
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(4);
        }
        VirtualFile configRoot = (VirtualFile)ObjectUtils.chooseNotNull((Object)ProjectKt.getProjectStoreDirectory((VirtualFile)project.getBaseDir()), (Object)project.getBaseDir());
        String string = configRoot.getPath() + DEFAULT_HTTP_REQUESTS_ROOT;
        if (string == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static VirtualFile findFile(@NotNull Project project, @NotNull String fileName) throws IOException {
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(6);
        }
        if (fileName == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String rootPath = HttpRequestHistoryManager.getDefaultDirectoryPath(project);
        String fullPath = rootPath + "/" + fileName;
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(fullPath);
        if (file != null && !file.isDirectory()) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                HttpRequestHistoryManager.$$$reportNull$$$0(8);
            }
            return virtualFile;
        }
        ChangeListManager.getInstance((Project)project).addDirectoryToIgnoreImplicitly(rootPath);
        VirtualFile virtualFile = (VirtualFile)WriteAction.compute(() -> {
            if (fileName == null) {
                HttpRequestHistoryManager.$$$reportNull$$$0(31);
            }
            VirtualFile dir = VfsUtil.createDirectories((String)PathUtil.getParentPath((String)fullPath));
            return dir.findOrCreateChildData((Object)LocalFileSystem.getInstance(), fileName);
        });
        if (virtualFile == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(9);
        }
        return virtualFile;
    }

    public void addToHistory(@NotNull RestClientRequest request, @Nullable RestClientResponse response) {
        if (request == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(10);
        }
        this.addToHistory(request, response, HttpResponseProcessor.EMPTY_PROCESSOR);
    }

    public void addToHistory(@NotNull RestClientRequest request, @Nullable RestClientResponse response, @NotNull HttpResponseProcessor processor) {
        if (request == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(12);
        }
        long time = System.currentTimeMillis();
        Runnable runnable = () -> {
            PsiDocumentManager manager;
            Document document;
            void request;
            String fileName;
            VirtualFile logDirectory;
            HttpRequestPsiFile logFile;
            if (processor == null) {
                HttpRequestHistoryManager.$$$reportNull$$$0(29);
            }
            if (request == null) {
                HttpRequestHistoryManager.$$$reportNull$$$0(30);
            }
            try {
                logFile = this.getLogFile();
            }
            catch (HttpRequestInvalidLogFileException e) {
                LOG.warn("Cannot save HTTP request because log file doesn't exists");
                processor.onResponseExecuted(null);
                return;
            }
            VirtualFile virtualFile = logDirectory = logFile.getParent() != null ? logFile.getParent().getVirtualFile() : null;
            if (logDirectory == null) {
                LOG.warn("Cannot save response output because log directory is invalid");
            }
            String string = fileName = response != null && logDirectory != null ? this.createResponseFile(response, logDirectory, time) : null;
            if (LOG.isDebugEnabled() && StringUtil.isNotEmpty((String)fileName)) {
                LOG.debug("Saved response output in '" + fileName + "'");
            }
            processor.onResponseExecuted(fileName);
            String text = HttpRequestPsiConverter.toPsiHttpRequest((RestClientRequest)request, fileName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Saving: '" + text + "'");
            }
            if ((document = (manager = PsiDocumentManager.getInstance((Project)logFile.getProject())).getDocument((PsiFile)logFile)) != null) {
                HttpRequest[] requests = (HttpRequest[])PsiTreeUtil.getChildrenOfType((PsiElement)logFile, HttpRequest.class);
                if (requests != null && requests.length >= this.getMaxHistorySize()) {
                    if (logDirectory != null) {
                        this.deleteHistoryFiles(logDirectory, requests[this.getMaxHistorySize() - 1]);
                    }
                    TextRange range = HttpRequestPsiUtils.getRequestsRange(requests[this.getMaxHistorySize() - 1], requests[requests.length - 1]);
                    int endOffset = requests[requests.length - 1].getNextSibling() != null ? range.getEndOffset() : document.getTextLength();
                    document.deleteString(range.getStartOffset(), endOffset);
                }
                document.insertString(0, (CharSequence)text);
                manager.commitDocument(document);
            }
        };
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(this.myProject, runnable, ACTION_TITLE, null));
    }

    private void deleteHistoryFiles(@NotNull VirtualFile directory, @Nullable HttpRequest request) {
        if (directory == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(13);
        }
        List<String> toDelete = HttpRequestHistoryManager.collectFilesToDelete(directory, request);
        for (String path : toDelete) {
            try {
                VirtualFile response = directory.getFileSystem().findFileByPath(path);
                if (response == null) {
                    LOG.debug("File with response output doesn't exists ('" + path + "')");
                    continue;
                }
                response.delete((Object)this);
                LOG.debug("Deleted " + path);
            }
            catch (Exception e) {
                LOG.warn("Cannot delete response output file ('" + path + "')", (Throwable)e);
            }
        }
    }

    @NotNull
    private static List<String> collectFilesToDelete(@NotNull VirtualFile directory, @Nullable HttpRequest request) {
        if (directory == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(14);
        }
        List paths = ContainerUtil.newSmartList();
        while (request != null) {
            List<HttpDifferenceFile> diffFiles = request.getDifferenceFileList();
            for (HttpDifferenceFile diffFile : diffFiles) {
                HttpFilePath filePath = diffFile.getFilePath();
                if (filePath == null || FileUtil.isAbsolutePlatformIndependent((String)filePath.getPresentablePath())) continue;
                String presentablePath = PathUtil.toSystemIndependentName((String)filePath.getPresentablePath());
                String absolutePath = FileUtil.toCanonicalPath((String)(directory.getPath() + "/" + presentablePath), (char)'/');
                if (!FileUtil.isAncestor((String)directory.getPath(), (String)absolutePath, (boolean)false)) continue;
                paths.add(absolutePath);
            }
            request = (HttpRequest)PsiTreeUtil.getNextSiblingOfType((PsiElement)request, HttpRequest.class);
        }
        List list = paths;
        if (list == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    private String createResponseFile(@NotNull RestClientResponse response, @NotNull VirtualFile logDirectory, long startTimeMs) {
        if (response == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(16);
        }
        if (logDirectory == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(17);
        }
        if (response.getContentLength() == 0) {
            return null;
        }
        int code = response.getStatusLine().getStatusCode();
        FileType fileType = RestClientFileUtil.findFileType(response.getContentType().getMimeType());
        try {
            PsiFile file;
            String timestamp = this.timeToFileName(startTimeMs);
            String fileName = HttpRequestHistoryManager.unique(logDirectory, code, fileType, timestamp);
            VirtualFile responseFile = logDirectory.findOrCreateChildData((Object)this, fileName);
            VfsUtil.saveText((VirtualFile)responseFile, (String)response.getContent());
            if (fileType != PlainTextFileType.INSTANCE && (file = PsiManager.getInstance((Project)this.myProject).findFile(responseFile)) != null) {
                new ReformatCodeProcessor(file, false).run();
            }
            return fileName;
        }
        catch (IOException e) {
            LOG.warn("Cannot create file with response output", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private static String unique(@NotNull VirtualFile root, int code, @NotNull FileType fileType, @NotNull String timestamp) {
        String fileName;
        if (root == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(18);
        }
        if (fileType == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(19);
        }
        if (timestamp == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(20);
        }
        if (root.findChild(fileName = PathUtil.makeFileName((String)(timestamp + "." + code), (String)fileType.getDefaultExtension())) == null) {
            String string = fileName;
            if (string == null) {
                HttpRequestHistoryManager.$$$reportNull$$$0(21);
            }
            return string;
        }
        int counter = 1;
        while (root.findChild(fileName) != null) {
            fileName = PathUtil.makeFileName((String)(timestamp + "-" + counter + "." + code), (String)fileType.getDefaultExtension());
            ++counter;
        }
        String string = fileName;
        if (string == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    protected String timeToFileName(long startTimeMs) {
        Date date = new Date(startTimeMs);
        String string = DATE_FORMAT.format(date) + "T" + TIME_FORMAT.format(date);
        if (string == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(23);
        }
        return string;
    }

    protected int getMaxHistorySize() {
        return 50;
    }

    @NotNull
    public synchronized HttpRequestPsiFile getLogFile() throws HttpRequestInvalidLogFileException {
        HttpRequestPsiFile file2;
        if (this.myLogFilePointer == null || this.myLogFilePointer.getElement() == null) {
            try {
                VirtualFile log = HttpRequestHistoryManager.findFile(this.myProject, DEFAULT_LOG_FILE_NAME);
                PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(log);
                if (psiFile instanceof HttpRequestPsiFile) {
                    this.myLogFilePointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)((HttpRequestPsiFile)psiFile));
                } else {
                    if (FileIndexFacade.getInstance((Project)this.myProject).isUnderIgnored(log)) {
                        VirtualFile parent = HttpRequestHistoryManager.getParentByCondition(log, (Condition<VirtualFile>)((Condition)file -> FileIndexFacade.getInstance((Project)this.myProject).isUnderIgnored(file)));
                        throw HttpRequestInvalidLogFileException.createIgnoredLogException(this.myProject, parent.getPath());
                    }
                    if (Registry.is((String)"ide.hide.excluded.files") && FileIndexFacade.getInstance((Project)this.myProject).isExcludedFile(log)) {
                        VirtualFile parent = HttpRequestHistoryManager.getParentByCondition(log, (Condition<VirtualFile>)((Condition)file -> FileIndexFacade.getInstance((Project)this.myProject).isExcludedFile(file)));
                        throw HttpRequestInvalidLogFileException.createExcludedLogException(parent.getPath());
                    }
                    if (psiFile != null && log.isValid() && !log.isDirectory() && !this.myProject.isDefault()) {
                        throw HttpRequestInvalidLogFileException.createInvalidTypeException(this.myProject, psiFile.getFileType());
                    }
                    LOG.error("HTTP Requests Log file is invalid: " + psiFile + ". Path: '" + log.getPresentableUrl() + "', valid: " + log.isValid() + ", dir: " + log.isDirectory() + ", default project: " + this.myProject.isDefault());
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        HttpRequestPsiFile httpRequestPsiFile = file2 = this.myLogFilePointer != null ? (HttpRequestPsiFile)this.myLogFilePointer.getElement() : null;
        if (file2 == null) {
            throw new HttpRequestInvalidLogFileException();
        }
        HttpRequestPsiFile httpRequestPsiFile2 = file2;
        if (httpRequestPsiFile2 == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(24);
        }
        return httpRequestPsiFile2;
    }

    @NotNull
    private static VirtualFile getParentByCondition(@NotNull VirtualFile file, @NotNull Condition<VirtualFile> condition) {
        if (file == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(25);
        }
        if (condition == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(26);
        }
        VirtualFile target = file;
        while (file != null && condition.value((Object)file)) {
            target = file;
            file = file.getParent();
        }
        VirtualFile virtualFile = target;
        if (virtualFile == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(27);
        }
        return virtualFile;
    }

    public synchronized void setLogFile(@NotNull HttpRequestPsiFile logfile) {
        if (logfile == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(28);
        }
        this.myLogFilePointer = SmartPointerManager.getInstance((Project)logfile.getProject()).createSmartPsiElementPointer((PsiElement)logfile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/HttpRequestHistoryManager";
                break;
            }
            case 7: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 10: 
            case 11: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 12: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logDirectory";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/HttpRequestHistoryManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogDirectoryPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDirectoryPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilesToDelete";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "unique";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "timeToFileName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFile";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentByCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDirectoryPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteHistoryFiles";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectFilesToDelete";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createResponseFile";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getParentByCondition";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setLogFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addToHistory$1";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

