/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.environment.HttpRequestIndex;
import com.intellij.ws.http.request.psi.HttpMethod;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestTokenTypeSets;
import com.intellij.ws.http.request.psi.HttpScheme;
import com.intellij.ws.http.request.run.RunHttpRequestAction;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestLineMarkerProvider
extends RunLineMarkerContributor {
    private static final String TOOLTIP = "Run HTTP Request";

    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        HttpRequest request;
        if (element == null) {
            HttpRequestLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (HttpRequestLineMarkerProvider.isHttpRequestRunElement(element) && (request = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)element, HttpRequest.class)) != null) {
            Project project = element.getProject();
            PsiFile containingFile = element.getContainingFile();
            HttpRequestEnvironment.clearDefaultIfInvalid(project, containingFile);
            Collection<String> envs = HttpRequestIndex.getAllEnvironments(project, containingFile);
            ArrayList actions = ContainerUtil.newArrayList((Object[])new AnAction[]{new RunHttpRequestAction.RunRequestWithDefaultEnvAction(request)});
            for (String env : envs) {
                actions.add(new RunHttpRequestAction.RunRequestWithEnvAction(request, env));
            }
            actions.add(new RunHttpRequestAction.RunRequestWithoutEnvAction(request));
            return new RunLineMarkerContributor.Info(AllIcons.RunConfigurations.TestState.Run, actions.toArray(AnAction.EMPTY_ARRAY), psiElement -> TOOLTIP);
        }
        return null;
    }

    private static boolean isHttpRequestRunElement(@NotNull PsiElement element) {
        if (element == null) {
            HttpRequestLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (HttpRequestLineMarkerProvider.isOfTypes(element, HttpRequestTokenTypeSets.METHODS)) {
            return true;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof HttpScheme) {
            HttpRequest request = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)parent, HttpRequest.class);
            return request != null && !(request.getFirstChild() instanceof HttpMethod);
        }
        return false;
    }

    private static boolean isOfTypes(@NotNull PsiElement element, @NotNull TokenSet tokens) {
        ASTNode node;
        if (element == null) {
            HttpRequestLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (tokens == null) {
            HttpRequestLineMarkerProvider.$$$reportNull$$$0(3);
        }
        IElementType elementType = (node = element.getNode()) != null ? node.getElementType() : null;
        return elementType != null && tokens.contains(elementType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/run/HttpRequestLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isHttpRequestRunElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isOfTypes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

