/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.actions.HttpRequestBaseAction;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.run.HttpRequestValidationException;
import com.intellij.ws.http.request.run.RunHttpRequestProfileState;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunHttpRequestAction
extends HttpRequestBaseAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.RunHttpRequestAction");
    private static final String TEST_FRAMEWORK_NAME = "HTTP Client";
    protected final HttpRequest myRequest;

    public RunHttpRequestAction(@NotNull HttpRequest request, @Nullable String initialEnv) {
        if (request == null) {
            RunHttpRequestAction.$$$reportNull$$$0(0);
        }
        this.myRequest = request;
        if (StringUtil.isEmpty((String)initialEnv)) {
            this.getTemplatePresentation().setText("Run " + StringUtil.notNullize((String)request.getHttpHost(HttpRequestVariableSubstitutor.empty())));
        } else {
            this.getTemplatePresentation().setText("Run with '" + initialEnv + "' environment");
        }
    }

    public void actionPerformed(AnActionEvent event) {
        try {
            final Project project = event.getProject();
            if (project != null) {
                final HttpRequestVariableSubstitutor substitutor = HttpRequestVariableSubstitutor.create(project, this.getEnvironment(project));
                final String name = this.myRequest.getHttpUrl(substitutor);
                ExecutionEnvironmentBuilder builder = new ExecutionEnvironmentBuilder(project, DefaultRunExecutor.getRunExecutorInstance()).runProfile(new RunProfile(){

                    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
                        if (executor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (environment == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        LOG.info("Executing " + name);
                        SMTRunnerConsoleProperties properties = new SMTRunnerConsoleProperties(project, (RunProfile)this, RunHttpRequestAction.TEST_FRAMEWORK_NAME, executor);
                        return new RunHttpRequestProfileState(environment.getProject(), RunHttpRequestAction.this.myRequest, properties, substitutor);
                    }

                    public String getName() {
                        return name;
                    }

                    @Nullable
                    public Icon getIcon() {
                        return AllIcons.Actions.Execute;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "executor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "environment";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ws/http/request/run/RunHttpRequestAction$1";
                        objectArray[2] = "getState";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
            }
        }
        catch (HttpRequestValidationException e) {
            this.showErrorBalloon(e.getMessage(), event);
        }
    }

    @NotNull
    public abstract HttpRequestEnvironment getEnvironment(Project var1) throws HttpRequestValidationException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/ws/http/request/run/RunHttpRequestAction", "<init>"));
    }

    public static class RunRequestWithoutEnvAction
    extends RunHttpRequestAction {
        public RunRequestWithoutEnvAction(@NotNull HttpRequest request) {
            if (request == null) {
                RunRequestWithoutEnvAction.$$$reportNull$$$0(0);
            }
            super(request, null);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabledAndVisible(true);
            e.getPresentation().setText(this.getTemplatePresentation().getText(), false);
        }

        @Override
        @NotNull
        public HttpRequestEnvironment getEnvironment(Project project) {
            HttpRequestEnvironment.setDefaultEnvName(project, null);
            HttpRequestEnvironment httpRequestEnvironment = HttpRequestEnvironment.empty();
            if (httpRequestEnvironment == null) {
                RunRequestWithoutEnvAction.$$$reportNull$$$0(1);
            }
            return httpRequestEnvironment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/run/RunHttpRequestAction$RunRequestWithoutEnvAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestAction$RunRequestWithoutEnvAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnvironment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RunRequestWithDefaultEnvAction
    extends RunHttpRequestAction {
        public RunRequestWithDefaultEnvAction(@NotNull HttpRequest request) {
            if (request == null) {
                RunRequestWithDefaultEnvAction.$$$reportNull$$$0(0);
            }
            super(request, null);
        }

        public void update(AnActionEvent e) {
            String defaultEnv;
            super.update(e);
            Project project = e.getProject();
            String string = defaultEnv = project != null ? HttpRequestEnvironment.getDefaultEnvName(project) : null;
            if (StringUtil.isNotEmpty((String)defaultEnv)) {
                e.getPresentation().setText("Run with '" + defaultEnv + "' environment", false);
                e.getPresentation().setEnabledAndVisible(true);
            } else {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        @Override
        @NotNull
        public HttpRequestEnvironment getEnvironment(Project project) throws HttpRequestValidationException {
            HttpRequestEnvironment env = HttpRequestEnvironment.getDefault(project, this.myRequest.getContainingFile());
            HttpRequestEnvironment httpRequestEnvironment = env != null ? env : HttpRequestEnvironment.empty();
            if (httpRequestEnvironment == null) {
                RunRequestWithDefaultEnvAction.$$$reportNull$$$0(1);
            }
            return httpRequestEnvironment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/run/RunHttpRequestAction$RunRequestWithDefaultEnvAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestAction$RunRequestWithDefaultEnvAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnvironment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RunRequestWithEnvAction
    extends RunHttpRequestAction {
        private final String myEnvironment;

        public RunRequestWithEnvAction(@NotNull HttpRequest request, @Nullable String environment) {
            if (request == null) {
                RunRequestWithEnvAction.$$$reportNull$$$0(0);
            }
            super(request, environment);
            this.myEnvironment = environment;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Project project = e.getProject();
            boolean isDefaultEnv = project != null && StringUtil.isNotEmpty((String)this.myEnvironment) && StringUtil.equals((CharSequence)this.myEnvironment, (CharSequence)HttpRequestEnvironment.getDefaultEnvName(project));
            e.getPresentation().setEnabledAndVisible(!isDefaultEnv);
            if (!isDefaultEnv) {
                e.getPresentation().setText(this.getTemplatePresentation().getText(), false);
            }
        }

        @Override
        @NotNull
        public HttpRequestEnvironment getEnvironment(@NotNull Project project) throws HttpRequestValidationException {
            if (project == null) {
                RunRequestWithEnvAction.$$$reportNull$$$0(1);
            }
            HttpRequestEnvironment environment = HttpRequestEnvironment.create(project, this.myEnvironment, this.myRequest.getContainingFile());
            HttpRequestEnvironment.setDefaultEnvName(project, this.myEnvironment);
            HttpRequestEnvironment httpRequestEnvironment = environment;
            if (httpRequestEnvironment == null) {
                RunRequestWithEnvAction.$$$reportNull$$$0(2);
            }
            return httpRequestEnvironment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/run/RunHttpRequestAction$RunRequestWithEnvAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestAction$RunRequestWithEnvAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnvironment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getEnvironment";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

