/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.ws.http.request.HttpRequestPsiConverter;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpFilePath;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpResponseHandler;
import com.intellij.ws.http.request.psi.HttpResponseScript;
import com.intellij.ws.http.request.psi.HttpScriptBody;
import com.intellij.ws.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.ws.http.request.run.HttpClientResponseHandler;
import com.intellij.ws.http.request.run.HttpPhysicalResponseProcessor;
import com.intellij.ws.http.request.run.HttpRequestHistoryManager;
import com.intellij.ws.http.request.run.HttpRequestNotifications;
import com.intellij.ws.http.request.run.HttpResponseConsolePrinter;
import com.intellij.ws.http.request.run.HttpResponsePresentation;
import com.intellij.ws.http.request.run.HttpScratchResponseProcessor;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientControllerImpl;
import com.intellij.ws.rest.client.RestClientFileUtil;
import com.intellij.ws.rest.client.RestClientRequest;
import com.intellij.ws.rest.client.RestClientRequestProcessor;
import com.intellij.ws.rest.client.RestClientResponse;
import com.intellij.ws.rest.client.RestClientResponseListener;
import java.util.Collection;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RunHttpRequestProfileState
implements RunProfileState {
    private final Project myProject;
    private final HttpRequest myPsiRequest;
    private final SMTRunnerConsoleProperties myProperties;
    private final HttpRequestVariableSubstitutor mySubstitutor;

    public RunHttpRequestProfileState(@NotNull Project project, @NotNull HttpRequest psiRequest, @NotNull SMTRunnerConsoleProperties properties, @NotNull HttpRequestVariableSubstitutor substitutor) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(0);
        }
        if (psiRequest == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(2);
        }
        if (substitutor == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myPsiRequest = psiRequest;
        this.myProperties = properties;
        this.mySubstitutor = substitutor;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        HttpResponseHandler responseHandlerPsi;
        if (runner == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(4);
        }
        HttpClientRequestProcessHandler processHandler = new HttpClientRequestProcessHandler((responseHandlerPsi = this.myPsiRequest.getResponseHandler()) != null);
        HttpClientResponseHandler responseHandler = RunHttpRequestProfileState.createHandler(responseHandlerPsi, processHandler);
        RestClientRequest request = HttpRequestPsiConverter.toRestClientRequest(this.myPsiRequest, this.mySubstitutor);
        String target = request.httpMethod + " " + request.toString() + "\n\n";
        HttpResponseConsolePrinter printer = new HttpResponseConsolePrinter(this.myProject, target, this.myProperties, responseHandler);
        printer.attachToProcess(processHandler);
        this.executeHttpRequest(this.myProject, request, processHandler, printer, responseHandler);
        return new DefaultExecutionResult((ExecutionConsole)printer.getConsole(), (ProcessHandler)processHandler);
    }

    private void executeHttpRequest(@NotNull Project project, @NotNull RestClientRequest request, final @NotNull HttpClientRequestProcessHandler processHandler, final @NotNull HttpResponseConsolePrinter printer, final @Nullable HttpClientResponseHandler handler) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(5);
        }
        if (request == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(6);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(7);
        }
        if (printer == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(8);
        }
        RestClientControllerImpl controller = new RestClientControllerImpl(project){

            @Override
            protected void addToHistory(final @NotNull Project project, @NotNull RestClientRequest request, final @Nullable RestClientResponse response) {
                PsiFile file;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (request == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (response != null && handler != null) {
                    EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
                    processHandler.setPostProcessorIndicator((ProgressIndicator)progressIndicator);
                    ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(project, RestClientBundle.message("rest.client.request.response.handler.execution", new Object[0]), false){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            try {
                                handler.handle(project, response, printer.getResponseHandlerWriter(), printer.getResponseHandlerTestWriter());
                            }
                            catch (ExecutionException e) {
                                String title = RestClientBundle.message("rest.client.cannot.execute.response.handler.failed.title", new Object[0]);
                                HttpRequestNotifications.showWarningBalloon(this.myProject, title, e.getMessage());
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ws/http/request/run/RunHttpRequestProfileState$1$1", "run"));
                        }
                    }, (ProgressIndicator)progressIndicator);
                }
                HttpPhysicalResponseProcessor processor = (file = RunHttpRequestProfileState.this.myPsiRequest.getContainingFile()) != null && ScratchUtil.isScratch((VirtualFile)file.getVirtualFile()) ? new HttpScratchResponseProcessor(RunHttpRequestProfileState.this.myPsiRequest) : new HttpPhysicalResponseProcessor(RunHttpRequestProfileState.this.myPsiRequest);
                HttpRequestHistoryManager.getInstance(project).addToHistory(request, response, processor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "request";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState$1";
                objectArray[2] = "addToHistory";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                int exitCode;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((exitCode = event.getExitCode()) != 0) {
                    String message = exitCode == 1 ? RestClientBundle.message("rest.client.request.execute.cancel", new Object[0]) : RestClientBundle.message("rest.client.request.execute.cancel.post.process", new Object[0]);
                    printer.setErrorResponse(HttpResponsePresentation.createErrorResponse(message));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ws/http/request/run/RunHttpRequestProfileState$2", "processTerminated"));
            }
        });
        controller.onGoButtonClick(request, false, new RestClientResponseListener(){

            @Override
            public void onResponse(@Nullable String header, @NotNull String response, @Nullable String mimeType, @NotNull String status) {
                if (response == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (status == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!this.isInterrupted()) {
                    FileType fileType = RestClientFileUtil.findFileType(mimeType);
                    printer.setResponse(HttpResponsePresentation.createResponse(header, response, status), fileType);
                }
            }

            @Override
            public void onErrorResponse(String response) {
                if (!this.isInterrupted()) {
                    printer.setErrorResponse(HttpResponsePresentation.createErrorResponse(StringUtil.notNullize((String)response)));
                }
            }

            @Override
            public void onSetCookies(Collection<Cookie> cookies) {
            }

            private boolean isInterrupted() {
                Integer code = processHandler.getExitCode();
                return code != null && code != 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "response";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "status";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState$3";
                objectArray[2] = "onResponse";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, new RestClientRequestProcessor(){

            @Override
            public void preProcessRequest(@NotNull RestClientRequest request) {
                if (request == null) {
                    4.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void postProcessRequest(@NotNull RestClientRequest request, @NotNull CookieStore store) {
                if (request == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (store == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (!processHandler.isProcessTerminated() && !processHandler.isProcessTerminating()) {
                    processHandler.requestFinished();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "store";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "preProcessRequest";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "postProcessRequest";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public static HttpClientResponseHandler createHandler(@Nullable HttpResponseHandler handler, @NotNull HttpClientRequestProcessHandler processHandler) {
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(9);
        }
        if (handler != null) {
            PsiElement scriptHolder = handler.getResponseScriptHolder();
            if (scriptHolder instanceof HttpResponseScript) {
                String text;
                HttpScriptBody body = ((HttpResponseScript)scriptHolder).getScriptBody();
                String string = text = body != null ? body.getText() : null;
                if (StringUtil.isNotEmpty((String)text)) {
                    return new HttpClientResponseHandler(text, processHandler);
                }
            } else if (scriptHolder instanceof HttpFilePath) {
                PsiFile file = FileReferenceUtil.findFile((PsiElement)scriptHolder);
                if (file != null) {
                    return new HttpClientResponseHandler(file.getText(), processHandler);
                }
                Project project = handler.getProject();
                String title = RestClientBundle.message("rest.client.cannot.execute.response.handler.failed.title", new Object[0]);
                String path = ((HttpFilePath)scriptHolder).getPresentablePath();
                HttpRequestNotifications.showWarningBalloon(project, title, RestClientBundle.message("rest.client.request.cannot.find.response.handler", path));
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRequest";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "executeHttpRequest";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

