/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestBody;
import com.intellij.ws.http.request.psi.HttpRequestTarget;
import com.intellij.ws.rest.client.RestClientFileUtil;
import icons.RestClientIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestStructureViewElement
extends PsiTreeElementBase<PsiElement>
implements ColoredItemPresentation {
    private final String myPresentationText;
    private final String myLocation;
    private final Icon myIcon;
    private final boolean myIsValid;

    private HttpRequestStructureViewElement(@NotNull PsiElement element, @NotNull String text, @Nullable String location, @Nullable Icon icon, boolean isValid) {
        if (element == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(0);
        }
        if (text == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(1);
        }
        super(element);
        this.myPresentationText = text;
        this.myLocation = location;
        this.myIcon = icon;
        this.myIsValid = isValid;
    }

    @NotNull
    public static StructureViewTreeElement create(@NotNull PsiElement element, @Nullable String text, @Nullable Icon icon) {
        if (element == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(2);
        }
        HttpRequestStructureViewElement httpRequestStructureViewElement = new HttpRequestStructureViewElement(element, StringUtil.notNullize((String)text, (String)"<not defined>"), null, icon, StringUtil.isNotEmpty((String)text));
        if (httpRequestStructureViewElement == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(3);
        }
        return httpRequestStructureViewElement;
    }

    @NotNull
    public static StructureViewTreeElement createRequest(@NotNull PsiElement element, @NotNull String text, @Nullable String location, boolean isValid) {
        if (element == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(4);
        }
        if (text == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(5);
        }
        HttpRequestStructureViewElement httpRequestStructureViewElement = new HttpRequestStructureViewElement(element, text, location, RestClientIcons.Request, isValid);
        if (httpRequestStructureViewElement == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(6);
        }
        return httpRequestStructureViewElement;
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        String mimeType;
        FileType fileType;
        HttpRequestBody body;
        PsiElement element = this.getElement();
        if (element instanceof HttpRequestPsiFile) {
            Object[] type = (HttpRequest[])PsiTreeUtil.getChildrenOfType((PsiElement)element, HttpRequest.class);
            if (!ArrayUtil.isEmpty((Object[])type)) {
                ArrayList children = ContainerUtil.newArrayListWithCapacity((int)type.length);
                PsiFile file = element.getContainingFile();
                HttpRequestVariableSubstitutor substitutor = HttpRequestVariableSubstitutor.getDefault(element.getProject(), file);
                boolean showHosts = HttpRequestStructureViewElement.showHosts((HttpRequest[])type, substitutor);
                boolean showMethods = HttpRequestStructureViewElement.showMethods((HttpRequest[])type);
                for (Object request : type) {
                    String originalHost = request.getHttpHost(substitutor);
                    HttpRequestTarget target = request.getRequestTarget();
                    String path = target != null ? target.getHttpPath(substitutor) : null;
                    boolean isEmpty = StringUtil.isEmpty((String)path);
                    String method = request.getHttpMethod();
                    StringBuilder location = new StringBuilder();
                    if (showMethods && !StringUtil.equals((CharSequence)method, (CharSequence)"GET")) {
                        location.append(method);
                    }
                    if (showHosts && !isEmpty) {
                        if (location.length() > 0) {
                            location.append(" ");
                        }
                        location.append(StringUtil.notNullize((String)originalHost, (String)"<not defined>"));
                    }
                    String text = isEmpty ? StringUtil.notNullize((String)originalHost, (String)"<not defined>") : "/" + StringUtil.notNullize((String)path);
                    children.add(HttpRequestStructureViewElement.createRequest((PsiElement)request, text, location.length() == 0 ? null : location.toString(), StringUtil.isNotEmpty((String)originalHost)));
                }
                ArrayList arrayList = children;
                if (arrayList == null) {
                    HttpRequestStructureViewElement.$$$reportNull$$$0(7);
                }
                return arrayList;
            }
        } else if (element instanceof HttpRequest && (body = ((HttpRequest)element).getRequestBody()) != null && (fileType = RestClientFileUtil.findFileType(mimeType = ((HttpRequest)element).getMimeType())) != null) {
            List list = ContainerUtil.newSmartList((Object)HttpRequestStructureViewElement.create((PsiElement)body, mimeType, fileType.getIcon()));
            if (list == null) {
                HttpRequestStructureViewElement.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(9);
        }
        return list;
    }

    public String getLocationString() {
        return this.myLocation;
    }

    public boolean isSearchInLocationString() {
        return true;
    }

    private static boolean showHosts(HttpRequest[] type, HttpRequestVariableSubstitutor substitutor) {
        if (type.length <= 1) {
            return true;
        }
        return Stream.of(type).map(request -> request.getHttpHost(substitutor)).filter(StringUtil::isNotEmpty).distinct().count() > 1L;
    }

    private static boolean showMethods(HttpRequest[] type) {
        if (type.length <= 1) {
            return true;
        }
        return Stream.of(type).map(request -> request.getHttpMethod()).filter(StringUtil::isNotEmpty).distinct().count() > 1L;
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        if (!this.myIsValid) {
            return CodeInsightColors.ERRORS_ATTRIBUTES;
        }
        return null;
    }

    @Nullable
    public String getPresentableText() {
        return this.myPresentationText;
    }

    public Icon getIcon(boolean open) {
        if (this.myIcon != null) {
            return this.myIcon;
        }
        return super.getIcon(open);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/structure/HttpRequestStructureViewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/structure/HttpRequestStructureViewElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequest";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

