/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.OutlineStepSubstitution;
import org.jetbrains.plugins.cucumber.steps.search.CucumberStepSearchUtil;

public class CucumberUtil {
    @NonNls
    public static final String STEP_DEFINITIONS_DIR_NAME = "step_definitions";
    public static final String[][] ARR = new String[][]{{"\\\\", "\\\\\\\\"}, {"\\|", "\\\\|"}, {"\\$", "\\\\\\$"}, {"\\^", "\\\\^"}, {"\\+", "\\+"}, {"\\-", "\\\\-"}, {"\\#", "\\\\#"}, {"\\?", "\\\\?"}, {"\\*", "\\\\*"}, {"\\/", "\\\\/"}, {"\\{", "\\\\{"}, {"\\}", "\\\\}"}, {"\\[", "\\\\["}, {"\\]", "\\\\]"}, {"\\(", "\\\\("}, {"\\)", "\\\\)"}, {"\\+", "\\\\+"}, {"\"([^\\\\\"]*)\"", "\"([^\"]*)\""}, {"(?<=^|[ .,])\\d+[ ]", "(\\\\d+) "}, {"(?<=^|[ .,])\\d+[,]", "(\\\\d+),"}, {"(?<=^|[ .,])\\d+[.]", "(\\\\d+)."}, {"(?<=^|[ .,])\\d+$", "(\\\\d+)"}, {"\\.", "\\\\."}, {"(<[^>]*>)", "(.*)"}};
    public static final char LEFT_PAR = '(';
    public static final char RIGHT_PAR = ')';
    public static final char LEFT_SQUARE_BRACE = '[';
    public static final char RIGHT_SQUARE_BRACE = ']';
    public static final char LEFT_BRACE = '{';
    public static final char RIGHT_BRACE = '}';
    public static final char ESCAPE_SLASH = '\\';
    public static final String PREFIX_CHAR = "^";
    public static final String SUFFIX_CHAR = "$";

    public static boolean findGherkinReferencesToElement(@NotNull PsiElement stepDefinitionElement, @NotNull String regexp, @NotNull Processor<? super PsiReference> consumer, @NotNull SearchScope effectiveSearchScope) {
        if (stepDefinitionElement == null) {
            CucumberUtil.$$$reportNull$$$0(0);
        }
        if (regexp == null) {
            CucumberUtil.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            CucumberUtil.$$$reportNull$$$0(2);
        }
        if (effectiveSearchScope == null) {
            CucumberUtil.$$$reportNull$$$0(3);
        }
        return CucumberUtil.findPossibleGherkinElementUsages(stepDefinitionElement, regexp, new MyReferenceCheckingProcessor(stepDefinitionElement, consumer), effectiveSearchScope);
    }

    public static boolean findPossibleGherkinElementUsages(@NotNull PsiElement stepDefinitionElement, @NotNull String regexp, @NotNull TextOccurenceProcessor processor, @NotNull SearchScope effectiveSearchScope) {
        String word;
        if (stepDefinitionElement == null) {
            CucumberUtil.$$$reportNull$$$0(4);
        }
        if (regexp == null) {
            CucumberUtil.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            CucumberUtil.$$$reportNull$$$0(6);
        }
        if (effectiveSearchScope == null) {
            CucumberUtil.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmptyOrSpaces((String)(word = CucumberUtil.getTheBiggestWordToSearchByIndex(regexp)))) {
            return true;
        }
        SearchScope searchScope = CucumberStepSearchUtil.restrictScopeToGherkinFiles((Computable<SearchScope>)((Computable)() -> {
            if (effectiveSearchScope == null) {
                CucumberUtil.$$$reportNull$$$0(12);
            }
            return effectiveSearchScope;
        }));
        int context = 5;
        PsiSearchHelper instance = PsiSearchHelper.getInstance((Project)stepDefinitionElement.getProject());
        return instance.processElementsWithWord(processor, searchScope, word, (short)5, true);
    }

    public static String getTheBiggestWordToSearchByIndex(@NotNull String regexp) {
        if (regexp == null) {
            CucumberUtil.$$$reportNull$$$0(8);
        }
        String result = "";
        if (regexp.startsWith(PREFIX_CHAR)) {
            regexp = regexp.substring(1);
        }
        if (regexp.endsWith(SUFFIX_CHAR)) {
            regexp = regexp.substring(0, regexp.length() - 1);
        }
        int par = 0;
        int squareBrace = 0;
        int brace = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < regexp.length(); ++i) {
            char c = regexp.charAt(i);
            if (c == '#') {
                sb = new StringBuilder();
                continue;
            }
            if (c != '\\') {
                if (c == '(') {
                    ++par;
                }
                if (c == ')' && par > 0) {
                    --par;
                }
                if (c == '{') {
                    ++brace;
                }
                if (c == '}' && brace > 0) {
                    --brace;
                }
                if (c == '[') {
                    ++squareBrace;
                }
                if (c == ']' && squareBrace > 0) {
                    --squareBrace;
                }
            } else {
                sb = new StringBuilder();
                ++i;
            }
            if (par > 0 | squareBrace > 0 | brace > 0) {
                if (par + squareBrace + brace != 1) continue;
                sb = new StringBuilder();
                continue;
            }
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                if (sb.length() <= 0 || sb.toString().length() <= result.length()) continue;
                result = sb.toString();
                continue;
            }
            sb = new StringBuilder();
        }
        if (sb.length() > 0 && sb.toString().length() > result.length()) {
            result = sb.toString();
        }
        return result;
    }

    public static String prepareStepRegexp(String stepName) {
        String result = stepName;
        for (String[] rule : ARR) {
            result = result.replaceAll(rule[0], rule[1]);
        }
        return result;
    }

    @NotNull
    public static OutlineStepSubstitution substituteTableReferences(String stepName, @Nullable Map<String, String> outlineTableMap) {
        int end;
        int start;
        if (outlineTableMap == null) {
            OutlineStepSubstitution outlineStepSubstitution = new OutlineStepSubstitution(stepName, Collections.emptyList());
            if (outlineStepSubstitution == null) {
                CucumberUtil.$$$reportNull$$$0(9);
            }
            return outlineStepSubstitution;
        }
        ArrayList<Pair<Integer, Integer>> offsets = new ArrayList<Pair<Integer, Integer>>();
        StringBuilder result = new StringBuilder();
        int currentOffset = 0;
        while ((start = stepName.indexOf(60, currentOffset)) >= 0 && (end = stepName.indexOf(62, start)) >= 0) {
            String columnName = stepName.substring(start + 1, end);
            String value = outlineTableMap.get(columnName);
            if (value == null) {
                OutlineStepSubstitution outlineStepSubstitution = new OutlineStepSubstitution(stepName);
                if (outlineStepSubstitution == null) {
                    CucumberUtil.$$$reportNull$$$0(10);
                }
                return outlineStepSubstitution;
            }
            result.append(stepName.subSequence(currentOffset, start));
            int replaceOffset = result.length();
            result.append(value);
            int outlineParameterLength = end - start + 1;
            int valueLength = value.length();
            offsets.add((Pair<Integer, Integer>)new Pair((Object)replaceOffset, (Object)(outlineParameterLength - valueLength)));
            currentOffset = end + 1;
        }
        result.append(stepName.subSequence(currentOffset, stepName.length()));
        OutlineStepSubstitution outlineStepSubstitution = new OutlineStepSubstitution(result.toString(), offsets);
        if (outlineStepSubstitution == null) {
            CucumberUtil.$$$reportNull$$$0(11);
        }
        return outlineStepSubstitution;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinitionElement";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectiveSearchScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/CucumberUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/CucumberUtil";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTableReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findGherkinReferencesToElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPossibleGherkinElementUsages";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTheBiggestWordToSearchByIndex";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findPossibleGherkinElementUsages$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReferenceCheckingProcessor
    implements TextOccurenceProcessor {
        @NotNull
        private final PsiElement myElementToFind;
        @NotNull
        private final Processor<? super PsiReference> myConsumer;

        private MyReferenceCheckingProcessor(@NotNull PsiElement elementToFind, @NotNull Processor<? super PsiReference> consumer) {
            if (elementToFind == null) {
                MyReferenceCheckingProcessor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyReferenceCheckingProcessor.$$$reportNull$$$0(1);
            }
            this.myElementToFind = elementToFind;
            this.myConsumer = consumer;
        }

        public boolean execute(@NotNull PsiElement element, int offsetInElement) {
            if (element == null) {
                MyReferenceCheckingProcessor.$$$reportNull$$$0(2);
            }
            PsiElement parent = element.getParent();
            boolean result = this.executeInternal(element);
            if (result && parent != null) {
                return this.executeInternal(parent);
            }
            return result;
        }

        private boolean executeInternal(@NotNull PsiElement referenceOwner) {
            if (referenceOwner == null) {
                MyReferenceCheckingProcessor.$$$reportNull$$$0(3);
            }
            for (PsiReference ref : referenceOwner.getReferences()) {
                if (ref == null || !ref.isReferenceTo(this.myElementToFind) || this.myConsumer.process((Object)ref)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToFind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceOwner";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/cucumber/CucumberUtil$MyReferenceCheckingProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeInternal";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

