/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.docker.debug;

import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLabel;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.debug.DebugDeploymentTransformer;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.debugger.DebuggerWorkerPlatform;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.ProtocolComponent;
import com.jetbrains.rider.protocol.components.LoggerHost;
import com.jetbrains.rider.util.NetUtils;
import com.jetbrains.rider.util.reactive.IOptProperty;
import com.jetbrains.rider.util.reactive.InterfacesKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/docker/debug/RiderDebugDeploymentTransformer;", "Lcom/intellij/docker/debug/DebugDeploymentTransformer;", "Lcom/intellij/docker/agent/DockerAgentDeploymentConfig;", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "transformConfig", "config", "Companion", "rider-plugins-appender"})
public final class RiderDebugDeploymentTransformer
implements DebugDeploymentTransformer<DockerAgentDeploymentConfig> {
    private final ExecutionEnvironment executionEnvironment;
    @NotNull
    private static final Key<Pair<Integer, Integer>> PORTS_KEY;
    @NotNull
    private static final Key<String[]> ENTRYPOINT_OVERRIDE_KEY;
    @NotNull
    public static final String logContainerDir = "/riderLogs";
    @NotNull
    public static final String debuggerContainerDir = "/riderDebugger";
    public static final Companion Companion;

    @NotNull
    public DockerAgentDeploymentConfig transformConfig(@NotNull DockerAgentDeploymentConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        File debuggerWorkerAssembly = RiderEnvironment.INSTANCE.getBundledFile(DebuggerWorkerPlatform.AnyCpu.getAssemblyName());
        Pair freePorts = NetUtils.INSTANCE.findFreePorts(57000, 57100);
        int monoPort = NetUtils.INSTANCE.findFreePort(34000);
        this.executionEnvironment.putUserData(PORTS_KEY, (Object)freePorts);
        return new DockerAgentDeploymentConfig(this, config, freePorts, debuggerWorkerAssembly){
            private final /* synthetic */ DockerAgentDeploymentConfig $$delegate_0;
            final /* synthetic */ RiderDebugDeploymentTransformer this$0;
            final /* synthetic */ DockerAgentDeploymentConfig $config;
            final /* synthetic */ Pair $freePorts;
            final /* synthetic */ File $debuggerWorkerAssembly;

            @Nullable
            public DockerPortBinding[] getPortBindings() {
                Collection $receiver$iv;
                DockerPortBinding[] portBindings;
                DockerPortBinding[] dockerPortBindingArray = portBindings = this.$config.getPortBindings();
                if (portBindings == null) {
                    dockerPortBindingArray = new DockerPortBinding[]{};
                }
                List resultBindings = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(dockerPortBindingArray, dockerPortBindingArray.length));
                DockerPortBindingImpl $i$f$emptyArray = new DockerPortBindingImpl();
                List list = resultBindings;
                DockerPortBindingImpl $receiver = $i$f$emptyArray;
                $receiver.setHostPort((Integer)this.$freePorts.getFirst());
                $receiver.setContainerPort(((Number)this.$freePorts.getFirst()).intValue());
                DockerPortBindingImpl dockerPortBindingImpl = $i$f$emptyArray;
                list.add(dockerPortBindingImpl);
                $i$f$emptyArray = new DockerPortBindingImpl();
                list = resultBindings;
                $receiver = $i$f$emptyArray;
                $receiver.setHostPort((Integer)this.$freePorts.getSecond());
                $receiver.setContainerPort(((Number)this.$freePorts.getSecond()).intValue());
                dockerPortBindingImpl = $i$f$emptyArray;
                list.add(dockerPortBindingImpl);
                Collection collection = $receiver$iv = (Collection)resultBindings;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                DockerPortBinding[] dockerPortBindingArray2 = thisCollection$iv.toArray(new DockerPortBinding[0]);
                if (dockerPortBindingArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return dockerPortBindingArray2;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public DockerVolumeBinding[] getVolumeBindings() {
                Collection $receiver$iv;
                void $receiver$iv$iv$iv;
                Iterable $receiver$iv$iv;
                File binDirectory;
                DockerVolumeBinding[] volumeBindings;
                DockerVolumeBinding[] dockerVolumeBindingArray = volumeBindings = this.$config.getVolumeBindings();
                if (volumeBindings == null) {
                    dockerVolumeBindingArray = new DockerVolumeBinding[]{};
                }
                List resultBindings = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(dockerVolumeBindingArray, dockerVolumeBindingArray.length));
                File file = binDirectory = this.$debuggerWorkerAssembly.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"binDirectory");
                resultBindings.add(new DockerVolumeBindingImpl("/riderDebugger", file.getAbsolutePath(), true));
                Project project = RiderDebugDeploymentTransformer.access$getExecutionEnvironment$p(this.this$0).getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"executionEnvironment.project");
                IProtocolHost $receiver$iv2 = ApplicationProtocolKt.getProtocolHost((Project)project);
                Iterable iterable = $receiver$iv$iv = (Iterable)$receiver$iv2.getComponents();
                Collection destination$iv$iv$iv = new ArrayList<E>();
                for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                    if (!(element$iv$iv$iv instanceof LoggerHost)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                LoggerHost loggerHost = (LoggerHost)((ProtocolComponent)CollectionsKt.single((List)((List)destination$iv$iv$iv)));
                String workerLogSubDir = (String)InterfacesKt.valueOrDefault((IOptProperty)loggerHost.getModel().getTestLogDir(), (Object)"DebuggerWorker");
                File workerLogDir = new File(RiderEnvironment.INSTANCE.getLogDirectory(), workerLogSubDir);
                resultBindings.add(new DockerVolumeBindingImpl("/riderLogs", workerLogDir.getAbsolutePath(), false));
                Collection collection = $receiver$iv = (Collection)resultBindings;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                DockerVolumeBinding[] dockerVolumeBindingArray2 = thisCollection$iv.toArray(new DockerVolumeBinding[0]);
                if (dockerVolumeBindingArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return dockerVolumeBindingArray2;
            }

            @Nullable
            public String[] getEntrypoint() {
                String[] overriddenEntrypoint = this.$config.getEntrypoint();
                if (overriddenEntrypoint != null) {
                    RiderDebugDeploymentTransformer.access$getExecutionEnvironment$p(this.this$0).putUserData(RiderDebugDeploymentTransformer.Companion.getENTRYPOINT_OVERRIDE_KEY(), (Object)overriddenEntrypoint);
                }
                return new String[]{"/riderDebugger/runtime.sh", "/riderDebugger/" + this.$debuggerWorkerAssembly.getName(), "--mode=server", "--frontend-port=" + ((Number)this.$freePorts.getFirst()).intValue(), "--backend-port=" + ((Number)this.$freePorts.getSecond()).intValue()};
            }

            @NotNull
            public DockerEnvVar[] getEnvVars() {
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add((Object)((DockerEnvVar)new DockerEnvVarImpl("LOG_DIR", "/riderLogs")));
                SpreadBuilder spreadBuilder2 = spreadBuilder;
                SpreadBuilder spreadBuilder3 = spreadBuilder;
                DockerEnvVar[] dockerEnvVarArray = this.$config.getEnvVars();
                if (dockerEnvVarArray == null) {
                    SpreadBuilder spreadBuilder4 = spreadBuilder2;
                    SpreadBuilder spreadBuilder5 = spreadBuilder3;
                    DockerEnvVar[] dockerEnvVarArray2 = new DockerEnvVar[]{};
                    spreadBuilder3 = spreadBuilder5;
                    spreadBuilder2 = spreadBuilder4;
                    dockerEnvVarArray = dockerEnvVarArray2;
                }
                spreadBuilder2.addSpread((Object)dockerEnvVarArray);
                return (DockerEnvVar[])spreadBuilder3.toArray((Object[])new DockerEnvVar[spreadBuilder3.size()]);
            }
            {
                this.this$0 = $outer;
                this.$config = $captured_local_variable$1;
                this.$freePorts = $captured_local_variable$2;
                this.$debuggerWorkerAssembly = $captured_local_variable$3;
                this.$$delegate_0 = $captured_local_variable$1;
            }

            public DockerEnvVar[] getBuildArgs() {
                return this.$$delegate_0.getBuildArgs();
            }

            public String[] getCommand() {
                return this.$$delegate_0.getCommand();
            }

            public String getContainerName() {
                return this.$$delegate_0.getContainerName();
            }

            public String[] getCustomCliOptions() {
                return this.$$delegate_0.getCustomCliOptions();
            }

            public File getCustomContextFolder() {
                return this.$$delegate_0.getCustomContextFolder();
            }

            public String getDeploymentName() {
                return this.$$delegate_0.getDeploymentName();
            }

            public Integer[] getExposedPorts() {
                return this.$$delegate_0.getExposedPorts();
            }

            public String[] getExtraHosts() {
                return this.$$delegate_0.getExtraHosts();
            }

            public File getFile() {
                return this.$$delegate_0.getFile();
            }

            public String getImageTag() {
                return this.$$delegate_0.getImageTag();
            }

            public String getJSON() {
                return this.$$delegate_0.getJSON();
            }

            public DockerLabel[] getLabels() {
                return this.$$delegate_0.getLabels();
            }

            public DockerLink[] getLinks() {
                return this.$$delegate_0.getLinks();
            }

            public Boolean getNetworkDisabled() {
                return this.$$delegate_0.getNetworkDisabled();
            }

            public String getNetworkMode() {
                return this.$$delegate_0.getNetworkMode();
            }

            public Boolean getPublishAllPorts() {
                return this.$$delegate_0.getPublishAllPorts();
            }

            public Boolean getStdinOnce() {
                return this.$$delegate_0.getStdinOnce();
            }

            public String getUser() {
                return this.$$delegate_0.getUser();
            }

            public DockerVolumesFrom[] getVolumesFrom() {
                return this.$$delegate_0.getVolumesFrom();
            }

            public String getWorkingDir() {
                return this.$$delegate_0.getWorkingDir();
            }

            public boolean isBuildImageOnly() {
                return this.$$delegate_0.isBuildImageOnly();
            }

            public boolean isCreateContainerOnly() {
                return this.$$delegate_0.isCreateContainerOnly();
            }

            public boolean isFileArchive() {
                return this.$$delegate_0.isFileArchive();
            }

            public boolean isPublishAllPorts() {
                return this.$$delegate_0.isPublishAllPorts();
            }

            public String sourceType() {
                return this.$$delegate_0.sourceType();
            }
        };
    }

    public RiderDebugDeploymentTransformer(@NotNull ExecutionEnvironment executionEnvironment) {
        Intrinsics.checkParameterIsNotNull((Object)executionEnvironment, (String)"executionEnvironment");
        this.executionEnvironment = executionEnvironment;
    }

    static {
        Companion = new Companion(null);
        PORTS_KEY = new Key("PortsKey");
        ENTRYPOINT_OVERRIDE_KEY = new Key("EntryPointKey");
    }

    @NotNull
    public static final /* synthetic */ ExecutionEnvironment access$getExecutionEnvironment$p(RiderDebugDeploymentTransformer $this) {
        return $this.executionEnvironment;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR#\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/docker/debug/RiderDebugDeploymentTransformer$Companion;", "", "()V", "ENTRYPOINT_OVERRIDE_KEY", "Lcom/intellij/openapi/util/Key;", "", "", "getENTRYPOINT_OVERRIDE_KEY", "()Lcom/intellij/openapi/util/Key;", "PORTS_KEY", "Lkotlin/Pair;", "", "getPORTS_KEY", "debuggerContainerDir", "logContainerDir", "rider-plugins-appender"})
    public static final class Companion {
        @NotNull
        public final Key<Pair<Integer, Integer>> getPORTS_KEY() {
            return PORTS_KEY;
        }

        @NotNull
        public final Key<String[]> getENTRYPOINT_OVERRIDE_KEY() {
            return ENTRYPOINT_OVERRIDE_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

