/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.base.Predicate;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.ui.AbstractTabs;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TabbedTerminalWidget;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalTabs;
import com.jediterm.terminal.ui.TerminalWidget;
import com.jediterm.terminal.ui.settings.TabbedSettingsProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public class JBTabbedTerminalWidget
extends TabbedTerminalWidget
implements Disposable {
    private final Project myProject;
    private final JBTerminalSystemSettingsProviderBase mySettingsProvider;
    private final Disposable myParent;

    public JBTabbedTerminalWidget(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, final @NotNull Predicate<Pair<TerminalWidget, String>> createNewSessionAction, @NotNull Disposable parent) {
        if (project == null) {
            JBTabbedTerminalWidget.$$$reportNull$$$0(0);
        }
        if (settingsProvider == null) {
            JBTabbedTerminalWidget.$$$reportNull$$$0(1);
        }
        if (createNewSessionAction == null) {
            JBTabbedTerminalWidget.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            JBTabbedTerminalWidget.$$$reportNull$$$0(3);
        }
        super((TabbedSettingsProvider)settingsProvider, input -> {
            if (createNewSessionAction == null) {
                JBTabbedTerminalWidget.$$$reportNull$$$0(8);
            }
            return createNewSessionAction.apply((Object)Pair.create((Object)input, null));
        });
        this.myProject = project;
        this.mySettingsProvider = settingsProvider;
        this.myParent = parent;
        JBTabbedTerminalWidget.convertActions((JComponent)((Object)this), this.getActions());
        Disposer.register((Disposable)parent, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)settingsProvider);
        DnDSupport.createBuilder((JComponent)((Object)this)).setDropHandler(new DnDDropHandler(){

            public void drop(DnDEvent event) {
                TransferableWrapper ao;
                if (event.getAttachedObject() instanceof TransferableWrapper && (ao = (TransferableWrapper)event.getAttachedObject()) != null && ao.getPsiElements() != null && ao.getPsiElements().length == 1 && ao.getPsiElements()[0] instanceof PsiFileSystemItem) {
                    PsiFileSystemItem element = (PsiFileSystemItem)ao.getPsiElements()[0];
                    PsiDirectory dir = element instanceof PsiFile ? ((PsiFile)element).getContainingDirectory() : (PsiDirectory)element;
                    createNewSessionAction.apply((Object)Pair.create((Object)((Object)JBTabbedTerminalWidget.this), (Object)dir.getVirtualFile().getPath()));
                }
            }
        }).install();
    }

    public static void convertActions(@NotNull JComponent component, @NotNull List<TerminalAction> actions) {
        if (component == null) {
            JBTabbedTerminalWidget.$$$reportNull$$$0(4);
        }
        if (actions == null) {
            JBTabbedTerminalWidget.$$$reportNull$$$0(5);
        }
        JBTabbedTerminalWidget.convertActions(component, actions, null);
    }

    public static void convertActions(@NotNull JComponent component, @NotNull List<TerminalAction> actions, @Nullable Predicate<KeyEvent> elseAction) {
        if (component == null) {
            JBTabbedTerminalWidget.$$$reportNull$$$0(6);
        }
        if (actions == null) {
            JBTabbedTerminalWidget.$$$reportNull$$$0(7);
        }
        for (TerminalAction action : actions) {
            if (action.isHidden()) continue;
            DumbAwareAction.create(e -> {
                KeyEvent event;
                KeyEvent keyEvent = event = e.getInputEvent() instanceof KeyEvent ? (KeyEvent)e.getInputEvent() : null;
                if (!action.perform(event) && elseAction != null) {
                    elseAction.apply((Object)event);
                }
            }).registerCustomShortcutSet(action.getKeyCode(), action.getModifiers(), component);
        }
    }

    protected JediTermWidget createInnerTerminalWidget(TabbedSettingsProvider settingsProvider) {
        JBTerminalWidget widget = new JBTerminalWidget(this.myProject, this.mySettingsProvider, this.myParent);
        JBTabbedTerminalWidget.convertActions((JComponent)widget, widget.getActions());
        JBTabbedTerminalWidget.convertActions((JComponent)widget.getTerminalPanel(), widget.getTerminalPanel().getActions(), (Predicate<KeyEvent>)((Predicate)input -> {
            widget.getTerminalPanel().handleKeyEvent(input);
            return true;
        }));
        return widget;
    }

    protected TerminalTabs createTabbedPane() {
        return new JBTerminalTabs(this.myProject, this.myParent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createNewSessionAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/terminal/JBTabbedTerminalWidget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "convertActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class JBTerminalTabs
    implements TerminalTabs {
        private final JBEditorTabs myTabs;
        private final TabInfo.DragOutDelegate myDragDelegate;
        private final CopyOnWriteArraySet<AbstractTabs.TabChangeListener> myListeners;

        public JBTerminalTabs(@NotNull Project project, Disposable parent) {
            if (project == null) {
                JBTerminalTabs.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                JBTerminalTabs.$$$reportNull$$$0(1);
            }
            this.myDragDelegate = new MyDragOutDelegate();
            this.myListeners = new CopyOnWriteArraySet();
            ActionManager actionManager = ActionManager.getInstance();
            this.myTabs = new JBEditorTabs(project, actionManager, IdeFocusManager.getInstance((Project)project), parent){

                protected TabLabel createTabLabel(TabInfo info) {
                    return new TerminalTabLabel((JBTabsImpl)this, info);
                }
            };
            this.myTabs.addListener(new TabsListener(){

                public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                    for (AbstractTabs.TabChangeListener each : JBTerminalTabs.this.myListeners) {
                        each.selectionChanged();
                    }
                }

                public void tabRemoved(TabInfo tabInfo) {
                    for (AbstractTabs.TabChangeListener each : JBTerminalTabs.this.myListeners) {
                        each.tabRemoved();
                    }
                }
            });
            this.myTabs.setTabDraggingEnabled(true);
        }

        public int getSelectedIndex() {
            return this.myTabs.getIndexOf(this.myTabs.getSelectedInfo());
        }

        public void setSelectedIndex(int index) {
            this.myTabs.select(this.myTabs.getTabAt(index), true);
        }

        public void setTabComponentAt(int index, Component component) {
        }

        public int indexOfComponent(Component component) {
            for (int i = 0; i < this.myTabs.getTabCount(); ++i) {
                if (!component.equals(this.myTabs.getTabAt(i).getComponent())) continue;
                return i;
            }
            return -1;
        }

        public int indexOfTabComponent(Component component) {
            return 0;
        }

        private TabInfo getTabAt(int index) {
            this.checkIndex(index);
            return this.myTabs.getTabAt(index);
        }

        private void checkIndex(int index) {
            if (index < 0 || index >= this.getTabCount()) {
                throw new ArrayIndexOutOfBoundsException("tabCount=" + this.getTabCount() + " index=" + index);
            }
        }

        public JediTermWidget getComponentAt(int i) {
            return (JediTermWidget)this.getTabAt(i).getComponent();
        }

        public void addChangeListener(AbstractTabs.TabChangeListener listener) {
            this.myListeners.add(listener);
        }

        public void setTitleAt(int index, String title) {
            this.getTabAt(index).setText(title);
        }

        public void setSelectedComponent(JediTermWidget terminal) {
            TabInfo info = this.myTabs.findInfo((Component)terminal);
            if (info != null) {
                this.myTabs.select(info, true);
            }
        }

        public JComponent getComponent() {
            return this.myTabs.getComponent();
        }

        public int getTabCount() {
            return this.myTabs.getTabCount();
        }

        public void addTab(String name, JediTermWidget terminal) {
            this.myTabs.addTab(this.createTabInfo(name, terminal));
            this.myTabs.updateUI();
        }

        private TabInfo createTabInfo(String name, JediTermWidget terminal) {
            TabInfo tabInfo = new TabInfo((JComponent)terminal).setText(name).setDragOutDelegate(this.myDragDelegate);
            return tabInfo.setObject((Object)new TerminalSessionVirtualFileImpl(tabInfo, terminal, (TabbedSettingsProvider)JBTabbedTerminalWidget.this.mySettingsProvider));
        }

        public String getTitleAt(int i) {
            return this.getTabAt(i).getText();
        }

        public void removeAll() {
            this.myTabs.removeAllTabs();
        }

        public void remove(JediTermWidget terminal) {
            TabInfo info = this.myTabs.findInfo((Component)terminal);
            if (info != null) {
                this.myTabs.removeTab(info);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/terminal/JBTabbedTerminalWidget$JBTerminalTabs";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        class MyDragOutDelegate
        implements TabInfo.DragOutDelegate {
            private TerminalSessionVirtualFileImpl myFile;
            private DragSession mySession;

            MyDragOutDelegate() {
            }

            public void dragOutStarted(MouseEvent mouseEvent, TabInfo info) {
                TabInfo previousSelection = info.getPreviousSelection();
                Image img = JBTabsImpl.getComponentImage((TabInfo)info);
                info.setHidden(true);
                if (previousSelection != null) {
                    JBTerminalTabs.this.myTabs.select(previousSelection, true);
                }
                this.myFile = (TerminalSessionVirtualFileImpl)((Object)info.getObject());
                Presentation presentation = new Presentation(info.getText());
                presentation.setIcon(info.getIcon());
                this.mySession = this.getDockManager().createDragSession(mouseEvent, (DockableContent)new EditorTabbedContainer.DockableEditor(JBTabbedTerminalWidget.this.myProject, img, (VirtualFile)this.myFile, presentation, info.getComponent().getPreferredSize(), false));
            }

            private DockManager getDockManager() {
                return DockManager.getInstance((Project)JBTabbedTerminalWidget.this.myProject);
            }

            public void processDragOut(MouseEvent event, TabInfo source) {
                this.mySession.process(event);
            }

            public void dragOutFinished(MouseEvent event, TabInfo source) {
                this.myFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, Boolean.TRUE);
                JBTerminalTabs.this.myTabs.removeTab(source);
                this.mySession.process(event);
                this.myFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
                this.myFile = null;
                this.mySession = null;
            }

            public void dragOutCancelled(TabInfo source) {
                source.setHidden(false);
                if (this.mySession != null) {
                    this.mySession.cancel();
                }
                this.myFile = null;
                this.mySession = null;
            }
        }

        private class TerminalTabLabel
        extends TabLabel {
            public TerminalTabLabel(JBTabsImpl tabs, final TabInfo info) {
                super(tabs, info);
                this.setOpaque(false);
                this.setFocusable(false);
                SimpleColoredComponent label = this.myLabel;
                label.setBorder((Border)JBUI.Borders.emptyRight((int)5));
                label.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent event) {
                        this.handleMouse(event);
                    }

                    @Override
                    public void mousePressed(MouseEvent event) {
                        this.handleMouse(event);
                    }

                    private void handleMouse(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            JPopupMenu menu = TerminalTabLabel.this.createPopup();
                            menu.show(e.getComponent(), e.getX(), e.getY());
                        } else if (e.getButton() != 2) {
                            TerminalTabLabel.this.myTabs.select(TerminalTabLabel.this.getInfo(), true);
                            if (e.getClickCount() == 2 && !e.isConsumed()) {
                                e.consume();
                                TerminalTabLabel.this.renameTab();
                            }
                        }
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() == 2) {
                            if (TerminalTabLabel.this.myTabs.getSelectedInfo() == info) {
                                JBTabbedTerminalWidget.this.closeCurrentSession();
                            } else {
                                TerminalTabLabel.this.myTabs.select(info, true);
                            }
                        }
                    }
                });
            }

            protected JPopupMenu createPopup() {
                JPopupMenu popupMenu = new JPopupMenu();
                TerminalAction.addToMenu((JPopupMenu)popupMenu, (TerminalActionProvider)JBTabbedTerminalWidget.this);
                JMenuItem rename = new JMenuItem("Rename Tab");
                rename.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TerminalTabLabel.this.renameTab();
                    }
                });
                popupMenu.add(rename);
                return popupMenu;
            }

            private void renameTab() {
                new TabbedTerminalWidget.TabRenamer(){

                    protected JTextField createTextField() {
                        JBTextField textField = new JBTextField(){
                            private int myMinimalWidth;

                            public Dimension getPreferredSize() {
                                Dimension size = super.getPreferredSize();
                                if (size.width > this.myMinimalWidth) {
                                    this.myMinimalWidth = size.width;
                                }
                                return this.wider(size, this.myMinimalWidth);
                            }

                            private Dimension wider(Dimension size, int minimalWidth) {
                                return new Dimension(minimalWidth + 10, size.height);
                            }
                        };
                        if (TerminalTabLabel.this.myTabs.useSmallLabels()) {
                            textField.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, (Font)textField.getFont()));
                        }
                        textField.setOpaque(true);
                        return textField;
                    }
                }.install(JBTerminalTabs.this.getSelectedIndex(), this.getInfo().getText(), (Component)this.myLabel, new TabbedTerminalWidget.TabRenamer.RenameCallBack(){

                    public void setComponent(Component c) {
                        TerminalTabLabel.this.myTabs.setTabDraggingEnabled(!(c instanceof JBTextField));
                        TerminalTabLabel.this.setPlaceholderContent(true, (JComponent)c);
                    }

                    public void setNewName(int index, String name) {
                        JBTerminalTabs.this.setTitleAt(index, name);
                    }
                });
            }
        }
    }
}

