/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ClientData;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.View;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;
import org.jetbrains.idea.perforce.perforce.connections.SingletonConnection;

class PerforceClientImpl
implements PerforceClient {
    private final Project myProject;
    private final P4Connection myConnection;

    public PerforceClientImpl(Project project, P4Connection connection) {
        this.myProject = project;
        this.myConnection = connection;
    }

    private Map<String, List<String>> getInfo() throws VcsException {
        return PerforceManager.getInstance(this.myProject).getCachedInfo(this.myConnection);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PerforceClientImpl.$$$reportNull$$$0(0);
        }
        return project;
    }

    @Override
    public String getName() throws VcsException {
        return this.getFieldValue("Client name:");
    }

    @Override
    @NotNull
    public List<String> getRoots() throws VcsException {
        List<String> list = PerforceManager.getInstance(this.myProject).getClientRoots(this.myConnection);
        if (list == null) {
            PerforceClientImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public List<View> getViews() throws VcsException {
        return PerforceManager.getInstance(this.myProject).getCachedClients(this.myConnection).getViews();
    }

    @Override
    @Nullable
    public List<String> getCachedOptions() {
        try {
            ClientData clientSpec = PerforceManager.getInstance(this.myProject).getClientOnlyCached(this.myConnection);
            return clientSpec == null ? null : clientSpec.getOptions();
        }
        catch (VcsException e) {
            return null;
        }
    }

    private String getFieldValue(String fieldName) throws VcsException {
        List<String> names = this.getInfo().get(fieldName);
        return names == null || names.isEmpty() ? null : names.get(0);
    }

    @Override
    public String getUserName() throws VcsException {
        return this.getFieldValue("User name:");
    }

    @Override
    @Nullable
    public String getServerPort() throws VcsException {
        return this.getFieldValue("Server address:");
    }

    @Override
    @Nullable
    public String getDeclaredServerPort() {
        if (this.myConnection instanceof P4ParametersConnection) {
            return ((P4ParametersConnection)this.myConnection).getParameters().getServer();
        }
        if (this.myConnection instanceof SingletonConnection) {
            return PerforceSettings.getSettings((Project)this.myProject).port;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/perforce/application/PerforceClientImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

