/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class TestFullNameView {
    private final String myPopupTitle;
    private final TextFieldWithBrowseButton myTextFieldWithBrowseButton;
    private List<String> myNames;
    private boolean myPopupCanBeShown;

    public TestFullNameView() {
        this("Edit test name");
    }

    public TestFullNameView(@NotNull String popupTitle) {
        if (popupTitle == null) {
            TestFullNameView.$$$reportNull$$$0(0);
        }
        this.myNames = ImmutableList.of();
        this.myPopupCanBeShown = true;
        this.myPopupTitle = popupTitle;
        this.myTextFieldWithBrowseButton = new TextFieldWithBrowseButton();
        JTextField textField = this.myTextFieldWithBrowseButton.getTextField();
        textField.setEditable(false);
        textField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TestFullNameView.this.showPopup();
            }
        });
        this.myTextFieldWithBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestFullNameView.this.showPopup();
            }
        });
    }

    private void showPopup() {
        if (!this.myPopupCanBeShown) {
            return;
        }
        this.myPopupCanBeShown = false;
        JTextField textField = (JTextField)this.myTextFieldWithBrowseButton.getChildComponent();
        final TfnPopupContentView contentView = new TfnPopupContentView(this.myNames, textField.getWidth() - 3);
        contentView.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TestFullNameView.this.setNames(contentView.getTableModel().getNames());
            }
        });
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(contentView.getComponent(), contentView.getPreferredFocusComponent()).setSettingButtons((Component)contentView.getToolbarComponent()).setTitle(this.myPopupTitle).setShowBorder(true).setShowShadow(false).setRequestFocus(true).setFocusable(true).setFocusOwners(new Component[]{contentView.getComponent()}).setLocateWithinScreenBounds(true).setCancelOnOtherWindowOpen(false).setMovable(false).setResizable(true).setCancelOnWindowDeactivation(true).setCancelOnClickOutside(true).setMinSize(new Dimension(100, 50)).setCancelButton(new IconButton("Close", AllIcons.Actions.Close, AllIcons.Actions.CloseHovered));
        JBPopup popup = builder.createPopup();
        popup.setFinalRunnable(() -> {
            this.setNames(contentView.getTableModel().getNames());
            Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            alarm.addRequest(() -> {
                this.myPopupCanBeShown = true;
                Disposer.dispose((Disposable)alarm);
            }, 200, ModalityState.any());
        });
        popup.show(this.calcUnderneathPoint());
        this.installDialogFix(popup);
    }

    private void installDialogFix(final @NotNull JBPopup popup) {
        DialogWrapper dialogWrapper;
        Window window;
        if (popup == null) {
            TestFullNameView.$$$reportNull$$$0(1);
        }
        Window window2 = window = (dialogWrapper = DialogWrapper.findInstance((Component)this.myTextFieldWithBrowseButton)) != null ? dialogWrapper.getWindow() : null;
        if (window != null) {
            final ComponentAdapter listener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (this.checkPopup()) {
                        popup.closeOk(null);
                    }
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    if (this.checkPopup()) {
                        RelativePoint point = TestFullNameView.this.calcUnderneathPoint();
                        popup.setLocation(point.getScreenPoint());
                    }
                }

                private boolean checkPopup() {
                    if (popup.isDisposed() || !popup.isVisible()) {
                        window.removeComponentListener(this);
                        return false;
                    }
                    return true;
                }
            };
            window.addComponentListener(listener);
            popup.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    window.removeComponentListener(listener);
                    popup.removeListener((JBPopupListener)this);
                }
            });
        }
    }

    @NotNull
    private RelativePoint calcUnderneathPoint() {
        JTextField textField = (JTextField)this.myTextFieldWithBrowseButton.getChildComponent();
        RelativePoint relativePoint = new RelativePoint((Component)textField, new Point(2, textField.getHeight() + 2));
        if (relativePoint == null) {
            TestFullNameView.$$$reportNull$$$0(2);
        }
        return relativePoint;
    }

    @NotNull
    public JComponent getComponent() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myTextFieldWithBrowseButton;
        if (textFieldWithBrowseButton == null) {
            TestFullNameView.$$$reportNull$$$0(3);
        }
        return textFieldWithBrowseButton;
    }

    @NotNull
    public List<String> getNames() {
        List<String> list = this.myNames;
        if (list == null) {
            TestFullNameView.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void setNames(@NotNull List<String> names) {
        if (names == null) {
            TestFullNameView.$$$reportNull$$$0(5);
        }
        this.myNames = ImmutableList.copyOf(names);
        this.myTextFieldWithBrowseButton.setText(JsTestFqn.getPresentableName(names));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupTitle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/util/TestFullNameView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/util/TestFullNameView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcUnderneathPoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installDialogFix";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TfnTableModel
    extends AbstractTableModel {
        private final List<String> myNames;

        public TfnTableModel(@NotNull List<String> names) {
            if (names == null) {
                TfnTableModel.$$$reportNull$$$0(0);
            }
            this.myNames = Lists.newArrayList(names);
        }

        private static void checkColumnIndex(int columnIndex) {
            if (columnIndex != 0) {
                throw new IllegalStateException("Unexpected column: " + columnIndex);
            }
        }

        public List<String> getNames() {
            return ContainerUtil.newArrayList(this.myNames);
        }

        @Override
        public int getRowCount() {
            return this.myNames.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            TfnTableModel.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
            this.myNames.set(rowIndex, String.valueOf(aValue));
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TfnTableModel.checkColumnIndex(columnIndex);
            this.checkRowIndex(rowIndex);
            return this.myNames.get(rowIndex);
        }

        public void removeRow(int rowIndex) {
            this.checkRowIndex(rowIndex);
            this.myNames.remove(rowIndex);
        }

        private void checkRowIndex(int rowIndex) {
            if (rowIndex < 0 || rowIndex >= this.myNames.size()) {
                throw new IllegalStateException("Requested excluded file is out of bound: (rowIndex: " + rowIndex + ", size: " + this.myNames.size() + ")");
            }
        }

        public void addName(@NotNull String name, int index) {
            if (name == null) {
                TfnTableModel.$$$reportNull$$$0(1);
            }
            this.myNames.add(index, name);
            this.fireTableRowsInserted(index, index);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/testFramework/util/TestFullNameView$TfnTableModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TfnPopupContentView {
        private final TfnTableModel myTableModel;
        private final JBTable myTable;
        private final JPanel myContent;
        private final JComponent myToolbarComponent;

        public TfnPopupContentView(@NotNull List<String> initialNames, int preferredWidth) {
            if (initialNames == null) {
                TfnPopupContentView.$$$reportNull$$$0(0);
            }
            this.myContent = new JPanel(new BorderLayout());
            this.myTableModel = new TfnTableModel(initialNames);
            this.myTable = new JBTable((TableModel)this.myTableModel);
            this.myTable.setSelectionMode(0);
            this.myTable.setStriped(true);
            this.myTable.getEmptyText().setText("Empty test name");
            this.myTable.getSelectionModel().setSelectionMode(2);
            this.myTable.setTableHeader(null);
            this.myToolbarComponent = this.createToolbarComponent();
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTable, (int)20, (int)30);
            scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            scrollPane.getViewport().setPreferredSize(new Dimension(-1, this.myTable.getRowHeight() * Math.max(4, initialNames.size())));
            this.myContent.add(scrollPane);
            SwingHelper.setPreferredWidth((Component)this.myContent, (int)preferredWidth);
        }

        @NotNull
        private JComponent createToolbarComponent() {
            AnAction[] actions;
            for (AnAction action : actions = new AnAction[]{new TfnToolbarAction(CommonActionsPanel.Buttons.ADD, AllIcons.General.Add){

                public void actionPerformed(AnActionEvent e) {
                    this.addNameAfterSelected();
                }
            }, new TfnToolbarAction(CommonActionsPanel.Buttons.REMOVE, AllIcons.General.Remove){

                public void update(AnActionEvent e) {
                    e.getPresentation().setEnabled(myTable.getSelectedRowCount() > 0);
                }

                public void actionPerformed(AnActionEvent e) {
                    this.removeSelectedNames();
                }
            }, new TfnToolbarAction(CommonActionsPanel.Buttons.EDIT, AllIcons.Actions.Edit){

                public void update(AnActionEvent e) {
                    e.getPresentation().setEnabled(myTable.getSelectedRowCount() > 0);
                }

                public void actionPerformed(AnActionEvent e) {
                    this.editSelectedName();
                }
            }}) {
                ShortcutSet shortcutSet = action.getShortcutSet();
                if (shortcutSet == null) continue;
                action.registerCustomShortcutSet(shortcutSet, (JComponent)this.myTable);
            }
            final ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("JsTestFullNameView", (ActionGroup)new DefaultActionGroup(actions), true);
            toolbar.setReservePlaceAutoPopupIcon(false);
            toolbar.setMinimumButtonSize(new Dimension(18, 18));
            JComponent component = toolbar.getComponent();
            component.setOpaque(false);
            this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    toolbar.updateActionsImmediately();
                }
            });
            JComponent jComponent = component;
            if (jComponent == null) {
                TfnPopupContentView.$$$reportNull$$$0(1);
            }
            return jComponent;
        }

        @NotNull
        public JComponent getToolbarComponent() {
            JComponent jComponent = this.myToolbarComponent;
            if (jComponent == null) {
                TfnPopupContentView.$$$reportNull$$$0(2);
            }
            return jComponent;
        }

        @NotNull
        protected JComponent getComponent() {
            JPanel jPanel = this.myContent;
            if (jPanel == null) {
                TfnPopupContentView.$$$reportNull$$$0(3);
            }
            return jPanel;
        }

        private void addNameAfterSelected() {
            int selectedRow = this.myTable.getSelectedRow();
            int addInd = selectedRow < 0 ? this.myTableModel.getRowCount() : selectedRow + 1;
            this.myTableModel.addName("", addInd);
            this.myTable.setRowSelectionInterval(addInd, addInd);
            TableUtil.scrollSelectionToVisible((JTable)this.myTable);
            this.myTable.editCellAt(addInd, 0);
        }

        private void editSelectedName() {
            if (this.myTable.isEditing()) {
                TableUtil.stopEditing((JTable)this.myTable);
            } else {
                int selectedRow = this.myTable.getSelectedRow();
                if (selectedRow >= 0) {
                    TableUtil.editCellAt((JTable)this.myTable, (int)selectedRow, (int)0);
                }
            }
        }

        private void removeSelectedNames() {
            TableCellEditor editor;
            int[] selected = this.myTable.getSelectedRows();
            if (selected.length == 0) {
                return;
            }
            if (this.myTable.isEditing() && (editor = this.myTable.getCellEditor()) != null) {
                editor.stopCellEditing();
            }
            Arrays.sort(selected);
            int removedCount = 0;
            for (int indexToRemove : selected) {
                int row = indexToRemove - removedCount;
                this.myTableModel.removeRow(row);
                this.myTableModel.fireTableRowsDeleted(row, row);
                ++removedCount;
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
            if (this.myTableModel.getRowCount() > 0) {
                int newSelectedRow = Math.min(this.myTableModel.getRowCount() - 1, selected[0]);
                this.myTable.setRowSelectionInterval(newSelectedRow, newSelectedRow);
            }
        }

        public JComponent getPreferredFocusComponent() {
            return this.myTable;
        }

        public TfnTableModel getTableModel() {
            return this.myTableModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialNames";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/testFramework/util/TestFullNameView$TfnPopupContentView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/testFramework/util/TestFullNameView$TfnPopupContentView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolbarComponent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class TfnToolbarAction
    extends DumbAwareAction {
        public TfnToolbarAction(@NotNull CommonActionsPanel.Buttons buttonType, @NotNull Icon icon) {
            if (buttonType == null) {
                TfnToolbarAction.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                TfnToolbarAction.$$$reportNull$$$0(1);
            }
            super(StringUtil.capitalize((String)buttonType.name().toLowerCase(Locale.ENGLISH)), null, icon);
            this.setShortcutSet(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)buttonType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buttonType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/testFramework/util/TestFullNameView$TfnToolbarAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

