/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.config;

import com.intellij.javascript.karma.config.KarmaBasePathFinder;
import com.intellij.javascript.karma.config.KarmaConfigFileReference;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class KarmaConfigReferenceContributor
extends PsiReferenceContributor {
    private static final String FILES_VAR_NAME = "files";
    public static final ElementPattern<JSLiteralExpression> STRING_LITERAL_INSIDE_KARMA_CONFIG_FILE = PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

        public boolean isAcceptable(Object element, PsiElement context) {
            PsiFile psiFile = context.getContainingFile();
            return KarmaUtil.isKarmaConfigFile(psiFile.getName(), false);
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            KarmaConfigReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider(STRING_LITERAL_INSIDE_KARMA_CONFIG_FILE, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                JSLiteralExpression literalExpression;
                if (psiElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (processingContext == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)psiElement, JSLiteralExpression.class)) == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                if (KarmaBasePathFinder.isBasePathStringLiteral(literalExpression)) {
                    FileReference[] fileReferenceArray = new BasePathFileReferenceSet(literalExpression, this).getAllReferences();
                    if (fileReferenceArray == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return fileReferenceArray;
                }
                if (KarmaConfigReferenceContributor.isFileStringLiteral(literalExpression)) {
                    FileReference[] fileReferenceArray = new FilesFileReferenceSet(literalExpression, this).getAllReferences();
                    if (fileReferenceArray == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    return fileReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(5);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processingContext";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$2";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static boolean isFileStringLiteral(@NotNull JSLiteralExpression literalExpression) {
        JSProperty property;
        JSArrayLiteralExpression arrayLiteralExpression;
        if (literalExpression == null) {
            KarmaConfigReferenceContributor.$$$reportNull$$$0(1);
        }
        if (literalExpression.isQuotedLiteral() && (arrayLiteralExpression = (JSArrayLiteralExpression)ObjectUtils.tryCast((Object)literalExpression.getParent(), JSArrayLiteralExpression.class)) != null && (property = (JSProperty)ObjectUtils.tryCast((Object)arrayLiteralExpression.getParent(), JSProperty.class)) != null) {
            String name = JsPsiUtils.getPropertyName((JSProperty)property);
            return FILES_VAR_NAME.equals(name);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileStringLiteral";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FilesFileReferenceSet
    extends FileReferenceSet {
        private boolean myPatternUsed;

        public FilesFileReferenceSet(@NotNull JSLiteralExpression literalExpression, @NotNull PsiReferenceProvider psiReferenceProvider) {
            if (literalExpression == null) {
                FilesFileReferenceSet.$$$reportNull$$$0(0);
            }
            if (psiReferenceProvider == null) {
                FilesFileReferenceSet.$$$reportNull$$$0(1);
            }
            super(StringUtil.unquoteString((String)literalExpression.getText()), (PsiElement)literalExpression, 1, psiReferenceProvider, !SystemInfo.isWindows, false, null, false);
            this.myPatternUsed = false;
            this.setEmptyPathAllowed(true);
            super.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> {
                PsiDirectory psiChildDirectory;
                if (!(file instanceof JSFile)) {
                    return null;
                }
                PsiDirectory psiDirectory = file.getParent();
                if (psiDirectory == null) {
                    return null;
                }
                String basePath = KarmaBasePathFinder.getInstance().fetchBasePath((JSFile)file);
                if (StringUtil.isEmpty((String)basePath)) {
                    return Collections.singletonList(psiDirectory);
                }
                VirtualFile vDirectory = psiDirectory.getVirtualFile();
                VirtualFile vChildDirectory = vDirectory.findFileByRelativePath(basePath);
                if (vChildDirectory != null && (psiChildDirectory = psiDirectory.getManager().findDirectory(vChildDirectory)) != null) {
                    return Collections.singletonList(psiChildDirectory);
                }
                return Collections.emptyList();
            });
            super.reparse();
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            if (this.isAbsolutePathReference()) {
                Collection collection = this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
                if (collection == null) {
                    FilesFileReferenceSet.$$$reportNull$$$0(2);
                }
                return collection;
            }
            Collection collection = super.computeDefaultContexts();
            if (collection == null) {
                FilesFileReferenceSet.$$$reportNull$$$0(3);
            }
            return collection;
        }

        public FileReference createFileReference(TextRange range, int index, String text) {
            if (!this.myPatternUsed && text.contains("*")) {
                this.myPatternUsed = true;
            }
            return new KarmaConfigFileReference(this, range, index, text, KarmaConfigFileReference.FileType.FILE, this.myPatternUsed);
        }

        protected boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literalExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiReferenceProvider";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$FilesFileReferenceSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$FilesFileReferenceSet";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeDefaultContexts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class BasePathFileReferenceSet
    extends FileReferenceSet {
        public BasePathFileReferenceSet(@NotNull JSLiteralExpression literalExpression, @NotNull PsiReferenceProvider psiReferenceProvider) {
            if (literalExpression == null) {
                BasePathFileReferenceSet.$$$reportNull$$$0(0);
            }
            if (psiReferenceProvider == null) {
                BasePathFileReferenceSet.$$$reportNull$$$0(1);
            }
            super(BasePathFileReferenceSet.getString(literalExpression), (PsiElement)literalExpression, 1, psiReferenceProvider, !SystemInfo.isWindows, false, null, false);
            this.setEmptyPathAllowed(true);
            super.reparse();
        }

        private static String getString(@NotNull JSLiteralExpression expression) {
            String value;
            if (expression == null) {
                BasePathFileReferenceSet.$$$reportNull$$$0(2);
            }
            return (value = StringUtil.unquoteString((String)expression.getText())).isEmpty() ? "." : value;
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            if (this.isAbsolutePathReference()) {
                Collection collection = this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
                if (collection == null) {
                    BasePathFileReferenceSet.$$$reportNull$$$0(3);
                }
                return collection;
            }
            Collection collection = super.computeDefaultContexts();
            if (collection == null) {
                BasePathFileReferenceSet.$$$reportNull$$$0(4);
            }
            return collection;
        }

        protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
            return FileReferenceSet.DIRECTORY_FILTER;
        }

        public FileReference createFileReference(TextRange range, int index, String text) {
            return new KarmaConfigFileReference(this, range, index, text, KarmaConfigFileReference.FileType.DIRECTORY, false);
        }

        protected boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literalExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiReferenceProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$BasePathFileReferenceSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/karma/config/KarmaConfigReferenceContributor$BasePathFileReferenceSet";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeDefaultContexts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getString";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

