/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.karma.coverage.KarmaCoveragePeer;
import com.intellij.javascript.karma.coverage.KarmaCoverageRunner;
import com.intellij.javascript.karma.coverage.KarmaCoverageSession;
import com.intellij.javascript.karma.execution.KarmaConsoleView;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaCoverageProgramRunner
extends GenericProgramRunner {
    private static final Logger LOG = Logger.getInstance(KarmaCoverageProgramRunner.class);
    private static final String COVERAGE_RUNNER_ID = KarmaCoverageProgramRunner.class.getSimpleName();

    @NotNull
    public String getRunnerId() {
        String string = COVERAGE_RUNNER_ID;
        if (string == null) {
            KarmaCoverageProgramRunner.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            KarmaCoverageProgramRunner.$$$reportNull$$$0(1);
        }
        if (profile == null) {
            KarmaCoverageProgramRunner.$$$reportNull$$$0(2);
        }
        return "Coverage".equals(executorId) && profile instanceof KarmaRunConfiguration;
    }

    public RunnerSettings createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return new CoverageRunnerData();
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            KarmaCoverageProgramRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            KarmaCoverageProgramRunner.$$$reportNull$$$0(4);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ExecutionResult executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
        if (executionResult == null) {
            return null;
        }
        RunContentDescriptor descriptor = KarmaUtil.createDefaultDescriptor(executionResult, env);
        KarmaConsoleView consoleView = KarmaConsoleView.get(executionResult, state);
        if (consoleView == null) {
            return descriptor;
        }
        KarmaServer server = consoleView.getKarmaServer();
        if (executionResult.getProcessHandler() instanceof NopProcessHandler) {
            server.onBrowsersReady(() -> ExecutionUtil.restartIfActive((RunContentDescriptor)descriptor));
        } else {
            KarmaCoverageProgramRunner.listenForCoverageFile(env, server);
        }
        return descriptor;
    }

    private static void listenForCoverageFile(final @NotNull ExecutionEnvironment env, final @NotNull KarmaServer server) {
        if (env == null) {
            KarmaCoverageProgramRunner.$$$reportNull$$$0(5);
        }
        if (server == null) {
            KarmaCoverageProgramRunner.$$$reportNull$$$0(6);
        }
        final RunConfigurationBase runConfiguration = (RunConfigurationBase)env.getRunProfile();
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
        CoverageHelper.resetCoverageSuit((RunConfigurationBase)runConfiguration);
        final String coverageFilePath = coverageEnabledConfiguration.getCoverageFilePath();
        if (coverageFilePath != null) {
            KarmaCoveragePeer coveragePeer = server.getCoveragePeer();
            Objects.requireNonNull(coveragePeer);
            coveragePeer.startCoverageSession(new KarmaCoverageSession(){

                @Override
                public void onCoverageSessionFinished(@Nullable File lcovFile) {
                    LOG.info("Processing karma coverage file: " + lcovFile);
                    UIUtil.invokeLaterIfNeeded(() -> {
                        Project project;
                        if (env == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (server == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if ((project = env.getProject()).isDisposed()) {
                            return;
                        }
                        if (lcovFile != null) {
                            KarmaCoverageProgramRunner.processLcovInfoFile(lcovFile, coverageFilePath, env, server, runConfiguration);
                        } else {
                            int response = Messages.showYesNoDialog((Project)project, (String)"Cannot find karma test coverage report - lcov.info", (String)"Missing Karma Coverage Report", (String)"Select lcov.info", (String)"Cancel", (Icon)Messages.getWarningIcon());
                            if (response == 0) {
                                FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileDescriptor(), (Project)project, null, null, file -> {
                                    File selected;
                                    if (env == null) {
                                        1.$$$reportNull$$$0(2);
                                    }
                                    if (server == null) {
                                        1.$$$reportNull$$$0(3);
                                    }
                                    File file2 = selected = file != null ? VfsUtilCore.virtualToIoFile((VirtualFile)file) : null;
                                    if (selected != null) {
                                        KarmaCoverageProgramRunner.processLcovInfoFile(selected, coverageFilePath, env, server, runConfiguration);
                                    }
                                });
                            }
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "env";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "server";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onCoverageSessionFinished$1";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$null$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static void processLcovInfoFile(@NotNull File lcovInfoFile, @NotNull String toCoverageFilePath, @NotNull ExecutionEnvironment env, @NotNull KarmaServer karmaServer, @NotNull RunConfigurationBase runConfiguration) {
        if (lcovInfoFile == null) {
            KarmaCoverageProgramRunner.$$$reportNull$$$0(7);
        }
        if (toCoverageFilePath == null) {
            KarmaCoverageProgramRunner.$$$reportNull$$$0(8);
        }
        if (env == null) {
            KarmaCoverageProgramRunner.$$$reportNull$$$0(9);
        }
        if (karmaServer == null) {
            KarmaCoverageProgramRunner.$$$reportNull$$$0(10);
        }
        if (runConfiguration == null) {
            KarmaCoverageProgramRunner.$$$reportNull$$$0(11);
        }
        try {
            FileUtil.copy((File)lcovInfoFile, (File)new File(toCoverageFilePath));
        }
        catch (IOException e) {
            LOG.error("Cannot copy " + lcovInfoFile.getAbsolutePath() + " to " + toCoverageFilePath, (Throwable)e);
            return;
        }
        RunnerSettings runnerSettings = env.getRunnerSettings();
        if (runnerSettings != null) {
            KarmaCoverageRunner coverageRunner = KarmaCoverageRunner.getInstance();
            coverageRunner.setKarmaServer(karmaServer);
            CoverageDataManager.getInstance((Project)env.getProject()).processGatheredCoverage(runConfiguration, runnerSettings);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lcovInfoFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCoverageFilePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "karmaServer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "listenForCoverageFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processLcovInfoFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

