/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.debug;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.execution.ILiveEditOptions;
import com.intellij.openapi.components.ServiceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggableWebBrowser {
    private final JavaScriptDebugEngine myDebugEngine;
    private final WebBrowser myWebBrowser;

    private DebuggableWebBrowser(@NotNull JavaScriptDebugEngine debugEngine, @NotNull WebBrowser webBrowser) {
        if (debugEngine == null) {
            DebuggableWebBrowser.$$$reportNull$$$0(0);
        }
        if (webBrowser == null) {
            DebuggableWebBrowser.$$$reportNull$$$0(1);
        }
        this.myDebugEngine = debugEngine;
        this.myWebBrowser = webBrowser;
    }

    @NotNull
    public JavaScriptDebugEngine getDebugEngine() {
        JavaScriptDebugEngine javaScriptDebugEngine = this.myDebugEngine;
        if (javaScriptDebugEngine == null) {
            DebuggableWebBrowser.$$$reportNull$$$0(2);
        }
        return javaScriptDebugEngine;
    }

    @NotNull
    public WebBrowser getWebBrowser() {
        WebBrowser webBrowser = this.myWebBrowser;
        if (webBrowser == null) {
            DebuggableWebBrowser.$$$reportNull$$$0(3);
        }
        return webBrowser;
    }

    @Nullable
    public static DebuggableWebBrowser create(@NotNull WebBrowser browser) {
        ILiveEditOptions liveEditOptions;
        if (browser == null) {
            DebuggableWebBrowser.$$$reportNull$$$0(4);
        }
        boolean useExtension = (liveEditOptions = (ILiveEditOptions)ServiceManager.getService(ILiveEditOptions.class)) != null && liveEditOptions.isChromeUpdateApp();
        JavaScriptDebugEngine debugEngine = JavaScriptDebugEngine.Companion.findByBrowser(browser, useExtension);
        return debugEngine != null ? new DebuggableWebBrowser(debugEngine, browser) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugEngine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webBrowser";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/debug/DebuggableWebBrowser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/debug/DebuggableWebBrowser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugEngine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

