/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.debug;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.debug.DebuggableWebBrowser;
import com.intellij.javascript.karma.debug.KarmaKt;
import com.intellij.javascript.karma.execution.KarmaConsoleView;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcess;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.connection.VmConnection;

public class KarmaDebugProgramRunner
extends AsyncProgramRunner {
    private static final Logger LOG = Logger.getInstance(KarmaDebugProgramRunner.class);

    @NotNull
    public String getRunnerId() {
        if ("KarmaJavaScriptTestRunnerDebug" == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(0);
        }
        return "KarmaJavaScriptTestRunnerDebug";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(1);
        }
        if (profile == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(2);
        }
        return DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && profile instanceof KarmaRunConfiguration;
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) throws ExecutionException {
        if (environment == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(3);
        }
        if (state == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(4);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ExecutionResult executionResult = state.execute(environment.getExecutor(), (ProgramRunner)this);
        if (executionResult == null) {
            Promise promise = Promise.resolve(null);
            if (promise == null) {
                KarmaDebugProgramRunner.$$$reportNull$$$0(5);
            }
            return promise;
        }
        KarmaConsoleView consoleView = KarmaConsoleView.get(executionResult, state);
        if (consoleView == null) {
            Promise promise = Promise.resolve((Object)KarmaUtil.createDefaultDescriptor(executionResult, environment));
            if (promise == null) {
                KarmaDebugProgramRunner.$$$reportNull$$$0(6);
            }
            return promise;
        }
        KarmaServer karmaServer = consoleView.getKarmaServer();
        if (executionResult.getProcessHandler() instanceof NopProcessHandler) {
            RunContentDescriptor descriptor = KarmaUtil.createDefaultDescriptor(executionResult, environment);
            karmaServer.onPortBound(() -> ExecutionUtil.restartIfActive((RunContentDescriptor)descriptor));
            Promise promise = Promises.resolvedPromise((Object)descriptor);
            if (promise == null) {
                KarmaDebugProgramRunner.$$$reportNull$$$0(7);
            }
            return promise;
        }
        DebuggableWebBrowser debuggableWebBrowser = KarmaDebugProgramRunner.getChromeInfo();
        Promise<RunContentDescriptor> promise = KarmaKt.prepareKarmaDebugger(environment.getProject(), debuggableWebBrowser, (ThrowableComputable<RunContentDescriptor, ExecutionException>)((ThrowableComputable)() -> {
            if (environment == null) {
                KarmaDebugProgramRunner.$$$reportNull$$$0(29);
            }
            return KarmaDebugProgramRunner.createDescriptor(environment, executionResult, consoleView, karmaServer, debuggableWebBrowser);
        }));
        if (promise == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(8);
        }
        return promise;
    }

    @NotNull
    private static DebuggableWebBrowser getChromeInfo() throws ExecutionException {
        WebBrowser browser = WebBrowserManager.getInstance().getFirstBrowserOrNull(BrowserFamily.CHROME);
        if (browser == null) {
            throw new ExecutionException("Debugging is available in Chrome browser only.<p>Please configure Chrome browser in 'Settings | Tools | Web Browsers'");
        }
        DebuggableWebBrowser debuggableWebBrowser = DebuggableWebBrowser.create(browser);
        if (debuggableWebBrowser == null) {
            throw new ExecutionException("Cannot find Chrome engine for debugging");
        }
        DebuggableWebBrowser debuggableWebBrowser2 = debuggableWebBrowser;
        if (debuggableWebBrowser2 == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(9);
        }
        return debuggableWebBrowser2;
    }

    @NotNull
    private static RunContentDescriptor createDescriptor(@NotNull ExecutionEnvironment environment, final @NotNull ExecutionResult executionResult, final @NotNull KarmaConsoleView consoleView, final @NotNull KarmaServer karmaServer, final @NotNull DebuggableWebBrowser debuggableWebBrowser) throws ExecutionException {
        if (environment == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(10);
        }
        if (executionResult == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(11);
        }
        if (consoleView == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(12);
        }
        if (karmaServer == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(13);
        }
        if (debuggableWebBrowser == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(14);
        }
        final Url url = Urls.newFromEncoded((String)karmaServer.formatUrl("/"));
        final DebuggableFileFinder fileFinder = KarmaDebugProgramRunner.getDebuggableFileFinder(karmaServer);
        XDebugSession session = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                JavaScriptDebugProcess debugProcess = KarmaDebugProgramRunner.createDebugProcess(session, karmaServer, fileFinder, executionResult, debuggableWebBrowser, url);
                debugProcess.setScriptsCanBeReloaded(true);
                debugProcess.addFirstLineBreakpointPattern("\\.browserify$");
                debugProcess.setElementsInspectorEnabled(false);
                debugProcess.setConsoleMessagesSupportEnabled(false);
                debugProcess.setLayouter((XDebugTabLayouter)consoleView.createDebugLayouter(debugProcess));
                karmaServer.onBrowsersReady(() -> {
                    if (karmaServer == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (executionResult == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    KarmaDebugProgramRunner.openConnectionIfRemoteDebugging(karmaServer, debugProcess.getConnection());
                    Runnable resumeTestRunning = ConcurrencyUtil.once(() -> {
                        if (executionResult == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        KarmaDebugProgramRunner.resumeTestRunning((OSProcessHandler)executionResult.getProcessHandler());
                    });
                    SingleAlarm alarm = new SingleAlarm(resumeTestRunning, 5000);
                    alarm.request();
                    debugProcess.getConnection().executeOnStart(vm -> {
                        if (Registry.is((String)"js.debugger.break.on.first.statement", (boolean)false)) {
                            vm.getBreakpointManager().setBreakOnFirstStatement();
                        }
                        alarm.cancelAllRequests();
                        resumeTestRunning.run();
                        return Unit.INSTANCE;
                    });
                });
                JavaScriptDebugProcess javaScriptDebugProcess = debugProcess;
                if (javaScriptDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return javaScriptDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "karmaServer";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executionResult";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$start$2";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$null$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        RunContentDescriptor runContentDescriptor = KarmaUtil.withReusePolicy(session.getRunContentDescriptor(), karmaServer);
        if (runContentDescriptor == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(15);
        }
        return runContentDescriptor;
    }

    @NotNull
    private static JavaScriptDebugProcess<? extends VmConnection> createDebugProcess(@NotNull XDebugSession session, @NotNull KarmaServer karmaServer, @NotNull DebuggableFileFinder fileFinder, @NotNull ExecutionResult executionResult, @NotNull DebuggableWebBrowser debuggableWebBrowser, @NotNull Url url) {
        KarmaConfig karmaConfig;
        if (session == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(16);
        }
        if (karmaServer == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(17);
        }
        if (fileFinder == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(18);
        }
        if (executionResult == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(19);
        }
        if (debuggableWebBrowser == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(20);
        }
        if (url == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(21);
        }
        if ((karmaConfig = karmaServer.getKarmaConfig()) != null && karmaConfig.getRemoteDebuggingPort() > 0) {
            BrowserChromeDebugProcess browserChromeDebugProcess = new BrowserChromeDebugProcess(session, fileFinder, (VmConnection)new WipRemoteVmConnection(), executionResult);
            if (browserChromeDebugProcess == null) {
                KarmaDebugProgramRunner.$$$reportNull$$$0(22);
            }
            return browserChromeDebugProcess;
        }
        JavaScriptDebugEngine debugEngine = debuggableWebBrowser.getDebugEngine();
        WebBrowser browser = debuggableWebBrowser.getWebBrowser();
        boolean reloadPage = !karmaServer.areBrowsersReady();
        JavaScriptDebugProcess javaScriptDebugProcess = debugEngine.createDebugProcess(session, browser, fileFinder, url, executionResult, reloadPage);
        if (javaScriptDebugProcess == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(23);
        }
        return javaScriptDebugProcess;
    }

    private static void openConnectionIfRemoteDebugging(@NotNull KarmaServer server, @NotNull VmConnection<?> connection) {
        KarmaConfig config;
        if (server == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(24);
        }
        if (connection == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(25);
        }
        if ((config = server.getKarmaConfig()) != null && config.getRemoteDebuggingPort() > 0 && connection instanceof WipRemoteVmConnection) {
            ((WipRemoteVmConnection)connection).open(new InetSocketAddress(config.getHostname(), config.getRemoteDebuggingPort()));
        }
    }

    @NotNull
    private static DebuggableFileFinder getDebuggableFileFinder(@NotNull KarmaServer karmaServer) {
        VirtualFile basePath;
        if (karmaServer == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(26);
        }
        HashBiMap mappings = HashBiMap.create();
        KarmaConfig karmaConfig = karmaServer.getKarmaConfig();
        if (karmaConfig != null && (basePath = LocalFileSystem.getInstance().findFileByPath(karmaConfig.getBasePath())) != null && basePath.isValid()) {
            if (karmaConfig.isWebpack()) {
                mappings.put((Object)("webpack:///" + basePath.getPath()), (Object)basePath);
                VirtualFile nodeModulesDir = basePath.findChild("node_modules");
                if (nodeModulesDir != null && nodeModulesDir.isValid() && nodeModulesDir.isDirectory()) {
                    mappings.put((Object)karmaServer.formatUrlWithoutUrlRoot("/base/node_modules"), (Object)nodeModulesDir);
                }
            } else {
                mappings.put((Object)karmaServer.formatUrlWithoutUrlRoot("/base"), (Object)basePath);
            }
        }
        VirtualFile[] roots = ManagingFS.getInstance().getLocalRoots();
        if (SystemInfo.isWindows) {
            for (VirtualFile root : roots) {
                String key = karmaServer.formatUrlWithoutUrlRoot("/absolute" + root.getName());
                if (mappings.containsKey((Object)key)) {
                    LOG.warn("Duplicate mapping for Karma debug: " + key);
                    continue;
                }
                mappings.put((Object)key, (Object)root);
            }
        } else if (roots.length == 1) {
            mappings.put((Object)karmaServer.formatUrlWithoutUrlRoot("/absolute"), (Object)roots[0]);
        }
        RemoteDebuggingFileFinder remoteDebuggingFileFinder = new RemoteDebuggingFileFinder((BiMap)mappings, null);
        if (remoteDebuggingFileFinder == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(27);
        }
        return remoteDebuggingFileFinder;
    }

    private static void resumeTestRunning(@NotNull OSProcessHandler processHandler) {
        Process process;
        if (processHandler == null) {
            KarmaDebugProgramRunner.$$$reportNull$$$0(28);
        }
        if ((process = processHandler.getProcess()).isAlive()) {
            try {
                OutputStream processInput = process.getOutputStream();
                processInput.write("resume-test-running\n".getBytes(CharsetToolkit.UTF8_CHARSET));
                processInput.flush();
            }
            catch (IOException e) {
                LOG.warn("process.isAlive()=" + process.isAlive(), (Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: 
            case 10: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 13: 
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "karmaServer";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggableWebBrowser";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFinder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/debug/KarmaDebugProgramRunner";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChromeInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcess";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggableFileFinder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcess";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "openConnectionIfRemoteDebugging";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDebuggableFileFinder";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resumeTestRunning";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

