/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaTestLocationProvider
implements SMTestLocator {
    private static final String PROTOCOL_ID__CONFIG_FILE = "config";
    private static final String PROTOCOL_ID__TEST_SUITE = "suite";
    private static final String PROTOCOL_ID__TEST = "test";
    public static final KarmaTestLocationProvider INSTANCE = new KarmaTestLocationProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        Object location;
        if (protocol == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(0);
        }
        if (path == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(3);
        }
        if ((location = PROTOCOL_ID__CONFIG_FILE.equals(protocol) ? KarmaTestLocationProvider.getConfigLocation(project, path) : (PROTOCOL_ID__TEST_SUITE.equals(protocol) ? KarmaTestLocationProvider.getTestLocation(project, path, true) : (PROTOCOL_ID__TEST.equals(protocol) ? KarmaTestLocationProvider.getTestLocation(project, path, false) : null))) != null) {
            List<Location> list = Collections.singletonList(location);
            if (list == null) {
                KarmaTestLocationProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    private static Location<PsiFile> getConfigLocation(Project project, @NotNull String locationData) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        if (locationData == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(6);
        }
        if ((virtualFile = VfsUtil.findFileByIoFile((File)new File(locationData), (boolean)false)) != null && virtualFile.isValid() && (psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) != null && psiFile.isValid()) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile);
        }
        return null;
    }

    @Nullable
    private static Location getTestLocation(Project project, @NotNull String locationData, boolean isSuite) {
        String testName;
        List<String> suiteNames;
        List<String> path;
        if (locationData == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(7);
        }
        if ((path = EscapeUtils.split((String)locationData, (char)'.')).isEmpty()) {
            return null;
        }
        if (isSuite) {
            suiteNames = path;
            testName = null;
        } else {
            suiteNames = path.subList(0, path.size() - 1);
            testName = path.get(path.size() - 1);
        }
        PsiElement psiElement = KarmaTestLocationProvider.findJasmineElement(project, suiteNames, testName);
        if (psiElement == null) {
            String moduleName = null;
            if (suiteNames.size() == 0) {
                moduleName = "Default Module";
            } else if (suiteNames.size() == 1) {
                moduleName = suiteNames.get(0);
            }
            if (moduleName != null) {
                psiElement = KarmaTestLocationProvider.findQUnitElement(project, moduleName, testName);
            }
        }
        if (psiElement != null) {
            return PsiLocation.fromPsiElement((PsiElement)psiElement);
        }
        return null;
    }

    @Nullable
    private static PsiElement findJasmineElement(Project project, @NotNull List<String> suiteNames, @Nullable String testName) {
        if (suiteNames == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(8);
        }
        String key = JsTestFileByTestNameIndex.createJasmineKey(suiteNames);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findJsTestFilesByNameInScope((String)key, (GlobalSearchScope)scope);
        JasmineFileStructureBuilder builder = JasmineFileStructureBuilder.getInstance();
        for (VirtualFile file : jsTestVirtualFiles) {
            JasmineFileStructure jasmineFileStructure;
            PsiElement element;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile) || (element = (jasmineFileStructure = (JasmineFileStructure)builder.fetchCachedTestFileStructure((JSFile)psiFile)).findPsiElement(suiteNames, testName)) == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement findQUnitElement(Project project, @NotNull String moduleName, @Nullable String testName) {
        if (moduleName == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(9);
        }
        String key = JsTestFileByTestNameIndex.createQUnitKey((String)moduleName, (String)testName);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findJsTestFilesByNameInScope((String)key, (GlobalSearchScope)scope);
        QUnitFileStructureBuilder builder = QUnitFileStructureBuilder.getInstance();
        for (VirtualFile file : jsTestVirtualFiles) {
            QUnitFileStructure qunitFileStructure;
            PsiElement element;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile) || (element = (qunitFileStructure = (QUnitFileStructure)builder.fetchCachedTestFileStructure((JSFile)psiFile)).findPsiElement(moduleName, testName)) == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaTestLocationProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteNames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaTestLocationProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfigLocation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findJasmineElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findQUnitElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

