/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.browsers.OpenUrlHyperlinkInfo;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerTerminatedListener;
import com.intellij.javascript.karma.util.ArchivedOutputListener;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaServerLogComponent
implements ComponentWithActions {
    public static final String KARMA_SERVER_CONTENT_ID = "KarmaServer";
    private final ConsoleView myConsole;
    private final KarmaServer myServer;
    private ActionGroup myActionGroup;

    private KarmaServerLogComponent(@NotNull ConsoleView console, @NotNull KarmaServer server) {
        if (console == null) {
            KarmaServerLogComponent.$$$reportNull$$$0(0);
        }
        if (server == null) {
            KarmaServerLogComponent.$$$reportNull$$$0(1);
        }
        this.myConsole = console;
        this.myServer = server;
    }

    @Nullable
    public ActionGroup getToolbarActions() {
        AnAction[] actions;
        if (this.myActionGroup != null) {
            return this.myActionGroup;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new StopProcessAction("Stop Karma Server", null, this.myServer.getProcessHandler()));
        for (AnAction action : actions = this.myConsole.createConsoleActions()) {
            group.add(action);
        }
        group.addSeparator();
        this.myActionGroup = group;
        return this.myActionGroup;
    }

    @Nullable
    public JComponent getSearchComponent() {
        return null;
    }

    @Nullable
    public String getToolbarPlace() {
        return "unknown";
    }

    @Nullable
    public JComponent getToolbarContextComponent() {
        return this.myConsole.getComponent();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myConsole.getComponent();
        if (jComponent == null) {
            KarmaServerLogComponent.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public boolean isContentBuiltIn() {
        return false;
    }

    @NotNull
    private static ConsoleView createConsole(@NotNull Project project) {
        if (project == null) {
            KarmaServerLogComponent.$$$reportNull$$$0(3);
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(project, scope);
        builder.setUsePredefinedMessageFilter(false);
        builder.addFilter((Filter)new NodeStackTraceFilter(project));
        builder.setViewer(false);
        ConsoleView consoleView = builder.getConsole();
        if (consoleView == null) {
            KarmaServerLogComponent.$$$reportNull$$$0(4);
        }
        return consoleView;
    }

    public static void register(@NotNull Project project, final @NotNull KarmaServer server, @NotNull RunnerLayoutUi ui) {
        if (project == null) {
            KarmaServerLogComponent.$$$reportNull$$$0(5);
        }
        if (server == null) {
            KarmaServerLogComponent.$$$reportNull$$$0(6);
        }
        if (ui == null) {
            KarmaServerLogComponent.$$$reportNull$$$0(7);
        }
        final ConsoleView console = KarmaServerLogComponent.createConsole(project);
        KarmaServerLogComponent component = new KarmaServerLogComponent(console, server);
        EmptyIcon emptyIcon = EmptyIcon.create((int)JBUI.scale((int)4));
        final Content content = ui.createContent(KARMA_SERVER_CONTENT_ID, (ComponentWithActions)component, "Karma Server", ExecutionUtil.getLiveIndicator((Icon)emptyIcon), console.getPreferredFocusableComponent());
        content.setCloseable(false);
        ui.addContent(content, 4, PlaceInGrid.bottom, false);
        final NopProcessHandler wrapperProcessHandler = new NopProcessHandler();
        console.attachToProcess((ProcessHandler)wrapperProcessHandler);
        final KarmaServerTerminatedListener terminationCallback = new KarmaServerTerminatedListener((Icon)emptyIcon){
            final /* synthetic */ Icon val$emptyIcon;
            {
                this.val$emptyIcon = icon;
            }

            @Override
            public void onTerminated(int exitCode) {
                wrapperProcessHandler.destroyProcess();
                content.setIcon(this.val$emptyIcon);
            }
        };
        server.onTerminated(terminationCallback);
        final ArchivedOutputListener outputListener = new ArchivedOutputListener(){

            @Override
            public void onOutputAvailable(@NotNull String text, Key outputType, boolean archived) {
                if (text == null) {
                    2.$$$reportNull$$$0(0);
                }
                ConsoleViewContentType contentType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                console.print(text, contentType);
                if (!archived && (KarmaServerLogComponent.startsWithMessage(text, ":ERROR ") || KarmaServerLogComponent.startsWithMessage(text, ":WARN [launcher]"))) {
                    ApplicationManager.getApplication().invokeLater(() -> content.fireAlert(), ModalityState.any());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/karma/server/KarmaServerLogComponent$2", "onOutputAvailable"));
            }
        };
        server.getProcessOutputManager().addOutputListener(outputListener);
        component.foldCommandLine();
        component.registerPrintingBrowserCapturingSuggestion();
        Disposer.register((Disposable)content, (Disposable)console);
        Disposer.register((Disposable)console, (Disposable)new Disposable(){

            public void dispose() {
                server.removeTerminatedListener(terminationCallback);
                server.getProcessOutputManager().removeOutputListener(outputListener);
            }
        });
    }

    private void foldCommandLine() {
        this.myServer.getCommandLineFolder().foldCommandLine(this.myConsole, this.myServer.getProcessHandler());
    }

    private void registerPrintingBrowserCapturingSuggestion() {
        this.myServer.onPortBound(() -> {
            if (this.myServer.getServerSettings().isDebug() || this.myServer.areBrowsersReady() || Disposer.isDisposed((Disposable)this.myConsole)) {
                return;
            }
            final int DELAY_MILLIS = 3000;
            final Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myConsole);
            final AtomicLong lastPrintTimeMillis = new AtomicLong(0L);
            alarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    if (KarmaServerLogComponent.this.myServer.getProcessHandler().isProcessTerminated()) {
                        Disposer.dispose((Disposable)alarm);
                        return;
                    }
                    long timeoutMillis = lastPrintTimeMillis.get() + (long)DELAY_MILLIS - System.currentTimeMillis();
                    if (timeoutMillis > 0L) {
                        alarm.addRequest((Runnable)this, timeoutMillis + 100L, ModalityState.any());
                    } else {
                        KarmaServerLogComponent.this.myConsole.print("Waiting for a captured browser... To capture a browser open ", ConsoleViewContentType.SYSTEM_OUTPUT);
                        String url = KarmaServerLogComponent.this.myServer.formatUrl("/");
                        KarmaServerLogComponent.this.myConsole.printHyperlink(url, (HyperlinkInfo)new OpenUrlHyperlinkInfo(url));
                        KarmaServerLogComponent.this.myConsole.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                        Disposer.dispose((Disposable)alarm);
                    }
                }
            }, 3000, ModalityState.any());
            this.myServer.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    lastPrintTimeMillis.set(System.currentTimeMillis());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/javascript/karma/server/KarmaServerLogComponent$5";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)alarm);
            this.myServer.onBrowsersReady(() -> Disposer.dispose((Disposable)alarm));
        });
    }

    private static boolean startsWithMessage(@NotNull String line, @NotNull String message) {
        int ind;
        if (line == null) {
            KarmaServerLogComponent.$$$reportNull$$$0(8);
        }
        if (message == null) {
            KarmaServerLogComponent.$$$reportNull$$$0(9);
        }
        if ((ind = line.indexOf(message)) == -1) {
            return false;
        }
        for (int i = 0; i < ind; ++i) {
            char ch = line.charAt(i);
            if (Character.isDigit(ch) || " :.".indexOf(ch) != -1) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/server/KarmaServerLogComponent";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServerLogComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startsWithMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

