/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.Function;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.jetbrains.firefox.FirefoxListener;
import com.jetbrains.firefox.FirefoxRemoteVmConnection$createBootstrap$;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.StandaloneFirefoxVm;
import com.jetbrains.firefox.rdp.ListTabsResult;
import com.jetbrains.firefox.rdp.Tab;
import com.jetbrains.firefox.rdp.TabAttached;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import java.net.InetSocketAddress;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.RemoteVmConnectionKt;
import org.jetbrains.io.NettyKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/firefox/FirefoxRemoteVmConnection;", "Lorg/jetbrains/debugger/connection/RemoteVmConnection;", "Lorg/jetbrains/debugger/Vm;", "()V", "tabLabel", "", "connectedAddressToPresentation", "address", "Ljava/net/InetSocketAddress;", "vm", "createBootstrap", "Lio/netty/bootstrap/Bootstrap;", "vmResult", "Lorg/jetbrains/concurrency/AsyncPromise;", "describeTab", "tab", "Lcom/jetbrains/firefox/rdp/Tab;", "intellij.javascript.firefox.connector"})
public class FirefoxRemoteVmConnection
extends RemoteVmConnection<Vm> {
    private String tabLabel;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bootstrap createBootstrap(@NotNull InetSocketAddress address, @NotNull AsyncPromise<Vm> vmResult) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull(vmResult, (String)"vmResult");
        Bootstrap $receiver$iv = this.createBootstrap();
        $receiver$iv.handler((ChannelHandler)new ChannelInitializer<Channel>(this, vmResult){
            final /* synthetic */ FirefoxRemoteVmConnection this$0;
            final /* synthetic */ AsyncPromise $vmResult$inlined;
            {
                this.this$0 = firefoxRemoteVmConnection;
                this.$vmResult$inlined = asyncPromise;
            }

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                Channel it = channel;
                StandaloneFirefoxVm vm = new StandaloneFirefoxVm(FirefoxRemoteVmConnection.access$getDebugEventListener$p(this.this$0), it);
                vm.getCommandProcessor().addInitialMessageHandler().thenAsync((Function)new Function<T, Promise<SUB_RESULT>>(vm){
                    final /* synthetic */ StandaloneFirefoxVm $vm;
                    {
                        this.$vm = standaloneFirefoxVm;
                    }

                    @NotNull
                    public final Promise<ListTabsResult> fun(Object it) {
                        return this.$vm.getCommandProcessor().send(FirefoxRequest.Companion.listTabs());
                    }
                }).thenAsync((Function)new Function<T, Promise<SUB_RESULT>>(this){
                    final /* synthetic */ createBootstrap$$inlined$handler$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final Promise<Tab> fun(ListTabsResult it) {
                        return Promises.isRejected((Promise)((Promise)this.this$0.$vmResult$inlined)) ? Promises.rejectedPromise((String)"rejected") : RemoteVmConnectionKt.chooseDebuggee((Collection)it.tabs(), (int)it.selected(), (Function2)((Function2)new Function2<Tab, ColoredListCellRenderer<?>, Unit>(this){
                            final /* synthetic */ createBootstrap$$inlined$handler$1$lambda$2 this$0;
                            {
                                this.this$0 = var1_1;
                                super(2);
                            }

                            public final void invoke(@NotNull Tab item, @NotNull ColoredListCellRenderer<?> renderer) {
                                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                                Intrinsics.checkParameterIsNotNull(renderer, (String)"renderer");
                                renderer.append(FirefoxRemoteVmConnection.access$describeTab(this.this$0.this$0.this$0, item));
                            }
                        }));
                    }
                }).thenAsync((Function)new Function<T, Promise<SUB_RESULT>>(vm, this){
                    final /* synthetic */ StandaloneFirefoxVm $vm;
                    final /* synthetic */ createBootstrap$$inlined$handler$1 this$0;
                    {
                        this.$vm = standaloneFirefoxVm;
                        this.this$0 = var2_2;
                    }

                    @NotNull
                    public final Promise<TabAttached> fun(Tab it) {
                        Promise promise;
                        if (Promises.isRejected((Promise)((Promise)this.this$0.$vmResult$inlined))) {
                            promise = Promises.rejectedPromise((String)"rejected");
                        } else {
                            FirefoxRemoteVmConnection firefoxRemoteVmConnection = this.this$0.this$0;
                            FirefoxRemoteVmConnection firefoxRemoteVmConnection2 = this.this$0.this$0;
                            Tab tab = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)tab, (String)"it");
                            FirefoxRemoteVmConnection.access$setTabLabel$p(firefoxRemoteVmConnection, FirefoxRemoteVmConnection.access$describeTab(firefoxRemoteVmConnection2, tab));
                            this.$vm.setTabActor(it.actor());
                            promise = this.$vm.getCommandProcessor().send(FirefoxRequest.Companion.attachToTab(it.actor()));
                        }
                        return promise;
                    }
                }).then((Function)new Function<T, SUB_RESULT>(vm, this){
                    final /* synthetic */ StandaloneFirefoxVm $vm;
                    final /* synthetic */ createBootstrap$$inlined$handler$1 this$0;
                    {
                        this.$vm = standaloneFirefoxVm;
                        this.this$0 = var2_2;
                    }

                    @NotNull
                    public final Vm invoke(@NotNull TabAttached tabAttached) {
                        Intrinsics.checkParameterIsNotNull((Object)tabAttached, (String)"tabAttached");
                        if (!Promises.isRejected((Promise)((Promise)this.this$0.$vmResult$inlined))) {
                            this.$vm.setThreadActor(tabAttached.threadActor());
                            this.$vm.getCommandProcessor().addListener(new FirefoxListener(this){
                                final /* synthetic */ createBootstrap$$inlined$handler$1$lambda$4 this$0;
                                {
                                    this.this$0 = $outer;
                                }

                                public void tabDetached(@NotNull String actor) {
                                    Intrinsics.checkParameterIsNotNull((Object)actor, (String)"actor");
                                    if (Intrinsics.areEqual((Object)actor, (Object)this.this$0.$vm.getTabActor())) {
                                        this.this$0.$vm.setTabActor(null);
                                        this.this$0.$vm.setThreadActor(null);
                                        this.this$0.this$0.this$0.close(ConnectionStatus.DISCONNECTED.getStatusText() + " (tab detached)", ConnectionStatus.DETACHED);
                                    }
                                }
                            });
                        }
                        return (Vm)this.$vm;
                    }
                }).processed((Promise)this.$vmResult$inlined);
            }
        });
        return var3_3;
    }

    @NotNull
    protected Bootstrap createBootstrap() {
        return NettyKt.oioClientBootstrap();
    }

    private final String describeTab(Tab tab) {
        return tab.title() + " (" + JsFileUtil.trimTitle((String)tab.url()) + ')';
    }

    @NotNull
    protected String connectedAddressToPresentation(@NotNull InetSocketAddress address, @NotNull Vm vm) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        StringBuilder stringBuilder = new StringBuilder().append(super.connectedAddressToPresentation(address, vm));
        if (this.tabLabel == null) {
            string = "";
        } else {
            StringBuilder stringBuilder2 = new StringBuilder().append(" \u2013 ");
            String string2 = this.tabLabel;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = stringBuilder2.append(string2).toString();
        }
        return stringBuilder.append(string).toString();
    }

    @NotNull
    public static final /* synthetic */ DebugEventListener access$getDebugEventListener$p(FirefoxRemoteVmConnection $this) {
        return $this.getDebugEventListener();
    }

    @NotNull
    public static final /* synthetic */ String access$describeTab(FirefoxRemoteVmConnection $this, @NotNull Tab tab) {
        return $this.describeTab(tab);
    }

    @Nullable
    public static final /* synthetic */ String access$getTabLabel$p(FirefoxRemoteVmConnection $this) {
        return $this.tabLabel;
    }

    public static final /* synthetic */ void access$setTabLabel$p(FirefoxRemoteVmConnection $this, @Nullable String string) {
        $this.tabLabel = string;
    }
}

