/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxMessageDecoder;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxVm;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.StandaloneVmHelper;
import org.jetbrains.debugger.Vm;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.rpc.MessageProcessor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/firefox/StandaloneFirefoxVm;", "Lcom/jetbrains/firefox/FirefoxVm;", "Lorg/jetbrains/debugger/StandaloneVmHelper$VmEx;", "tabListener", "Lorg/jetbrains/debugger/DebugEventListener;", "channel", "Lio/netty/channel/Channel;", "(Lorg/jetbrains/debugger/DebugEventListener;Lio/netty/channel/Channel;)V", "attachStateManager", "Lorg/jetbrains/debugger/StandaloneVmHelper;", "getAttachStateManager", "()Lorg/jetbrains/debugger/StandaloneVmHelper;", "vmHelper", "createDisconnectRequest", "Lcom/jetbrains/firefox/FirefoxRequest;", "Ljava/lang/Void;", "writeMessage", "", "content", "Lio/netty/buffer/ByteBuf;", "intellij.javascript.firefox.connector"})
public final class StandaloneFirefoxVm
extends FirefoxVm
implements StandaloneVmHelper.VmEx {
    private final StandaloneVmHelper vmHelper;
    @NotNull
    private final StandaloneVmHelper attachStateManager;

    @NotNull
    public StandaloneVmHelper getAttachStateManager() {
        return this.attachStateManager;
    }

    @Override
    protected boolean writeMessage(@NotNull ByteBuf content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Channel channel = this.vmHelper.getChannelIfActive();
        return channel != null && !FirefoxCommandProcessor.Companion.write(content, channel).isCancelled();
    }

    @Nullable
    public FirefoxRequest<Void> createDisconnectRequest() {
        FirefoxRequest<Void> firefoxRequest;
        if (this.getTabActor() == null) {
            firefoxRequest = null;
        } else {
            String string = this.getTabActor();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            firefoxRequest = FirefoxRequest.Companion.detach(string);
        }
        return firefoxRequest;
    }

    public StandaloneFirefoxVm(@NotNull DebugEventListener tabListener, @NotNull Channel channel) {
        Intrinsics.checkParameterIsNotNull((Object)tabListener, (String)"tabListener");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        super(tabListener);
        this.attachStateManager = this.vmHelper = new StandaloneVmHelper((Vm)this, (MessageProcessor)this.getCommandProcessor(), channel);
        channel.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)new FirefoxMessageDecoder(){

            @Override
            protected void processMessage(@NotNull CharSequence response, @NotNull ChannelHandlerContext context) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                try {
                    this.getCommandProcessor().processIncomingJson(new JsonReaderEx(response));
                }
                catch (Exception e) {
                    CommandProcessorKt.getLOG().error((Throwable)e);
                }
            }
        }, ChannelExceptionHandler.getInstance()});
    }
}

