using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class BreakpointHelperHost : RdExtBase {
    //fields
    //public fields
    [NotNull] public RdEndpoint<SourcePositionInfo, BreakpointVariantList> GetPossibleBreakpointVariants { get { return _GetPossibleBreakpointVariants; }}
    [NotNull] public IRdProperty<List<RdLanguage>> SupportedLanguages { get { return _SupportedLanguages; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<SourcePositionInfo, BreakpointVariantList> _GetPossibleBreakpointVariants;
    [NotNull] private readonly RdProperty<List<RdLanguage>> _SupportedLanguages;
    
    //primary constructor
    private BreakpointHelperHost(
      [NotNull] RdEndpoint<SourcePositionInfo, BreakpointVariantList> getPossibleBreakpointVariants,
      [NotNull] RdProperty<List<RdLanguage>> supportedLanguages
    )
    {
      if (getPossibleBreakpointVariants == null) throw new ArgumentNullException("getPossibleBreakpointVariants");
      if (supportedLanguages == null) throw new ArgumentNullException("supportedLanguages");
      
      _GetPossibleBreakpointVariants = getPossibleBreakpointVariants;
      _SupportedLanguages = supportedLanguages;
      _SupportedLanguages.OptimizeNested = true;
      _GetPossibleBreakpointVariants.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("getPossibleBreakpointVariants", _GetPossibleBreakpointVariants));
      BindableChildren.Add(new KeyValuePair<string, object>("supportedLanguages", _SupportedLanguages));
    }
    //secondary constructor
    internal BreakpointHelperHost (
    ) : this (
      new RdEndpoint<SourcePositionInfo, BreakpointVariantList>(SourcePositionInfo.Read, SourcePositionInfo.Write, BreakpointVariantList.Read, BreakpointVariantList.Write),
      new RdProperty<List<RdLanguage>>(ReadRdLanguageList, WriteRdLanguageList)
    ) {}
    //statics
    
    public static CtxReadDelegate<List<RdLanguage>> ReadRdLanguageList = RdLanguage.Read.List();
    
    public static CtxWriteDelegate<List<RdLanguage>> WriteRdLanguageList = RdLanguage.Write.List();
    
    protected override long SerializationHash => -3624441693831390706L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(BreakpointVariantModel.Read, BreakpointVariantModel.Write);
      serializers.Register(DummyBreakpointVariantModel.Read, DummyBreakpointVariantModel.Write);
      serializers.Register(BreakpointVariantList.Read, BreakpointVariantList.Write);
      serializers.Register(SourcePositionInfo.Read, SourcePositionInfo.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BreakpointHelperHost (");
      using (printer.IndentCookie()) {
        printer.Print("getPossibleBreakpointVariants = "); _GetPossibleBreakpointVariants.PrintEx(printer); printer.Println();
        printer.Print("supportedLanguages = "); _SupportedLanguages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionBreakpointHelperHostEx
   {
    public static BreakpointHelperHost GetBreakpointHelperHost(this Solution solution)
    {
      return solution.GetOrCreateExtension("breakpointHelperHost", () => new BreakpointHelperHost());
    }
  }
  
  
  public class BreakpointVariantList : IPrintable, IEquatable<BreakpointVariantList> {
    //fields
    //public fields
    [NotNull] public List<BreakpointVariantModelBase> Items {get; private set;}
    
    //private fields
    //primary constructor
    public BreakpointVariantList(
      [NotNull] List<BreakpointVariantModelBase> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BreakpointVariantList> Read = (ctx, reader) => 
    {
      var items = ReadBreakpointVariantModelBaseList(ctx, reader);
      return new BreakpointVariantList(items);
    };
    public static CtxReadDelegate<List<BreakpointVariantModelBase>> ReadBreakpointVariantModelBaseList = BreakpointVariantModelBase.Read.List();
    
    public static CtxWriteDelegate<BreakpointVariantList> Write = (ctx, writer, value) => 
    {
      WriteBreakpointVariantModelBaseList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<BreakpointVariantModelBase>> WriteBreakpointVariantModelBaseList = BreakpointVariantModelBase.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BreakpointVariantList) obj);
    }
    public bool Equals(BreakpointVariantList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Items);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BreakpointVariantList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BreakpointVariantModel : BreakpointVariantModelBase
   {
    //fields
    //public fields
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    [NotNull] public string Text {get; private set;}
    
    //private fields
    //primary constructor
    public BreakpointVariantModel(
      int startOffset,
      int endOffset,
      [NotNull] string text
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      StartOffset = startOffset;
      EndOffset = endOffset;
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BreakpointVariantModel> Read = (ctx, reader) => 
    {
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      var text = reader.ReadString();
      return new BreakpointVariantModel(startOffset, endOffset, text);
    };
    
    public static new CtxWriteDelegate<BreakpointVariantModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
      writer.Write(value.Text);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BreakpointVariantModel) obj);
    }
    public bool Equals(BreakpointVariantModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return StartOffset == other.StartOffset && EndOffset == other.EndOffset && Text == other.Text;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + StartOffset.GetHashCode();
        hash = hash * 31 + EndOffset.GetHashCode();
        hash = hash * 31 + Text.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BreakpointVariantModel (");
      using (printer.IndentCookie()) {
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class BreakpointVariantModelBase {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BreakpointVariantModelBase> Read = Polymorphic<BreakpointVariantModelBase>.ReadAbstract(BreakpointVariantModelBase_Unknown.Read);
    
    public static CtxWriteDelegate<BreakpointVariantModelBase> Write = Polymorphic<BreakpointVariantModelBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BreakpointVariantModelBase_Unknown : BreakpointVariantModelBase
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BreakpointVariantModelBase_Unknown> Read = (ctx, reader) => 
    {
      return new BreakpointVariantModelBase_Unknown();
    };
    
    public static new CtxWriteDelegate<BreakpointVariantModelBase_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BreakpointVariantModelBase_Unknown) obj);
    }
    public bool Equals(BreakpointVariantModelBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BreakpointVariantModelBase_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DummyBreakpointVariantModel : BreakpointVariantModelBase
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<DummyBreakpointVariantModel> Read = (ctx, reader) => 
    {
      return new DummyBreakpointVariantModel();
    };
    
    public static new CtxWriteDelegate<DummyBreakpointVariantModel> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DummyBreakpointVariantModel) obj);
    }
    public bool Equals(DummyBreakpointVariantModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DummyBreakpointVariantModel (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SourcePositionInfo : IPrintable, IEquatable<SourcePositionInfo> {
    //fields
    //public fields
    [NotNull] public string File {get; private set;}
    public int Line {get; private set;}
    
    //private fields
    //primary constructor
    public SourcePositionInfo(
      [NotNull] string file,
      int line
    )
    {
      if (file == null) throw new ArgumentNullException("file");
      
      File = file;
      Line = line;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SourcePositionInfo> Read = (ctx, reader) => 
    {
      var file = reader.ReadString();
      var line = reader.ReadInt();
      return new SourcePositionInfo(file, line);
    };
    
    public static CtxWriteDelegate<SourcePositionInfo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.File);
      writer.Write(value.Line);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SourcePositionInfo) obj);
    }
    public bool Equals(SourcePositionInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return File == other.File && Line == other.Line;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + File.GetHashCode();
        hash = hash * 31 + Line.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SourcePositionInfo (");
      using (printer.IndentCookie()) {
        printer.Print("file = "); File.PrintEx(printer); printer.Println();
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
