using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [JetBrains.Application.ShellComponent]
  public class CodeCleanupModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public RdEndpoint<CodeCleanupArgs, CodeCleanupResult> Run { get { return _Run; }}
    [NotNull] public RdEndpoint<RdVoid, ProfileDescriptor[]> GetProfileNames { get { return _GetProfileNames; }}
    [NotNull] public RdEndpoint<RdVoid, SilentProfileResult> GetSilentProfile { get { return _GetSilentProfile; }}
    [NotNull] public RdEndpoint<string, RdVoid> SetSilentProfile { get { return _SetSilentProfile; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<CodeCleanupArgs, CodeCleanupResult> _Run;
    [NotNull] private readonly RdEndpoint<RdVoid, ProfileDescriptor[]> _GetProfileNames;
    [NotNull] private readonly RdEndpoint<RdVoid, SilentProfileResult> _GetSilentProfile;
    [NotNull] private readonly RdEndpoint<string, RdVoid> _SetSilentProfile;
    
    //primary constructor
    private CodeCleanupModel(
      [NotNull] RdEndpoint<CodeCleanupArgs, CodeCleanupResult> run,
      [NotNull] RdEndpoint<RdVoid, ProfileDescriptor[]> getProfileNames,
      [NotNull] RdEndpoint<RdVoid, SilentProfileResult> getSilentProfile,
      [NotNull] RdEndpoint<string, RdVoid> setSilentProfile
    )
    {
      if (run == null) throw new ArgumentNullException("run");
      if (getProfileNames == null) throw new ArgumentNullException("getProfileNames");
      if (getSilentProfile == null) throw new ArgumentNullException("getSilentProfile");
      if (setSilentProfile == null) throw new ArgumentNullException("setSilentProfile");
      
      _Run = run;
      _GetProfileNames = getProfileNames;
      _GetSilentProfile = getSilentProfile;
      _SetSilentProfile = setSilentProfile;
      _GetSilentProfile.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("run", _Run));
      BindableChildren.Add(new KeyValuePair<string, object>("getProfileNames", _GetProfileNames));
      BindableChildren.Add(new KeyValuePair<string, object>("getSilentProfile", _GetSilentProfile));
      BindableChildren.Add(new KeyValuePair<string, object>("setSilentProfile", _SetSilentProfile));
    }
    //secondary constructor
    private CodeCleanupModel (
    ) : this (
      new RdEndpoint<CodeCleanupArgs, CodeCleanupResult>(CodeCleanupArgs.Read, CodeCleanupArgs.Write, CodeCleanupResult.Read, CodeCleanupResult.Write),
      new RdEndpoint<RdVoid, ProfileDescriptor[]>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadProfileDescriptorArray, WriteProfileDescriptorArray),
      new RdEndpoint<RdVoid, SilentProfileResult>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadSilentProfileResultNullable, WriteSilentProfileResultNullable),
      new RdEndpoint<string, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<ProfileDescriptor[]> ReadProfileDescriptorArray = ProfileDescriptor.Read.Array();
    public static CtxReadDelegate<SilentProfileResult> ReadSilentProfileResultNullable = SilentProfileResult.Read.NullableClass();
    
    public static CtxWriteDelegate<ProfileDescriptor[]> WriteProfileDescriptorArray = ProfileDescriptor.Write.Array();
    public static CtxWriteDelegate<SilentProfileResult> WriteSilentProfileResultNullable = SilentProfileResult.Write.NullableClass();
    
    protected override long SerializationHash => -4517908607827122152L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(CodeCleanupArgs.Read, CodeCleanupArgs.Write);
      serializers.Register(Success.Read, Success.Write);
      serializers.Register(Error.Read, Error.Write);
      serializers.Register(ProfileDescriptor.Read, ProfileDescriptor.Write);
      serializers.Register(SelectedSilentProfile.Read, SelectedSilentProfile.Write);
      serializers.Register(ShowDialogToChooseSilentProfile.Read, ShowDialogToChooseSilentProfile.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public CodeCleanupModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeCleanupModel (");
      using (printer.IndentCookie()) {
        printer.Print("run = "); _Run.PrintEx(printer); printer.Println();
        printer.Print("getProfileNames = "); _GetProfileNames.PrintEx(printer); printer.Println();
        printer.Print("getSilentProfile = "); _GetSilentProfile.PrintEx(printer); printer.Println();
        printer.Print("setSilentProfile = "); _SetSilentProfile.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeCleanupArgs : IPrintable, IEquatable<CodeCleanupArgs> {
    //fields
    //public fields
    [NotNull] public int[] ProjectModelNodeIds {get; private set;}
    [NotNull] public string ProfileName {get; private set;}
    
    //private fields
    //primary constructor
    public CodeCleanupArgs(
      [NotNull] int[] projectModelNodeIds,
      [NotNull] string profileName
    )
    {
      if (projectModelNodeIds == null) throw new ArgumentNullException("projectModelNodeIds");
      if (profileName == null) throw new ArgumentNullException("profileName");
      
      ProjectModelNodeIds = projectModelNodeIds;
      ProfileName = profileName;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CodeCleanupArgs> Read = (ctx, reader) => 
    {
      var projectModelNodeIds = JetBrains.Platform.RdFramework.Impl.Serializers.ReadIntArray(ctx, reader);
      var profileName = reader.ReadString();
      return new CodeCleanupArgs(projectModelNodeIds, profileName);
    };
    
    public static CtxWriteDelegate<CodeCleanupArgs> Write = (ctx, writer, value) => 
    {
      JetBrains.Platform.RdFramework.Impl.Serializers.WriteIntArray(ctx, writer, value.ProjectModelNodeIds);
      writer.Write(value.ProfileName);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CodeCleanupArgs) obj);
    }
    public bool Equals(CodeCleanupArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectModelNodeIds.SequenceEqual(other.ProjectModelNodeIds) && ProfileName == other.ProfileName;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(ProjectModelNodeIds);
        hash = hash * 31 + ProfileName.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CodeCleanupArgs (");
      using (printer.IndentCookie()) {
        printer.Print("projectModelNodeIds = "); ProjectModelNodeIds.PrintEx(printer); printer.Println();
        printer.Print("profileName = "); ProfileName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class CodeCleanupResult {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CodeCleanupResult> Read = Polymorphic<CodeCleanupResult>.ReadAbstract(CodeCleanupResult_Unknown.Read);
    
    public static CtxWriteDelegate<CodeCleanupResult> Write = Polymorphic<CodeCleanupResult>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class CodeCleanupResult_Unknown : CodeCleanupResult
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeCleanupResult_Unknown> Read = (ctx, reader) => 
    {
      return new CodeCleanupResult_Unknown();
    };
    
    public static new CtxWriteDelegate<CodeCleanupResult_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CodeCleanupResult_Unknown) obj);
    }
    public bool Equals(CodeCleanupResult_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CodeCleanupResult_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class Error : CodeCleanupResult
   {
    //fields
    //public fields
    [NotNull] public string ErrorMessage {get; private set;}
    
    //private fields
    //primary constructor
    public Error(
      [NotNull] string errorMessage
    )
    {
      if (errorMessage == null) throw new ArgumentNullException("errorMessage");
      
      ErrorMessage = errorMessage;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<Error> Read = (ctx, reader) => 
    {
      var errorMessage = reader.ReadString();
      return new Error(errorMessage);
    };
    
    public static new CtxWriteDelegate<Error> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ErrorMessage);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((Error) obj);
    }
    public bool Equals(Error other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ErrorMessage == other.ErrorMessage;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ErrorMessage.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("Error (");
      using (printer.IndentCookie()) {
        printer.Print("errorMessage = "); ErrorMessage.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ProfileDescriptor : IPrintable, IEquatable<ProfileDescriptor> {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string IdeaProfileContent {get; private set;}
    public bool IsRecentlyUsed {get; private set;}
    
    //private fields
    //primary constructor
    public ProfileDescriptor(
      [NotNull] string name,
      [NotNull] string ideaProfileContent,
      bool isRecentlyUsed
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (ideaProfileContent == null) throw new ArgumentNullException("ideaProfileContent");
      
      Name = name;
      IdeaProfileContent = ideaProfileContent;
      IsRecentlyUsed = isRecentlyUsed;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProfileDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var ideaProfileContent = reader.ReadString();
      var isRecentlyUsed = reader.ReadBool();
      return new ProfileDescriptor(name, ideaProfileContent, isRecentlyUsed);
    };
    
    public static CtxWriteDelegate<ProfileDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.IdeaProfileContent);
      writer.Write(value.IsRecentlyUsed);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ProfileDescriptor) obj);
    }
    public bool Equals(ProfileDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && IdeaProfileContent == other.IdeaProfileContent && IsRecentlyUsed == other.IsRecentlyUsed;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + IdeaProfileContent.GetHashCode();
        hash = hash * 31 + IsRecentlyUsed.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ProfileDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("ideaProfileContent = "); IdeaProfileContent.PrintEx(printer); printer.Println();
        printer.Print("isRecentlyUsed = "); IsRecentlyUsed.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SelectedSilentProfile : SilentProfileResult
   {
    //fields
    //public fields
    [NotNull] public ProfileDescriptor Profile {get; private set;}
    
    //private fields
    //primary constructor
    public SelectedSilentProfile(
      [NotNull] ProfileDescriptor profile
    )
    {
      if (profile == null) throw new ArgumentNullException("profile");
      
      Profile = profile;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<SelectedSilentProfile> Read = (ctx, reader) => 
    {
      var profile = ProfileDescriptor.Read(ctx, reader);
      return new SelectedSilentProfile(profile);
    };
    
    public static new CtxWriteDelegate<SelectedSilentProfile> Write = (ctx, writer, value) => 
    {
      ProfileDescriptor.Write(ctx, writer, value.Profile);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SelectedSilentProfile) obj);
    }
    public bool Equals(SelectedSilentProfile other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Profile, other.Profile);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Profile.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SelectedSilentProfile (");
      using (printer.IndentCookie()) {
        printer.Print("profile = "); Profile.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ShowDialogToChooseSilentProfile : SilentProfileResult
   {
    //fields
    //public fields
    [NotNull] public List<ProfileDescriptor> AllProfiles {get; private set;}
    
    //private fields
    //primary constructor
    public ShowDialogToChooseSilentProfile(
      [NotNull] List<ProfileDescriptor> allProfiles
    )
    {
      if (allProfiles == null) throw new ArgumentNullException("allProfiles");
      
      AllProfiles = allProfiles;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ShowDialogToChooseSilentProfile> Read = (ctx, reader) => 
    {
      var allProfiles = ReadProfileDescriptorList(ctx, reader);
      return new ShowDialogToChooseSilentProfile(allProfiles);
    };
    public static CtxReadDelegate<List<ProfileDescriptor>> ReadProfileDescriptorList = ProfileDescriptor.Read.List();
    
    public static new CtxWriteDelegate<ShowDialogToChooseSilentProfile> Write = (ctx, writer, value) => 
    {
      WriteProfileDescriptorList(ctx, writer, value.AllProfiles);
    };
    public static CtxWriteDelegate<List<ProfileDescriptor>> WriteProfileDescriptorList = ProfileDescriptor.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ShowDialogToChooseSilentProfile) obj);
    }
    public bool Equals(ShowDialogToChooseSilentProfile other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return AllProfiles.SequenceEqual(other.AllProfiles);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(AllProfiles);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ShowDialogToChooseSilentProfile (");
      using (printer.IndentCookie()) {
        printer.Print("allProfiles = "); AllProfiles.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class SilentProfileResult {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SilentProfileResult> Read = Polymorphic<SilentProfileResult>.ReadAbstract(SilentProfileResult_Unknown.Read);
    
    public static CtxWriteDelegate<SilentProfileResult> Write = Polymorphic<SilentProfileResult>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class SilentProfileResult_Unknown : SilentProfileResult
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<SilentProfileResult_Unknown> Read = (ctx, reader) => 
    {
      return new SilentProfileResult_Unknown();
    };
    
    public static new CtxWriteDelegate<SilentProfileResult_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SilentProfileResult_Unknown) obj);
    }
    public bool Equals(SilentProfileResult_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SilentProfileResult_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class Success : CodeCleanupResult
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<Success> Read = (ctx, reader) => 
    {
      return new Success();
    };
    
    public static new CtxWriteDelegate<Success> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((Success) obj);
    }
    public bool Equals(Success other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("Success (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
