using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class CodeStructureTree : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> ToolWindowVisible { get { return _ToolWindowVisible; }}
    [NotNull] public IRdProperty<CodeStructureTreeNodesList> TreeNodes { get { return _TreeNodes; }}
    [NotNull] public ISink<int> NavigateTo { get { return _NavigateTo; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _ToolWindowVisible;
    [NotNull] private readonly RdProperty<CodeStructureTreeNodesList> _TreeNodes;
    [NotNull] private readonly RdSignal<int> _NavigateTo;
    
    //primary constructor
    private CodeStructureTree(
      [NotNull] RdProperty<bool> toolWindowVisible,
      [NotNull] RdProperty<CodeStructureTreeNodesList> treeNodes,
      [NotNull] RdSignal<int> navigateTo
    )
    {
      if (toolWindowVisible == null) throw new ArgumentNullException("toolWindowVisible");
      if (treeNodes == null) throw new ArgumentNullException("treeNodes");
      if (navigateTo == null) throw new ArgumentNullException("navigateTo");
      
      _ToolWindowVisible = toolWindowVisible;
      _TreeNodes = treeNodes;
      _NavigateTo = navigateTo;
      _ToolWindowVisible.OptimizeNested = true;
      _TreeNodes.OptimizeNested = true;
      _TreeNodes.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("toolWindowVisible", _ToolWindowVisible));
      BindableChildren.Add(new KeyValuePair<string, object>("treeNodes", _TreeNodes));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateTo", _NavigateTo));
    }
    //secondary constructor
    internal CodeStructureTree (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<CodeStructureTreeNodesList>(CodeStructureTreeNodesList.Read, CodeStructureTreeNodesList.Write),
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -3450040034028762944L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(CodeStructureTreeNodesList.Read, CodeStructureTreeNodesList.Write);
      serializers.Register(CodeStructureTreeNode.Read, CodeStructureTreeNode.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStructureTree (");
      using (printer.IndentCookie()) {
        printer.Print("toolWindowVisible = "); _ToolWindowVisible.PrintEx(printer); printer.Println();
        printer.Print("treeNodes = "); _TreeNodes.PrintEx(printer); printer.Println();
        printer.Print("navigateTo = "); _NavigateTo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionCodeStructureTreeEx
   {
    public static CodeStructureTree GetCodeStructureTree(this Solution solution)
    {
      return solution.GetOrCreateExtension("codeStructureTree", () => new CodeStructureTree());
    }
  }
  
  
  public class CodeStructureTreeNode : IPrintable, IEquatable<CodeStructureTreeNode> {
    //fields
    //public fields
    public int Id {get; private set;}
    [NotNull] public List<int> Children {get; private set;}
    public bool Navigable {get; private set;}
    public int Offset {get; private set;}
    [NotNull] public string Name {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    public CodeStructureTreeNode(
      int id,
      [NotNull] List<int> children,
      bool navigable,
      int offset,
      [NotNull] string name,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (children == null) throw new ArgumentNullException("children");
      if (name == null) throw new ArgumentNullException("name");
      
      Id = id;
      Children = children;
      Navigable = navigable;
      Offset = offset;
      Name = name;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CodeStructureTreeNode> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var children = ReadIntList(ctx, reader);
      var navigable = reader.ReadBool();
      var offset = reader.ReadInt();
      var name = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      return new CodeStructureTreeNode(id, children, navigable, offset, name, icon);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<CodeStructureTreeNode> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      WriteIntList(ctx, writer, value.Children);
      writer.Write(value.Navigable);
      writer.Write(value.Offset);
      writer.Write(value.Name);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CodeStructureTreeNode) obj);
    }
    public bool Equals(CodeStructureTreeNode other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Children.SequenceEqual(other.Children) && Navigable == other.Navigable && Offset == other.Offset && Name == other.Name && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Children);
        hash = hash * 31 + Navigable.GetHashCode();
        hash = hash * 31 + Offset.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStructureTreeNode (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
        printer.Print("navigable = "); Navigable.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStructureTreeNodesList : IPrintable, IEquatable<CodeStructureTreeNodesList> {
    //fields
    //public fields
    public int ForFile {get; private set;}
    [NotNull] public List<CodeStructureTreeNode> TreeNodes {get; private set;}
    
    //private fields
    //primary constructor
    public CodeStructureTreeNodesList(
      int forFile,
      [NotNull] List<CodeStructureTreeNode> treeNodes
    )
    {
      if (treeNodes == null) throw new ArgumentNullException("treeNodes");
      
      ForFile = forFile;
      TreeNodes = treeNodes;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CodeStructureTreeNodesList> Read = (ctx, reader) => 
    {
      var forFile = reader.ReadInt();
      var treeNodes = ReadCodeStructureTreeNodeList(ctx, reader);
      return new CodeStructureTreeNodesList(forFile, treeNodes);
    };
    public static CtxReadDelegate<List<CodeStructureTreeNode>> ReadCodeStructureTreeNodeList = CodeStructureTreeNode.Read.List();
    
    public static CtxWriteDelegate<CodeStructureTreeNodesList> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ForFile);
      WriteCodeStructureTreeNodeList(ctx, writer, value.TreeNodes);
    };
    public static CtxWriteDelegate<List<CodeStructureTreeNode>> WriteCodeStructureTreeNodeList = CodeStructureTreeNode.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CodeStructureTreeNodesList) obj);
    }
    public bool Equals(CodeStructureTreeNodesList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ForFile == other.ForFile && TreeNodes.SequenceEqual(other.TreeNodes);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ForFile.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(TreeNodes);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStructureTreeNodesList (");
      using (printer.IndentCookie()) {
        printer.Print("forFile = "); ForFile.PrintEx(printer); printer.Println();
        printer.Print("treeNodes = "); TreeNodes.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
