using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [JetBrains.Application.ShellComponent]
  public class Colors : RdExtBase {
    //fields
    //public fields
    //private fields
    //primary constructor
    private Colors(
    )
    {
    }
    //secondary constructor
    //statics
    
    
    
    protected override long SerializationHash => 3482087214675934788L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RgbColor.Read, RgbColor.Write);
      serializers.Register(RgbaColor.Read, RgbaColor.Write);
      serializers.Register(ThemeColorId.Read, ThemeColorId.Write);
      serializers.Register(DualColor.Read, DualColor.Write);
      serializers.RegisterEnum<ColorId>();
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public Colors(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("Colors (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class AbstractColor {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AbstractColor> Read = Polymorphic<AbstractColor>.ReadAbstract(AbstractColor_Unknown.Read);
    
    public static CtxWriteDelegate<AbstractColor> Write = Polymorphic<AbstractColor>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class AbstractColor_Unknown : AbstractColor
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<AbstractColor_Unknown> Read = (ctx, reader) => 
    {
      return new AbstractColor_Unknown();
    };
    
    public static new CtxWriteDelegate<AbstractColor_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AbstractColor_Unknown) obj);
    }
    public bool Equals(AbstractColor_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AbstractColor_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ColorId {
    DefaultForeground
  }
  
  
  public class DualColor : AbstractColor
   {
    //fields
    //public fields
    [NotNull] public RgbaColor LightColor {get; private set;}
    [NotNull] public RgbaColor DarkColor {get; private set;}
    
    //private fields
    //primary constructor
    public DualColor(
      [NotNull] RgbaColor lightColor,
      [NotNull] RgbaColor darkColor
    )
    {
      if (lightColor == null) throw new ArgumentNullException("lightColor");
      if (darkColor == null) throw new ArgumentNullException("darkColor");
      
      LightColor = lightColor;
      DarkColor = darkColor;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<DualColor> Read = (ctx, reader) => 
    {
      var lightColor = RgbaColor.Read(ctx, reader);
      var darkColor = RgbaColor.Read(ctx, reader);
      return new DualColor(lightColor, darkColor);
    };
    
    public static new CtxWriteDelegate<DualColor> Write = (ctx, writer, value) => 
    {
      RgbaColor.Write(ctx, writer, value.LightColor);
      RgbaColor.Write(ctx, writer, value.DarkColor);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DualColor) obj);
    }
    public bool Equals(DualColor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(LightColor, other.LightColor) && Equals(DarkColor, other.DarkColor);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + LightColor.GetHashCode();
        hash = hash * 31 + DarkColor.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DualColor (");
      using (printer.IndentCookie()) {
        printer.Print("lightColor = "); LightColor.PrintEx(printer); printer.Println();
        printer.Print("darkColor = "); DarkColor.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RgbColor : AbstractColor
   {
    //fields
    //public fields
    public int Red {get; private set;}
    public int Green {get; private set;}
    public int Blue {get; private set;}
    
    //private fields
    //primary constructor
    public RgbColor(
      int red,
      int green,
      int blue
    )
    {
      Red = red;
      Green = green;
      Blue = blue;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RgbColor> Read = (ctx, reader) => 
    {
      var red = reader.ReadInt();
      var green = reader.ReadInt();
      var blue = reader.ReadInt();
      return new RgbColor(red, green, blue);
    };
    
    public static new CtxWriteDelegate<RgbColor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Red);
      writer.Write(value.Green);
      writer.Write(value.Blue);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RgbColor) obj);
    }
    public bool Equals(RgbColor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Red == other.Red && Green == other.Green && Blue == other.Blue;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Red.GetHashCode();
        hash = hash * 31 + Green.GetHashCode();
        hash = hash * 31 + Blue.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RgbColor (");
      using (printer.IndentCookie()) {
        printer.Print("red = "); Red.PrintEx(printer); printer.Println();
        printer.Print("green = "); Green.PrintEx(printer); printer.Println();
        printer.Print("blue = "); Blue.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RgbaColor : AbstractColor
   {
    //fields
    //public fields
    public int Red {get; private set;}
    public int Green {get; private set;}
    public int Blue {get; private set;}
    public int Alpha {get; private set;}
    
    //private fields
    //primary constructor
    public RgbaColor(
      int red,
      int green,
      int blue,
      int alpha
    )
    {
      Red = red;
      Green = green;
      Blue = blue;
      Alpha = alpha;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RgbaColor> Read = (ctx, reader) => 
    {
      var red = reader.ReadInt();
      var green = reader.ReadInt();
      var blue = reader.ReadInt();
      var alpha = reader.ReadInt();
      return new RgbaColor(red, green, blue, alpha);
    };
    
    public static new CtxWriteDelegate<RgbaColor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Red);
      writer.Write(value.Green);
      writer.Write(value.Blue);
      writer.Write(value.Alpha);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RgbaColor) obj);
    }
    public bool Equals(RgbaColor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Red == other.Red && Green == other.Green && Blue == other.Blue && Alpha == other.Alpha;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Red.GetHashCode();
        hash = hash * 31 + Green.GetHashCode();
        hash = hash * 31 + Blue.GetHashCode();
        hash = hash * 31 + Alpha.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RgbaColor (");
      using (printer.IndentCookie()) {
        printer.Print("red = "); Red.PrintEx(printer); printer.Println();
        printer.Print("green = "); Green.PrintEx(printer); printer.Println();
        printer.Print("blue = "); Blue.PrintEx(printer); printer.Println();
        printer.Print("alpha = "); Alpha.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ThemeColorId : AbstractColor
   {
    //fields
    //public fields
    public ColorId Id {get; private set;}
    
    //private fields
    //primary constructor
    public ThemeColorId(
      ColorId id
    )
    {
      Id = id;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ThemeColorId> Read = (ctx, reader) => 
    {
      var id = (ColorId)reader.ReadInt();
      return new ThemeColorId(id);
    };
    
    public static new CtxWriteDelegate<ThemeColorId> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Id);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ThemeColorId) obj);
    }
    public bool Equals(ThemeColorId other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Id;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ThemeColorId (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
