using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class DebugCompletionProvider : RdExtBase {
    //fields
    //public fields
    [NotNull] public RdEndpoint<DebugCompletionParameters, CompletionList> GetCompletions { get { return _GetCompletions; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<DebugCompletionParameters, CompletionList> _GetCompletions;
    
    //primary constructor
    private DebugCompletionProvider(
      [NotNull] RdEndpoint<DebugCompletionParameters, CompletionList> getCompletions
    )
    {
      if (getCompletions == null) throw new ArgumentNullException("getCompletions");
      
      _GetCompletions = getCompletions;
      _GetCompletions.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("getCompletions", _GetCompletions));
    }
    //secondary constructor
    internal DebugCompletionProvider (
    ) : this (
      new RdEndpoint<DebugCompletionParameters, CompletionList>(DebugCompletionParameters.Read, DebugCompletionParameters.Write, CompletionList.Read, CompletionList.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 5390767143325118442L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(DebugCompletionParameters.Read, DebugCompletionParameters.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DebugCompletionProvider (");
      using (printer.IndentCookie()) {
        printer.Print("getCompletions = "); _GetCompletions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionDebugCompletionProviderEx
   {
    public static DebugCompletionProvider GetDebugCompletionProvider(this Solution solution)
    {
      return solution.GetOrCreateExtension("debugCompletionProvider", () => new DebugCompletionProvider());
    }
  }
  
  
  public class DebugCompletionParameters : IPrintable, IEquatable<DebugCompletionParameters> {
    //fields
    //public fields
    [NotNull] public string Prefix {get; private set;}
    [NotNull] public string ProjectFile {get; private set;}
    public int ProjectFileOffset {get; private set;}
    
    //private fields
    //primary constructor
    public DebugCompletionParameters(
      [NotNull] string prefix,
      [NotNull] string projectFile,
      int projectFileOffset
    )
    {
      if (prefix == null) throw new ArgumentNullException("prefix");
      if (projectFile == null) throw new ArgumentNullException("projectFile");
      
      Prefix = prefix;
      ProjectFile = projectFile;
      ProjectFileOffset = projectFileOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DebugCompletionParameters> Read = (ctx, reader) => 
    {
      var prefix = reader.ReadString();
      var projectFile = reader.ReadString();
      var projectFileOffset = reader.ReadInt();
      return new DebugCompletionParameters(prefix, projectFile, projectFileOffset);
    };
    
    public static CtxWriteDelegate<DebugCompletionParameters> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Prefix);
      writer.Write(value.ProjectFile);
      writer.Write(value.ProjectFileOffset);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DebugCompletionParameters) obj);
    }
    public bool Equals(DebugCompletionParameters other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Prefix == other.Prefix && ProjectFile == other.ProjectFile && ProjectFileOffset == other.ProjectFileOffset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Prefix.GetHashCode();
        hash = hash * 31 + ProjectFile.GetHashCode();
        hash = hash * 31 + ProjectFileOffset.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DebugCompletionParameters (");
      using (printer.IndentCookie()) {
        printer.Print("prefix = "); Prefix.PrintEx(printer); printer.Println();
        printer.Print("projectFile = "); ProjectFile.PrintEx(printer); printer.Println();
        printer.Print("projectFileOffset = "); ProjectFileOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
