using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.debuggerHelper
{
  
  
  [JetBrains.Application.ShellComponent]
  public class DebuggerHelperHostModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public RdEndpoint<int, bool> IsProcess64Bit { get { return _IsProcess64Bit; }}
    [NotNull] public RdEndpoint<string, bool> IsExeWillRunAs64Bit { get { return _IsExeWillRunAs64Bit; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<int, bool> _IsProcess64Bit;
    [NotNull] private readonly RdEndpoint<string, bool> _IsExeWillRunAs64Bit;
    
    //primary constructor
    private DebuggerHelperHostModel(
      [NotNull] RdEndpoint<int, bool> isProcess64Bit,
      [NotNull] RdEndpoint<string, bool> isExeWillRunAs64Bit
    )
    {
      if (isProcess64Bit == null) throw new ArgumentNullException("isProcess64Bit");
      if (isExeWillRunAs64Bit == null) throw new ArgumentNullException("isExeWillRunAs64Bit");
      
      _IsProcess64Bit = isProcess64Bit;
      _IsExeWillRunAs64Bit = isExeWillRunAs64Bit;
      BindableChildren.Add(new KeyValuePair<string, object>("isProcess64Bit", _IsProcess64Bit));
      BindableChildren.Add(new KeyValuePair<string, object>("isExeWillRunAs64Bit", _IsExeWillRunAs64Bit));
    }
    //secondary constructor
    private DebuggerHelperHostModel (
    ) : this (
      new RdEndpoint<int, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdEndpoint<string, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -5896925660699636680L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.IdeRoot), JetBrains.Rider.Model.IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public DebuggerHelperHostModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DebuggerHelperHostModel (");
      using (printer.IndentCookie()) {
        printer.Print("isProcess64Bit = "); _IsProcess64Bit.PrintEx(printer); printer.Println();
        printer.Print("isExeWillRunAs64Bit = "); _IsExeWillRunAs64Bit.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
