using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class DebuggerWorkerConnectionHelperModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IViewableMap<long, int> Ports { get { return _Ports; }}
    [NotNull] public RdEndpoint<string, string> GetDbgShimPath { get { return _GetDbgShimPath; }}
    
    //private fields
    [NotNull] private readonly RdMap<long, int> _Ports;
    [NotNull] private readonly RdEndpoint<string, string> _GetDbgShimPath;
    
    //primary constructor
    private DebuggerWorkerConnectionHelperModel(
      [NotNull] RdMap<long, int> ports,
      [NotNull] RdEndpoint<string, string> getDbgShimPath
    )
    {
      if (ports == null) throw new ArgumentNullException("ports");
      if (getDbgShimPath == null) throw new ArgumentNullException("getDbgShimPath");
      
      _Ports = ports;
      _GetDbgShimPath = getDbgShimPath;
      _Ports.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("ports", _Ports));
      BindableChildren.Add(new KeyValuePair<string, object>("getDbgShimPath", _GetDbgShimPath));
    }
    //secondary constructor
    internal DebuggerWorkerConnectionHelperModel (
    ) : this (
      new RdMap<long, int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadLong, JetBrains.Platform.RdFramework.Impl.Serializers.WriteLong, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdEndpoint<string, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 5366630517483330004L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DebuggerWorkerConnectionHelperModel (");
      using (printer.IndentCookie()) {
        printer.Print("ports = "); _Ports.PrintEx(printer); printer.Println();
        printer.Print("getDbgShimPath = "); _GetDbgShimPath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionDebuggerWorkerConnectionHelperModelEx
   {
    public static DebuggerWorkerConnectionHelperModel GetDebuggerWorkerConnectionHelperModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("debuggerWorkerConnectionHelperModel", () => new DebuggerWorkerConnectionHelperModel());
    }
  }
}
