using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class DeploymentHost : RdExtBase {
    //fields
    //public fields
    [NotNull] public RdEndpoint<DeploymentArgsBase, DeploymentResultBase> Deploy { get { return _Deploy; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<DeploymentArgsBase, DeploymentResultBase> _Deploy;
    
    //primary constructor
    private DeploymentHost(
      [NotNull] RdEndpoint<DeploymentArgsBase, DeploymentResultBase> deploy
    )
    {
      if (deploy == null) throw new ArgumentNullException("deploy");
      
      _Deploy = deploy;
      _Deploy.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("deploy", _Deploy));
    }
    //secondary constructor
    internal DeploymentHost (
    ) : this (
      new RdEndpoint<DeploymentArgsBase, DeploymentResultBase>(DeploymentArgsBase.Read, DeploymentArgsBase.Write, DeploymentResultBase.Read, DeploymentResultBase.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -5921041173231277660L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(XamarinAndroidDeploymentArgs.Read, XamarinAndroidDeploymentArgs.Write);
      serializers.Register(XamarinIOSDeploymentArgs.Read, XamarinIOSDeploymentArgs.Write);
      serializers.RegisterEnum<DeploymentResultStatus>();
      serializers.Register(XamarinAndroidDeploymentResult.Read, XamarinAndroidDeploymentResult.Write);
      serializers.Register(XamarinIOSDeploymentResult.Read, XamarinIOSDeploymentResult.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DeploymentHost (");
      using (printer.IndentCookie()) {
        printer.Print("deploy = "); _Deploy.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionDeploymentHostEx
   {
    public static DeploymentHost GetDeploymentHost(this Solution solution)
    {
      return solution.GetOrCreateExtension("deploymentHost", () => new DeploymentHost());
    }
  }
  
  
  public abstract class DeploymentArgsBase {
    //fields
    //public fields
    public RunnableProjectKind ProjectKind {get; private set;}
    [NotNull] public string ProjectFilePath {get; private set;}
    
    //private fields
    //primary constructor
    protected DeploymentArgsBase(
      RunnableProjectKind projectKind,
      [NotNull] string projectFilePath
    )
    {
      if (projectFilePath == null) throw new ArgumentNullException("projectFilePath");
      
      ProjectKind = projectKind;
      ProjectFilePath = projectFilePath;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DeploymentArgsBase> Read = Polymorphic<DeploymentArgsBase>.ReadAbstract(DeploymentArgsBase_Unknown.Read);
    
    public static CtxWriteDelegate<DeploymentArgsBase> Write = Polymorphic<DeploymentArgsBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class DeploymentArgsBase_Unknown : DeploymentArgsBase
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public DeploymentArgsBase_Unknown(
      RunnableProjectKind projectKind,
      [NotNull] string projectFilePath
    ) : base (
      projectKind,
      projectFilePath
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<DeploymentArgsBase_Unknown> Read = (ctx, reader) => 
    {
      var projectKind = (RunnableProjectKind)reader.ReadInt();
      var projectFilePath = reader.ReadString();
      return new DeploymentArgsBase_Unknown(projectKind, projectFilePath);
    };
    
    public static new CtxWriteDelegate<DeploymentArgsBase_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.ProjectKind);
      writer.Write(value.ProjectFilePath);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DeploymentArgsBase_Unknown) obj);
    }
    public bool Equals(DeploymentArgsBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectKind == other.ProjectKind && ProjectFilePath == other.ProjectFilePath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) ProjectKind;
        hash = hash * 31 + ProjectFilePath.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DeploymentArgsBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("projectKind = "); ProjectKind.PrintEx(printer); printer.Println();
        printer.Print("projectFilePath = "); ProjectFilePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class DeploymentResultBase {
    //fields
    //public fields
    public DeploymentResultStatus Status {get; private set;}
    
    //private fields
    //primary constructor
    protected DeploymentResultBase(
      DeploymentResultStatus status
    )
    {
      Status = status;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DeploymentResultBase> Read = Polymorphic<DeploymentResultBase>.ReadAbstract(DeploymentResultBase_Unknown.Read);
    
    public static CtxWriteDelegate<DeploymentResultBase> Write = Polymorphic<DeploymentResultBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class DeploymentResultBase_Unknown : DeploymentResultBase
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public DeploymentResultBase_Unknown(
      DeploymentResultStatus status
    ) : base (
      status
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<DeploymentResultBase_Unknown> Read = (ctx, reader) => 
    {
      var status = (DeploymentResultStatus)reader.ReadInt();
      return new DeploymentResultBase_Unknown(status);
    };
    
    public static new CtxWriteDelegate<DeploymentResultBase_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Status);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DeploymentResultBase_Unknown) obj);
    }
    public bool Equals(DeploymentResultBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Status == other.Status;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Status;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DeploymentResultBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum DeploymentResultStatus {
    Successed,
    Failed
  }
  
  
  public class XamarinAndroidDeploymentArgs : DeploymentArgsBase
   {
    //fields
    //public fields
    public bool Debug {get; private set;}
    [NotNull] public string DeviceName {get; private set;}
    
    //private fields
    //primary constructor
    public XamarinAndroidDeploymentArgs(
      bool debug,
      [NotNull] string deviceName,
      RunnableProjectKind projectKind,
      [NotNull] string projectFilePath
    ) : base (
      projectKind,
      projectFilePath
     ) 
    {
      if (deviceName == null) throw new ArgumentNullException("deviceName");
      
      Debug = debug;
      DeviceName = deviceName;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<XamarinAndroidDeploymentArgs> Read = (ctx, reader) => 
    {
      var projectKind = (RunnableProjectKind)reader.ReadInt();
      var projectFilePath = reader.ReadString();
      var debug = reader.ReadBool();
      var deviceName = reader.ReadString();
      return new XamarinAndroidDeploymentArgs(debug, deviceName, projectKind, projectFilePath);
    };
    
    public static new CtxWriteDelegate<XamarinAndroidDeploymentArgs> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.ProjectKind);
      writer.Write(value.ProjectFilePath);
      writer.Write(value.Debug);
      writer.Write(value.DeviceName);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((XamarinAndroidDeploymentArgs) obj);
    }
    public bool Equals(XamarinAndroidDeploymentArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Debug == other.Debug && DeviceName == other.DeviceName && ProjectKind == other.ProjectKind && ProjectFilePath == other.ProjectFilePath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Debug.GetHashCode();
        hash = hash * 31 + DeviceName.GetHashCode();
        hash = hash * 31 + (int) ProjectKind;
        hash = hash * 31 + ProjectFilePath.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("XamarinAndroidDeploymentArgs (");
      using (printer.IndentCookie()) {
        printer.Print("debug = "); Debug.PrintEx(printer); printer.Println();
        printer.Print("deviceName = "); DeviceName.PrintEx(printer); printer.Println();
        printer.Print("projectKind = "); ProjectKind.PrintEx(printer); printer.Println();
        printer.Print("projectFilePath = "); ProjectFilePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class XamarinAndroidDeploymentResult : DeploymentResultBase
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public XamarinAndroidDeploymentResult(
      DeploymentResultStatus status
    ) : base (
      status
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<XamarinAndroidDeploymentResult> Read = (ctx, reader) => 
    {
      var status = (DeploymentResultStatus)reader.ReadInt();
      return new XamarinAndroidDeploymentResult(status);
    };
    
    public static new CtxWriteDelegate<XamarinAndroidDeploymentResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Status);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((XamarinAndroidDeploymentResult) obj);
    }
    public bool Equals(XamarinAndroidDeploymentResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Status == other.Status;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Status;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("XamarinAndroidDeploymentResult (");
      using (printer.IndentCookie()) {
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class XamarinIOSDeploymentArgs : DeploymentArgsBase
   {
    //fields
    //public fields
    [NotNull] public string Address {get; private set;}
    [NotNull] public string User {get; private set;}
    
    //private fields
    //primary constructor
    public XamarinIOSDeploymentArgs(
      [NotNull] string address,
      [NotNull] string user,
      RunnableProjectKind projectKind,
      [NotNull] string projectFilePath
    ) : base (
      projectKind,
      projectFilePath
     ) 
    {
      if (address == null) throw new ArgumentNullException("address");
      if (user == null) throw new ArgumentNullException("user");
      
      Address = address;
      User = user;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<XamarinIOSDeploymentArgs> Read = (ctx, reader) => 
    {
      var projectKind = (RunnableProjectKind)reader.ReadInt();
      var projectFilePath = reader.ReadString();
      var address = reader.ReadString();
      var user = reader.ReadString();
      return new XamarinIOSDeploymentArgs(address, user, projectKind, projectFilePath);
    };
    
    public static new CtxWriteDelegate<XamarinIOSDeploymentArgs> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.ProjectKind);
      writer.Write(value.ProjectFilePath);
      writer.Write(value.Address);
      writer.Write(value.User);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((XamarinIOSDeploymentArgs) obj);
    }
    public bool Equals(XamarinIOSDeploymentArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Address == other.Address && User == other.User && ProjectKind == other.ProjectKind && ProjectFilePath == other.ProjectFilePath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Address.GetHashCode();
        hash = hash * 31 + User.GetHashCode();
        hash = hash * 31 + (int) ProjectKind;
        hash = hash * 31 + ProjectFilePath.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("XamarinIOSDeploymentArgs (");
      using (printer.IndentCookie()) {
        printer.Print("address = "); Address.PrintEx(printer); printer.Println();
        printer.Print("user = "); User.PrintEx(printer); printer.Println();
        printer.Print("projectKind = "); ProjectKind.PrintEx(printer); printer.Println();
        printer.Print("projectFilePath = "); ProjectFilePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class XamarinIOSDeploymentResult : DeploymentResultBase
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public XamarinIOSDeploymentResult(
      DeploymentResultStatus status
    ) : base (
      status
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<XamarinIOSDeploymentResult> Read = (ctx, reader) => 
    {
      var status = (DeploymentResultStatus)reader.ReadInt();
      return new XamarinIOSDeploymentResult(status);
    };
    
    public static new CtxWriteDelegate<XamarinIOSDeploymentResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Status);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((XamarinIOSDeploymentResult) obj);
    }
    public bool Equals(XamarinIOSDeploymentResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Status == other.Status;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Status;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("XamarinIOSDeploymentResult (");
      using (printer.IndentCookie()) {
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
