using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.Dialog
{
  
  
  [JetBrains.Application.ShellComponent]
  public class DialogModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdCall<JetBrains.Rider.Model.RgbaColor, JetBrains.Rider.Model.RgbaColor> ShowColorPickerDialog { get { return _ShowColorPickerDialog; }}
    [NotNull] public IRdCall<FileDialogParams, RdFileSystemPath> BrowseForOpenFile { get { return _BrowseForOpenFile; }}
    [NotNull] public IRdCall<FileDialogParams, List<RdFileSystemPath>> BrowseForOpenMultipleFiles { get { return _BrowseForOpenMultipleFiles; }}
    [NotNull] public IRdCall<FileDialogParams, RdFileSystemPath> BrowseForSaveFile { get { return _BrowseForSaveFile; }}
    [NotNull] public IRdCall<EditTextRequest, string> EditText { get { return _EditText; }}
    [NotNull] public RdEndpoint<EditTextRequestValidationRequest, EditTextRequestValidationResponse> ValidateCurrentText { get { return _ValidateCurrentText; }}
    
    //private fields
    [NotNull] private readonly RdCall<JetBrains.Rider.Model.RgbaColor, JetBrains.Rider.Model.RgbaColor> _ShowColorPickerDialog;
    [NotNull] private readonly RdCall<FileDialogParams, RdFileSystemPath> _BrowseForOpenFile;
    [NotNull] private readonly RdCall<FileDialogParams, List<RdFileSystemPath>> _BrowseForOpenMultipleFiles;
    [NotNull] private readonly RdCall<FileDialogParams, RdFileSystemPath> _BrowseForSaveFile;
    [NotNull] private readonly RdCall<EditTextRequest, string> _EditText;
    [NotNull] private readonly RdEndpoint<EditTextRequestValidationRequest, EditTextRequestValidationResponse> _ValidateCurrentText;
    
    //primary constructor
    private DialogModel(
      [NotNull] RdCall<JetBrains.Rider.Model.RgbaColor, JetBrains.Rider.Model.RgbaColor> showColorPickerDialog,
      [NotNull] RdCall<FileDialogParams, RdFileSystemPath> browseForOpenFile,
      [NotNull] RdCall<FileDialogParams, List<RdFileSystemPath>> browseForOpenMultipleFiles,
      [NotNull] RdCall<FileDialogParams, RdFileSystemPath> browseForSaveFile,
      [NotNull] RdCall<EditTextRequest, string> editText,
      [NotNull] RdEndpoint<EditTextRequestValidationRequest, EditTextRequestValidationResponse> validateCurrentText
    )
    {
      if (showColorPickerDialog == null) throw new ArgumentNullException("showColorPickerDialog");
      if (browseForOpenFile == null) throw new ArgumentNullException("browseForOpenFile");
      if (browseForOpenMultipleFiles == null) throw new ArgumentNullException("browseForOpenMultipleFiles");
      if (browseForSaveFile == null) throw new ArgumentNullException("browseForSaveFile");
      if (editText == null) throw new ArgumentNullException("editText");
      if (validateCurrentText == null) throw new ArgumentNullException("validateCurrentText");
      
      _ShowColorPickerDialog = showColorPickerDialog;
      _BrowseForOpenFile = browseForOpenFile;
      _BrowseForOpenMultipleFiles = browseForOpenMultipleFiles;
      _BrowseForSaveFile = browseForSaveFile;
      _EditText = editText;
      _ValidateCurrentText = validateCurrentText;
      _ShowColorPickerDialog.ValueCanBeNull = true;
      _BrowseForOpenFile.ValueCanBeNull = true;
      _BrowseForSaveFile.ValueCanBeNull = true;
      _EditText.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("showColorPickerDialog", _ShowColorPickerDialog));
      BindableChildren.Add(new KeyValuePair<string, object>("browseForOpenFile", _BrowseForOpenFile));
      BindableChildren.Add(new KeyValuePair<string, object>("browseForOpenMultipleFiles", _BrowseForOpenMultipleFiles));
      BindableChildren.Add(new KeyValuePair<string, object>("browseForSaveFile", _BrowseForSaveFile));
      BindableChildren.Add(new KeyValuePair<string, object>("editText", _EditText));
      BindableChildren.Add(new KeyValuePair<string, object>("validateCurrentText", _ValidateCurrentText));
    }
    //secondary constructor
    private DialogModel (
    ) : this (
      new RdCall<JetBrains.Rider.Model.RgbaColor, JetBrains.Rider.Model.RgbaColor>(ReadRgbaColorNullable, WriteRgbaColorNullable, ReadRgbaColorNullable, WriteRgbaColorNullable),
      new RdCall<FileDialogParams, RdFileSystemPath>(FileDialogParams.Read, FileDialogParams.Write, ReadRdFileSystemPathNullable, WriteRdFileSystemPathNullable),
      new RdCall<FileDialogParams, List<RdFileSystemPath>>(FileDialogParams.Read, FileDialogParams.Write, ReadRdFileSystemPathList, WriteRdFileSystemPathList),
      new RdCall<FileDialogParams, RdFileSystemPath>(FileDialogParams.Read, FileDialogParams.Write, ReadRdFileSystemPathNullable, WriteRdFileSystemPathNullable),
      new RdCall<EditTextRequest, string>(EditTextRequest.Read, EditTextRequest.Write, ReadStringNullable, WriteStringNullable),
      new RdEndpoint<EditTextRequestValidationRequest, EditTextRequestValidationResponse>(EditTextRequestValidationRequest.Read, EditTextRequestValidationRequest.Write, EditTextRequestValidationResponse.Read, EditTextRequestValidationResponse.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.RgbaColor> ReadRgbaColorNullable = JetBrains.Rider.Model.RgbaColor.Read.NullableClass();
    public static CtxReadDelegate<RdFileSystemPath> ReadRdFileSystemPathNullable = RdFileSystemPath.Read.NullableClass();
    public static CtxReadDelegate<List<RdFileSystemPath>> ReadRdFileSystemPathList = RdFileSystemPath.Read.List();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.RgbaColor> WriteRgbaColorNullable = JetBrains.Rider.Model.RgbaColor.Write.NullableClass();
    public static CtxWriteDelegate<RdFileSystemPath> WriteRdFileSystemPathNullable = RdFileSystemPath.Write.NullableClass();
    public static CtxWriteDelegate<List<RdFileSystemPath>> WriteRdFileSystemPathList = RdFileSystemPath.Write.List();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    
    protected override long SerializationHash => 2927803212298703546L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(ChooseFileType.Read, ChooseFileType.Write);
      serializers.Register(FileDialogParams.Read, FileDialogParams.Write);
      serializers.Register(RdFileSystemPath.Read, RdFileSystemPath.Write);
      serializers.Register(EditTextRequest.Read, EditTextRequest.Write);
      serializers.Register(EditTextRequestValidationRequest.Read, EditTextRequestValidationRequest.Write);
      serializers.Register(EditTextRequestValidationResponse.Read, EditTextRequestValidationResponse.Write);
      
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.IdeRoot), JetBrains.Rider.Model.IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public DialogModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DialogModel (");
      using (printer.IndentCookie()) {
        printer.Print("showColorPickerDialog = "); _ShowColorPickerDialog.PrintEx(printer); printer.Println();
        printer.Print("browseForOpenFile = "); _BrowseForOpenFile.PrintEx(printer); printer.Println();
        printer.Print("browseForOpenMultipleFiles = "); _BrowseForOpenMultipleFiles.PrintEx(printer); printer.Println();
        printer.Print("browseForSaveFile = "); _BrowseForSaveFile.PrintEx(printer); printer.Println();
        printer.Print("editText = "); _EditText.PrintEx(printer); printer.Println();
        printer.Print("validateCurrentText = "); _ValidateCurrentText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ChooseFileType : IPrintable, IEquatable<ChooseFileType> {
    //fields
    //public fields
    [CanBeNull] public string DisplayName {get; private set;}
    [NotNull] public string Extension {get; private set;}
    
    //private fields
    //primary constructor
    public ChooseFileType(
      [CanBeNull] string displayName,
      [NotNull] string extension
    )
    {
      if (extension == null) throw new ArgumentNullException("extension");
      
      DisplayName = displayName;
      Extension = extension;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ChooseFileType> Read = (ctx, reader) => 
    {
      var displayName = ReadStringNullable(ctx, reader);
      var extension = reader.ReadString();
      return new ChooseFileType(displayName, extension);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<ChooseFileType> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.DisplayName);
      writer.Write(value.Extension);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ChooseFileType) obj);
    }
    public bool Equals(ChooseFileType other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(DisplayName, other.DisplayName) && Extension == other.Extension;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (DisplayName != null ?DisplayName.GetHashCode() : 0);
        hash = hash * 31 + Extension.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ChooseFileType (");
      using (printer.IndentCookie()) {
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("extension = "); Extension.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditTextRequest : IPrintable, IEquatable<EditTextRequest> {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Label {get; private set;}
    [NotNull] public string InitialValue {get; private set;}
    
    //private fields
    //primary constructor
    public EditTextRequest(
      [NotNull] string id,
      [NotNull] string title,
      [NotNull] string label,
      [NotNull] string initialValue
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (title == null) throw new ArgumentNullException("title");
      if (label == null) throw new ArgumentNullException("label");
      if (initialValue == null) throw new ArgumentNullException("initialValue");
      
      Id = id;
      Title = title;
      Label = label;
      InitialValue = initialValue;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<EditTextRequest> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var title = reader.ReadString();
      var label = reader.ReadString();
      var initialValue = reader.ReadString();
      return new EditTextRequest(id, title, label, initialValue);
    };
    
    public static CtxWriteDelegate<EditTextRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Title);
      writer.Write(value.Label);
      writer.Write(value.InitialValue);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((EditTextRequest) obj);
    }
    public bool Equals(EditTextRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Title == other.Title && Label == other.Label && InitialValue == other.InitialValue;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + Title.GetHashCode();
        hash = hash * 31 + Label.GetHashCode();
        hash = hash * 31 + InitialValue.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("EditTextRequest (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("label = "); Label.PrintEx(printer); printer.Println();
        printer.Print("initialValue = "); InitialValue.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditTextRequestValidationRequest : IPrintable, IEquatable<EditTextRequestValidationRequest> {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string Value {get; private set;}
    
    //private fields
    //primary constructor
    public EditTextRequestValidationRequest(
      [NotNull] string id,
      [NotNull] string value
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (value == null) throw new ArgumentNullException("value");
      
      Id = id;
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<EditTextRequestValidationRequest> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var value = reader.ReadString();
      return new EditTextRequestValidationRequest(id, value);
    };
    
    public static CtxWriteDelegate<EditTextRequestValidationRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Value);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((EditTextRequestValidationRequest) obj);
    }
    public bool Equals(EditTextRequestValidationRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + Value.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("EditTextRequestValidationRequest (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditTextRequestValidationResponse : IPrintable, IEquatable<EditTextRequestValidationResponse> {
    //fields
    //public fields
    [CanBeNull] public string Error {get; private set;}
    
    //private fields
    //primary constructor
    public EditTextRequestValidationResponse(
      [CanBeNull] string error
    )
    {
      Error = error;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<EditTextRequestValidationResponse> Read = (ctx, reader) => 
    {
      var error = ReadStringNullable(ctx, reader);
      return new EditTextRequestValidationResponse(error);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<EditTextRequestValidationResponse> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.Error);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((EditTextRequestValidationResponse) obj);
    }
    public bool Equals(EditTextRequestValidationResponse other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Error, other.Error);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (Error != null ?Error.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("EditTextRequestValidationResponse (");
      using (printer.IndentCookie()) {
        printer.Print("error = "); Error.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FileDialogParams : IPrintable, IEquatable<FileDialogParams> {
    //fields
    //public fields
    [NotNull] public string WindowTitle {get; private set;}
    [NotNull] public List<ChooseFileType> FileTypes {get; private set;}
    
    //private fields
    //primary constructor
    public FileDialogParams(
      [NotNull] string windowTitle,
      [NotNull] List<ChooseFileType> fileTypes
    )
    {
      if (windowTitle == null) throw new ArgumentNullException("windowTitle");
      if (fileTypes == null) throw new ArgumentNullException("fileTypes");
      
      WindowTitle = windowTitle;
      FileTypes = fileTypes;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<FileDialogParams> Read = (ctx, reader) => 
    {
      var windowTitle = reader.ReadString();
      var fileTypes = ReadChooseFileTypeList(ctx, reader);
      return new FileDialogParams(windowTitle, fileTypes);
    };
    public static CtxReadDelegate<List<ChooseFileType>> ReadChooseFileTypeList = ChooseFileType.Read.List();
    
    public static CtxWriteDelegate<FileDialogParams> Write = (ctx, writer, value) => 
    {
      writer.Write(value.WindowTitle);
      WriteChooseFileTypeList(ctx, writer, value.FileTypes);
    };
    public static CtxWriteDelegate<List<ChooseFileType>> WriteChooseFileTypeList = ChooseFileType.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((FileDialogParams) obj);
    }
    public bool Equals(FileDialogParams other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return WindowTitle == other.WindowTitle && FileTypes.SequenceEqual(other.FileTypes);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + WindowTitle.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(FileTypes);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("FileDialogParams (");
      using (printer.IndentCookie()) {
        printer.Print("windowTitle = "); WindowTitle.PrintEx(printer); printer.Println();
        printer.Print("fileTypes = "); FileTypes.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFileSystemPath : IPrintable, IEquatable<RdFileSystemPath> {
    //fields
    //public fields
    [NotNull] public string Path {get; private set;}
    
    //private fields
    //primary constructor
    public RdFileSystemPath(
      [NotNull] string path
    )
    {
      if (path == null) throw new ArgumentNullException("path");
      
      Path = path;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdFileSystemPath> Read = (ctx, reader) => 
    {
      var path = reader.ReadString();
      return new RdFileSystemPath(path);
    };
    
    public static CtxWriteDelegate<RdFileSystemPath> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Path);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdFileSystemPath) obj);
    }
    public bool Equals(RdFileSystemPath other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Path == other.Path;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Path.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdFileSystemPath (");
      using (printer.IndentCookie()) {
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
