using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Platform.DebuggerAgent.Model.Direct
{
  
  
  public class DebuggerProcessAgentSlaveModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdCall<int, RuntimeInfo> CalculateRuntimes { get { return _CalculateRuntimes; }}
    
    //private fields
    [NotNull] private readonly RdCall<int, RuntimeInfo> _CalculateRuntimes;
    
    //primary constructor
    private DebuggerProcessAgentSlaveModel(
      [NotNull] RdCall<int, RuntimeInfo> calculateRuntimes
    )
    {
      if (calculateRuntimes == null) throw new ArgumentNullException("calculateRuntimes");
      
      _CalculateRuntimes = calculateRuntimes;
      _CalculateRuntimes.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("calculateRuntimes", _CalculateRuntimes));
    }
    //secondary constructor
    private DebuggerProcessAgentSlaveModel (
    ) : this (
      new RdCall<int, RuntimeInfo>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RuntimeInfo.Read, RuntimeInfo.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -7297714663111627985L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RuntimeInfo.Read, RuntimeInfo.Write);
      
      serializers.RegisterToplevelOnce(typeof(DebuggerProcessAgentSlaveModel), DebuggerProcessAgentSlaveModel.RegisterDeclaredTypesSerializers);
    }
    
    public DebuggerProcessAgentSlaveModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DebuggerProcessAgentSlaveModel (");
      using (printer.IndentCookie()) {
        printer.Print("calculateRuntimes = "); _CalculateRuntimes.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RuntimeInfo : IPrintable, IEquatable<RuntimeInfo> {
    //fields
    //public fields
    [NotNull] public List<string> LoadedRuntimes {get; private set;}
    
    //private fields
    //primary constructor
    public RuntimeInfo(
      [NotNull] List<string> loadedRuntimes
    )
    {
      if (loadedRuntimes == null) throw new ArgumentNullException("loadedRuntimes");
      
      LoadedRuntimes = loadedRuntimes;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RuntimeInfo> Read = (ctx, reader) => 
    {
      var loadedRuntimes = ReadStringList(ctx, reader);
      return new RuntimeInfo(loadedRuntimes);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RuntimeInfo> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.LoadedRuntimes);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RuntimeInfo) obj);
    }
    public bool Equals(RuntimeInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return LoadedRuntimes.SequenceEqual(other.LoadedRuntimes);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(LoadedRuntimes);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RuntimeInfo (");
      using (printer.IndentCookie()) {
        printer.Print("loadedRuntimes = "); LoadedRuntimes.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
