using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class DotCoverModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IViewableMap<string, RdDotCoverWorkspace> Workspaces { get { return _Workspaces; }}
    [NotNull] public RdDotCoverSolutionCoverageBrowserViewModel SolutionCoverageBrowser {get; private set;}
    [NotNull] public RdDotCoverIdeActionsNotifier IdeActionsNotifier {get; private set;}
    
    //private fields
    [NotNull] private readonly RdMap<string, RdDotCoverWorkspace> _Workspaces;
    
    //primary constructor
    private DotCoverModel(
      [NotNull] RdMap<string, RdDotCoverWorkspace> workspaces,
      [NotNull] RdDotCoverSolutionCoverageBrowserViewModel solutionCoverageBrowser,
      [NotNull] RdDotCoverIdeActionsNotifier ideActionsNotifier
    )
    {
      if (workspaces == null) throw new ArgumentNullException("workspaces");
      if (solutionCoverageBrowser == null) throw new ArgumentNullException("solutionCoverageBrowser");
      if (ideActionsNotifier == null) throw new ArgumentNullException("ideActionsNotifier");
      
      _Workspaces = workspaces;
      SolutionCoverageBrowser = solutionCoverageBrowser;
      IdeActionsNotifier = ideActionsNotifier;
      BindableChildren.Add(new KeyValuePair<string, object>("workspaces", _Workspaces));
      BindableChildren.Add(new KeyValuePair<string, object>("solutionCoverageBrowser", SolutionCoverageBrowser));
      BindableChildren.Add(new KeyValuePair<string, object>("ideActionsNotifier", IdeActionsNotifier));
    }
    //secondary constructor
    internal DotCoverModel (
    ) : this (
      new RdMap<string, RdDotCoverWorkspace>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, RdDotCoverWorkspace.Read, RdDotCoverWorkspace.Write),
      new RdDotCoverSolutionCoverageBrowserViewModel(),
      new RdDotCoverIdeActionsNotifier()
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 1336787377937360945L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdDotCoverCoverageNode.Read, RdDotCoverCoverageNode.Write);
      serializers.Register(RdDotCoverCoverageTreeViewModel.Read, RdDotCoverCoverageTreeViewModel.Write);
      serializers.Register(RdDotCoverSnapshotConfigurationViewModel.Read, RdDotCoverSnapshotConfigurationViewModel.Write);
      serializers.Register(RdDotCoverSnapshot.Read, RdDotCoverSnapshot.Write);
      serializers.Register(RdDotCoverWorkspace.Read, RdDotCoverWorkspace.Write);
      serializers.RegisterEnum<RdDotCoverCoverageTreeStatisticsType>();
      serializers.Register(RdDotCoverSolutionCoverageBrowserViewModel.Read, RdDotCoverSolutionCoverageBrowserViewModel.Write);
      serializers.Register(RdDotCoverIdeActionsNotifier.Read, RdDotCoverIdeActionsNotifier.Write);
      serializers.Register(RdDotCoverCoveringTest.Read, RdDotCoverCoveringTest.Write);
      serializers.Register(RdDotCoverCoveringTestsRequestResult.Read, RdDotCoverCoveringTestsRequestResult.Write);
      serializers.RegisterEnum<RdDotCoverLineMarkerShape>();
      serializers.Register(RdDotCoverLineMarkerModel.Read, RdDotCoverLineMarkerModel.Write);
      serializers.Register(RdDotCoverLineMarkerCoveringTestsRequest.Read, RdDotCoverLineMarkerCoveringTestsRequest.Write);
      serializers.Register(RdDotCoverLineMarkerCoveringTestsProviderModel.Read, RdDotCoverLineMarkerCoveringTestsProviderModel.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DotCoverModel (");
      using (printer.IndentCookie()) {
        printer.Print("workspaces = "); _Workspaces.PrintEx(printer); printer.Println();
        printer.Print("solutionCoverageBrowser = "); SolutionCoverageBrowser.PrintEx(printer); printer.Println();
        printer.Print("ideActionsNotifier = "); IdeActionsNotifier.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionDotCoverModelEx
   {
    public static DotCoverModel GetDotCoverModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("dotCoverModel", () => new DotCoverModel());
    }
  }
  
  
  public class RdDotCoverCoverageNode : IPrintable, IEquatable<RdDotCoverCoverageNode> {
    //fields
    //public fields
    public int Id {get; private set;}
    [NotNull] public string PresentableName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public int CoveragePercent {get; private set;}
    public long TotalStatements {get; private set;}
    public long UncoveredStatements {get; private set;}
    
    //private fields
    //primary constructor
    public RdDotCoverCoverageNode(
      int id,
      [NotNull] string presentableName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      int coveragePercent,
      long totalStatements,
      long uncoveredStatements
    )
    {
      if (presentableName == null) throw new ArgumentNullException("presentableName");
      
      Id = id;
      PresentableName = presentableName;
      Icon = icon;
      CoveragePercent = coveragePercent;
      TotalStatements = totalStatements;
      UncoveredStatements = uncoveredStatements;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdDotCoverCoverageNode> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var presentableName = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var coveragePercent = reader.ReadInt();
      var totalStatements = reader.ReadLong();
      var uncoveredStatements = reader.ReadLong();
      return new RdDotCoverCoverageNode(id, presentableName, icon, coveragePercent, totalStatements, uncoveredStatements);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<RdDotCoverCoverageNode> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.PresentableName);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.CoveragePercent);
      writer.Write(value.TotalStatements);
      writer.Write(value.UncoveredStatements);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDotCoverCoverageNode) obj);
    }
    public bool Equals(RdDotCoverCoverageNode other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && PresentableName == other.PresentableName && Equals(Icon, other.Icon) && CoveragePercent == other.CoveragePercent && TotalStatements == other.TotalStatements && UncoveredStatements == other.UncoveredStatements;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + PresentableName.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + CoveragePercent.GetHashCode();
        hash = hash * 31 + TotalStatements.GetHashCode();
        hash = hash * 31 + UncoveredStatements.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotCoverCoverageNode (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("presentableName = "); PresentableName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("coveragePercent = "); CoveragePercent.PrintEx(printer); printer.Println();
        printer.Print("totalStatements = "); TotalStatements.PrintEx(printer); printer.Println();
        printer.Print("uncoveredStatements = "); UncoveredStatements.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdDotCoverCoverageTreeStatisticsType {
    AllTests,
    SelectedSession,
    SelectedTests
  }
  
  
  public class RdDotCoverCoverageTreeViewModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public RdEndpoint<RdVoid, RdDotCoverCoverageNode> GetRoot { get { return _GetRoot; }}
    [NotNull] public RdEndpoint<int, bool> HasChildren { get { return _HasChildren; }}
    [NotNull] public RdEndpoint<int, List<RdDotCoverCoverageNode>> GetChildren { get { return _GetChildren; }}
    [NotNull] public ISource<RdVoid> TreeStructureChanged { get { return _TreeStructureChanged; }}
    [NotNull] public ISource<RdVoid> TreeDataChanged { get { return _TreeDataChanged; }}
    [NotNull] public ISink<int> Navigate { get { return _Navigate; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<RdVoid, RdDotCoverCoverageNode> _GetRoot;
    [NotNull] private readonly RdEndpoint<int, bool> _HasChildren;
    [NotNull] private readonly RdEndpoint<int, List<RdDotCoverCoverageNode>> _GetChildren;
    [NotNull] private readonly RdSignal<RdVoid> _TreeStructureChanged;
    [NotNull] private readonly RdSignal<RdVoid> _TreeDataChanged;
    [NotNull] private readonly RdSignal<int> _Navigate;
    
    //primary constructor
    private RdDotCoverCoverageTreeViewModel(
      [NotNull] RdEndpoint<RdVoid, RdDotCoverCoverageNode> getRoot,
      [NotNull] RdEndpoint<int, bool> hasChildren,
      [NotNull] RdEndpoint<int, List<RdDotCoverCoverageNode>> getChildren,
      [NotNull] RdSignal<RdVoid> treeStructureChanged,
      [NotNull] RdSignal<RdVoid> treeDataChanged,
      [NotNull] RdSignal<int> navigate
    )
    {
      if (getRoot == null) throw new ArgumentNullException("getRoot");
      if (hasChildren == null) throw new ArgumentNullException("hasChildren");
      if (getChildren == null) throw new ArgumentNullException("getChildren");
      if (treeStructureChanged == null) throw new ArgumentNullException("treeStructureChanged");
      if (treeDataChanged == null) throw new ArgumentNullException("treeDataChanged");
      if (navigate == null) throw new ArgumentNullException("navigate");
      
      _GetRoot = getRoot;
      _HasChildren = hasChildren;
      _GetChildren = getChildren;
      _TreeStructureChanged = treeStructureChanged;
      _TreeDataChanged = treeDataChanged;
      _Navigate = navigate;
      _GetRoot.Async = true;
      _HasChildren.Async = true;
      _GetChildren.Async = true;
      _GetChildren.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("getRoot", _GetRoot));
      BindableChildren.Add(new KeyValuePair<string, object>("hasChildren", _HasChildren));
      BindableChildren.Add(new KeyValuePair<string, object>("getChildren", _GetChildren));
      BindableChildren.Add(new KeyValuePair<string, object>("treeStructureChanged", _TreeStructureChanged));
      BindableChildren.Add(new KeyValuePair<string, object>("treeDataChanged", _TreeDataChanged));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
    }
    //secondary constructor
    public RdDotCoverCoverageTreeViewModel (
    ) : this (
      new RdEndpoint<RdVoid, RdDotCoverCoverageNode>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, RdDotCoverCoverageNode.Read, RdDotCoverCoverageNode.Write),
      new RdEndpoint<int, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdEndpoint<int, List<RdDotCoverCoverageNode>>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, ReadRdDotCoverCoverageNodeListNullable, WriteRdDotCoverCoverageNodeListNullable),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdDotCoverCoverageTreeViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var getRoot = RdEndpoint<RdVoid, RdDotCoverCoverageNode>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, RdDotCoverCoverageNode.Read, RdDotCoverCoverageNode.Write);
      var hasChildren = RdEndpoint<int, bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var getChildren = RdEndpoint<int, List<RdDotCoverCoverageNode>>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, ReadRdDotCoverCoverageNodeListNullable, WriteRdDotCoverCoverageNodeListNullable);
      var treeStructureChanged = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var treeDataChanged = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var navigate = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new RdDotCoverCoverageTreeViewModel(getRoot, hasChildren, getChildren, treeStructureChanged, treeDataChanged, navigate).WithId(_id);
    };
    public static CtxReadDelegate<List<RdDotCoverCoverageNode>> ReadRdDotCoverCoverageNodeListNullable = RdDotCoverCoverageNode.Read.List().NullableClass();
    
    public static CtxWriteDelegate<RdDotCoverCoverageTreeViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdEndpoint<RdVoid, RdDotCoverCoverageNode>.Write(ctx, writer, value._GetRoot);
      RdEndpoint<int, bool>.Write(ctx, writer, value._HasChildren);
      RdEndpoint<int, List<RdDotCoverCoverageNode>>.Write(ctx, writer, value._GetChildren);
      RdSignal<RdVoid>.Write(ctx, writer, value._TreeStructureChanged);
      RdSignal<RdVoid>.Write(ctx, writer, value._TreeDataChanged);
      RdSignal<int>.Write(ctx, writer, value._Navigate);
    };
    public static CtxWriteDelegate<List<RdDotCoverCoverageNode>> WriteRdDotCoverCoverageNodeListNullable = RdDotCoverCoverageNode.Write.List().NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotCoverCoverageTreeViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("getRoot = "); _GetRoot.PrintEx(printer); printer.Println();
        printer.Print("hasChildren = "); _HasChildren.PrintEx(printer); printer.Println();
        printer.Print("getChildren = "); _GetChildren.PrintEx(printer); printer.Println();
        printer.Print("treeStructureChanged = "); _TreeStructureChanged.PrintEx(printer); printer.Println();
        printer.Print("treeDataChanged = "); _TreeDataChanged.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotCoverCoveringTest : IPrintable, IEquatable<RdDotCoverCoveringTest> {
    //fields
    //public fields
    public int ElementIndex {get; private set;}
    [NotNull] public string Namespace {get; private set;}
    [NotNull] public string ShortPresentation {get; private set;}
    [NotNull] public string SessionName {get; private set;}
    public RdUnitTestStatus Status {get; private set;}
    public bool Outdated {get; private set;}
    [CanBeNull] public string ShortMessage {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    public RdDotCoverCoveringTest(
      int elementIndex,
      [NotNull] string @namespace,
      [NotNull] string shortPresentation,
      [NotNull] string sessionName,
      RdUnitTestStatus status,
      bool outdated,
      [CanBeNull] string shortMessage,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (@namespace == null) throw new ArgumentNullException("namespace");
      if (shortPresentation == null) throw new ArgumentNullException("shortPresentation");
      if (sessionName == null) throw new ArgumentNullException("sessionName");
      
      ElementIndex = elementIndex;
      Namespace = @namespace;
      ShortPresentation = shortPresentation;
      SessionName = sessionName;
      Status = status;
      Outdated = outdated;
      ShortMessage = shortMessage;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdDotCoverCoveringTest> Read = (ctx, reader) => 
    {
      var elementIndex = reader.ReadInt();
      var @namespace = reader.ReadString();
      var shortPresentation = reader.ReadString();
      var sessionName = reader.ReadString();
      var status = (RdUnitTestStatus)reader.ReadInt();
      var outdated = reader.ReadBool();
      var shortMessage = ReadStringNullable(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      return new RdDotCoverCoveringTest(elementIndex, @namespace, shortPresentation, sessionName, status, outdated, shortMessage, icon);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<RdDotCoverCoveringTest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ElementIndex);
      writer.Write(value.Namespace);
      writer.Write(value.ShortPresentation);
      writer.Write(value.SessionName);
      writer.Write((int)value.Status);
      writer.Write(value.Outdated);
      WriteStringNullable(ctx, writer, value.ShortMessage);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDotCoverCoveringTest) obj);
    }
    public bool Equals(RdDotCoverCoveringTest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ElementIndex == other.ElementIndex && Namespace == other.Namespace && ShortPresentation == other.ShortPresentation && SessionName == other.SessionName && Status == other.Status && Outdated == other.Outdated && Equals(ShortMessage, other.ShortMessage) && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ElementIndex.GetHashCode();
        hash = hash * 31 + Namespace.GetHashCode();
        hash = hash * 31 + ShortPresentation.GetHashCode();
        hash = hash * 31 + SessionName.GetHashCode();
        hash = hash * 31 + (int) Status;
        hash = hash * 31 + Outdated.GetHashCode();
        hash = hash * 31 + (ShortMessage != null ?ShortMessage.GetHashCode() : 0);
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotCoverCoveringTest (");
      using (printer.IndentCookie()) {
        printer.Print("elementIndex = "); ElementIndex.PrintEx(printer); printer.Println();
        printer.Print("namespace = "); Namespace.PrintEx(printer); printer.Println();
        printer.Print("shortPresentation = "); ShortPresentation.PrintEx(printer); printer.Println();
        printer.Print("sessionName = "); SessionName.PrintEx(printer); printer.Println();
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
        printer.Print("outdated = "); Outdated.PrintEx(printer); printer.Println();
        printer.Print("shortMessage = "); ShortMessage.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotCoverCoveringTestsRequestResult : IPrintable, IEquatable<RdDotCoverCoveringTestsRequestResult> {
    //fields
    //public fields
    public int FailedTestCount {get; private set;}
    public int OutdatedTestCount {get; private set;}
    [NotNull] public List<RdDotCoverCoveringTest> Tests {get; private set;}
    public bool HaveMoreTests {get; private set;}
    
    //private fields
    //primary constructor
    public RdDotCoverCoveringTestsRequestResult(
      int failedTestCount,
      int outdatedTestCount,
      [NotNull] List<RdDotCoverCoveringTest> tests,
      bool haveMoreTests
    )
    {
      if (tests == null) throw new ArgumentNullException("tests");
      
      FailedTestCount = failedTestCount;
      OutdatedTestCount = outdatedTestCount;
      Tests = tests;
      HaveMoreTests = haveMoreTests;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdDotCoverCoveringTestsRequestResult> Read = (ctx, reader) => 
    {
      var failedTestCount = reader.ReadInt();
      var outdatedTestCount = reader.ReadInt();
      var tests = ReadRdDotCoverCoveringTestList(ctx, reader);
      var haveMoreTests = reader.ReadBool();
      return new RdDotCoverCoveringTestsRequestResult(failedTestCount, outdatedTestCount, tests, haveMoreTests);
    };
    public static CtxReadDelegate<List<RdDotCoverCoveringTest>> ReadRdDotCoverCoveringTestList = RdDotCoverCoveringTest.Read.List();
    
    public static CtxWriteDelegate<RdDotCoverCoveringTestsRequestResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FailedTestCount);
      writer.Write(value.OutdatedTestCount);
      WriteRdDotCoverCoveringTestList(ctx, writer, value.Tests);
      writer.Write(value.HaveMoreTests);
    };
    public static CtxWriteDelegate<List<RdDotCoverCoveringTest>> WriteRdDotCoverCoveringTestList = RdDotCoverCoveringTest.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDotCoverCoveringTestsRequestResult) obj);
    }
    public bool Equals(RdDotCoverCoveringTestsRequestResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FailedTestCount == other.FailedTestCount && OutdatedTestCount == other.OutdatedTestCount && Tests.SequenceEqual(other.Tests) && HaveMoreTests == other.HaveMoreTests;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + FailedTestCount.GetHashCode();
        hash = hash * 31 + OutdatedTestCount.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Tests);
        hash = hash * 31 + HaveMoreTests.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotCoverCoveringTestsRequestResult (");
      using (printer.IndentCookie()) {
        printer.Print("failedTestCount = "); FailedTestCount.PrintEx(printer); printer.Println();
        printer.Print("outdatedTestCount = "); OutdatedTestCount.PrintEx(printer); printer.Println();
        printer.Print("tests = "); Tests.PrintEx(printer); printer.Println();
        printer.Print("haveMoreTests = "); HaveMoreTests.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotCoverIdeActionsNotifier : RdBindableBase {
    //fields
    //public fields
    [NotNull] public ISink<RdVoid> SaveActionPerformed { get { return _SaveActionPerformed; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _SaveActionPerformed;
    
    //primary constructor
    private RdDotCoverIdeActionsNotifier(
      [NotNull] RdSignal<RdVoid> saveActionPerformed
    )
    {
      if (saveActionPerformed == null) throw new ArgumentNullException("saveActionPerformed");
      
      _SaveActionPerformed = saveActionPerformed;
      BindableChildren.Add(new KeyValuePair<string, object>("saveActionPerformed", _SaveActionPerformed));
    }
    //secondary constructor
    public RdDotCoverIdeActionsNotifier (
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdDotCoverIdeActionsNotifier> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var saveActionPerformed = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdDotCoverIdeActionsNotifier(saveActionPerformed).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdDotCoverIdeActionsNotifier> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdVoid>.Write(ctx, writer, value._SaveActionPerformed);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotCoverIdeActionsNotifier (");
      using (printer.IndentCookie()) {
        printer.Print("saveActionPerformed = "); _SaveActionPerformed.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotCoverLineMarkerCoveringTestsProviderModel : MarkupModelExtension
   {
    //fields
    //public fields
    [NotNull] public RdEndpoint<RdDotCoverLineMarkerCoveringTestsRequest, RdDotCoverCoveringTestsRequestResult> GetCoveringTests { get { return _GetCoveringTests; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<RdDotCoverLineMarkerCoveringTestsRequest, RdDotCoverCoveringTestsRequestResult> _GetCoveringTests;
    
    //primary constructor
    private RdDotCoverLineMarkerCoveringTestsProviderModel(
      [NotNull] RdEndpoint<RdDotCoverLineMarkerCoveringTestsRequest, RdDotCoverCoveringTestsRequestResult> getCoveringTests,
      [NotNull] string key
    ) : base (
      key
     ) 
    {
      if (getCoveringTests == null) throw new ArgumentNullException("getCoveringTests");
      
      _GetCoveringTests = getCoveringTests;
      BindableChildren.Add(new KeyValuePair<string, object>("getCoveringTests", _GetCoveringTests));
    }
    //secondary constructor
    public RdDotCoverLineMarkerCoveringTestsProviderModel (
      [NotNull] string key
    ) : this (
      new RdEndpoint<RdDotCoverLineMarkerCoveringTestsRequest, RdDotCoverCoveringTestsRequestResult>(RdDotCoverLineMarkerCoveringTestsRequest.Read, RdDotCoverLineMarkerCoveringTestsRequest.Write, RdDotCoverCoveringTestsRequestResult.Read, RdDotCoverCoveringTestsRequestResult.Write),
      key
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdDotCoverLineMarkerCoveringTestsProviderModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var key = reader.ReadString();
      var getCoveringTests = RdEndpoint<RdDotCoverLineMarkerCoveringTestsRequest, RdDotCoverCoveringTestsRequestResult>.Read(ctx, reader, RdDotCoverLineMarkerCoveringTestsRequest.Read, RdDotCoverLineMarkerCoveringTestsRequest.Write, RdDotCoverCoveringTestsRequestResult.Read, RdDotCoverCoveringTestsRequestResult.Write);
      return new RdDotCoverLineMarkerCoveringTestsProviderModel(getCoveringTests, key).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdDotCoverLineMarkerCoveringTestsProviderModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Key);
      RdEndpoint<RdDotCoverLineMarkerCoveringTestsRequest, RdDotCoverCoveringTestsRequestResult>.Write(ctx, writer, value._GetCoveringTests);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotCoverLineMarkerCoveringTestsProviderModel (");
      using (printer.IndentCookie()) {
        printer.Print("getCoveringTests = "); _GetCoveringTests.PrintEx(printer); printer.Println();
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotCoverLineMarkerCoveringTestsRequest : IPrintable, IEquatable<RdDotCoverLineMarkerCoveringTestsRequest> {
    //fields
    //public fields
    public long HighlighterId {get; private set;}
    public int ReceivedTestsCount {get; private set;}
    
    //private fields
    //primary constructor
    public RdDotCoverLineMarkerCoveringTestsRequest(
      long highlighterId,
      int receivedTestsCount
    )
    {
      HighlighterId = highlighterId;
      ReceivedTestsCount = receivedTestsCount;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdDotCoverLineMarkerCoveringTestsRequest> Read = (ctx, reader) => 
    {
      var highlighterId = reader.ReadLong();
      var receivedTestsCount = reader.ReadInt();
      return new RdDotCoverLineMarkerCoveringTestsRequest(highlighterId, receivedTestsCount);
    };
    
    public static CtxWriteDelegate<RdDotCoverLineMarkerCoveringTestsRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.HighlighterId);
      writer.Write(value.ReceivedTestsCount);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDotCoverLineMarkerCoveringTestsRequest) obj);
    }
    public bool Equals(RdDotCoverLineMarkerCoveringTestsRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return HighlighterId == other.HighlighterId && ReceivedTestsCount == other.ReceivedTestsCount;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + HighlighterId.GetHashCode();
        hash = hash * 31 + ReceivedTestsCount.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotCoverLineMarkerCoveringTestsRequest (");
      using (printer.IndentCookie()) {
        printer.Print("highlighterId = "); HighlighterId.PrintEx(printer); printer.Println();
        printer.Print("receivedTestsCount = "); ReceivedTestsCount.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotCoverLineMarkerModel : HighlighterModel
   {
    //fields
    //public fields
    public RdDotCoverLineMarkerShape Shape {get; private set;}
    public bool Faded {get; private set;}
    
    //private fields
    //primary constructor
    public RdDotCoverLineMarkerModel(
      RdDotCoverLineMarkerShape shape,
      bool faded,
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      attributeId,
      start,
      end
     ) 
    {
      Shape = shape;
      Faded = faded;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdDotCoverLineMarkerModel> Read = (ctx, reader) => 
    {
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var shape = (RdDotCoverLineMarkerShape)reader.ReadInt();
      var faded = reader.ReadBool();
      return new RdDotCoverLineMarkerModel(shape, faded, layer, isExactRange, documentVersion, textToHighlight, id, attributeId, start, end);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<RdDotCoverLineMarkerModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
      writer.Write((int)value.Shape);
      writer.Write(value.Faded);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDotCoverLineMarkerModel) obj);
    }
    public bool Equals(RdDotCoverLineMarkerModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Shape == other.Shape && Faded == other.Faded && Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Shape;
        hash = hash * 31 + Faded.GetHashCode();
        hash = hash * 31 + Layer.GetHashCode();
        hash = hash * 31 + IsExactRange.GetHashCode();
        hash = hash * 31 + DocumentVersion.GetHashCode();
        hash = hash * 31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotCoverLineMarkerModel (");
      using (printer.IndentCookie()) {
        printer.Print("shape = "); Shape.PrintEx(printer); printer.Println();
        printer.Print("faded = "); Faded.PrintEx(printer); printer.Println();
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdDotCoverLineMarkerShape {
    line,
    zigZag,
    dots
  }
  
  
  public class RdDotCoverSnapshot : RdBindableBase {
    //fields
    //public fields
    [NotNull] public RdDotCoverCoverageTreeViewModel CoverageTree {get; private set;}
    [NotNull] public RdDotCoverSnapshotConfigurationViewModel Configuration {get; private set;}
    
    //private fields
    //primary constructor
    private RdDotCoverSnapshot(
      [NotNull] RdDotCoverCoverageTreeViewModel coverageTree,
      [NotNull] RdDotCoverSnapshotConfigurationViewModel configuration
    )
    {
      if (coverageTree == null) throw new ArgumentNullException("coverageTree");
      if (configuration == null) throw new ArgumentNullException("configuration");
      
      CoverageTree = coverageTree;
      Configuration = configuration;
      BindableChildren.Add(new KeyValuePair<string, object>("coverageTree", CoverageTree));
      BindableChildren.Add(new KeyValuePair<string, object>("configuration", Configuration));
    }
    //secondary constructor
    public RdDotCoverSnapshot (
    ) : this (
      new RdDotCoverCoverageTreeViewModel(),
      new RdDotCoverSnapshotConfigurationViewModel()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdDotCoverSnapshot> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var coverageTree = RdDotCoverCoverageTreeViewModel.Read(ctx, reader);
      var configuration = RdDotCoverSnapshotConfigurationViewModel.Read(ctx, reader);
      return new RdDotCoverSnapshot(coverageTree, configuration).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdDotCoverSnapshot> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdDotCoverCoverageTreeViewModel.Write(ctx, writer, value.CoverageTree);
      RdDotCoverSnapshotConfigurationViewModel.Write(ctx, writer, value.Configuration);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotCoverSnapshot (");
      using (printer.IndentCookie()) {
        printer.Print("coverageTree = "); CoverageTree.PrintEx(printer); printer.Println();
        printer.Print("configuration = "); Configuration.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotCoverSnapshotConfigurationViewModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> HighlightingEnabled { get { return _HighlightingEnabled; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _HighlightingEnabled;
    
    //primary constructor
    private RdDotCoverSnapshotConfigurationViewModel(
      [NotNull] RdProperty<bool> highlightingEnabled
    )
    {
      if (highlightingEnabled == null) throw new ArgumentNullException("highlightingEnabled");
      
      _HighlightingEnabled = highlightingEnabled;
      _HighlightingEnabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("highlightingEnabled", _HighlightingEnabled));
    }
    //secondary constructor
    public RdDotCoverSnapshotConfigurationViewModel (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdDotCoverSnapshotConfigurationViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var highlightingEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new RdDotCoverSnapshotConfigurationViewModel(highlightingEnabled).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdDotCoverSnapshotConfigurationViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._HighlightingEnabled);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotCoverSnapshotConfigurationViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("highlightingEnabled = "); _HighlightingEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotCoverSolutionCoverageBrowserViewModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> WorkspaceId { get { return _WorkspaceId; }}
    [NotNull] public IRdProperty<RdDotCoverCoverageTreeStatisticsType> StatisticsType { get { return _StatisticsType; }}
    [NotNull] public IRdProperty<bool> IsBusy { get { return _IsBusy; }}
    [NotNull] public ISource<RdVoid> ActivationRequested { get { return _ActivationRequested; }}
    [NotNull] public RdEndpoint<RdVoid, string> DropData { get { return _DropData; }}
    [NotNull] public RdEndpoint<RdVoid, string> SaveData { get { return _SaveData; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _WorkspaceId;
    [NotNull] private readonly RdProperty<RdDotCoverCoverageTreeStatisticsType> _StatisticsType;
    [NotNull] private readonly RdProperty<bool> _IsBusy;
    [NotNull] private readonly RdSignal<RdVoid> _ActivationRequested;
    [NotNull] private readonly RdEndpoint<RdVoid, string> _DropData;
    [NotNull] private readonly RdEndpoint<RdVoid, string> _SaveData;
    
    //primary constructor
    private RdDotCoverSolutionCoverageBrowserViewModel(
      [NotNull] RdProperty<string> workspaceId,
      [NotNull] RdProperty<RdDotCoverCoverageTreeStatisticsType> statisticsType,
      [NotNull] RdProperty<bool> isBusy,
      [NotNull] RdSignal<RdVoid> activationRequested,
      [NotNull] RdEndpoint<RdVoid, string> dropData,
      [NotNull] RdEndpoint<RdVoid, string> saveData
    )
    {
      if (workspaceId == null) throw new ArgumentNullException("workspaceId");
      if (statisticsType == null) throw new ArgumentNullException("statisticsType");
      if (isBusy == null) throw new ArgumentNullException("isBusy");
      if (activationRequested == null) throw new ArgumentNullException("activationRequested");
      if (dropData == null) throw new ArgumentNullException("dropData");
      if (saveData == null) throw new ArgumentNullException("saveData");
      
      _WorkspaceId = workspaceId;
      _StatisticsType = statisticsType;
      _IsBusy = isBusy;
      _ActivationRequested = activationRequested;
      _DropData = dropData;
      _SaveData = saveData;
      _WorkspaceId.OptimizeNested = true;
      _StatisticsType.OptimizeNested = true;
      _IsBusy.OptimizeNested = true;
      _WorkspaceId.ValueCanBeNull = true;
      _DropData.ValueCanBeNull = true;
      _SaveData.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("workspaceId", _WorkspaceId));
      BindableChildren.Add(new KeyValuePair<string, object>("statisticsType", _StatisticsType));
      BindableChildren.Add(new KeyValuePair<string, object>("isBusy", _IsBusy));
      BindableChildren.Add(new KeyValuePair<string, object>("activationRequested", _ActivationRequested));
      BindableChildren.Add(new KeyValuePair<string, object>("dropData", _DropData));
      BindableChildren.Add(new KeyValuePair<string, object>("saveData", _SaveData));
    }
    //secondary constructor
    public RdDotCoverSolutionCoverageBrowserViewModel (
    ) : this (
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdProperty<RdDotCoverCoverageTreeStatisticsType>(ReadRdDotCoverCoverageTreeStatisticsType, WriteRdDotCoverCoverageTreeStatisticsType),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<RdVoid, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadStringNullable, WriteStringNullable),
      new RdEndpoint<RdVoid, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadStringNullable, WriteStringNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdDotCoverSolutionCoverageBrowserViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var workspaceId = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      var statisticsType = RdProperty<RdDotCoverCoverageTreeStatisticsType>.Read(ctx, reader, ReadRdDotCoverCoverageTreeStatisticsType, WriteRdDotCoverCoverageTreeStatisticsType);
      var isBusy = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var activationRequested = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var dropData = RdEndpoint<RdVoid, string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadStringNullable, WriteStringNullable);
      var saveData = RdEndpoint<RdVoid, string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, ReadStringNullable, WriteStringNullable);
      return new RdDotCoverSolutionCoverageBrowserViewModel(workspaceId, statisticsType, isBusy, activationRequested, dropData, saveData).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdDotCoverCoverageTreeStatisticsType> ReadRdDotCoverCoverageTreeStatisticsType = new CtxReadDelegate<RdDotCoverCoverageTreeStatisticsType>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<RdDotCoverCoverageTreeStatisticsType>);
    
    public static CtxWriteDelegate<RdDotCoverSolutionCoverageBrowserViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<string>.Write(ctx, writer, value._WorkspaceId);
      RdProperty<RdDotCoverCoverageTreeStatisticsType>.Write(ctx, writer, value._StatisticsType);
      RdProperty<bool>.Write(ctx, writer, value._IsBusy);
      RdSignal<RdVoid>.Write(ctx, writer, value._ActivationRequested);
      RdEndpoint<RdVoid, string>.Write(ctx, writer, value._DropData);
      RdEndpoint<RdVoid, string>.Write(ctx, writer, value._SaveData);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdDotCoverCoverageTreeStatisticsType> WriteRdDotCoverCoverageTreeStatisticsType = new CtxWriteDelegate<RdDotCoverCoverageTreeStatisticsType>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<RdDotCoverCoverageTreeStatisticsType>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotCoverSolutionCoverageBrowserViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("workspaceId = "); _WorkspaceId.PrintEx(printer); printer.Println();
        printer.Print("statisticsType = "); _StatisticsType.PrintEx(printer); printer.Println();
        printer.Print("isBusy = "); _IsBusy.PrintEx(printer); printer.Println();
        printer.Print("activationRequested = "); _ActivationRequested.PrintEx(printer); printer.Println();
        printer.Print("dropData = "); _DropData.PrintEx(printer); printer.Println();
        printer.Print("saveData = "); _SaveData.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDotCoverWorkspace : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<RdDotCoverSnapshot> Snapshot { get { return _Snapshot; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RdDotCoverSnapshot> _Snapshot;
    
    //primary constructor
    private RdDotCoverWorkspace(
      [NotNull] RdProperty<RdDotCoverSnapshot> snapshot
    )
    {
      if (snapshot == null) throw new ArgumentNullException("snapshot");
      
      _Snapshot = snapshot;
      _Snapshot.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("snapshot", _Snapshot));
    }
    //secondary constructor
    public RdDotCoverWorkspace (
    ) : this (
      new RdProperty<RdDotCoverSnapshot>(ReadRdDotCoverSnapshotNullable, WriteRdDotCoverSnapshotNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdDotCoverWorkspace> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var snapshot = RdProperty<RdDotCoverSnapshot>.Read(ctx, reader, ReadRdDotCoverSnapshotNullable, WriteRdDotCoverSnapshotNullable);
      return new RdDotCoverWorkspace(snapshot).WithId(_id);
    };
    public static CtxReadDelegate<RdDotCoverSnapshot> ReadRdDotCoverSnapshotNullable = RdDotCoverSnapshot.Read.NullableClass();
    
    public static CtxWriteDelegate<RdDotCoverWorkspace> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<RdDotCoverSnapshot>.Write(ctx, writer, value._Snapshot);
    };
    public static CtxWriteDelegate<RdDotCoverSnapshot> WriteRdDotCoverSnapshotNullable = RdDotCoverSnapshot.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdDotCoverWorkspace (");
      using (printer.IndentCookie()) {
        printer.Print("snapshot = "); _Snapshot.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
