using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class DotNetActiveRuntimeModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<RdActiveRuntime> ActiveRuntime { get { return _ActiveRuntime; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RdActiveRuntime> _ActiveRuntime;
    
    //primary constructor
    private DotNetActiveRuntimeModel(
      [NotNull] RdProperty<RdActiveRuntime> activeRuntime
    )
    {
      if (activeRuntime == null) throw new ArgumentNullException("activeRuntime");
      
      _ActiveRuntime = activeRuntime;
      _ActiveRuntime.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("activeRuntime", _ActiveRuntime));
    }
    //secondary constructor
    internal DotNetActiveRuntimeModel (
    ) : this (
      new RdProperty<RdActiveRuntime>(RdActiveRuntime.Read, RdActiveRuntime.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 3064299608752106257L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdActiveRuntime.Read, RdActiveRuntime.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DotNetActiveRuntimeModel (");
      using (printer.IndentCookie()) {
        printer.Print("activeRuntime = "); _ActiveRuntime.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionDotNetActiveRuntimeModelEx
   {
    public static DotNetActiveRuntimeModel GetDotNetActiveRuntimeModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("dotNetActiveRuntimeModel", () => new DotNetActiveRuntimeModel());
    }
  }
  
  
  public class RdActiveRuntime : IPrintable, IEquatable<RdActiveRuntime> {
    //fields
    //public fields
    [CanBeNull] public string MonoExePath {get; private set;}
    [CanBeNull] public string DotNetCliExePath {get; private set;}
    [NotNull] public List<string> DotNetCoreSdkList {get; private set;}
    
    //private fields
    //primary constructor
    public RdActiveRuntime(
      [CanBeNull] string monoExePath,
      [CanBeNull] string dotNetCliExePath,
      [NotNull] List<string> dotNetCoreSdkList
    )
    {
      if (dotNetCoreSdkList == null) throw new ArgumentNullException("dotNetCoreSdkList");
      
      MonoExePath = monoExePath;
      DotNetCliExePath = dotNetCliExePath;
      DotNetCoreSdkList = dotNetCoreSdkList;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdActiveRuntime> Read = (ctx, reader) => 
    {
      var monoExePath = ReadStringNullable(ctx, reader);
      var dotNetCliExePath = ReadStringNullable(ctx, reader);
      var dotNetCoreSdkList = ReadStringList(ctx, reader);
      return new RdActiveRuntime(monoExePath, dotNetCliExePath, dotNetCoreSdkList);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdActiveRuntime> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.MonoExePath);
      WriteStringNullable(ctx, writer, value.DotNetCliExePath);
      WriteStringList(ctx, writer, value.DotNetCoreSdkList);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdActiveRuntime) obj);
    }
    public bool Equals(RdActiveRuntime other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(MonoExePath, other.MonoExePath) && Equals(DotNetCliExePath, other.DotNetCliExePath) && DotNetCoreSdkList.SequenceEqual(other.DotNetCoreSdkList);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (MonoExePath != null ?MonoExePath.GetHashCode() : 0);
        hash = hash * 31 + (DotNetCliExePath != null ?DotNetCliExePath.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(DotNetCoreSdkList);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdActiveRuntime (");
      using (printer.IndentCookie()) {
        printer.Print("monoExePath = "); MonoExePath.PrintEx(printer); printer.Println();
        printer.Print("dotNetCliExePath = "); DotNetCliExePath.PrintEx(printer); printer.Println();
        printer.Print("dotNetCoreSdkList = "); DotNetCoreSdkList.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
