using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class DotTraceHost : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> OpenedSnapshot { get { return _OpenedSnapshot; }}
    [NotNull] public IViewableMap<string, DotTraceSnapshotListItem> SnapshotsList { get { return _SnapshotsList; }}
    [NotNull] public IRdProperty<DotTraceTopMethodsView> TopMethodsView { get { return _TopMethodsView; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.UIAutomation.BeControl> CallTreeViewV2 { get { return _CallTreeViewV2; }}
    [NotNull] public ISink<DotTraceNavigateToCode> Navigate { get { return _Navigate; }}
    [NotNull] public IViewableList<DotTraceAttachedProcessListItem> Processes { get { return _Processes; }}
    [NotNull] public ISink<DotTraceAttachRequest> AttachRequest { get { return _AttachRequest; }}
    [NotNull] public ISink<DotTraceProfileRequest> ProfileRequest { get { return _ProfileRequest; }}
    [NotNull] public IRdProperty<DotTraceActiveSession> ActiveSession { get { return _ActiveSession; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _OpenedSnapshot;
    [NotNull] private readonly RdMap<string, DotTraceSnapshotListItem> _SnapshotsList;
    [NotNull] private readonly RdProperty<DotTraceTopMethodsView> _TopMethodsView;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl> _CallTreeViewV2;
    [NotNull] private readonly RdSignal<DotTraceNavigateToCode> _Navigate;
    [NotNull] private readonly RdList<DotTraceAttachedProcessListItem> _Processes;
    [NotNull] private readonly RdSignal<DotTraceAttachRequest> _AttachRequest;
    [NotNull] private readonly RdSignal<DotTraceProfileRequest> _ProfileRequest;
    [NotNull] private readonly RdProperty<DotTraceActiveSession> _ActiveSession;
    
    //primary constructor
    private DotTraceHost(
      [NotNull] RdProperty<string> openedSnapshot,
      [NotNull] RdMap<string, DotTraceSnapshotListItem> snapshotsList,
      [NotNull] RdProperty<DotTraceTopMethodsView> topMethodsView,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl> callTreeViewV2,
      [NotNull] RdSignal<DotTraceNavigateToCode> navigate,
      [NotNull] RdList<DotTraceAttachedProcessListItem> processes,
      [NotNull] RdSignal<DotTraceAttachRequest> attachRequest,
      [NotNull] RdSignal<DotTraceProfileRequest> profileRequest,
      [NotNull] RdProperty<DotTraceActiveSession> activeSession
    )
    {
      if (openedSnapshot == null) throw new ArgumentNullException("openedSnapshot");
      if (snapshotsList == null) throw new ArgumentNullException("snapshotsList");
      if (topMethodsView == null) throw new ArgumentNullException("topMethodsView");
      if (callTreeViewV2 == null) throw new ArgumentNullException("callTreeViewV2");
      if (navigate == null) throw new ArgumentNullException("navigate");
      if (processes == null) throw new ArgumentNullException("processes");
      if (attachRequest == null) throw new ArgumentNullException("attachRequest");
      if (profileRequest == null) throw new ArgumentNullException("profileRequest");
      if (activeSession == null) throw new ArgumentNullException("activeSession");
      
      _OpenedSnapshot = openedSnapshot;
      _SnapshotsList = snapshotsList;
      _TopMethodsView = topMethodsView;
      _CallTreeViewV2 = callTreeViewV2;
      _Navigate = navigate;
      _Processes = processes;
      _AttachRequest = attachRequest;
      _ProfileRequest = profileRequest;
      _ActiveSession = activeSession;
      _OpenedSnapshot.OptimizeNested = true;
      _SnapshotsList.OptimizeNested = true;
      _Processes.OptimizeNested = true;
      _OpenedSnapshot.ValueCanBeNull = true;
      _TopMethodsView.ValueCanBeNull = true;
      _CallTreeViewV2.ValueCanBeNull = true;
      _ActiveSession.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("openedSnapshot", _OpenedSnapshot));
      BindableChildren.Add(new KeyValuePair<string, object>("snapshotsList", _SnapshotsList));
      BindableChildren.Add(new KeyValuePair<string, object>("topMethodsView", _TopMethodsView));
      BindableChildren.Add(new KeyValuePair<string, object>("callTreeViewV2", _CallTreeViewV2));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
      BindableChildren.Add(new KeyValuePair<string, object>("processes", _Processes));
      BindableChildren.Add(new KeyValuePair<string, object>("attachRequest", _AttachRequest));
      BindableChildren.Add(new KeyValuePair<string, object>("profileRequest", _ProfileRequest));
      BindableChildren.Add(new KeyValuePair<string, object>("activeSession", _ActiveSession));
    }
    //secondary constructor
    internal DotTraceHost (
    ) : this (
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdMap<string, DotTraceSnapshotListItem>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, DotTraceSnapshotListItem.Read, DotTraceSnapshotListItem.Write),
      new RdProperty<DotTraceTopMethodsView>(ReadDotTraceTopMethodsViewNullable, WriteDotTraceTopMethodsViewNullable),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.BeControl>(ReadBeControlNullable, WriteBeControlNullable),
      new RdSignal<DotTraceNavigateToCode>(DotTraceNavigateToCode.Read, DotTraceNavigateToCode.Write),
      new RdList<DotTraceAttachedProcessListItem>(DotTraceAttachedProcessListItem.Read, DotTraceAttachedProcessListItem.Write),
      new RdSignal<DotTraceAttachRequest>(DotTraceAttachRequest.Read, DotTraceAttachRequest.Write),
      new RdSignal<DotTraceProfileRequest>(DotTraceProfileRequest.Read, DotTraceProfileRequest.Write),
      new RdProperty<DotTraceActiveSession>(ReadDotTraceActiveSessionNullable, WriteDotTraceActiveSessionNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<DotTraceTopMethodsView> ReadDotTraceTopMethodsViewNullable = DotTraceTopMethodsView.Read.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.BeControl> ReadBeControlNullable = JetBrains.Rider.Model.UIAutomation.BeControl.Read.NullableClass();
    public static CtxReadDelegate<DotTraceActiveSession> ReadDotTraceActiveSessionNullable = DotTraceActiveSession.Read.NullableClass();
    
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<DotTraceTopMethodsView> WriteDotTraceTopMethodsViewNullable = DotTraceTopMethodsView.Write.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.BeControl> WriteBeControlNullable = JetBrains.Rider.Model.UIAutomation.BeControl.Write.NullableClass();
    public static CtxWriteDelegate<DotTraceActiveSession> WriteDotTraceActiveSessionNullable = DotTraceActiveSession.Write.NullableClass();
    
    protected override long SerializationHash => -6243598524192406564L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(CallTreeNodeConstant.Read, CallTreeNodeConstant.Write);
      serializers.Register(DotTraceMethod.Read, DotTraceMethod.Write);
      serializers.Register(DotTraceSnapshotListItem.Read, DotTraceSnapshotListItem.Write);
      serializers.Register(DotTraceTopMethodsView.Read, DotTraceTopMethodsView.Write);
      serializers.Register(DotTraceAttachedProcessListItem.Read, DotTraceAttachedProcessListItem.Write);
      serializers.Register(DotTraceAttachRequest.Read, DotTraceAttachRequest.Write);
      serializers.Register(DotTraceProfilingConfiguration.Read, DotTraceProfilingConfiguration.Write);
      serializers.Register(DotTraceNavigateToCode.Read, DotTraceNavigateToCode.Write);
      serializers.Register(DotTraceProfileRequest.Read, DotTraceProfileRequest.Write);
      serializers.Register(DotTraceActiveSession.Read, DotTraceActiveSession.Write);
      serializers.RegisterEnum<MeasureType>();
      serializers.RegisterEnum<MeterKind>();
      serializers.RegisterEnum<DotTraceCoreCommand>();
      serializers.Register(DotTraceOperationsState.Read, DotTraceOperationsState.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceHost (");
      using (printer.IndentCookie()) {
        printer.Print("openedSnapshot = "); _OpenedSnapshot.PrintEx(printer); printer.Println();
        printer.Print("snapshotsList = "); _SnapshotsList.PrintEx(printer); printer.Println();
        printer.Print("topMethodsView = "); _TopMethodsView.PrintEx(printer); printer.Println();
        printer.Print("callTreeViewV2 = "); _CallTreeViewV2.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
        printer.Print("processes = "); _Processes.PrintEx(printer); printer.Println();
        printer.Print("attachRequest = "); _AttachRequest.PrintEx(printer); printer.Println();
        printer.Print("profileRequest = "); _ProfileRequest.PrintEx(printer); printer.Println();
        printer.Print("activeSession = "); _ActiveSession.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionDotTraceHostEx
   {
    public static DotTraceHost GetDotTraceHost(this Solution solution)
    {
      return solution.GetOrCreateExtension("dotTraceHost", () => new DotTraceHost());
    }
  }
  
  
  public class CallTreeNodeConstant : RdDataConstant
   {
    //fields
    //public fields
    public long Fuid {get; private set;}
    
    //private fields
    //primary constructor
    public CallTreeNodeConstant(
      long fuid
    )
    {
      Fuid = fuid;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CallTreeNodeConstant> Read = (ctx, reader) => 
    {
      var fuid = reader.ReadLong();
      return new CallTreeNodeConstant(fuid);
    };
    
    public static new CtxWriteDelegate<CallTreeNodeConstant> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Fuid);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CallTreeNodeConstant) obj);
    }
    public bool Equals(CallTreeNodeConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Fuid == other.Fuid;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Fuid.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CallTreeNodeConstant (");
      using (printer.IndentCookie()) {
        printer.Print("fuid = "); Fuid.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceActiveSession : RdBindableBase {
    //fields
    //public fields
    [NotNull] public ISink<DotTraceCoreCommand> CoreCommand { get { return _CoreCommand; }}
    [NotNull] public IRdProperty<bool> IsDetachPossible { get { return _IsDetachPossible; }}
    [NotNull] public IRdProperty<bool> IsKillPossible { get { return _IsKillPossible; }}
    [NotNull] public ISource<DotTraceOperationsState> CoreStateChanged { get { return _CoreStateChanged; }}
    [NotNull] public IViewableList<string> ErrorMessages { get { return _ErrorMessages; }}
    
    //private fields
    [NotNull] private readonly RdSignal<DotTraceCoreCommand> _CoreCommand;
    [NotNull] private readonly RdProperty<bool> _IsDetachPossible;
    [NotNull] private readonly RdProperty<bool> _IsKillPossible;
    [NotNull] private readonly RdSignal<DotTraceOperationsState> _CoreStateChanged;
    [NotNull] private readonly RdList<string> _ErrorMessages;
    
    //primary constructor
    private DotTraceActiveSession(
      [NotNull] RdSignal<DotTraceCoreCommand> coreCommand,
      [NotNull] RdProperty<bool> isDetachPossible,
      [NotNull] RdProperty<bool> isKillPossible,
      [NotNull] RdSignal<DotTraceOperationsState> coreStateChanged,
      [NotNull] RdList<string> errorMessages
    )
    {
      if (coreCommand == null) throw new ArgumentNullException("coreCommand");
      if (isDetachPossible == null) throw new ArgumentNullException("isDetachPossible");
      if (isKillPossible == null) throw new ArgumentNullException("isKillPossible");
      if (coreStateChanged == null) throw new ArgumentNullException("coreStateChanged");
      if (errorMessages == null) throw new ArgumentNullException("errorMessages");
      
      _CoreCommand = coreCommand;
      _IsDetachPossible = isDetachPossible;
      _IsKillPossible = isKillPossible;
      _CoreStateChanged = coreStateChanged;
      _ErrorMessages = errorMessages;
      _IsDetachPossible.OptimizeNested = true;
      _IsKillPossible.OptimizeNested = true;
      _ErrorMessages.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("coreCommand", _CoreCommand));
      BindableChildren.Add(new KeyValuePair<string, object>("isDetachPossible", _IsDetachPossible));
      BindableChildren.Add(new KeyValuePair<string, object>("isKillPossible", _IsKillPossible));
      BindableChildren.Add(new KeyValuePair<string, object>("coreStateChanged", _CoreStateChanged));
      BindableChildren.Add(new KeyValuePair<string, object>("errorMessages", _ErrorMessages));
    }
    //secondary constructor
    public DotTraceActiveSession (
    ) : this (
      new RdSignal<DotTraceCoreCommand>(ReadDotTraceCoreCommand, WriteDotTraceCoreCommand),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<DotTraceOperationsState>(DotTraceOperationsState.Read, DotTraceOperationsState.Write),
      new RdList<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<DotTraceActiveSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var coreCommand = RdSignal<DotTraceCoreCommand>.Read(ctx, reader, ReadDotTraceCoreCommand, WriteDotTraceCoreCommand);
      var isDetachPossible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isKillPossible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var coreStateChanged = RdSignal<DotTraceOperationsState>.Read(ctx, reader, DotTraceOperationsState.Read, DotTraceOperationsState.Write);
      var errorMessages = RdList<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new DotTraceActiveSession(coreCommand, isDetachPossible, isKillPossible, coreStateChanged, errorMessages).WithId(_id);
    };
    public static CtxReadDelegate<DotTraceCoreCommand> ReadDotTraceCoreCommand = new CtxReadDelegate<DotTraceCoreCommand>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<DotTraceCoreCommand>);
    
    public static CtxWriteDelegate<DotTraceActiveSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<DotTraceCoreCommand>.Write(ctx, writer, value._CoreCommand);
      RdProperty<bool>.Write(ctx, writer, value._IsDetachPossible);
      RdProperty<bool>.Write(ctx, writer, value._IsKillPossible);
      RdSignal<DotTraceOperationsState>.Write(ctx, writer, value._CoreStateChanged);
      RdList<string>.Write(ctx, writer, value._ErrorMessages);
    };
    public static CtxWriteDelegate<DotTraceCoreCommand> WriteDotTraceCoreCommand = new CtxWriteDelegate<DotTraceCoreCommand>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<DotTraceCoreCommand>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceActiveSession (");
      using (printer.IndentCookie()) {
        printer.Print("coreCommand = "); _CoreCommand.PrintEx(printer); printer.Println();
        printer.Print("isDetachPossible = "); _IsDetachPossible.PrintEx(printer); printer.Println();
        printer.Print("isKillPossible = "); _IsKillPossible.PrintEx(printer); printer.Println();
        printer.Print("coreStateChanged = "); _CoreStateChanged.PrintEx(printer); printer.Println();
        printer.Print("errorMessages = "); _ErrorMessages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceAttachRequest : IPrintable, IEquatable<DotTraceAttachRequest> {
    //fields
    //public fields
    public int Pid {get; private set;}
    [NotNull] public string Exe {get; private set;}
    
    //private fields
    //primary constructor
    public DotTraceAttachRequest(
      int pid,
      [NotNull] string exe
    )
    {
      if (exe == null) throw new ArgumentNullException("exe");
      
      Pid = pid;
      Exe = exe;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DotTraceAttachRequest> Read = (ctx, reader) => 
    {
      var pid = reader.ReadInt();
      var exe = reader.ReadString();
      return new DotTraceAttachRequest(pid, exe);
    };
    
    public static CtxWriteDelegate<DotTraceAttachRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Pid);
      writer.Write(value.Exe);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DotTraceAttachRequest) obj);
    }
    public bool Equals(DotTraceAttachRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Pid == other.Pid && Exe == other.Exe;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Pid.GetHashCode();
        hash = hash * 31 + Exe.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceAttachRequest (");
      using (printer.IndentCookie()) {
        printer.Print("pid = "); Pid.PrintEx(printer); printer.Println();
        printer.Print("exe = "); Exe.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceAttachedProcessListItem : IPrintable, IEquatable<DotTraceAttachedProcessListItem> {
    //fields
    //public fields
    [NotNull] public string ProcessName {get; private set;}
    [NotNull] public string CommandLine {get; private set;}
    public int Pid {get; private set;}
    [NotNull] public string Version {get; private set;}
    
    //private fields
    //primary constructor
    public DotTraceAttachedProcessListItem(
      [NotNull] string processName,
      [NotNull] string commandLine,
      int pid,
      [NotNull] string version
    )
    {
      if (processName == null) throw new ArgumentNullException("processName");
      if (commandLine == null) throw new ArgumentNullException("commandLine");
      if (version == null) throw new ArgumentNullException("version");
      
      ProcessName = processName;
      CommandLine = commandLine;
      Pid = pid;
      Version = version;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DotTraceAttachedProcessListItem> Read = (ctx, reader) => 
    {
      var processName = reader.ReadString();
      var commandLine = reader.ReadString();
      var pid = reader.ReadInt();
      var version = reader.ReadString();
      return new DotTraceAttachedProcessListItem(processName, commandLine, pid, version);
    };
    
    public static CtxWriteDelegate<DotTraceAttachedProcessListItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProcessName);
      writer.Write(value.CommandLine);
      writer.Write(value.Pid);
      writer.Write(value.Version);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DotTraceAttachedProcessListItem) obj);
    }
    public bool Equals(DotTraceAttachedProcessListItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProcessName == other.ProcessName && CommandLine == other.CommandLine && Pid == other.Pid && Version == other.Version;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProcessName.GetHashCode();
        hash = hash * 31 + CommandLine.GetHashCode();
        hash = hash * 31 + Pid.GetHashCode();
        hash = hash * 31 + Version.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceAttachedProcessListItem (");
      using (printer.IndentCookie()) {
        printer.Print("processName = "); ProcessName.PrintEx(printer); printer.Println();
        printer.Print("commandLine = "); CommandLine.PrintEx(printer); printer.Println();
        printer.Print("pid = "); Pid.PrintEx(printer); printer.Println();
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum DotTraceCoreCommand {
    Start,
    StopSave,
    StopSaveStart,
    Drop,
    Detach,
    Close
  }
  
  
  public class DotTraceMethod : IPrintable, IEquatable<DotTraceMethod> {
    //fields
    //public fields
    public long Fuid {get; private set;}
    [NotNull] public ModelRichText BeforePayload {get; private set;}
    [CanBeNull] public ModelRichText AfterPayload {get; private set;}
    [NotNull] public string TotalPayload {get; private set;}
    [NotNull] public string OwnPayload {get; private set;}
    [NotNull] public string Percent {get; private set;}
    [CanBeNull] public int? Count {get; private set;}
    
    //private fields
    //primary constructor
    public DotTraceMethod(
      long fuid,
      [NotNull] ModelRichText beforePayload,
      [CanBeNull] ModelRichText afterPayload,
      [NotNull] string totalPayload,
      [NotNull] string ownPayload,
      [NotNull] string percent,
      [CanBeNull] int? count
    )
    {
      if (beforePayload == null) throw new ArgumentNullException("beforePayload");
      if (totalPayload == null) throw new ArgumentNullException("totalPayload");
      if (ownPayload == null) throw new ArgumentNullException("ownPayload");
      if (percent == null) throw new ArgumentNullException("percent");
      
      Fuid = fuid;
      BeforePayload = beforePayload;
      AfterPayload = afterPayload;
      TotalPayload = totalPayload;
      OwnPayload = ownPayload;
      Percent = percent;
      Count = count;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DotTraceMethod> Read = (ctx, reader) => 
    {
      var fuid = reader.ReadLong();
      var beforePayload = ModelRichText.Read(ctx, reader);
      var afterPayload = ReadModelRichTextNullable(ctx, reader);
      var totalPayload = reader.ReadString();
      var ownPayload = reader.ReadString();
      var percent = reader.ReadString();
      var count = ReadIntNullable(ctx, reader);
      return new DotTraceMethod(fuid, beforePayload, afterPayload, totalPayload, ownPayload, percent, count);
    };
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static CtxWriteDelegate<DotTraceMethod> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Fuid);
      ModelRichText.Write(ctx, writer, value.BeforePayload);
      WriteModelRichTextNullable(ctx, writer, value.AfterPayload);
      writer.Write(value.TotalPayload);
      writer.Write(value.OwnPayload);
      writer.Write(value.Percent);
      WriteIntNullable(ctx, writer, value.Count);
    };
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DotTraceMethod) obj);
    }
    public bool Equals(DotTraceMethod other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Fuid == other.Fuid && Equals(BeforePayload, other.BeforePayload) && Equals(AfterPayload, other.AfterPayload) && TotalPayload == other.TotalPayload && OwnPayload == other.OwnPayload && Percent == other.Percent && Equals(Count, other.Count);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Fuid.GetHashCode();
        hash = hash * 31 + BeforePayload.GetHashCode();
        hash = hash * 31 + (AfterPayload != null ?AfterPayload.GetHashCode() : 0);
        hash = hash * 31 + TotalPayload.GetHashCode();
        hash = hash * 31 + OwnPayload.GetHashCode();
        hash = hash * 31 + Percent.GetHashCode();
        hash = hash * 31 + (Count != null ?Count.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceMethod (");
      using (printer.IndentCookie()) {
        printer.Print("fuid = "); Fuid.PrintEx(printer); printer.Println();
        printer.Print("beforePayload = "); BeforePayload.PrintEx(printer); printer.Println();
        printer.Print("afterPayload = "); AfterPayload.PrintEx(printer); printer.Println();
        printer.Print("totalPayload = "); TotalPayload.PrintEx(printer); printer.Println();
        printer.Print("ownPayload = "); OwnPayload.PrintEx(printer); printer.Println();
        printer.Print("percent = "); Percent.PrintEx(printer); printer.Println();
        printer.Print("count = "); Count.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceNavigateToCode : IPrintable, IEquatable<DotTraceNavigateToCode> {
    //fields
    //public fields
    public long Fuid {get; private set;}
    
    //private fields
    //primary constructor
    public DotTraceNavigateToCode(
      long fuid
    )
    {
      Fuid = fuid;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DotTraceNavigateToCode> Read = (ctx, reader) => 
    {
      var fuid = reader.ReadLong();
      return new DotTraceNavigateToCode(fuid);
    };
    
    public static CtxWriteDelegate<DotTraceNavigateToCode> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Fuid);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DotTraceNavigateToCode) obj);
    }
    public bool Equals(DotTraceNavigateToCode other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Fuid == other.Fuid;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Fuid.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceNavigateToCode (");
      using (printer.IndentCookie()) {
        printer.Print("fuid = "); Fuid.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceOperationsState : IPrintable, IEquatable<DotTraceOperationsState> {
    //fields
    //public fields
    public bool IsStartEnabled {get; private set;}
    public bool IsGetEnabled {get; private set;}
    public bool IsDropEnabled {get; private set;}
    public bool IsDetachEnabled {get; private set;}
    public bool IsKillEnabled {get; private set;}
    [NotNull] public string CurrentProcess {get; private set;}
    
    //private fields
    //primary constructor
    public DotTraceOperationsState(
      bool isStartEnabled,
      bool isGetEnabled,
      bool isDropEnabled,
      bool isDetachEnabled,
      bool isKillEnabled,
      [NotNull] string currentProcess
    )
    {
      if (currentProcess == null) throw new ArgumentNullException("currentProcess");
      
      IsStartEnabled = isStartEnabled;
      IsGetEnabled = isGetEnabled;
      IsDropEnabled = isDropEnabled;
      IsDetachEnabled = isDetachEnabled;
      IsKillEnabled = isKillEnabled;
      CurrentProcess = currentProcess;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DotTraceOperationsState> Read = (ctx, reader) => 
    {
      var isStartEnabled = reader.ReadBool();
      var isGetEnabled = reader.ReadBool();
      var isDropEnabled = reader.ReadBool();
      var isDetachEnabled = reader.ReadBool();
      var isKillEnabled = reader.ReadBool();
      var currentProcess = reader.ReadString();
      return new DotTraceOperationsState(isStartEnabled, isGetEnabled, isDropEnabled, isDetachEnabled, isKillEnabled, currentProcess);
    };
    
    public static CtxWriteDelegate<DotTraceOperationsState> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsStartEnabled);
      writer.Write(value.IsGetEnabled);
      writer.Write(value.IsDropEnabled);
      writer.Write(value.IsDetachEnabled);
      writer.Write(value.IsKillEnabled);
      writer.Write(value.CurrentProcess);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DotTraceOperationsState) obj);
    }
    public bool Equals(DotTraceOperationsState other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsStartEnabled == other.IsStartEnabled && IsGetEnabled == other.IsGetEnabled && IsDropEnabled == other.IsDropEnabled && IsDetachEnabled == other.IsDetachEnabled && IsKillEnabled == other.IsKillEnabled && CurrentProcess == other.CurrentProcess;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IsStartEnabled.GetHashCode();
        hash = hash * 31 + IsGetEnabled.GetHashCode();
        hash = hash * 31 + IsDropEnabled.GetHashCode();
        hash = hash * 31 + IsDetachEnabled.GetHashCode();
        hash = hash * 31 + IsKillEnabled.GetHashCode();
        hash = hash * 31 + CurrentProcess.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceOperationsState (");
      using (printer.IndentCookie()) {
        printer.Print("isStartEnabled = "); IsStartEnabled.PrintEx(printer); printer.Println();
        printer.Print("isGetEnabled = "); IsGetEnabled.PrintEx(printer); printer.Println();
        printer.Print("isDropEnabled = "); IsDropEnabled.PrintEx(printer); printer.Println();
        printer.Print("isDetachEnabled = "); IsDetachEnabled.PrintEx(printer); printer.Println();
        printer.Print("isKillEnabled = "); IsKillEnabled.PrintEx(printer); printer.Println();
        printer.Print("currentProcess = "); CurrentProcess.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceProfileRequest : IPrintable, IEquatable<DotTraceProfileRequest> {
    //fields
    //public fields
    [NotNull] public string Path {get; private set;}
    [NotNull] public string WorkDir {get; private set;}
    [NotNull] public string Arguments {get; private set;}
    [NotNull] public List<EnvironmentVariable> EnvironmentVariables {get; private set;}
    [CanBeNull] public DotTraceProfilingConfiguration Configuration {get; private set;}
    
    //private fields
    //primary constructor
    public DotTraceProfileRequest(
      [NotNull] string path,
      [NotNull] string workDir,
      [NotNull] string arguments,
      [NotNull] List<EnvironmentVariable> environmentVariables,
      [CanBeNull] DotTraceProfilingConfiguration configuration
    )
    {
      if (path == null) throw new ArgumentNullException("path");
      if (workDir == null) throw new ArgumentNullException("workDir");
      if (arguments == null) throw new ArgumentNullException("arguments");
      if (environmentVariables == null) throw new ArgumentNullException("environmentVariables");
      
      Path = path;
      WorkDir = workDir;
      Arguments = arguments;
      EnvironmentVariables = environmentVariables;
      Configuration = configuration;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DotTraceProfileRequest> Read = (ctx, reader) => 
    {
      var path = reader.ReadString();
      var workDir = reader.ReadString();
      var arguments = reader.ReadString();
      var environmentVariables = ReadEnvironmentVariableList(ctx, reader);
      var configuration = ReadDotTraceProfilingConfigurationNullable(ctx, reader);
      return new DotTraceProfileRequest(path, workDir, arguments, environmentVariables, configuration);
    };
    public static CtxReadDelegate<List<EnvironmentVariable>> ReadEnvironmentVariableList = EnvironmentVariable.Read.List();
    public static CtxReadDelegate<DotTraceProfilingConfiguration> ReadDotTraceProfilingConfigurationNullable = DotTraceProfilingConfiguration.Read.NullableClass();
    
    public static CtxWriteDelegate<DotTraceProfileRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Path);
      writer.Write(value.WorkDir);
      writer.Write(value.Arguments);
      WriteEnvironmentVariableList(ctx, writer, value.EnvironmentVariables);
      WriteDotTraceProfilingConfigurationNullable(ctx, writer, value.Configuration);
    };
    public static CtxWriteDelegate<List<EnvironmentVariable>> WriteEnvironmentVariableList = EnvironmentVariable.Write.List();
    public static CtxWriteDelegate<DotTraceProfilingConfiguration> WriteDotTraceProfilingConfigurationNullable = DotTraceProfilingConfiguration.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DotTraceProfileRequest) obj);
    }
    public bool Equals(DotTraceProfileRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Path == other.Path && WorkDir == other.WorkDir && Arguments == other.Arguments && EnvironmentVariables.SequenceEqual(other.EnvironmentVariables) && Equals(Configuration, other.Configuration);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Path.GetHashCode();
        hash = hash * 31 + WorkDir.GetHashCode();
        hash = hash * 31 + Arguments.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(EnvironmentVariables);
        hash = hash * 31 + (Configuration != null ?Configuration.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceProfileRequest (");
      using (printer.IndentCookie()) {
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("workDir = "); WorkDir.PrintEx(printer); printer.Println();
        printer.Print("arguments = "); Arguments.PrintEx(printer); printer.Println();
        printer.Print("environmentVariables = "); EnvironmentVariables.PrintEx(printer); printer.Println();
        printer.Print("configuration = "); Configuration.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceProfilingConfiguration : IPrintable, IEquatable<DotTraceProfilingConfiguration> {
    //fields
    //public fields
    public JetBrains.Rider.Model.MeasureType MeasureType {get; private set;}
    public JetBrains.Rider.Model.MeterKind MeterKind {get; private set;}
    public bool StartImmediately {get; private set;}
    public bool ProfileChildProcesses {get; private set;}
    public bool ReuseSameNameThreads {get; private set;}
    public bool PrecisionMode {get; private set;}
    public bool EnableJitInlining {get; private set;}
    public bool EnableNativeAllocations {get; private set;}
    public bool EnableDebugOutput {get; private set;}
    public bool EnableTpl {get; private set;}
    
    //private fields
    //primary constructor
    public DotTraceProfilingConfiguration(
      JetBrains.Rider.Model.MeasureType measureType,
      JetBrains.Rider.Model.MeterKind meterKind,
      bool startImmediately,
      bool profileChildProcesses,
      bool reuseSameNameThreads,
      bool precisionMode,
      bool enableJitInlining,
      bool enableNativeAllocations,
      bool enableDebugOutput,
      bool enableTpl
    )
    {
      MeasureType = measureType;
      MeterKind = meterKind;
      StartImmediately = startImmediately;
      ProfileChildProcesses = profileChildProcesses;
      ReuseSameNameThreads = reuseSameNameThreads;
      PrecisionMode = precisionMode;
      EnableJitInlining = enableJitInlining;
      EnableNativeAllocations = enableNativeAllocations;
      EnableDebugOutput = enableDebugOutput;
      EnableTpl = enableTpl;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DotTraceProfilingConfiguration> Read = (ctx, reader) => 
    {
      var measureType = (JetBrains.Rider.Model.MeasureType)reader.ReadInt();
      var meterKind = (JetBrains.Rider.Model.MeterKind)reader.ReadInt();
      var startImmediately = reader.ReadBool();
      var profileChildProcesses = reader.ReadBool();
      var reuseSameNameThreads = reader.ReadBool();
      var precisionMode = reader.ReadBool();
      var enableJitInlining = reader.ReadBool();
      var enableNativeAllocations = reader.ReadBool();
      var enableDebugOutput = reader.ReadBool();
      var enableTpl = reader.ReadBool();
      return new DotTraceProfilingConfiguration(measureType, meterKind, startImmediately, profileChildProcesses, reuseSameNameThreads, precisionMode, enableJitInlining, enableNativeAllocations, enableDebugOutput, enableTpl);
    };
    
    public static CtxWriteDelegate<DotTraceProfilingConfiguration> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.MeasureType);
      writer.Write((int)value.MeterKind);
      writer.Write(value.StartImmediately);
      writer.Write(value.ProfileChildProcesses);
      writer.Write(value.ReuseSameNameThreads);
      writer.Write(value.PrecisionMode);
      writer.Write(value.EnableJitInlining);
      writer.Write(value.EnableNativeAllocations);
      writer.Write(value.EnableDebugOutput);
      writer.Write(value.EnableTpl);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DotTraceProfilingConfiguration) obj);
    }
    public bool Equals(DotTraceProfilingConfiguration other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return MeasureType == other.MeasureType && MeterKind == other.MeterKind && StartImmediately == other.StartImmediately && ProfileChildProcesses == other.ProfileChildProcesses && ReuseSameNameThreads == other.ReuseSameNameThreads && PrecisionMode == other.PrecisionMode && EnableJitInlining == other.EnableJitInlining && EnableNativeAllocations == other.EnableNativeAllocations && EnableDebugOutput == other.EnableDebugOutput && EnableTpl == other.EnableTpl;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) MeasureType;
        hash = hash * 31 + (int) MeterKind;
        hash = hash * 31 + StartImmediately.GetHashCode();
        hash = hash * 31 + ProfileChildProcesses.GetHashCode();
        hash = hash * 31 + ReuseSameNameThreads.GetHashCode();
        hash = hash * 31 + PrecisionMode.GetHashCode();
        hash = hash * 31 + EnableJitInlining.GetHashCode();
        hash = hash * 31 + EnableNativeAllocations.GetHashCode();
        hash = hash * 31 + EnableDebugOutput.GetHashCode();
        hash = hash * 31 + EnableTpl.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceProfilingConfiguration (");
      using (printer.IndentCookie()) {
        printer.Print("measureType = "); MeasureType.PrintEx(printer); printer.Println();
        printer.Print("meterKind = "); MeterKind.PrintEx(printer); printer.Println();
        printer.Print("startImmediately = "); StartImmediately.PrintEx(printer); printer.Println();
        printer.Print("profileChildProcesses = "); ProfileChildProcesses.PrintEx(printer); printer.Println();
        printer.Print("reuseSameNameThreads = "); ReuseSameNameThreads.PrintEx(printer); printer.Println();
        printer.Print("precisionMode = "); PrecisionMode.PrintEx(printer); printer.Println();
        printer.Print("enableJitInlining = "); EnableJitInlining.PrintEx(printer); printer.Println();
        printer.Print("enableNativeAllocations = "); EnableNativeAllocations.PrintEx(printer); printer.Println();
        printer.Print("enableDebugOutput = "); EnableDebugOutput.PrintEx(printer); printer.Println();
        printer.Print("enableTpl = "); EnableTpl.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceSnapshotListItem : IPrintable, IEquatable<DotTraceSnapshotListItem> {
    //fields
    //public fields
    public DateTime Date {get; private set;}
    [NotNull] public string Path {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public string Application {get; private set;}
    [NotNull] public string SnapshotType {get; private set;}
    [NotNull] public string Size {get; private set;}
    
    //private fields
    //primary constructor
    public DotTraceSnapshotListItem(
      DateTime date,
      [NotNull] string path,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string application,
      [NotNull] string snapshotType,
      [NotNull] string size
    )
    {
      if (path == null) throw new ArgumentNullException("path");
      if (application == null) throw new ArgumentNullException("application");
      if (snapshotType == null) throw new ArgumentNullException("snapshotType");
      if (size == null) throw new ArgumentNullException("size");
      
      Date = date;
      Path = path;
      Icon = icon;
      Application = application;
      SnapshotType = snapshotType;
      Size = size;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DotTraceSnapshotListItem> Read = (ctx, reader) => 
    {
      var date = reader.ReadDateTime();
      var path = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var application = reader.ReadString();
      var snapshotType = reader.ReadString();
      var size = reader.ReadString();
      return new DotTraceSnapshotListItem(date, path, icon, application, snapshotType, size);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<DotTraceSnapshotListItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Date);
      writer.Write(value.Path);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.Application);
      writer.Write(value.SnapshotType);
      writer.Write(value.Size);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DotTraceSnapshotListItem) obj);
    }
    public bool Equals(DotTraceSnapshotListItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Date == other.Date && Path == other.Path && Equals(Icon, other.Icon) && Application == other.Application && SnapshotType == other.SnapshotType && Size == other.Size;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Date.GetHashCode();
        hash = hash * 31 + Path.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + Application.GetHashCode();
        hash = hash * 31 + SnapshotType.GetHashCode();
        hash = hash * 31 + Size.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceSnapshotListItem (");
      using (printer.IndentCookie()) {
        printer.Print("date = "); Date.PrintEx(printer); printer.Println();
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("application = "); Application.PrintEx(printer); printer.Println();
        printer.Print("snapshotType = "); SnapshotType.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DotTraceTopMethodsView : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> HideSystemFunction { get { return _HideSystemFunction; }}
    [NotNull] public IViewableMap<int, DotTraceMethod> MethodsList { get { return _MethodsList; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _HideSystemFunction;
    [NotNull] private readonly RdMap<int, DotTraceMethod> _MethodsList;
    
    //primary constructor
    private DotTraceTopMethodsView(
      [NotNull] RdProperty<bool> hideSystemFunction,
      [NotNull] RdMap<int, DotTraceMethod> methodsList
    )
    {
      if (hideSystemFunction == null) throw new ArgumentNullException("hideSystemFunction");
      if (methodsList == null) throw new ArgumentNullException("methodsList");
      
      _HideSystemFunction = hideSystemFunction;
      _MethodsList = methodsList;
      _HideSystemFunction.OptimizeNested = true;
      _MethodsList.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("hideSystemFunction", _HideSystemFunction));
      BindableChildren.Add(new KeyValuePair<string, object>("methodsList", _MethodsList));
    }
    //secondary constructor
    public DotTraceTopMethodsView (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdMap<int, DotTraceMethod>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, DotTraceMethod.Read, DotTraceMethod.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<DotTraceTopMethodsView> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var hideSystemFunction = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var methodsList = RdMap<int, DotTraceMethod>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, DotTraceMethod.Read, DotTraceMethod.Write);
      return new DotTraceTopMethodsView(hideSystemFunction, methodsList).WithId(_id);
    };
    
    public static CtxWriteDelegate<DotTraceTopMethodsView> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._HideSystemFunction);
      RdMap<int, DotTraceMethod>.Write(ctx, writer, value._MethodsList);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DotTraceTopMethodsView (");
      using (printer.IndentCookie()) {
        printer.Print("hideSystemFunction = "); _HideSystemFunction.PrintEx(printer); printer.Println();
        printer.Print("methodsList = "); _MethodsList.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum MeasureType {
    Sampling,
    Tracing,
    TracingInject,
    Timeline
  }
  
  
  public enum MeterKind {
    None,
    PerformanceCounter,
    ThreadTime,
    Rdtsc,
    ThreadCycleTime
  }
}
