using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class FileTemplateModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IViewableMap<int, RdFileTemplate> ItemTemplates { get { return _ItemTemplates; }}
    [NotNull] public RdEndpoint<RdGetTemplatesCommand, RdGeTemplatesResult> GetTemplates { get { return _GetTemplates; }}
    [NotNull] public RdEndpoint<RdCreateFromTemplateCommand, ProjectModelTaskResult> CreateFromTemplate { get { return _CreateFromTemplate; }}
    
    //private fields
    [NotNull] private readonly RdMap<int, RdFileTemplate> _ItemTemplates;
    [NotNull] private readonly RdEndpoint<RdGetTemplatesCommand, RdGeTemplatesResult> _GetTemplates;
    [NotNull] private readonly RdEndpoint<RdCreateFromTemplateCommand, ProjectModelTaskResult> _CreateFromTemplate;
    
    //primary constructor
    private FileTemplateModel(
      [NotNull] RdMap<int, RdFileTemplate> itemTemplates,
      [NotNull] RdEndpoint<RdGetTemplatesCommand, RdGeTemplatesResult> getTemplates,
      [NotNull] RdEndpoint<RdCreateFromTemplateCommand, ProjectModelTaskResult> createFromTemplate
    )
    {
      if (itemTemplates == null) throw new ArgumentNullException("itemTemplates");
      if (getTemplates == null) throw new ArgumentNullException("getTemplates");
      if (createFromTemplate == null) throw new ArgumentNullException("createFromTemplate");
      
      _ItemTemplates = itemTemplates;
      _GetTemplates = getTemplates;
      _CreateFromTemplate = createFromTemplate;
      _ItemTemplates.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("itemTemplates", _ItemTemplates));
      BindableChildren.Add(new KeyValuePair<string, object>("getTemplates", _GetTemplates));
      BindableChildren.Add(new KeyValuePair<string, object>("createFromTemplate", _CreateFromTemplate));
    }
    //secondary constructor
    internal FileTemplateModel (
    ) : this (
      new RdMap<int, RdFileTemplate>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdFileTemplate.Read, RdFileTemplate.Write),
      new RdEndpoint<RdGetTemplatesCommand, RdGeTemplatesResult>(RdGetTemplatesCommand.Read, RdGetTemplatesCommand.Write, RdGeTemplatesResult.Read, RdGeTemplatesResult.Write),
      new RdEndpoint<RdCreateFromTemplateCommand, ProjectModelTaskResult>(RdCreateFromTemplateCommand.Read, RdCreateFromTemplateCommand.Write, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -2254238076584558809L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdFileTemplate.Read, RdFileTemplate.Write);
      serializers.Register(RdTemplateNodeLocation.Read, RdTemplateNodeLocation.Write);
      serializers.Register(RdTemplatePathLocation.Read, RdTemplatePathLocation.Write);
      serializers.Register(RdGetTemplatesCommand.Read, RdGetTemplatesCommand.Write);
      serializers.Register(RdGeTemplatesResult.Read, RdGeTemplatesResult.Write);
      serializers.Register(RdCreateFromTemplateCommand.Read, RdCreateFromTemplateCommand.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("FileTemplateModel (");
      using (printer.IndentCookie()) {
        printer.Print("itemTemplates = "); _ItemTemplates.PrintEx(printer); printer.Println();
        printer.Print("getTemplates = "); _GetTemplates.PrintEx(printer); printer.Println();
        printer.Print("createFromTemplate = "); _CreateFromTemplate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionFileTemplateModelEx
   {
    public static FileTemplateModel GetFileTemplateModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("fileTemplateModel", () => new FileTemplateModel());
    }
  }
  
  
  public class RdCreateFromTemplateCommand : IPrintable, IEquatable<RdCreateFromTemplateCommand> {
    //fields
    //public fields
    [NotNull] public string ItemName {get; private set;}
    [NotNull] public RdFileTemplate Template {get; private set;}
    [NotNull] public RdTemplateLocation Location {get; private set;}
    
    //private fields
    //primary constructor
    public RdCreateFromTemplateCommand(
      [NotNull] string itemName,
      [NotNull] RdFileTemplate template,
      [NotNull] RdTemplateLocation location
    )
    {
      if (itemName == null) throw new ArgumentNullException("itemName");
      if (template == null) throw new ArgumentNullException("template");
      if (location == null) throw new ArgumentNullException("location");
      
      ItemName = itemName;
      Template = template;
      Location = location;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdCreateFromTemplateCommand> Read = (ctx, reader) => 
    {
      var itemName = reader.ReadString();
      var template = RdFileTemplate.Read(ctx, reader);
      var location = RdTemplateLocation.Read(ctx, reader);
      return new RdCreateFromTemplateCommand(itemName, template, location);
    };
    
    public static CtxWriteDelegate<RdCreateFromTemplateCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemName);
      RdFileTemplate.Write(ctx, writer, value.Template);
      RdTemplateLocation.Write(ctx, writer, value.Location);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCreateFromTemplateCommand) obj);
    }
    public bool Equals(RdCreateFromTemplateCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemName == other.ItemName && Equals(Template, other.Template) && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ItemName.GetHashCode();
        hash = hash * 31 + Template.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCreateFromTemplateCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemName = "); ItemName.PrintEx(printer); printer.Println();
        printer.Print("template = "); Template.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFileTemplate : IPrintable, IEquatable<RdFileTemplate> {
    //fields
    //public fields
    public int Id {get; private set;}
    [NotNull] public string Name {get; private set;}
    [NotNull] public string Description {get; private set;}
    [NotNull] public string Group {get; private set;}
    [NotNull] public string DefaultFileName {get; private set;}
    [NotNull] public string DefaultFileExtension {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    public RdFileTemplate(
      int id,
      [NotNull] string name,
      [NotNull] string description,
      [NotNull] string group,
      [NotNull] string defaultFileName,
      [NotNull] string defaultFileExtension,
      [NotNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (description == null) throw new ArgumentNullException("description");
      if (group == null) throw new ArgumentNullException("group");
      if (defaultFileName == null) throw new ArgumentNullException("defaultFileName");
      if (defaultFileExtension == null) throw new ArgumentNullException("defaultFileExtension");
      if (icon == null) throw new ArgumentNullException("icon");
      
      Id = id;
      Name = name;
      Description = description;
      Group = group;
      DefaultFileName = defaultFileName;
      DefaultFileExtension = defaultFileExtension;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdFileTemplate> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var name = reader.ReadString();
      var description = reader.ReadString();
      var group = reader.ReadString();
      var defaultFileName = reader.ReadString();
      var defaultFileExtension = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      return new RdFileTemplate(id, name, description, group, defaultFileName, defaultFileExtension, icon);
    };
    
    public static CtxWriteDelegate<RdFileTemplate> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Name);
      writer.Write(value.Description);
      writer.Write(value.Group);
      writer.Write(value.DefaultFileName);
      writer.Write(value.DefaultFileExtension);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdFileTemplate) obj);
    }
    public bool Equals(RdFileTemplate other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Name == other.Name && Description == other.Description && Group == other.Group && DefaultFileName == other.DefaultFileName && DefaultFileExtension == other.DefaultFileExtension && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Description.GetHashCode();
        hash = hash * 31 + Group.GetHashCode();
        hash = hash * 31 + DefaultFileName.GetHashCode();
        hash = hash * 31 + DefaultFileExtension.GetHashCode();
        hash = hash * 31 + Icon.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdFileTemplate (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("group = "); Group.PrintEx(printer); printer.Println();
        printer.Print("defaultFileName = "); DefaultFileName.PrintEx(printer); printer.Println();
        printer.Print("defaultFileExtension = "); DefaultFileExtension.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdGeTemplatesResult : IPrintable, IEquatable<RdGeTemplatesResult> {
    //fields
    //public fields
    [NotNull] public List<int> TemplateIds {get; private set;}
    
    //private fields
    //primary constructor
    public RdGeTemplatesResult(
      [NotNull] List<int> templateIds
    )
    {
      if (templateIds == null) throw new ArgumentNullException("templateIds");
      
      TemplateIds = templateIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdGeTemplatesResult> Read = (ctx, reader) => 
    {
      var templateIds = ReadIntList(ctx, reader);
      return new RdGeTemplatesResult(templateIds);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<RdGeTemplatesResult> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.TemplateIds);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdGeTemplatesResult) obj);
    }
    public bool Equals(RdGeTemplatesResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return TemplateIds.SequenceEqual(other.TemplateIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(TemplateIds);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdGeTemplatesResult (");
      using (printer.IndentCookie()) {
        printer.Print("templateIds = "); TemplateIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdGetTemplatesCommand : IPrintable, IEquatable<RdGetTemplatesCommand> {
    //fields
    //public fields
    [NotNull] public RdTemplateLocation Location {get; private set;}
    
    //private fields
    //primary constructor
    public RdGetTemplatesCommand(
      [NotNull] RdTemplateLocation location
    )
    {
      if (location == null) throw new ArgumentNullException("location");
      
      Location = location;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdGetTemplatesCommand> Read = (ctx, reader) => 
    {
      var location = RdTemplateLocation.Read(ctx, reader);
      return new RdGetTemplatesCommand(location);
    };
    
    public static CtxWriteDelegate<RdGetTemplatesCommand> Write = (ctx, writer, value) => 
    {
      RdTemplateLocation.Write(ctx, writer, value.Location);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdGetTemplatesCommand) obj);
    }
    public bool Equals(RdGetTemplatesCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdGetTemplatesCommand (");
      using (printer.IndentCookie()) {
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdTemplateLocation {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdTemplateLocation> Read = Polymorphic<RdTemplateLocation>.ReadAbstract(RdTemplateLocation_Unknown.Read);
    
    public static CtxWriteDelegate<RdTemplateLocation> Write = Polymorphic<RdTemplateLocation>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdTemplateLocation_Unknown : RdTemplateLocation
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdTemplateLocation_Unknown> Read = (ctx, reader) => 
    {
      return new RdTemplateLocation_Unknown();
    };
    
    public static new CtxWriteDelegate<RdTemplateLocation_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdTemplateLocation_Unknown) obj);
    }
    public bool Equals(RdTemplateLocation_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdTemplateLocation_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTemplateNodeLocation : RdTemplateLocation
   {
    //fields
    //public fields
    public int ItemId {get; private set;}
    
    //private fields
    //primary constructor
    public RdTemplateNodeLocation(
      int itemId
    )
    {
      ItemId = itemId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdTemplateNodeLocation> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      return new RdTemplateNodeLocation(itemId);
    };
    
    public static new CtxWriteDelegate<RdTemplateNodeLocation> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdTemplateNodeLocation) obj);
    }
    public bool Equals(RdTemplateNodeLocation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ItemId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdTemplateNodeLocation (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTemplatePathLocation : RdTemplateLocation
   {
    //fields
    //public fields
    [NotNull] public string FolderLocation {get; private set;}
    
    //private fields
    //primary constructor
    public RdTemplatePathLocation(
      [NotNull] string folderLocation
    )
    {
      if (folderLocation == null) throw new ArgumentNullException("folderLocation");
      
      FolderLocation = folderLocation;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdTemplatePathLocation> Read = (ctx, reader) => 
    {
      var folderLocation = reader.ReadString();
      return new RdTemplatePathLocation(folderLocation);
    };
    
    public static new CtxWriteDelegate<RdTemplatePathLocation> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FolderLocation);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdTemplatePathLocation) obj);
    }
    public bool Equals(RdTemplatePathLocation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FolderLocation == other.FolderLocation;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + FolderLocation.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdTemplatePathLocation (");
      using (printer.IndentCookie()) {
        printer.Print("folderLocation = "); FolderLocation.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
