using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class FindUsagesModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public ISource<RdHighlights> Highlights { get { return _Highlights; }}
    [NotNull] public IViewableMap<int, RdFindUsagesSession> Sessions { get { return _Sessions; }}
    [NotNull] public IRdProperty<RdUsageGroupingRuleList> GroupingRules { get { return _GroupingRules; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdHighlights> _Highlights;
    [NotNull] private readonly RdMap<int, RdFindUsagesSession> _Sessions;
    [NotNull] private readonly RdProperty<RdUsageGroupingRuleList> _GroupingRules;
    
    //primary constructor
    private FindUsagesModel(
      [NotNull] RdSignal<RdHighlights> highlights,
      [NotNull] RdMap<int, RdFindUsagesSession> sessions,
      [NotNull] RdProperty<RdUsageGroupingRuleList> groupingRules
    )
    {
      if (highlights == null) throw new ArgumentNullException("highlights");
      if (sessions == null) throw new ArgumentNullException("sessions");
      if (groupingRules == null) throw new ArgumentNullException("groupingRules");
      
      _Highlights = highlights;
      _Sessions = sessions;
      _GroupingRules = groupingRules;
      BindableChildren.Add(new KeyValuePair<string, object>("highlights", _Highlights));
      BindableChildren.Add(new KeyValuePair<string, object>("sessions", _Sessions));
      BindableChildren.Add(new KeyValuePair<string, object>("groupingRules", _GroupingRules));
    }
    //secondary constructor
    internal FindUsagesModel (
    ) : this (
      new RdSignal<RdHighlights>(RdHighlights.Read, RdHighlights.Write),
      new RdMap<int, RdFindUsagesSession>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdFindUsagesSession.Read, RdFindUsagesSession.Write),
      new RdProperty<RdUsageGroupingRuleList>(RdUsageGroupingRuleList.Read, RdUsageGroupingRuleList.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 2436361507257012780L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdUsagePosition.Read, RdUsagePosition.Write);
      serializers.Register(RdUsageGroup.Read, RdUsageGroup.Write);
      serializers.Register(RdUsage.Read, RdUsage.Write);
      serializers.Register(RdMergeableUsage.Read, RdMergeableUsage.Write);
      serializers.Register(RdUsageGroupNavigationData.Read, RdUsageGroupNavigationData.Write);
      serializers.Register(RdUsageList.Read, RdUsageList.Write);
      serializers.RegisterEnum<RdUsageKind>();
      serializers.Register(RdLightUsage.Read, RdLightUsage.Write);
      serializers.Register(RdHighlights.Read, RdHighlights.Write);
      serializers.Register(RdFindUsagesSession.Read, RdFindUsagesSession.Write);
      serializers.Register(RdUsageGroupingRuleList.Read, RdUsageGroupingRuleList.Write);
      serializers.Register(RdUsageNavigationData.Read, RdUsageNavigationData.Write);
      serializers.Register(RdUsageTargetList.Read, RdUsageTargetList.Write);
      serializers.Register(RdUsageTarget.Read, RdUsageTarget.Write);
      serializers.Register(RdUsageTargetNavigationData.Read, RdUsageTargetNavigationData.Write);
      serializers.Register(RdUsageGroupingRule.Read, RdUsageGroupingRule.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("FindUsagesModel (");
      using (printer.IndentCookie()) {
        printer.Print("highlights = "); _Highlights.PrintEx(printer); printer.Println();
        printer.Print("sessions = "); _Sessions.PrintEx(printer); printer.Println();
        printer.Print("groupingRules = "); _GroupingRules.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionFindUsagesModelEx
   {
    public static FindUsagesModel GetFindUsagesHost(this Solution solution)
    {
      return solution.GetOrCreateExtension("findUsagesModel", () => new FindUsagesModel());
    }
  }
  
  
  public class RdFindUsagesSession : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public RdUsageList Usages {get; private set;}
    [NotNull] public RdUsageTargetList Targets {get; private set;}
    public bool ShowWithSingleUsage {get; private set;}
    [CanBeNull] public int? GotoSessionKey {get; private set;}
    [NotNull] public IRdProperty<bool> IsSearchComplete { get { return _IsSearchComplete; }}
    [NotNull] public IRdProperty<bool> CanReRun { get { return _CanReRun; }}
    [NotNull] public ISink<RdVoid> ReRun { get { return _ReRun; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsSearchComplete;
    [NotNull] private readonly RdProperty<bool> _CanReRun;
    [NotNull] private readonly RdSignal<RdVoid> _ReRun;
    
    //primary constructor
    private RdFindUsagesSession(
      [NotNull] string title,
      [NotNull] RdUsageList usages,
      [NotNull] RdUsageTargetList targets,
      bool showWithSingleUsage,
      [CanBeNull] int? gotoSessionKey,
      [NotNull] RdProperty<bool> isSearchComplete,
      [NotNull] RdProperty<bool> canReRun,
      [NotNull] RdSignal<RdVoid> reRun
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (usages == null) throw new ArgumentNullException("usages");
      if (targets == null) throw new ArgumentNullException("targets");
      if (isSearchComplete == null) throw new ArgumentNullException("isSearchComplete");
      if (canReRun == null) throw new ArgumentNullException("canReRun");
      if (reRun == null) throw new ArgumentNullException("reRun");
      
      Title = title;
      Usages = usages;
      Targets = targets;
      ShowWithSingleUsage = showWithSingleUsage;
      GotoSessionKey = gotoSessionKey;
      _IsSearchComplete = isSearchComplete;
      _CanReRun = canReRun;
      _ReRun = reRun;
      _IsSearchComplete.OptimizeNested = true;
      _CanReRun.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("usages", Usages));
      BindableChildren.Add(new KeyValuePair<string, object>("targets", Targets));
      BindableChildren.Add(new KeyValuePair<string, object>("isSearchComplete", _IsSearchComplete));
      BindableChildren.Add(new KeyValuePair<string, object>("canReRun", _CanReRun));
      BindableChildren.Add(new KeyValuePair<string, object>("reRun", _ReRun));
    }
    //secondary constructor
    public RdFindUsagesSession (
      [NotNull] string title,
      [NotNull] RdUsageList usages,
      [NotNull] RdUsageTargetList targets,
      bool showWithSingleUsage,
      [CanBeNull] int? gotoSessionKey
    ) : this (
      title,
      usages,
      targets,
      showWithSingleUsage,
      gotoSessionKey,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdFindUsagesSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var usages = RdUsageList.Read(ctx, reader);
      var targets = RdUsageTargetList.Read(ctx, reader);
      var showWithSingleUsage = reader.ReadBool();
      var gotoSessionKey = ReadIntNullable(ctx, reader);
      var isSearchComplete = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var canReRun = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var reRun = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdFindUsagesSession(title, usages, targets, showWithSingleUsage, gotoSessionKey, isSearchComplete, canReRun, reRun).WithId(_id);
    };
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static CtxWriteDelegate<RdFindUsagesSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      RdUsageList.Write(ctx, writer, value.Usages);
      RdUsageTargetList.Write(ctx, writer, value.Targets);
      writer.Write(value.ShowWithSingleUsage);
      WriteIntNullable(ctx, writer, value.GotoSessionKey);
      RdProperty<bool>.Write(ctx, writer, value._IsSearchComplete);
      RdProperty<bool>.Write(ctx, writer, value._CanReRun);
      RdSignal<RdVoid>.Write(ctx, writer, value._ReRun);
    };
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdFindUsagesSession (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("usages = "); Usages.PrintEx(printer); printer.Println();
        printer.Print("targets = "); Targets.PrintEx(printer); printer.Println();
        printer.Print("showWithSingleUsage = "); ShowWithSingleUsage.PrintEx(printer); printer.Println();
        printer.Print("gotoSessionKey = "); GotoSessionKey.PrintEx(printer); printer.Println();
        printer.Print("isSearchComplete = "); _IsSearchComplete.PrintEx(printer); printer.Println();
        printer.Print("canReRun = "); _CanReRun.PrintEx(printer); printer.Println();
        printer.Print("reRun = "); _ReRun.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdHighlights : IPrintable, IEquatable<RdHighlights> {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.TextControlId TextControlId {get; private set;}
    [NotNull] public List<RdLightUsage> Occurrences {get; private set;}
    
    //private fields
    //primary constructor
    public RdHighlights(
      [NotNull] JetBrains.Rider.Model.TextControlId textControlId,
      [NotNull] List<RdLightUsage> occurrences
    )
    {
      if (textControlId == null) throw new ArgumentNullException("textControlId");
      if (occurrences == null) throw new ArgumentNullException("occurrences");
      
      TextControlId = textControlId;
      Occurrences = occurrences;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdHighlights> Read = (ctx, reader) => 
    {
      var textControlId = JetBrains.Rider.Model.TextControlId.Read(ctx, reader);
      var occurrences = ReadRdLightUsageList(ctx, reader);
      return new RdHighlights(textControlId, occurrences);
    };
    public static CtxReadDelegate<List<RdLightUsage>> ReadRdLightUsageList = RdLightUsage.Read.List();
    
    public static CtxWriteDelegate<RdHighlights> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.TextControlId.Write(ctx, writer, value.TextControlId);
      WriteRdLightUsageList(ctx, writer, value.Occurrences);
    };
    public static CtxWriteDelegate<List<RdLightUsage>> WriteRdLightUsageList = RdLightUsage.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdHighlights) obj);
    }
    public bool Equals(RdHighlights other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextControlId, other.TextControlId) && Occurrences.SequenceEqual(other.Occurrences);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + TextControlId.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Occurrences);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdHighlights (");
      using (printer.IndentCookie()) {
        printer.Print("textControlId = "); TextControlId.PrintEx(printer); printer.Println();
        printer.Print("occurrences = "); Occurrences.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLightUsage : IPrintable, IEquatable<RdLightUsage> {
    //fields
    //public fields
    public int Start {get; private set;}
    public int End {get; private set;}
    public RdUsageKind Kind {get; private set;}
    
    //private fields
    //primary constructor
    public RdLightUsage(
      int start,
      int end,
      RdUsageKind kind
    )
    {
      Start = start;
      End = end;
      Kind = kind;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLightUsage> Read = (ctx, reader) => 
    {
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var kind = (RdUsageKind)reader.ReadInt();
      return new RdLightUsage(start, end, kind);
    };
    
    public static CtxWriteDelegate<RdLightUsage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Start);
      writer.Write(value.End);
      writer.Write((int)value.Kind);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLightUsage) obj);
    }
    public bool Equals(RdLightUsage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Start == other.Start && End == other.End && Kind == other.Kind;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        hash = hash * 31 + (int) Kind;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLightUsage (");
      using (printer.IndentCookie()) {
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMergeableUsage : RdUsageBase
   {
    //fields
    //public fields
    [NotNull] public RdUsagePosition Position {get; private set;}
    
    //private fields
    //primary constructor
    public RdMergeableUsage(
      [NotNull] RdUsagePosition position,
      int index,
      [NotNull] string text,
      bool isAccessedForReading,
      bool isAccessedForWriting,
      int startOffset,
      int endOffset,
      [NotNull] string fileId,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<RdUsageGroup> groups
    ) : base (
      index,
      text,
      isAccessedForReading,
      isAccessedForWriting,
      startOffset,
      endOffset,
      fileId,
      icon,
      groups
     ) 
    {
      if (position == null) throw new ArgumentNullException("position");
      
      Position = position;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdMergeableUsage> Read = (ctx, reader) => 
    {
      var index = reader.ReadInt();
      var text = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var isAccessedForReading = reader.ReadBool();
      var isAccessedForWriting = reader.ReadBool();
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      var fileId = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var groups = ReadRdUsageGroupList(ctx, reader);
      var position = RdUsagePosition.Read(ctx, reader);
      return new RdMergeableUsage(position, index, text, isAccessedForReading, isAccessedForWriting, startOffset, endOffset, fileId, icon, groups);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<RdUsageGroup>> ReadRdUsageGroupList = RdUsageGroup.Read.List();
    
    public static new CtxWriteDelegate<RdMergeableUsage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Index);
      ctx.WriteInterned(writer, value.Text, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.IsAccessedForReading);
      writer.Write(value.IsAccessedForWriting);
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
      writer.Write(value.FileId);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteRdUsageGroupList(ctx, writer, value.Groups);
      RdUsagePosition.Write(ctx, writer, value.Position);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<RdUsageGroup>> WriteRdUsageGroupList = RdUsageGroup.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdMergeableUsage) obj);
    }
    public bool Equals(RdMergeableUsage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Position, other.Position) && Index == other.Index && Equals(Text, other.Text) && IsAccessedForReading == other.IsAccessedForReading && IsAccessedForWriting == other.IsAccessedForWriting && StartOffset == other.StartOffset && EndOffset == other.EndOffset && FileId == other.FileId && Equals(Icon, other.Icon) && Groups.SequenceEqual(other.Groups);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Position.GetHashCode();
        hash = hash * 31 + Index.GetHashCode();
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + IsAccessedForReading.GetHashCode();
        hash = hash * 31 + IsAccessedForWriting.GetHashCode();
        hash = hash * 31 + StartOffset.GetHashCode();
        hash = hash * 31 + EndOffset.GetHashCode();
        hash = hash * 31 + FileId.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(Groups);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdMergeableUsage (");
      using (printer.IndentCookie()) {
        printer.Print("position = "); Position.PrintEx(printer); printer.Println();
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("isAccessedForReading = "); IsAccessedForReading.PrintEx(printer); printer.Println();
        printer.Print("isAccessedForWriting = "); IsAccessedForWriting.PrintEx(printer); printer.Println();
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
        printer.Print("fileId = "); FileId.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("groups = "); Groups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsage : RdUsageBase
   {
    //fields
    //public fields
    [NotNull] public ModelRichText DisplayName {get; private set;}
    
    //private fields
    //primary constructor
    public RdUsage(
      [NotNull] ModelRichText displayName,
      int index,
      [NotNull] string text,
      bool isAccessedForReading,
      bool isAccessedForWriting,
      int startOffset,
      int endOffset,
      [NotNull] string fileId,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<RdUsageGroup> groups
    ) : base (
      index,
      text,
      isAccessedForReading,
      isAccessedForWriting,
      startOffset,
      endOffset,
      fileId,
      icon,
      groups
     ) 
    {
      if (displayName == null) throw new ArgumentNullException("displayName");
      
      DisplayName = displayName;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdUsage> Read = (ctx, reader) => 
    {
      var index = reader.ReadInt();
      var text = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var isAccessedForReading = reader.ReadBool();
      var isAccessedForWriting = reader.ReadBool();
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      var fileId = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var groups = ReadRdUsageGroupList(ctx, reader);
      var displayName = ModelRichText.Read(ctx, reader);
      return new RdUsage(displayName, index, text, isAccessedForReading, isAccessedForWriting, startOffset, endOffset, fileId, icon, groups);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<RdUsageGroup>> ReadRdUsageGroupList = RdUsageGroup.Read.List();
    
    public static new CtxWriteDelegate<RdUsage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Index);
      ctx.WriteInterned(writer, value.Text, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.IsAccessedForReading);
      writer.Write(value.IsAccessedForWriting);
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
      writer.Write(value.FileId);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteRdUsageGroupList(ctx, writer, value.Groups);
      ModelRichText.Write(ctx, writer, value.DisplayName);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<RdUsageGroup>> WriteRdUsageGroupList = RdUsageGroup.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUsage) obj);
    }
    public bool Equals(RdUsage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(DisplayName, other.DisplayName) && Index == other.Index && Equals(Text, other.Text) && IsAccessedForReading == other.IsAccessedForReading && IsAccessedForWriting == other.IsAccessedForWriting && StartOffset == other.StartOffset && EndOffset == other.EndOffset && FileId == other.FileId && Equals(Icon, other.Icon) && Groups.SequenceEqual(other.Groups);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DisplayName.GetHashCode();
        hash = hash * 31 + Index.GetHashCode();
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + IsAccessedForReading.GetHashCode();
        hash = hash * 31 + IsAccessedForWriting.GetHashCode();
        hash = hash * 31 + StartOffset.GetHashCode();
        hash = hash * 31 + EndOffset.GetHashCode();
        hash = hash * 31 + FileId.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(Groups);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsage (");
      using (printer.IndentCookie()) {
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("isAccessedForReading = "); IsAccessedForReading.PrintEx(printer); printer.Println();
        printer.Print("isAccessedForWriting = "); IsAccessedForWriting.PrintEx(printer); printer.Println();
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
        printer.Print("fileId = "); FileId.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("groups = "); Groups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdUsageBase {
    //fields
    //public fields
    public int Index {get; private set;}
    [NotNull] public string Text {get; private set;}
    public bool IsAccessedForReading {get; private set;}
    public bool IsAccessedForWriting {get; private set;}
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    [NotNull] public string FileId {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public List<RdUsageGroup> Groups {get; private set;}
    
    //private fields
    //primary constructor
    protected RdUsageBase(
      int index,
      [NotNull] string text,
      bool isAccessedForReading,
      bool isAccessedForWriting,
      int startOffset,
      int endOffset,
      [NotNull] string fileId,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<RdUsageGroup> groups
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      if (fileId == null) throw new ArgumentNullException("fileId");
      if (groups == null) throw new ArgumentNullException("groups");
      
      Index = index;
      Text = text;
      IsAccessedForReading = isAccessedForReading;
      IsAccessedForWriting = isAccessedForWriting;
      StartOffset = startOffset;
      EndOffset = endOffset;
      FileId = fileId;
      Icon = icon;
      Groups = groups;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsageBase> Read = Polymorphic<RdUsageBase>.ReadAbstract(RdUsageBase_Unknown.Read);
    
    public static CtxWriteDelegate<RdUsageBase> Write = Polymorphic<RdUsageBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdUsageBase_Unknown : RdUsageBase
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public RdUsageBase_Unknown(
      int index,
      [NotNull] string text,
      bool isAccessedForReading,
      bool isAccessedForWriting,
      int startOffset,
      int endOffset,
      [NotNull] string fileId,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<RdUsageGroup> groups
    ) : base (
      index,
      text,
      isAccessedForReading,
      isAccessedForWriting,
      startOffset,
      endOffset,
      fileId,
      icon,
      groups
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdUsageBase_Unknown> Read = (ctx, reader) => 
    {
      var index = reader.ReadInt();
      var text = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var isAccessedForReading = reader.ReadBool();
      var isAccessedForWriting = reader.ReadBool();
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      var fileId = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var groups = ReadRdUsageGroupList(ctx, reader);
      return new RdUsageBase_Unknown(index, text, isAccessedForReading, isAccessedForWriting, startOffset, endOffset, fileId, icon, groups);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<RdUsageGroup>> ReadRdUsageGroupList = RdUsageGroup.Read.List();
    
    public static new CtxWriteDelegate<RdUsageBase_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Index);
      ctx.WriteInterned(writer, value.Text, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.IsAccessedForReading);
      writer.Write(value.IsAccessedForWriting);
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
      writer.Write(value.FileId);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteRdUsageGroupList(ctx, writer, value.Groups);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<RdUsageGroup>> WriteRdUsageGroupList = RdUsageGroup.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUsageBase_Unknown) obj);
    }
    public bool Equals(RdUsageBase_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Index == other.Index && Equals(Text, other.Text) && IsAccessedForReading == other.IsAccessedForReading && IsAccessedForWriting == other.IsAccessedForWriting && StartOffset == other.StartOffset && EndOffset == other.EndOffset && FileId == other.FileId && Equals(Icon, other.Icon) && Groups.SequenceEqual(other.Groups);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Index.GetHashCode();
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + IsAccessedForReading.GetHashCode();
        hash = hash * 31 + IsAccessedForWriting.GetHashCode();
        hash = hash * 31 + StartOffset.GetHashCode();
        hash = hash * 31 + EndOffset.GetHashCode();
        hash = hash * 31 + FileId.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(Groups);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("isAccessedForReading = "); IsAccessedForReading.PrintEx(printer); printer.Println();
        printer.Print("isAccessedForWriting = "); IsAccessedForWriting.PrintEx(printer); printer.Println();
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
        printer.Print("fileId = "); FileId.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("groups = "); Groups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageGroup : IPrintable, IEquatable<RdUsageGroup> {
    //fields
    //public fields
    [NotNull] public string GroupingRuleName {get; private set;}
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    public RdUsageGroup(
      [NotNull] string groupingRuleName,
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (groupingRuleName == null) throw new ArgumentNullException("groupingRuleName");
      if (text == null) throw new ArgumentNullException("text");
      
      GroupingRuleName = groupingRuleName;
      Text = text;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsageGroup> Read = (ctx, reader) => 
    {
      var groupingRuleName = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var text = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var icon = ReadIconNullable(ctx, reader);
      return new RdUsageGroup(groupingRuleName, text, icon);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<RdUsageGroup> Write = (ctx, writer, value) => 
    {
      ctx.WriteInterned(writer, value.GroupingRuleName, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      ctx.WriteInterned(writer, value.Text, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUsageGroup) obj);
    }
    public bool Equals(RdUsageGroup other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(GroupingRuleName, other.GroupingRuleName) && Equals(Text, other.Text) && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + GroupingRuleName.GetHashCode();
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageGroup (");
      using (printer.IndentCookie()) {
        printer.Print("groupingRuleName = "); GroupingRuleName.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageGroupNavigationData : IPrintable, IEquatable<RdUsageGroupNavigationData> {
    //fields
    //public fields
    public int UsageIndex {get; private set;}
    [NotNull] public string GroupingRuleName {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //private fields
    //primary constructor
    public RdUsageGroupNavigationData(
      int usageIndex,
      [NotNull] string groupingRuleName,
      bool requestFocus
    )
    {
      if (groupingRuleName == null) throw new ArgumentNullException("groupingRuleName");
      
      UsageIndex = usageIndex;
      GroupingRuleName = groupingRuleName;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsageGroupNavigationData> Read = (ctx, reader) => 
    {
      var usageIndex = reader.ReadInt();
      var groupingRuleName = reader.ReadString();
      var requestFocus = reader.ReadBool();
      return new RdUsageGroupNavigationData(usageIndex, groupingRuleName, requestFocus);
    };
    
    public static CtxWriteDelegate<RdUsageGroupNavigationData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.UsageIndex);
      writer.Write(value.GroupingRuleName);
      writer.Write(value.RequestFocus);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUsageGroupNavigationData) obj);
    }
    public bool Equals(RdUsageGroupNavigationData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return UsageIndex == other.UsageIndex && GroupingRuleName == other.GroupingRuleName && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + UsageIndex.GetHashCode();
        hash = hash * 31 + GroupingRuleName.GetHashCode();
        hash = hash * 31 + RequestFocus.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageGroupNavigationData (");
      using (printer.IndentCookie()) {
        printer.Print("usageIndex = "); UsageIndex.PrintEx(printer); printer.Println();
        printer.Print("groupingRuleName = "); GroupingRuleName.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageGroupingRule : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string GroupingRuleName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public bool IsSeparable {get; private set;}
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    public bool IsNavigateable {get; private set;}
    public bool Configurable {get; private set;}
    public bool PriorityDependsOnUsages {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Enabled;
    
    //primary constructor
    private RdUsageGroupingRule(
      [NotNull] string groupingRuleName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      bool isSeparable,
      [NotNull] RdProperty<bool> enabled,
      bool isNavigateable,
      bool configurable,
      bool priorityDependsOnUsages
    )
    {
      if (groupingRuleName == null) throw new ArgumentNullException("groupingRuleName");
      if (enabled == null) throw new ArgumentNullException("enabled");
      
      GroupingRuleName = groupingRuleName;
      Icon = icon;
      IsSeparable = isSeparable;
      _Enabled = enabled;
      IsNavigateable = isNavigateable;
      Configurable = configurable;
      PriorityDependsOnUsages = priorityDependsOnUsages;
      _Enabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("enabled", _Enabled));
    }
    //secondary constructor
    public RdUsageGroupingRule (
      [NotNull] string groupingRuleName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      bool isSeparable,
      bool isNavigateable,
      bool configurable,
      bool priorityDependsOnUsages
    ) : this (
      groupingRuleName,
      icon,
      isSeparable,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      isNavigateable,
      configurable,
      priorityDependsOnUsages
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUsageGroupingRule> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var groupingRuleName = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var isSeparable = reader.ReadBool();
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isNavigateable = reader.ReadBool();
      var configurable = reader.ReadBool();
      var priorityDependsOnUsages = reader.ReadBool();
      return new RdUsageGroupingRule(groupingRuleName, icon, isSeparable, enabled, isNavigateable, configurable, priorityDependsOnUsages).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<RdUsageGroupingRule> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.GroupingRuleName);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.IsSeparable);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      writer.Write(value.IsNavigateable);
      writer.Write(value.Configurable);
      writer.Write(value.PriorityDependsOnUsages);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageGroupingRule (");
      using (printer.IndentCookie()) {
        printer.Print("groupingRuleName = "); GroupingRuleName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("isSeparable = "); IsSeparable.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("isNavigateable = "); IsNavigateable.PrintEx(printer); printer.Println();
        printer.Print("configurable = "); Configurable.PrintEx(printer); printer.Println();
        printer.Print("priorityDependsOnUsages = "); PriorityDependsOnUsages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageGroupingRuleList : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<RdUsageGroupingRule> Items {get; private set;}
    
    //private fields
    //primary constructor
    public RdUsageGroupingRuleList(
      [NotNull] List<RdUsageGroupingRule> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
      BindableChildren.Add(new KeyValuePair<string, object>("items", Items));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsageGroupingRuleList> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var items = ReadRdUsageGroupingRuleList(ctx, reader);
      return new RdUsageGroupingRuleList(items).WithId(_id);
    };
    public static CtxReadDelegate<List<RdUsageGroupingRule>> ReadRdUsageGroupingRuleList = RdUsageGroupingRule.Read.List();
    
    public static CtxWriteDelegate<RdUsageGroupingRuleList> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteRdUsageGroupingRuleList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<RdUsageGroupingRule>> WriteRdUsageGroupingRuleList = RdUsageGroupingRule.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageGroupingRuleList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdUsageKind {
    Target,
    ReadUsage,
    WriteUsage,
    Navigation,
    Other
  }
  
  
  public class RdUsageList : RdBindableBase {
    //fields
    //public fields
    [NotNull] public RdVoid GeneratorPlease {get; private set;}
    [NotNull] public IViewableMap<int, List<RdUsageBase>> Items { get { return _Items; }}
    [NotNull] public ISink<RdUsageNavigationData> NavigateTo { get { return _NavigateTo; }}
    [NotNull] public ISink<RdUsageGroupNavigationData> NavigateToGroup { get { return _NavigateToGroup; }}
    [NotNull] public RdEndpoint<int, bool> UpdateItem { get { return _UpdateItem; }}
    
    //private fields
    [NotNull] private readonly RdMap<int, List<RdUsageBase>> _Items;
    [NotNull] private readonly RdSignal<RdUsageNavigationData> _NavigateTo;
    [NotNull] private readonly RdSignal<RdUsageGroupNavigationData> _NavigateToGroup;
    [NotNull] private readonly RdEndpoint<int, bool> _UpdateItem;
    
    private SerializationCtx mySerializationContext;
    public override SerializationCtx SerializationContext { get { return mySerializationContext; } }
    //primary constructor
    private RdUsageList(
      [NotNull] RdVoid generatorPlease,
      [NotNull] RdMap<int, List<RdUsageBase>> items,
      [NotNull] RdSignal<RdUsageNavigationData> navigateTo,
      [NotNull] RdSignal<RdUsageGroupNavigationData> navigateToGroup,
      [NotNull] RdEndpoint<int, bool> updateItem
    )
    {
      if (generatorPlease == null) throw new ArgumentNullException("generatorPlease");
      if (items == null) throw new ArgumentNullException("items");
      if (navigateTo == null) throw new ArgumentNullException("navigateTo");
      if (navigateToGroup == null) throw new ArgumentNullException("navigateToGroup");
      if (updateItem == null) throw new ArgumentNullException("updateItem");
      
      GeneratorPlease = generatorPlease;
      _Items = items;
      _NavigateTo = navigateTo;
      _NavigateToGroup = navigateToGroup;
      _UpdateItem = updateItem;
      _Items.OptimizeNested = true;
      _UpdateItem.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("items", _Items));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateTo", _NavigateTo));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateToGroup", _NavigateToGroup));
      BindableChildren.Add(new KeyValuePair<string, object>("updateItem", _UpdateItem));
    }
    //secondary constructor
    public RdUsageList (
      [NotNull] RdVoid generatorPlease
    ) : this (
      generatorPlease,
      new RdMap<int, List<RdUsageBase>>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, ReadRdUsageBaseList, WriteRdUsageBaseList),
      new RdSignal<RdUsageNavigationData>(RdUsageNavigationData.Read, RdUsageNavigationData.Write),
      new RdSignal<RdUsageGroupNavigationData>(RdUsageGroupNavigationData.Read, RdUsageGroupNavigationData.Write),
      new RdEndpoint<int, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUsageList> Read = (ctx, reader) => 
    {
      ctx = ctx.WithInternRootHere(false);
      var _id = RdId.Read(reader);
      var generatorPlease = reader.ReadVoid();
      var items = RdMap<int, List<RdUsageBase>>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, ReadRdUsageBaseList, WriteRdUsageBaseList);
      var navigateTo = RdSignal<RdUsageNavigationData>.Read(ctx, reader, RdUsageNavigationData.Read, RdUsageNavigationData.Write);
      var navigateToGroup = RdSignal<RdUsageGroupNavigationData>.Read(ctx, reader, RdUsageGroupNavigationData.Read, RdUsageGroupNavigationData.Write);
      var updateItem = RdEndpoint<int, bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new RdUsageList(generatorPlease, items, navigateTo, navigateToGroup, updateItem) { mySerializationContext = ctx }.WithId(_id);
    };
    public static CtxReadDelegate<List<RdUsageBase>> ReadRdUsageBaseList = RdUsageBase.Read.List();
    
    public static CtxWriteDelegate<RdUsageList> Write = (ctx, writer, value) => 
    {
      ctx = ctx.WithInternRootHere(true);
      value.mySerializationContext = ctx;
      value.RdId.Write(writer);
      writer.Write(value.GeneratorPlease);
      RdMap<int, List<RdUsageBase>>.Write(ctx, writer, value._Items);
      RdSignal<RdUsageNavigationData>.Write(ctx, writer, value._NavigateTo);
      RdSignal<RdUsageGroupNavigationData>.Write(ctx, writer, value._NavigateToGroup);
      RdEndpoint<int, bool>.Write(ctx, writer, value._UpdateItem);
    };
    public static CtxWriteDelegate<List<RdUsageBase>> WriteRdUsageBaseList = RdUsageBase.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageList (");
      using (printer.IndentCookie()) {
        printer.Print("generatorPlease = "); GeneratorPlease.PrintEx(printer); printer.Println();
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("navigateTo = "); _NavigateTo.PrintEx(printer); printer.Println();
        printer.Print("navigateToGroup = "); _NavigateToGroup.PrintEx(printer); printer.Println();
        printer.Print("updateItem = "); _UpdateItem.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageNavigationData : IPrintable, IEquatable<RdUsageNavigationData> {
    //fields
    //public fields
    public int Index {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //private fields
    //primary constructor
    public RdUsageNavigationData(
      int index,
      bool requestFocus
    )
    {
      Index = index;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsageNavigationData> Read = (ctx, reader) => 
    {
      var index = reader.ReadInt();
      var requestFocus = reader.ReadBool();
      return new RdUsageNavigationData(index, requestFocus);
    };
    
    public static CtxWriteDelegate<RdUsageNavigationData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Index);
      writer.Write(value.RequestFocus);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUsageNavigationData) obj);
    }
    public bool Equals(RdUsageNavigationData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Index == other.Index && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Index.GetHashCode();
        hash = hash * 31 + RequestFocus.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageNavigationData (");
      using (printer.IndentCookie()) {
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsagePosition : IPrintable, IEquatable<RdUsagePosition> {
    //fields
    //public fields
    public int Line {get; private set;}
    public int Column {get; private set;}
    public int OccurrenceRangeStartOffset {get; private set;}
    public int OccurrenceRangeEndOffset {get; private set;}
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    [NotNull] public string DocumentMoniker {get; private set;}
    
    //private fields
    //primary constructor
    public RdUsagePosition(
      int line,
      int column,
      int occurrenceRangeStartOffset,
      int occurrenceRangeEndOffset,
      int startOffset,
      int endOffset,
      [NotNull] string documentMoniker
    )
    {
      if (documentMoniker == null) throw new ArgumentNullException("documentMoniker");
      
      Line = line;
      Column = column;
      OccurrenceRangeStartOffset = occurrenceRangeStartOffset;
      OccurrenceRangeEndOffset = occurrenceRangeEndOffset;
      StartOffset = startOffset;
      EndOffset = endOffset;
      DocumentMoniker = documentMoniker;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsagePosition> Read = (ctx, reader) => 
    {
      var line = reader.ReadInt();
      var column = reader.ReadInt();
      var occurrenceRangeStartOffset = reader.ReadInt();
      var occurrenceRangeEndOffset = reader.ReadInt();
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      var documentMoniker = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      return new RdUsagePosition(line, column, occurrenceRangeStartOffset, occurrenceRangeEndOffset, startOffset, endOffset, documentMoniker);
    };
    
    public static CtxWriteDelegate<RdUsagePosition> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Line);
      writer.Write(value.Column);
      writer.Write(value.OccurrenceRangeStartOffset);
      writer.Write(value.OccurrenceRangeEndOffset);
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
      ctx.WriteInterned(writer, value.DocumentMoniker, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUsagePosition) obj);
    }
    public bool Equals(RdUsagePosition other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Line == other.Line && Column == other.Column && OccurrenceRangeStartOffset == other.OccurrenceRangeStartOffset && OccurrenceRangeEndOffset == other.OccurrenceRangeEndOffset && StartOffset == other.StartOffset && EndOffset == other.EndOffset && Equals(DocumentMoniker, other.DocumentMoniker);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Line.GetHashCode();
        hash = hash * 31 + Column.GetHashCode();
        hash = hash * 31 + OccurrenceRangeStartOffset.GetHashCode();
        hash = hash * 31 + OccurrenceRangeEndOffset.GetHashCode();
        hash = hash * 31 + StartOffset.GetHashCode();
        hash = hash * 31 + EndOffset.GetHashCode();
        hash = hash * 31 + DocumentMoniker.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsagePosition (");
      using (printer.IndentCookie()) {
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
        printer.Print("column = "); Column.PrintEx(printer); printer.Println();
        printer.Print("occurrenceRangeStartOffset = "); OccurrenceRangeStartOffset.PrintEx(printer); printer.Println();
        printer.Print("occurrenceRangeEndOffset = "); OccurrenceRangeEndOffset.PrintEx(printer); printer.Println();
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
        printer.Print("documentMoniker = "); DocumentMoniker.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageTarget : RdBindableBase {
    //fields
    //public fields
    public int Index {get; private set;}
    [NotNull] public string ShortName {get; private set;}
    [NotNull] public string FullName {get; private set;}
    [NotNull] public IRdProperty<bool> IsValid { get { return _IsValid; }}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsValid;
    
    //primary constructor
    private RdUsageTarget(
      int index,
      [NotNull] string shortName,
      [NotNull] string fullName,
      [NotNull] RdProperty<bool> isValid,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (shortName == null) throw new ArgumentNullException("shortName");
      if (fullName == null) throw new ArgumentNullException("fullName");
      if (isValid == null) throw new ArgumentNullException("isValid");
      
      Index = index;
      ShortName = shortName;
      FullName = fullName;
      _IsValid = isValid;
      Icon = icon;
      _IsValid.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isValid", _IsValid));
    }
    //secondary constructor
    public RdUsageTarget (
      int index,
      [NotNull] string shortName,
      [NotNull] string fullName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      index,
      shortName,
      fullName,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      icon
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUsageTarget> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var index = reader.ReadInt();
      var shortName = reader.ReadString();
      var fullName = reader.ReadString();
      var isValid = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var icon = ReadIconNullable(ctx, reader);
      return new RdUsageTarget(index, shortName, fullName, isValid, icon).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<RdUsageTarget> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Index);
      writer.Write(value.ShortName);
      writer.Write(value.FullName);
      RdProperty<bool>.Write(ctx, writer, value._IsValid);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageTarget (");
      using (printer.IndentCookie()) {
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("shortName = "); ShortName.PrintEx(printer); printer.Println();
        printer.Print("fullName = "); FullName.PrintEx(printer); printer.Println();
        printer.Print("isValid = "); _IsValid.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageTargetList : RdBindableBase {
    //fields
    //public fields
    [CanBeNull] public string Title {get; private set;}
    [NotNull] public List<RdUsageTarget> Items {get; private set;}
    [NotNull] public ISink<RdUsageTargetNavigationData> NavigateTo { get { return _NavigateTo; }}
    [NotNull] public RdEndpoint<int, RdVoid> UpdateItem { get { return _UpdateItem; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdUsageTargetNavigationData> _NavigateTo;
    [NotNull] private readonly RdEndpoint<int, RdVoid> _UpdateItem;
    
    //primary constructor
    private RdUsageTargetList(
      [CanBeNull] string title,
      [NotNull] List<RdUsageTarget> items,
      [NotNull] RdSignal<RdUsageTargetNavigationData> navigateTo,
      [NotNull] RdEndpoint<int, RdVoid> updateItem
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      if (navigateTo == null) throw new ArgumentNullException("navigateTo");
      if (updateItem == null) throw new ArgumentNullException("updateItem");
      
      Title = title;
      Items = items;
      _NavigateTo = navigateTo;
      _UpdateItem = updateItem;
      BindableChildren.Add(new KeyValuePair<string, object>("items", Items));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateTo", _NavigateTo));
      BindableChildren.Add(new KeyValuePair<string, object>("updateItem", _UpdateItem));
    }
    //secondary constructor
    public RdUsageTargetList (
      [CanBeNull] string title,
      [NotNull] List<RdUsageTarget> items
    ) : this (
      title,
      items,
      new RdSignal<RdUsageTargetNavigationData>(RdUsageTargetNavigationData.Read, RdUsageTargetNavigationData.Write),
      new RdEndpoint<int, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUsageTargetList> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = ReadStringNullable(ctx, reader);
      var items = ReadRdUsageTargetList(ctx, reader);
      var navigateTo = RdSignal<RdUsageTargetNavigationData>.Read(ctx, reader, RdUsageTargetNavigationData.Read, RdUsageTargetNavigationData.Write);
      var updateItem = RdEndpoint<int, RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdUsageTargetList(title, items, navigateTo, updateItem).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<RdUsageTarget>> ReadRdUsageTargetList = RdUsageTarget.Read.List();
    
    public static CtxWriteDelegate<RdUsageTargetList> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.Title);
      WriteRdUsageTargetList(ctx, writer, value.Items);
      RdSignal<RdUsageTargetNavigationData>.Write(ctx, writer, value._NavigateTo);
      RdEndpoint<int, RdVoid>.Write(ctx, writer, value._UpdateItem);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<RdUsageTarget>> WriteRdUsageTargetList = RdUsageTarget.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageTargetList (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
        printer.Print("navigateTo = "); _NavigateTo.PrintEx(printer); printer.Println();
        printer.Print("updateItem = "); _UpdateItem.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageTargetNavigationData : IPrintable, IEquatable<RdUsageTargetNavigationData> {
    //fields
    //public fields
    public int Index {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //private fields
    //primary constructor
    public RdUsageTargetNavigationData(
      int index,
      bool requestFocus
    )
    {
      Index = index;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsageTargetNavigationData> Read = (ctx, reader) => 
    {
      var index = reader.ReadInt();
      var requestFocus = reader.ReadBool();
      return new RdUsageTargetNavigationData(index, requestFocus);
    };
    
    public static CtxWriteDelegate<RdUsageTargetNavigationData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Index);
      writer.Write(value.RequestFocus);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUsageTargetNavigationData) obj);
    }
    public bool Equals(RdUsageTargetNavigationData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Index == other.Index && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Index.GetHashCode();
        hash = hash * 31 + RequestFocus.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageTargetNavigationData (");
      using (printer.IndentCookie()) {
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
