using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.HighlighterRegistration
{
  
  
  [JetBrains.Application.ShellComponent]
  public class HighlighterRegistrationHostModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> BackendReady { get { return _BackendReady; }}
    [NotNull] public IRdProperty<AbstractRegistryModel> Registry { get { return _Registry; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _BackendReady;
    [NotNull] private readonly RdProperty<AbstractRegistryModel> _Registry;
    
    //primary constructor
    private HighlighterRegistrationHostModel(
      [NotNull] RdProperty<bool> backendReady,
      [NotNull] RdProperty<AbstractRegistryModel> registry
    )
    {
      if (backendReady == null) throw new ArgumentNullException("backendReady");
      if (registry == null) throw new ArgumentNullException("registry");
      
      _BackendReady = backendReady;
      _Registry = registry;
      _BackendReady.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("backendReady", _BackendReady));
      BindableChildren.Add(new KeyValuePair<string, object>("registry", _Registry));
    }
    //secondary constructor
    private HighlighterRegistrationHostModel (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<AbstractRegistryModel>(AbstractRegistryModel.Read, AbstractRegistryModel.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -7167648765567768935L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<IdeaEffectType>();
      serializers.RegisterEnum<RiderDisplayPriority>();
      serializers.Register(IdeaTextAttributes.Read, IdeaTextAttributes.Write);
      serializers.Register(IdeaTextAttributesKey.Read, IdeaTextAttributesKey.Write);
      serializers.RegisterEnum<ReSharperSeverity>();
      serializers.Register(IdeaHighlightInfoType.Read, IdeaHighlightInfoType.Write);
      serializers.RegisterEnum<RiderHighlighterModelKind>();
      serializers.RegisterEnum<GreedySide>();
      serializers.Register(RiderHighlighterProperties.Read, RiderHighlighterProperties.Write);
      serializers.Register(RiderHighlighterRegistrationPack.Read, RiderHighlighterRegistrationPack.Write);
      serializers.RegisterEnum<RiderKnownColorsSchemeModels>();
      serializers.Register(RiderColorsSchemeEntry.Read, RiderColorsSchemeEntry.Write);
      serializers.Register(RiderColorsSchemeModel.Read, RiderColorsSchemeModel.Write);
      serializers.Register(HighlighterData.Read, HighlighterData.Write);
      serializers.Register(RiderColorSettingsPageModel.Read, RiderColorSettingsPageModel.Write);
      serializers.Register(DefaultRegistryModel.Read, DefaultRegistryModel.Write);
      serializers.Register(CachedRegistryModel.Read, CachedRegistryModel.Write);
      serializers.Register(MyList.Read, MyList.Write);
      
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.IdeRoot), JetBrains.Rider.Model.IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public HighlighterRegistrationHostModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("HighlighterRegistrationHostModel (");
      using (printer.IndentCookie()) {
        printer.Print("backendReady = "); _BackendReady.PrintEx(printer); printer.Println();
        printer.Print("registry = "); _Registry.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class AbstractRegistryModel : RdBindableBase {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AbstractRegistryModel> Read = Polymorphic<AbstractRegistryModel>.ReadAbstract(AbstractRegistryModel_Unknown.Read);
    
    public static CtxWriteDelegate<AbstractRegistryModel> Write = Polymorphic<AbstractRegistryModel>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class AbstractRegistryModel_Unknown : AbstractRegistryModel
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<AbstractRegistryModel_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new AbstractRegistryModel_Unknown().WithId(_id);
    };
    
    public static new CtxWriteDelegate<AbstractRegistryModel_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("AbstractRegistryModel_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CachedRegistryModel : AbstractRegistryModel
   {
    //fields
    //public fields
    [NotNull] public List<string> CachedAttributesIds {get; private set;}
    
    //private fields
    //primary constructor
    public CachedRegistryModel(
      [NotNull] List<string> cachedAttributesIds
    )
    {
      if (cachedAttributesIds == null) throw new ArgumentNullException("cachedAttributesIds");
      
      CachedAttributesIds = cachedAttributesIds;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CachedRegistryModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var cachedAttributesIds = ReadStringList(ctx, reader);
      return new CachedRegistryModel(cachedAttributesIds).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static new CtxWriteDelegate<CachedRegistryModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringList(ctx, writer, value.CachedAttributesIds);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CachedRegistryModel (");
      using (printer.IndentCookie()) {
        printer.Print("cachedAttributesIds = "); CachedAttributesIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DefaultRegistryModel : AbstractRegistryModel
   {
    //fields
    //public fields
    [NotNull] public ISource<MyList> RegistrationPacks { get { return _RegistrationPacks; }}
    [NotNull] public ISource<RiderColorsSchemeModel> ColorsScheme { get { return _ColorsScheme; }}
    [NotNull] public ISource<RiderColorSettingsPageModel> ColorSettingsPage { get { return _ColorSettingsPage; }}
    
    //private fields
    [NotNull] private readonly RdSignal<MyList> _RegistrationPacks;
    [NotNull] private readonly RdSignal<RiderColorsSchemeModel> _ColorsScheme;
    [NotNull] private readonly RdSignal<RiderColorSettingsPageModel> _ColorSettingsPage;
    
    private SerializationCtx mySerializationContext;
    public override SerializationCtx SerializationContext { get { return mySerializationContext; } }
    //primary constructor
    private DefaultRegistryModel(
      [NotNull] RdSignal<MyList> registrationPacks,
      [NotNull] RdSignal<RiderColorsSchemeModel> colorsScheme,
      [NotNull] RdSignal<RiderColorSettingsPageModel> colorSettingsPage
    )
    {
      if (registrationPacks == null) throw new ArgumentNullException("registrationPacks");
      if (colorsScheme == null) throw new ArgumentNullException("colorsScheme");
      if (colorSettingsPage == null) throw new ArgumentNullException("colorSettingsPage");
      
      _RegistrationPacks = registrationPacks;
      _ColorsScheme = colorsScheme;
      _ColorSettingsPage = colorSettingsPage;
      BindableChildren.Add(new KeyValuePair<string, object>("registrationPacks", _RegistrationPacks));
      BindableChildren.Add(new KeyValuePair<string, object>("colorsScheme", _ColorsScheme));
      BindableChildren.Add(new KeyValuePair<string, object>("colorSettingsPage", _ColorSettingsPage));
    }
    //secondary constructor
    public DefaultRegistryModel (
    ) : this (
      new RdSignal<MyList>(MyList.Read, MyList.Write),
      new RdSignal<RiderColorsSchemeModel>(RiderColorsSchemeModel.Read, RiderColorsSchemeModel.Write),
      new RdSignal<RiderColorSettingsPageModel>(RiderColorSettingsPageModel.Read, RiderColorSettingsPageModel.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<DefaultRegistryModel> Read = (ctx, reader) => 
    {
      ctx = ctx.WithInternRootHere(false);
      var _id = RdId.Read(reader);
      var registrationPacks = RdSignal<MyList>.Read(ctx, reader, MyList.Read, MyList.Write);
      var colorsScheme = RdSignal<RiderColorsSchemeModel>.Read(ctx, reader, RiderColorsSchemeModel.Read, RiderColorsSchemeModel.Write);
      var colorSettingsPage = RdSignal<RiderColorSettingsPageModel>.Read(ctx, reader, RiderColorSettingsPageModel.Read, RiderColorSettingsPageModel.Write);
      return new DefaultRegistryModel(registrationPacks, colorsScheme, colorSettingsPage) { mySerializationContext = ctx }.WithId(_id);
    };
    
    public static new CtxWriteDelegate<DefaultRegistryModel> Write = (ctx, writer, value) => 
    {
      ctx = ctx.WithInternRootHere(true);
      value.mySerializationContext = ctx;
      value.RdId.Write(writer);
      RdSignal<MyList>.Write(ctx, writer, value._RegistrationPacks);
      RdSignal<RiderColorsSchemeModel>.Write(ctx, writer, value._ColorsScheme);
      RdSignal<RiderColorSettingsPageModel>.Write(ctx, writer, value._ColorSettingsPage);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DefaultRegistryModel (");
      using (printer.IndentCookie()) {
        printer.Print("registrationPacks = "); _RegistrationPacks.PrintEx(printer); printer.Println();
        printer.Print("colorsScheme = "); _ColorsScheme.PrintEx(printer); printer.Println();
        printer.Print("colorSettingsPage = "); _ColorSettingsPage.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum GreedySide {
    NONE,
    LEFT,
    RIGHT,
    BOTH
  }
  
  
  public class HighlighterData : IPrintable, IEquatable<HighlighterData> {
    //fields
    //public fields
    [NotNull] public string Data {get; private set;}
    [NotNull] public string AttributeId {get; private set;}
    
    //private fields
    //primary constructor
    public HighlighterData(
      [NotNull] string data,
      [NotNull] string attributeId
    )
    {
      if (data == null) throw new ArgumentNullException("data");
      if (attributeId == null) throw new ArgumentNullException("attributeId");
      
      Data = data;
      AttributeId = attributeId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<HighlighterData> Read = (ctx, reader) => 
    {
      var data = reader.ReadString();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      return new HighlighterData(data, attributeId);
    };
    
    public static CtxWriteDelegate<HighlighterData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Data);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((HighlighterData) obj);
    }
    public bool Equals(HighlighterData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Data == other.Data && Equals(AttributeId, other.AttributeId);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Data.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("HighlighterData (");
      using (printer.IndentCookie()) {
        printer.Print("data = "); Data.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum IdeaEffectType {
    LINE_UNDERSCORE,
    WAVE_UNDERSCORE,
    BOXED,
    STRIKEOUT,
    BOLD_LINE_UNDERSCORE,
    BOLD_DOTTED_LINE
  }
  
  
  public class IdeaHighlightInfoType : IPrintable, IEquatable<IdeaHighlightInfoType> {
    //fields
    //public fields
    public ReSharperSeverity Severity {get; private set;}
    [NotNull] public IdeaTextAttributesKey AttributesKey {get; private set;}
    
    //private fields
    //primary constructor
    public IdeaHighlightInfoType(
      ReSharperSeverity severity,
      [NotNull] IdeaTextAttributesKey attributesKey
    )
    {
      if (attributesKey == null) throw new ArgumentNullException("attributesKey");
      
      Severity = severity;
      AttributesKey = attributesKey;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<IdeaHighlightInfoType> Read = (ctx, reader) => 
    {
      var severity = (ReSharperSeverity)reader.ReadInt();
      var attributesKey = IdeaTextAttributesKey.Read(ctx, reader);
      return new IdeaHighlightInfoType(severity, attributesKey);
    };
    
    public static CtxWriteDelegate<IdeaHighlightInfoType> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Severity);
      IdeaTextAttributesKey.Write(ctx, writer, value.AttributesKey);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((IdeaHighlightInfoType) obj);
    }
    public bool Equals(IdeaHighlightInfoType other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Severity == other.Severity && Equals(AttributesKey, other.AttributesKey);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Severity;
        hash = hash * 31 + AttributesKey.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("IdeaHighlightInfoType (");
      using (printer.IndentCookie()) {
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("attributesKey = "); AttributesKey.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IdeaTextAttributes : IPrintable, IEquatable<IdeaTextAttributes> {
    //fields
    //public fields
    [CanBeNull] public JetBrains.Rider.Model.RgbColor ForegroundColor {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.RgbColor BackgroundColor {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.RgbColor EffectColor {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.RgbColor ErrorStripeColor {get; private set;}
    public IdeaEffectType EffectType {get; private set;}
    public int FontType {get; private set;}
    
    //private fields
    //primary constructor
    public IdeaTextAttributes(
      [CanBeNull] JetBrains.Rider.Model.RgbColor foregroundColor,
      [CanBeNull] JetBrains.Rider.Model.RgbColor backgroundColor,
      [CanBeNull] JetBrains.Rider.Model.RgbColor effectColor,
      [CanBeNull] JetBrains.Rider.Model.RgbColor errorStripeColor,
      IdeaEffectType effectType,
      int fontType
    )
    {
      ForegroundColor = foregroundColor;
      BackgroundColor = backgroundColor;
      EffectColor = effectColor;
      ErrorStripeColor = errorStripeColor;
      EffectType = effectType;
      FontType = fontType;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<IdeaTextAttributes> Read = (ctx, reader) => 
    {
      var foregroundColor = ReadRgbColorNullable(ctx, reader);
      var backgroundColor = ReadRgbColorNullable(ctx, reader);
      var effectColor = ReadRgbColorNullable(ctx, reader);
      var errorStripeColor = ReadRgbColorNullable(ctx, reader);
      var effectType = (IdeaEffectType)reader.ReadInt();
      var fontType = reader.ReadInt();
      return new IdeaTextAttributes(foregroundColor, backgroundColor, effectColor, errorStripeColor, effectType, fontType);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.RgbColor> ReadRgbColorNullable = JetBrains.Rider.Model.RgbColor.Read.NullableClass();
    
    public static CtxWriteDelegate<IdeaTextAttributes> Write = (ctx, writer, value) => 
    {
      WriteRgbColorNullable(ctx, writer, value.ForegroundColor);
      WriteRgbColorNullable(ctx, writer, value.BackgroundColor);
      WriteRgbColorNullable(ctx, writer, value.EffectColor);
      WriteRgbColorNullable(ctx, writer, value.ErrorStripeColor);
      writer.Write((int)value.EffectType);
      writer.Write(value.FontType);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.RgbColor> WriteRgbColorNullable = JetBrains.Rider.Model.RgbColor.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((IdeaTextAttributes) obj);
    }
    public bool Equals(IdeaTextAttributes other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(ForegroundColor, other.ForegroundColor) && Equals(BackgroundColor, other.BackgroundColor) && Equals(EffectColor, other.EffectColor) && Equals(ErrorStripeColor, other.ErrorStripeColor) && EffectType == other.EffectType && FontType == other.FontType;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (ForegroundColor != null ?ForegroundColor.GetHashCode() : 0);
        hash = hash * 31 + (BackgroundColor != null ?BackgroundColor.GetHashCode() : 0);
        hash = hash * 31 + (EffectColor != null ?EffectColor.GetHashCode() : 0);
        hash = hash * 31 + (ErrorStripeColor != null ?ErrorStripeColor.GetHashCode() : 0);
        hash = hash * 31 + (int) EffectType;
        hash = hash * 31 + FontType.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("IdeaTextAttributes (");
      using (printer.IndentCookie()) {
        printer.Print("foregroundColor = "); ForegroundColor.PrintEx(printer); printer.Println();
        printer.Print("backgroundColor = "); BackgroundColor.PrintEx(printer); printer.Println();
        printer.Print("effectColor = "); EffectColor.PrintEx(printer); printer.Println();
        printer.Print("errorStripeColor = "); ErrorStripeColor.PrintEx(printer); printer.Println();
        printer.Print("effectType = "); EffectType.PrintEx(printer); printer.Println();
        printer.Print("fontType = "); FontType.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IdeaTextAttributesKey : IPrintable, IEquatable<IdeaTextAttributesKey> {
    //fields
    //public fields
    [NotNull] public string ExternalName {get; private set;}
    [CanBeNull] public string Fallback {get; private set;}
    
    //private fields
    //primary constructor
    public IdeaTextAttributesKey(
      [NotNull] string externalName,
      [CanBeNull] string fallback
    )
    {
      if (externalName == null) throw new ArgumentNullException("externalName");
      
      ExternalName = externalName;
      Fallback = fallback;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<IdeaTextAttributesKey> Read = (ctx, reader) => 
    {
      var externalName = reader.ReadString();
      var fallback = ReadStringNullable(ctx, reader);
      return new IdeaTextAttributesKey(externalName, fallback);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<IdeaTextAttributesKey> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ExternalName);
      WriteStringNullable(ctx, writer, value.Fallback);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((IdeaTextAttributesKey) obj);
    }
    public bool Equals(IdeaTextAttributesKey other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ExternalName == other.ExternalName && Equals(Fallback, other.Fallback);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ExternalName.GetHashCode();
        hash = hash * 31 + (Fallback != null ?Fallback.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("IdeaTextAttributesKey (");
      using (printer.IndentCookie()) {
        printer.Print("externalName = "); ExternalName.PrintEx(printer); printer.Println();
        printer.Print("fallback = "); Fallback.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MyList : IPrintable, IEquatable<MyList> {
    //fields
    //public fields
    [NotNull] public List<RiderHighlighterRegistrationPack> Values {get; private set;}
    
    //private fields
    //primary constructor
    public MyList(
      [NotNull] List<RiderHighlighterRegistrationPack> values
    )
    {
      if (values == null) throw new ArgumentNullException("values");
      
      Values = values;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MyList> Read = (ctx, reader) => 
    {
      var values = ReadRiderHighlighterRegistrationPackList(ctx, reader);
      return new MyList(values);
    };
    public static CtxReadDelegate<List<RiderHighlighterRegistrationPack>> ReadRiderHighlighterRegistrationPackList = RiderHighlighterRegistrationPack.Read.List();
    
    public static CtxWriteDelegate<MyList> Write = (ctx, writer, value) => 
    {
      WriteRiderHighlighterRegistrationPackList(ctx, writer, value.Values);
    };
    public static CtxWriteDelegate<List<RiderHighlighterRegistrationPack>> WriteRiderHighlighterRegistrationPackList = RiderHighlighterRegistrationPack.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MyList) obj);
    }
    public bool Equals(MyList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Values.SequenceEqual(other.Values);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Values);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MyList (");
      using (printer.IndentCookie()) {
        printer.Print("values = "); Values.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ReSharperSeverity {
    INVALID_SEVERITY,
    DO_NOT_SHOW,
    INFO,
    HINT,
    SUGGESTION,
    WARNING,
    ERROR,
    WEAK_WARNING
  }
  
  
  public class RiderColorSettingsPageModel : IPrintable, IEquatable<RiderColorSettingsPageModel> {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    public RiderDisplayPriority Priority {get; private set;}
    [NotNull] public string DemoText {get; private set;}
    [NotNull] public List<HighlighterData> HighlighterTags {get; private set;}
    [NotNull] public List<HighlighterData> PresentableNames {get; private set;}
    
    //private fields
    //primary constructor
    public RiderColorSettingsPageModel(
      [NotNull] string name,
      RiderDisplayPriority priority,
      [NotNull] string demoText,
      [NotNull] List<HighlighterData> highlighterTags,
      [NotNull] List<HighlighterData> presentableNames
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (demoText == null) throw new ArgumentNullException("demoText");
      if (highlighterTags == null) throw new ArgumentNullException("highlighterTags");
      if (presentableNames == null) throw new ArgumentNullException("presentableNames");
      
      Name = name;
      Priority = priority;
      DemoText = demoText;
      HighlighterTags = highlighterTags;
      PresentableNames = presentableNames;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RiderColorSettingsPageModel> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var priority = (RiderDisplayPriority)reader.ReadInt();
      var demoText = reader.ReadString();
      var highlighterTags = ReadHighlighterDataList(ctx, reader);
      var presentableNames = ReadHighlighterDataList(ctx, reader);
      return new RiderColorSettingsPageModel(name, priority, demoText, highlighterTags, presentableNames);
    };
    public static CtxReadDelegate<List<HighlighterData>> ReadHighlighterDataList = HighlighterData.Read.List();
    
    public static CtxWriteDelegate<RiderColorSettingsPageModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write((int)value.Priority);
      writer.Write(value.DemoText);
      WriteHighlighterDataList(ctx, writer, value.HighlighterTags);
      WriteHighlighterDataList(ctx, writer, value.PresentableNames);
    };
    public static CtxWriteDelegate<List<HighlighterData>> WriteHighlighterDataList = HighlighterData.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RiderColorSettingsPageModel) obj);
    }
    public bool Equals(RiderColorSettingsPageModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Priority == other.Priority && DemoText == other.DemoText && HighlighterTags.SequenceEqual(other.HighlighterTags) && PresentableNames.SequenceEqual(other.PresentableNames);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + (int) Priority;
        hash = hash * 31 + DemoText.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(HighlighterTags);
        hash = hash * 31 + Collections.GetHashCode(PresentableNames);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RiderColorSettingsPageModel (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("priority = "); Priority.PrintEx(printer); printer.Println();
        printer.Print("demoText = "); DemoText.PrintEx(printer); printer.Println();
        printer.Print("highlighterTags = "); HighlighterTags.PrintEx(printer); printer.Println();
        printer.Print("presentableNames = "); PresentableNames.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RiderColorsSchemeEntry : IPrintable, IEquatable<RiderColorsSchemeEntry> {
    //fields
    //public fields
    [NotNull] public string AttributeId {get; private set;}
    public bool IsInherited {get; private set;}
    [CanBeNull] public IdeaTextAttributes Attributes {get; private set;}
    
    //private fields
    //primary constructor
    public RiderColorsSchemeEntry(
      [NotNull] string attributeId,
      bool isInherited,
      [CanBeNull] IdeaTextAttributes attributes
    )
    {
      if (attributeId == null) throw new ArgumentNullException("attributeId");
      
      AttributeId = attributeId;
      IsInherited = isInherited;
      Attributes = attributes;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RiderColorsSchemeEntry> Read = (ctx, reader) => 
    {
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var isInherited = reader.ReadBool();
      var attributes = ReadIdeaTextAttributesNullable(ctx, reader);
      return new RiderColorsSchemeEntry(attributeId, isInherited, attributes);
    };
    public static CtxReadDelegate<IdeaTextAttributes> ReadIdeaTextAttributesNullable = IdeaTextAttributes.Read.NullableClass();
    
    public static CtxWriteDelegate<RiderColorsSchemeEntry> Write = (ctx, writer, value) => 
    {
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.IsInherited);
      WriteIdeaTextAttributesNullable(ctx, writer, value.Attributes);
    };
    public static CtxWriteDelegate<IdeaTextAttributes> WriteIdeaTextAttributesNullable = IdeaTextAttributes.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RiderColorsSchemeEntry) obj);
    }
    public bool Equals(RiderColorsSchemeEntry other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(AttributeId, other.AttributeId) && IsInherited == other.IsInherited && Equals(Attributes, other.Attributes);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + IsInherited.GetHashCode();
        hash = hash * 31 + (Attributes != null ?Attributes.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RiderColorsSchemeEntry (");
      using (printer.IndentCookie()) {
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("isInherited = "); IsInherited.PrintEx(printer); printer.Println();
        printer.Print("attributes = "); Attributes.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RiderColorsSchemeModel : IPrintable, IEquatable<RiderColorsSchemeModel> {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public List<RiderColorsSchemeEntry> Entries {get; private set;}
    
    //private fields
    //primary constructor
    public RiderColorsSchemeModel(
      [NotNull] string name,
      [NotNull] List<RiderColorsSchemeEntry> entries
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (entries == null) throw new ArgumentNullException("entries");
      
      Name = name;
      Entries = entries;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RiderColorsSchemeModel> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var entries = ReadRiderColorsSchemeEntryList(ctx, reader);
      return new RiderColorsSchemeModel(name, entries);
    };
    public static CtxReadDelegate<List<RiderColorsSchemeEntry>> ReadRiderColorsSchemeEntryList = RiderColorsSchemeEntry.Read.List();
    
    public static CtxWriteDelegate<RiderColorsSchemeModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      WriteRiderColorsSchemeEntryList(ctx, writer, value.Entries);
    };
    public static CtxWriteDelegate<List<RiderColorsSchemeEntry>> WriteRiderColorsSchemeEntryList = RiderColorsSchemeEntry.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RiderColorsSchemeModel) obj);
    }
    public bool Equals(RiderColorsSchemeModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Entries.SequenceEqual(other.Entries);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Entries);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RiderColorsSchemeModel (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("entries = "); Entries.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RiderDisplayPriority {
    GENERAL_SETTINGS,
    COMMON_SETTINGS,
    CODE_SETTINGS,
    KEY_LANGUAGE_SETTINGS,
    LANGUAGE_SETTINGS,
    OTHER_SETTINGS
  }
  
  
  public enum RiderHighlighterModelKind {
    USUAL,
    GUTTER_MARK,
    FOLDING,
    LINE_MARKER
  }
  
  
  public class RiderHighlighterProperties : IPrintable, IEquatable<RiderHighlighterProperties> {
    //fields
    //public fields
    public RiderHighlighterModelKind Kind {get; private set;}
    public bool IsRecyclable {get; private set;}
    public JetBrains.Rider.Model.HighlighterRegistration.GreedySide GreedySide {get; private set;}
    public bool IsVerifiable {get; private set;}
    public bool IsBulkUpdatable {get; private set;}
    public bool IsVisibleIfFolded {get; private set;}
    
    //private fields
    //primary constructor
    public RiderHighlighterProperties(
      RiderHighlighterModelKind kind,
      bool isRecyclable,
      JetBrains.Rider.Model.HighlighterRegistration.GreedySide greedySide,
      bool isVerifiable,
      bool isBulkUpdatable,
      bool isVisibleIfFolded
    )
    {
      Kind = kind;
      IsRecyclable = isRecyclable;
      GreedySide = greedySide;
      IsVerifiable = isVerifiable;
      IsBulkUpdatable = isBulkUpdatable;
      IsVisibleIfFolded = isVisibleIfFolded;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RiderHighlighterProperties> Read = (ctx, reader) => 
    {
      var kind = (RiderHighlighterModelKind)reader.ReadInt();
      var isRecyclable = reader.ReadBool();
      var greedySide = (JetBrains.Rider.Model.HighlighterRegistration.GreedySide)reader.ReadInt();
      var isVerifiable = reader.ReadBool();
      var isBulkUpdatable = reader.ReadBool();
      var isVisibleIfFolded = reader.ReadBool();
      return new RiderHighlighterProperties(kind, isRecyclable, greedySide, isVerifiable, isBulkUpdatable, isVisibleIfFolded);
    };
    
    public static CtxWriteDelegate<RiderHighlighterProperties> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Kind);
      writer.Write(value.IsRecyclable);
      writer.Write((int)value.GreedySide);
      writer.Write(value.IsVerifiable);
      writer.Write(value.IsBulkUpdatable);
      writer.Write(value.IsVisibleIfFolded);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RiderHighlighterProperties) obj);
    }
    public bool Equals(RiderHighlighterProperties other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Kind == other.Kind && IsRecyclable == other.IsRecyclable && GreedySide == other.GreedySide && IsVerifiable == other.IsVerifiable && IsBulkUpdatable == other.IsBulkUpdatable && IsVisibleIfFolded == other.IsVisibleIfFolded;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Kind;
        hash = hash * 31 + IsRecyclable.GetHashCode();
        hash = hash * 31 + (int) GreedySide;
        hash = hash * 31 + IsVerifiable.GetHashCode();
        hash = hash * 31 + IsBulkUpdatable.GetHashCode();
        hash = hash * 31 + IsVisibleIfFolded.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RiderHighlighterProperties (");
      using (printer.IndentCookie()) {
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("isRecyclable = "); IsRecyclable.PrintEx(printer); printer.Println();
        printer.Print("greedySide = "); GreedySide.PrintEx(printer); printer.Println();
        printer.Print("isVerifiable = "); IsVerifiable.PrintEx(printer); printer.Println();
        printer.Print("isBulkUpdatable = "); IsBulkUpdatable.PrintEx(printer); printer.Println();
        printer.Print("isVisibleIfFolded = "); IsVisibleIfFolded.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RiderHighlighterRegistrationPack : IPrintable, IEquatable<RiderHighlighterRegistrationPack> {
    //fields
    //public fields
    [NotNull] public string AttributeId {get; private set;}
    [NotNull] public string DemoTextTag {get; private set;}
    [CanBeNull] public IdeaHighlightInfoType InfoType {get; private set;}
    [NotNull] public RiderHighlighterProperties Properties {get; private set;}
    
    //private fields
    //primary constructor
    public RiderHighlighterRegistrationPack(
      [NotNull] string attributeId,
      [NotNull] string demoTextTag,
      [CanBeNull] IdeaHighlightInfoType infoType,
      [NotNull] RiderHighlighterProperties properties
    )
    {
      if (attributeId == null) throw new ArgumentNullException("attributeId");
      if (demoTextTag == null) throw new ArgumentNullException("demoTextTag");
      if (properties == null) throw new ArgumentNullException("properties");
      
      AttributeId = attributeId;
      DemoTextTag = demoTextTag;
      InfoType = infoType;
      Properties = properties;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RiderHighlighterRegistrationPack> Read = (ctx, reader) => 
    {
      var attributeId = reader.ReadString();
      var demoTextTag = reader.ReadString();
      var infoType = ReadIdeaHighlightInfoTypeNullable(ctx, reader);
      var properties = RiderHighlighterProperties.Read(ctx, reader);
      return new RiderHighlighterRegistrationPack(attributeId, demoTextTag, infoType, properties);
    };
    public static CtxReadDelegate<IdeaHighlightInfoType> ReadIdeaHighlightInfoTypeNullable = IdeaHighlightInfoType.Read.NullableClass();
    
    public static CtxWriteDelegate<RiderHighlighterRegistrationPack> Write = (ctx, writer, value) => 
    {
      writer.Write(value.AttributeId);
      writer.Write(value.DemoTextTag);
      WriteIdeaHighlightInfoTypeNullable(ctx, writer, value.InfoType);
      RiderHighlighterProperties.Write(ctx, writer, value.Properties);
    };
    public static CtxWriteDelegate<IdeaHighlightInfoType> WriteIdeaHighlightInfoTypeNullable = IdeaHighlightInfoType.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RiderHighlighterRegistrationPack) obj);
    }
    public bool Equals(RiderHighlighterRegistrationPack other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return AttributeId == other.AttributeId && DemoTextTag == other.DemoTextTag && Equals(InfoType, other.InfoType) && Equals(Properties, other.Properties);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + DemoTextTag.GetHashCode();
        hash = hash * 31 + (InfoType != null ?InfoType.GetHashCode() : 0);
        hash = hash * 31 + Properties.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RiderHighlighterRegistrationPack (");
      using (printer.IndentCookie()) {
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("demoTextTag = "); DemoTextTag.PrintEx(printer); printer.Println();
        printer.Print("infoType = "); InfoType.PrintEx(printer); printer.Println();
        printer.Print("properties = "); Properties.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RiderKnownColorsSchemeModels {
    Default,
    Darcula,
    ReSharperLight,
    ReSharperDark,
    VisualStudioLight,
    VisualStudioDark
  }
}
