using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  public static class IdeRoot {
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(SolutionModel), SolutionModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.UIAutomation.UIAutomationInteractionModel), JetBrains.Rider.Model.UIAutomation.UIAutomationInteractionModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(ActionsModel), ActionsModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.Popups.PopupInteractionModel), JetBrains.Rider.Model.Popups.PopupInteractionModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.Refactorings.GenerateViewProviderModel), JetBrains.Rider.Model.Refactorings.GenerateViewProviderModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.Refactorings.RefactoringInteractionModel), JetBrains.Rider.Model.Refactorings.RefactoringInteractionModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(OptionsUtils), OptionsUtils.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(SettingsViewModel), SettingsViewModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(Colors), Colors.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.Inspections.InspectionsModel), JetBrains.Rider.Model.Inspections.InspectionsModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.Dialog.DialogModel), JetBrains.Rider.Model.Dialog.DialogModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(LayersModel), LayersModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.HighlighterRegistration.HighlighterRegistrationHostModel), JetBrains.Rider.Model.HighlighterRegistration.HighlighterRegistrationHostModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.debuggerHelper.DebuggerHelperHostModel), JetBrains.Rider.Model.debuggerHelper.DebuggerHelperHostModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(ShellModel), ShellModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(ServicesUtils), ServicesUtils.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.Loggers.LoggerModel), JetBrains.Rider.Model.Loggers.LoggerModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(RdShellModel), RdShellModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.UiContext.UiContextModel), JetBrains.Rider.Model.UiContext.UiContextModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(XamarinSettingsHostModel), XamarinSettingsHostModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.Tooltips.TooltipsModel), JetBrains.Rider.Model.Tooltips.TooltipsModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(TextModel), TextModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(DebugContextActionsHostModel), DebugContextActionsHostModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(CodeCleanupModel), CodeCleanupModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(ProjectTemplatesModel), ProjectTemplatesModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(SettingsModel), SettingsModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(RdActionExecutionContextHost), RdActionExecutionContextHost.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.Notifications.RdNotificationsModel), JetBrains.Rider.Model.Notifications.RdNotificationsModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(RdEnsureWritableHandlerModel), RdEnsureWritableHandlerModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(BuildModel), BuildModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(TestModel), TestModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.TestFramework.MockBackendModel), JetBrains.Rider.Model.TestFramework.MockBackendModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(MarkupPreviewModel), MarkupPreviewModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(SettingsHelperModel), SettingsHelperModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(CodeCleanupSettingsModel), CodeCleanupSettingsModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(RoslynFrontendModel), RoslynFrontendModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(RdNuGetHost), RdNuGetHost.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(PsiElementRangeProvider), PsiElementRangeProvider.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(TypingAssistModel), TypingAssistModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(StackTraceFilterProvider), StackTraceFilterProvider.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(TodoModel), TodoModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(QuickDocHostModel), QuickDocHostModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(FindUsagesModel), FindUsagesModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(DotNetActiveRuntimeModel), DotNetActiveRuntimeModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(DebuggerWorkerConnectionHelperModel), DebuggerWorkerConnectionHelperModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(GotoModel), GotoModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(RdCSharpInteractiveHost), RdCSharpInteractiveHost.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(CodeStructureTree), CodeStructureTree.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(ProjectModelView), ProjectModelView.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(LiveTemplateModel), LiveTemplateModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(XdtModel), XdtModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(ProjectModelTasks), ProjectModelTasks.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(SolutionProperties), SolutionProperties.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(UnitTestModel), UnitTestModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(PsiDebuggerHostModel), PsiDebuggerHostModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(RdEntityFrameworkHost), RdEntityFrameworkHost.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(DiagnosticsModel), DiagnosticsModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(BreakpointHelperHost), BreakpointHelperHost.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(DotTraceHost), DotTraceHost.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(DotCoverModel), DotCoverModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(FileSystemModel), FileSystemModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(PublishableProjectsModel), PublishableProjectsModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(SolutionAnalysisModel), SolutionAnalysisModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(RunnableProjectsModel), RunnableProjectsModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(FileTemplateModel), FileTemplateModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(RdProjectModelSinks), RdProjectModelSinks.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(DeploymentHost), DeploymentHost.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(ConfigurationParametersAccessModel), ConfigurationParametersAccessModel.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(DebugCompletionProvider), DebugCompletionProvider.RegisterDeclaredTypesSerializers);
      serializers.RegisterToplevelOnce(typeof(SpellCheckerModel), SpellCheckerModel.RegisterDeclaredTypesSerializers);
    }
  }
}
