using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [JetBrains.Application.ShellComponent]
  public class LayersModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.ManageLayersDialog> ManageLayersDialog { get { return _ManageLayersDialog; }}
    [NotNull] public IRdProperty<SettingsSelectionDialog> SelectSettingsDialog { get { return _SelectSettingsDialog; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.SelectLayerDialog> SelectLayerDialog { get { return _SelectLayerDialog; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.ManageLayersDialog> _ManageLayersDialog;
    [NotNull] private readonly RdProperty<SettingsSelectionDialog> _SelectSettingsDialog;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.SelectLayerDialog> _SelectLayerDialog;
    
    //primary constructor
    private LayersModel(
      [NotNull] RdProperty<JetBrains.Rider.Model.ManageLayersDialog> manageLayersDialog,
      [NotNull] RdProperty<SettingsSelectionDialog> selectSettingsDialog,
      [NotNull] RdProperty<JetBrains.Rider.Model.SelectLayerDialog> selectLayerDialog
    )
    {
      if (manageLayersDialog == null) throw new ArgumentNullException("manageLayersDialog");
      if (selectSettingsDialog == null) throw new ArgumentNullException("selectSettingsDialog");
      if (selectLayerDialog == null) throw new ArgumentNullException("selectLayerDialog");
      
      _ManageLayersDialog = manageLayersDialog;
      _SelectSettingsDialog = selectSettingsDialog;
      _SelectLayerDialog = selectLayerDialog;
      _ManageLayersDialog.ValueCanBeNull = true;
      _SelectSettingsDialog.ValueCanBeNull = true;
      _SelectLayerDialog.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("manageLayersDialog", _ManageLayersDialog));
      BindableChildren.Add(new KeyValuePair<string, object>("selectSettingsDialog", _SelectSettingsDialog));
      BindableChildren.Add(new KeyValuePair<string, object>("selectLayerDialog", _SelectLayerDialog));
    }
    //secondary constructor
    private LayersModel (
    ) : this (
      new RdProperty<JetBrains.Rider.Model.ManageLayersDialog>(ReadManageLayersDialogNullable, WriteManageLayersDialogNullable),
      new RdProperty<SettingsSelectionDialog>(ReadSettingsSelectionDialogNullable, WriteSettingsSelectionDialogNullable),
      new RdProperty<JetBrains.Rider.Model.SelectLayerDialog>(ReadSelectLayerDialogNullable, WriteSelectLayerDialogNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.ManageLayersDialog> ReadManageLayersDialogNullable = JetBrains.Rider.Model.ManageLayersDialog.Read.NullableClass();
    public static CtxReadDelegate<SettingsSelectionDialog> ReadSettingsSelectionDialogNullable = SettingsSelectionDialog.Read.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.SelectLayerDialog> ReadSelectLayerDialogNullable = JetBrains.Rider.Model.SelectLayerDialog.Read.NullableClass();
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.ManageLayersDialog> WriteManageLayersDialogNullable = JetBrains.Rider.Model.ManageLayersDialog.Write.NullableClass();
    public static CtxWriteDelegate<SettingsSelectionDialog> WriteSettingsSelectionDialogNullable = SettingsSelectionDialog.Write.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.SelectLayerDialog> WriteSelectLayerDialogNullable = JetBrains.Rider.Model.SelectLayerDialog.Write.NullableClass();
    
    protected override long SerializationHash => -2585104287957928901L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(LayerId.Read, LayerId.Write);
      serializers.Register(Layer.Read, Layer.Write);
      serializers.Register(ManageLayersDialogContent.Read, ManageLayersDialogContent.Write);
      serializers.Register(JetBrains.Rider.Model.ManageLayersDialog.Read, JetBrains.Rider.Model.ManageLayersDialog.Write);
      serializers.Register(SettingsSelectionTreeNodeViewModel.Read, SettingsSelectionTreeNodeViewModel.Write);
      serializers.Register(SettingsSelectionTree.Read, SettingsSelectionTree.Write);
      serializers.Register(SettingsSelectionDialog.Read, SettingsSelectionDialog.Write);
      serializers.Register(JetBrains.Rider.Model.SelectLayerDialog.Read, JetBrains.Rider.Model.SelectLayerDialog.Write);
      serializers.Register(RdSelectedLayerConstant.Read, RdSelectedLayerConstant.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public LayersModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("LayersModel (");
      using (printer.IndentCookie()) {
        printer.Print("manageLayersDialog = "); _ManageLayersDialog.PrintEx(printer); printer.Println();
        printer.Print("selectSettingsDialog = "); _SelectSettingsDialog.PrintEx(printer); printer.Println();
        printer.Print("selectLayerDialog = "); _SelectLayerDialog.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class Layer : RdBindableBase {
    //fields
    //public fields
    [NotNull] public LayerId Id {get; private set;}
    public bool IsLocked {get; private set;}
    public double Priority {get; private set;}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Icon> Icon { get { return _Icon; }}
    [NotNull] public IRdProperty<bool> IsActive { get { return _IsActive; }}
    [NotNull] public IRdProperty<string> DisplayName { get { return _DisplayName; }}
    [NotNull] public IRdProperty<string> OriginText { get { return _OriginText; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Icon> _Icon;
    [NotNull] private readonly RdProperty<bool> _IsActive;
    [NotNull] private readonly RdProperty<string> _DisplayName;
    [NotNull] private readonly RdProperty<string> _OriginText;
    
    //primary constructor
    private Layer(
      [NotNull] LayerId id,
      bool isLocked,
      double priority,
      [NotNull] RdProperty<JetBrains.Rider.Model.Icon> icon,
      [NotNull] RdProperty<bool> isActive,
      [NotNull] RdProperty<string> displayName,
      [NotNull] RdProperty<string> originText
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (icon == null) throw new ArgumentNullException("icon");
      if (isActive == null) throw new ArgumentNullException("isActive");
      if (displayName == null) throw new ArgumentNullException("displayName");
      if (originText == null) throw new ArgumentNullException("originText");
      
      Id = id;
      IsLocked = isLocked;
      Priority = priority;
      _Icon = icon;
      _IsActive = isActive;
      _DisplayName = displayName;
      _OriginText = originText;
      _Icon.OptimizeNested = true;
      _IsActive.OptimizeNested = true;
      _DisplayName.OptimizeNested = true;
      _OriginText.OptimizeNested = true;
      _Icon.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("icon", _Icon));
      BindableChildren.Add(new KeyValuePair<string, object>("isActive", _IsActive));
      BindableChildren.Add(new KeyValuePair<string, object>("displayName", _DisplayName));
      BindableChildren.Add(new KeyValuePair<string, object>("originText", _OriginText));
    }
    //secondary constructor
    public Layer (
      [NotNull] LayerId id,
      bool isLocked,
      double priority
    ) : this (
      id,
      isLocked,
      priority,
      new RdProperty<JetBrains.Rider.Model.Icon>(ReadIconNullable, WriteIconNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<Layer> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = LayerId.Read(ctx, reader);
      var isLocked = reader.ReadBool();
      var priority = reader.ReadDouble();
      var icon = RdProperty<JetBrains.Rider.Model.Icon>.Read(ctx, reader, ReadIconNullable, WriteIconNullable);
      var isActive = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var displayName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var originText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new Layer(id, isLocked, priority, icon, isActive, displayName, originText).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<Layer> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      LayerId.Write(ctx, writer, value.Id);
      writer.Write(value.IsLocked);
      writer.Write(value.Priority);
      RdProperty<JetBrains.Rider.Model.Icon>.Write(ctx, writer, value._Icon);
      RdProperty<bool>.Write(ctx, writer, value._IsActive);
      RdProperty<string>.Write(ctx, writer, value._DisplayName);
      RdProperty<string>.Write(ctx, writer, value._OriginText);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("Layer (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("isLocked = "); IsLocked.PrintEx(printer); printer.Println();
        printer.Print("priority = "); Priority.PrintEx(printer); printer.Println();
        printer.Print("icon = "); _Icon.PrintEx(printer); printer.Println();
        printer.Print("isActive = "); _IsActive.PrintEx(printer); printer.Println();
        printer.Print("displayName = "); _DisplayName.PrintEx(printer); printer.Println();
        printer.Print("originText = "); _OriginText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class LayerId : IPrintable, IEquatable<LayerId> {
    //fields
    //public fields
    public int Id {get; private set;}
    
    //private fields
    //primary constructor
    public LayerId(
      int id
    )
    {
      Id = id;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<LayerId> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      return new LayerId(id);
    };
    
    public static CtxWriteDelegate<LayerId> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((LayerId) obj);
    }
    public bool Equals(LayerId other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("LayerId (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ManageLayersDialog : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<ManageLayersDialogContent> Content { get { return _Content; }}
    
    //private fields
    [NotNull] private readonly RdProperty<ManageLayersDialogContent> _Content;
    
    //primary constructor
    private ManageLayersDialog(
      [NotNull] RdProperty<ManageLayersDialogContent> content
    )
    {
      if (content == null) throw new ArgumentNullException("content");
      
      _Content = content;
      _Content.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("content", _Content));
    }
    //secondary constructor
    public ManageLayersDialog (
    ) : this (
      new RdProperty<ManageLayersDialogContent>(ReadManageLayersDialogContentNullable, WriteManageLayersDialogContentNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<ManageLayersDialog> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var content = RdProperty<ManageLayersDialogContent>.Read(ctx, reader, ReadManageLayersDialogContentNullable, WriteManageLayersDialogContentNullable);
      return new ManageLayersDialog(content).WithId(_id);
    };
    public static CtxReadDelegate<ManageLayersDialogContent> ReadManageLayersDialogContentNullable = ManageLayersDialogContent.Read.NullableClass();
    
    public static CtxWriteDelegate<ManageLayersDialog> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<ManageLayersDialogContent>.Write(ctx, writer, value._Content);
    };
    public static CtxWriteDelegate<ManageLayersDialogContent> WriteManageLayersDialogContentNullable = ManageLayersDialogContent.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ManageLayersDialog (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); _Content.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ManageLayersDialogContent : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<List<Layer>> Layers { get { return _Layers; }}
    [NotNull] public ISource<RdVoid> Refresh { get { return _Refresh; }}
    [NotNull] public string ActionGroupId {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<List<Layer>> _Layers;
    [NotNull] private readonly RdSignal<RdVoid> _Refresh;
    
    //primary constructor
    private ManageLayersDialogContent(
      [NotNull] RdProperty<List<Layer>> layers,
      [NotNull] RdSignal<RdVoid> refresh,
      [NotNull] string actionGroupId
    )
    {
      if (layers == null) throw new ArgumentNullException("layers");
      if (refresh == null) throw new ArgumentNullException("refresh");
      if (actionGroupId == null) throw new ArgumentNullException("actionGroupId");
      
      _Layers = layers;
      _Refresh = refresh;
      ActionGroupId = actionGroupId;
      BindableChildren.Add(new KeyValuePair<string, object>("layers", _Layers));
      BindableChildren.Add(new KeyValuePair<string, object>("refresh", _Refresh));
    }
    //secondary constructor
    public ManageLayersDialogContent (
      [NotNull] string actionGroupId
    ) : this (
      new RdProperty<List<Layer>>(ReadLayerList, WriteLayerList),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      actionGroupId
    ) {}
    //statics
    
    public static CtxReadDelegate<ManageLayersDialogContent> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var layers = RdProperty<List<Layer>>.Read(ctx, reader, ReadLayerList, WriteLayerList);
      var refresh = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var actionGroupId = reader.ReadString();
      return new ManageLayersDialogContent(layers, refresh, actionGroupId).WithId(_id);
    };
    public static CtxReadDelegate<List<Layer>> ReadLayerList = Layer.Read.List();
    
    public static CtxWriteDelegate<ManageLayersDialogContent> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<List<Layer>>.Write(ctx, writer, value._Layers);
      RdSignal<RdVoid>.Write(ctx, writer, value._Refresh);
      writer.Write(value.ActionGroupId);
    };
    public static CtxWriteDelegate<List<Layer>> WriteLayerList = Layer.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ManageLayersDialogContent (");
      using (printer.IndentCookie()) {
        printer.Print("layers = "); _Layers.PrintEx(printer); printer.Println();
        printer.Print("refresh = "); _Refresh.PrintEx(printer); printer.Println();
        printer.Print("actionGroupId = "); ActionGroupId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSelectedLayerConstant : RdDataConstant
   {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.LayerId LayerId {get; private set;}
    
    //private fields
    //primary constructor
    public RdSelectedLayerConstant(
      [NotNull] JetBrains.Rider.Model.LayerId layerId
    )
    {
      if (layerId == null) throw new ArgumentNullException("layerId");
      
      LayerId = layerId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdSelectedLayerConstant> Read = (ctx, reader) => 
    {
      var layerId = JetBrains.Rider.Model.LayerId.Read(ctx, reader);
      return new RdSelectedLayerConstant(layerId);
    };
    
    public static new CtxWriteDelegate<RdSelectedLayerConstant> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.LayerId.Write(ctx, writer, value.LayerId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdSelectedLayerConstant) obj);
    }
    public bool Equals(RdSelectedLayerConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(LayerId, other.LayerId);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + LayerId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdSelectedLayerConstant (");
      using (printer.IndentCookie()) {
        printer.Print("layerId = "); LayerId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SelectLayerDialog : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<Layer> Layers {get; private set;}
    [NotNull] public ISink<LayerId> Close { get { return _Close; }}
    
    //private fields
    [NotNull] private readonly RdSignal<LayerId> _Close;
    
    //primary constructor
    private SelectLayerDialog(
      [NotNull] List<Layer> layers,
      [NotNull] RdSignal<LayerId> close
    )
    {
      if (layers == null) throw new ArgumentNullException("layers");
      if (close == null) throw new ArgumentNullException("close");
      
      Layers = layers;
      _Close = close;
      _Close.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("layers", Layers));
      BindableChildren.Add(new KeyValuePair<string, object>("close", _Close));
    }
    //secondary constructor
    public SelectLayerDialog (
      [NotNull] List<Layer> layers
    ) : this (
      layers,
      new RdSignal<LayerId>(ReadLayerIdNullable, WriteLayerIdNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<SelectLayerDialog> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var layers = ReadLayerList(ctx, reader);
      var close = RdSignal<LayerId>.Read(ctx, reader, ReadLayerIdNullable, WriteLayerIdNullable);
      return new SelectLayerDialog(layers, close).WithId(_id);
    };
    public static CtxReadDelegate<List<Layer>> ReadLayerList = Layer.Read.List();
    public static CtxReadDelegate<LayerId> ReadLayerIdNullable = LayerId.Read.NullableClass();
    
    public static CtxWriteDelegate<SelectLayerDialog> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteLayerList(ctx, writer, value.Layers);
      RdSignal<LayerId>.Write(ctx, writer, value._Close);
    };
    public static CtxWriteDelegate<List<Layer>> WriteLayerList = Layer.Write.List();
    public static CtxWriteDelegate<LayerId> WriteLayerIdNullable = LayerId.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SelectLayerDialog (");
      using (printer.IndentCookie()) {
        printer.Print("layers = "); Layers.PrintEx(printer); printer.Println();
        printer.Print("close = "); _Close.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SettingsSelectionDialog : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string ModeDescription {get; private set;}
    [NotNull] public string ModelName {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public SettingsSelectionTree Tree {get; private set;}
    [NotNull] public IRdProperty<string> ErrorFullText { get { return _ErrorFullText; }}
    [NotNull] public ISink<RdVoid> ShowError { get { return _ShowError; }}
    [NotNull] public ISink<bool> Close { get { return _Close; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _ErrorFullText;
    [NotNull] private readonly RdSignal<RdVoid> _ShowError;
    [NotNull] private readonly RdSignal<bool> _Close;
    
    //primary constructor
    private SettingsSelectionDialog(
      [NotNull] string modeDescription,
      [NotNull] string modelName,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] SettingsSelectionTree tree,
      [NotNull] RdProperty<string> errorFullText,
      [NotNull] RdSignal<RdVoid> showError,
      [NotNull] RdSignal<bool> close
    )
    {
      if (modeDescription == null) throw new ArgumentNullException("modeDescription");
      if (modelName == null) throw new ArgumentNullException("modelName");
      if (icon == null) throw new ArgumentNullException("icon");
      if (tree == null) throw new ArgumentNullException("tree");
      if (errorFullText == null) throw new ArgumentNullException("errorFullText");
      if (showError == null) throw new ArgumentNullException("showError");
      if (close == null) throw new ArgumentNullException("close");
      
      ModeDescription = modeDescription;
      ModelName = modelName;
      Icon = icon;
      Tree = tree;
      _ErrorFullText = errorFullText;
      _ShowError = showError;
      _Close = close;
      _ErrorFullText.OptimizeNested = true;
      _ErrorFullText.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("tree", Tree));
      BindableChildren.Add(new KeyValuePair<string, object>("errorFullText", _ErrorFullText));
      BindableChildren.Add(new KeyValuePair<string, object>("showError", _ShowError));
      BindableChildren.Add(new KeyValuePair<string, object>("close", _Close));
    }
    //secondary constructor
    public SettingsSelectionDialog (
      [NotNull] string modeDescription,
      [NotNull] string modelName,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] SettingsSelectionTree tree
    ) : this (
      modeDescription,
      modelName,
      icon,
      tree,
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<SettingsSelectionDialog> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var modeDescription = reader.ReadString();
      var modelName = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var tree = SettingsSelectionTree.Read(ctx, reader);
      var errorFullText = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      var showError = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var close = RdSignal<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new SettingsSelectionDialog(modeDescription, modelName, icon, tree, errorFullText, showError, close).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<SettingsSelectionDialog> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ModeDescription);
      writer.Write(value.ModelName);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      SettingsSelectionTree.Write(ctx, writer, value.Tree);
      RdProperty<string>.Write(ctx, writer, value._ErrorFullText);
      RdSignal<RdVoid>.Write(ctx, writer, value._ShowError);
      RdSignal<bool>.Write(ctx, writer, value._Close);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsSelectionDialog (");
      using (printer.IndentCookie()) {
        printer.Print("modeDescription = "); ModeDescription.PrintEx(printer); printer.Println();
        printer.Print("modelName = "); ModelName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("tree = "); Tree.PrintEx(printer); printer.Println();
        printer.Print("errorFullText = "); _ErrorFullText.PrintEx(printer); printer.Println();
        printer.Print("showError = "); _ShowError.PrintEx(printer); printer.Println();
        printer.Print("close = "); _Close.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SettingsSelectionTree : RdBindableBase {
    //fields
    //public fields
    [CanBeNull] public string TempFieldTo {get; private set;}
    [NotNull] public IRdProperty<SettingsSelectionTreeNodeViewModel> Root { get { return _Root; }}
    
    //private fields
    [NotNull] private readonly RdProperty<SettingsSelectionTreeNodeViewModel> _Root;
    
    //primary constructor
    private SettingsSelectionTree(
      [CanBeNull] string tempFieldTo,
      [NotNull] RdProperty<SettingsSelectionTreeNodeViewModel> root
    )
    {
      if (root == null) throw new ArgumentNullException("root");
      
      TempFieldTo = tempFieldTo;
      _Root = root;
      BindableChildren.Add(new KeyValuePair<string, object>("root", _Root));
    }
    //secondary constructor
    public SettingsSelectionTree (
      [CanBeNull] string tempFieldTo
    ) : this (
      tempFieldTo,
      new RdProperty<SettingsSelectionTreeNodeViewModel>(SettingsSelectionTreeNodeViewModel.Read, SettingsSelectionTreeNodeViewModel.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<SettingsSelectionTree> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var tempFieldTo = ReadStringNullable(ctx, reader);
      var root = RdProperty<SettingsSelectionTreeNodeViewModel>.Read(ctx, reader, SettingsSelectionTreeNodeViewModel.Read, SettingsSelectionTreeNodeViewModel.Write);
      return new SettingsSelectionTree(tempFieldTo, root).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<SettingsSelectionTree> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteStringNullable(ctx, writer, value.TempFieldTo);
      RdProperty<SettingsSelectionTreeNodeViewModel>.Write(ctx, writer, value._Root);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsSelectionTree (");
      using (printer.IndentCookie()) {
        printer.Print("tempFieldTo = "); TempFieldTo.PrintEx(printer); printer.Println();
        printer.Print("root = "); _Root.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SettingsSelectionTreeNodeViewModel : SettingsSelectionTreeNodeViewModelBase
   {
    //fields
    //public fields
    [NotNull] public List<SettingsSelectionTreeNodeViewModelBase> Children {get; private set;}
    
    //private fields
    //primary constructor
    private SettingsSelectionTreeNodeViewModel(
      [NotNull] List<SettingsSelectionTreeNodeViewModelBase> children,
      [NotNull] string settingName,
      [NotNull] string description,
      [NotNull] RdProperty<bool?> isSelected
    ) : base (
      settingName,
      description,
      isSelected
     ) 
    {
      if (children == null) throw new ArgumentNullException("children");
      
      Children = children;
      BindableChildren.Add(new KeyValuePair<string, object>("children", Children));
    }
    //secondary constructor
    public SettingsSelectionTreeNodeViewModel (
      [NotNull] List<SettingsSelectionTreeNodeViewModelBase> children,
      [NotNull] string settingName,
      [NotNull] string description
    ) : this (
      children,
      settingName,
      description,
      new RdProperty<bool?>(ReadBoolNullable, WriteBoolNullable)
    ) {}
    //statics
    
    public static new CtxReadDelegate<SettingsSelectionTreeNodeViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var settingName = reader.ReadString();
      var description = reader.ReadString();
      var isSelected = RdProperty<bool?>.Read(ctx, reader, ReadBoolNullable, WriteBoolNullable);
      var children = ReadSettingsSelectionTreeNodeViewModelBaseList(ctx, reader);
      return new SettingsSelectionTreeNodeViewModel(children, settingName, description, isSelected).WithId(_id);
    };
    public static CtxReadDelegate<List<SettingsSelectionTreeNodeViewModelBase>> ReadSettingsSelectionTreeNodeViewModelBaseList = SettingsSelectionTreeNodeViewModelBase.Read.List();
    public static CtxReadDelegate<bool?> ReadBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool.NullableStruct();
    
    public static new CtxWriteDelegate<SettingsSelectionTreeNodeViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.SettingName);
      writer.Write(value.Description);
      RdProperty<bool?>.Write(ctx, writer, value._IsSelected);
      WriteSettingsSelectionTreeNodeViewModelBaseList(ctx, writer, value.Children);
    };
    public static CtxWriteDelegate<List<SettingsSelectionTreeNodeViewModelBase>> WriteSettingsSelectionTreeNodeViewModelBaseList = SettingsSelectionTreeNodeViewModelBase.Write.List();
    public static CtxWriteDelegate<bool?> WriteBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool.NullableStruct();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsSelectionTreeNodeViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
        printer.Print("settingName = "); SettingName.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("isSelected = "); _IsSelected.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class SettingsSelectionTreeNodeViewModelBase : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string SettingName {get; private set;}
    [NotNull] public string Description {get; private set;}
    [NotNull] public IRdProperty<bool?> IsSelected { get { return _IsSelected; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<bool?> _IsSelected;
    
    //primary constructor
    protected SettingsSelectionTreeNodeViewModelBase(
      [NotNull] string settingName,
      [NotNull] string description,
      [NotNull] RdProperty<bool?> isSelected
    )
    {
      if (settingName == null) throw new ArgumentNullException("settingName");
      if (description == null) throw new ArgumentNullException("description");
      if (isSelected == null) throw new ArgumentNullException("isSelected");
      
      SettingName = settingName;
      Description = description;
      _IsSelected = isSelected;
      _IsSelected.OptimizeNested = true;
      _IsSelected.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isSelected", _IsSelected));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SettingsSelectionTreeNodeViewModelBase> Read = Polymorphic<SettingsSelectionTreeNodeViewModelBase>.ReadAbstract(SettingsSelectionTreeNodeViewModelBase_Unknown.Read);
    
    public static CtxWriteDelegate<SettingsSelectionTreeNodeViewModelBase> Write = Polymorphic<SettingsSelectionTreeNodeViewModelBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class SettingsSelectionTreeNodeViewModelBase_Unknown : SettingsSelectionTreeNodeViewModelBase
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    private SettingsSelectionTreeNodeViewModelBase_Unknown(
      [NotNull] string settingName,
      [NotNull] string description,
      [NotNull] RdProperty<bool?> isSelected
    ) : base (
      settingName,
      description,
      isSelected
     ) 
    {
    }
    //secondary constructor
    public SettingsSelectionTreeNodeViewModelBase_Unknown (
      [NotNull] string settingName,
      [NotNull] string description
    ) : this (
      settingName,
      description,
      new RdProperty<bool?>(ReadBoolNullable, WriteBoolNullable)
    ) {}
    //statics
    
    public static new CtxReadDelegate<SettingsSelectionTreeNodeViewModelBase_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var settingName = reader.ReadString();
      var description = reader.ReadString();
      var isSelected = RdProperty<bool?>.Read(ctx, reader, ReadBoolNullable, WriteBoolNullable);
      return new SettingsSelectionTreeNodeViewModelBase_Unknown(settingName, description, isSelected).WithId(_id);
    };
    public static CtxReadDelegate<bool?> ReadBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool.NullableStruct();
    
    public static new CtxWriteDelegate<SettingsSelectionTreeNodeViewModelBase_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.SettingName);
      writer.Write(value.Description);
      RdProperty<bool?>.Write(ctx, writer, value._IsSelected);
    };
    public static CtxWriteDelegate<bool?> WriteBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool.NullableStruct();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsSelectionTreeNodeViewModelBase_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("settingName = "); SettingName.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("isSelected = "); _IsSelected.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
